/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.editors;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarFile;
import javax.swing.JButton;
import javax.swing.JTextField;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.Main;
import net.charabia.jsmoothgen.application.gui.util.ClassChooserDialog;

public class MainClass
extends Editor {
    private JTextField m_classname = new JTextField();
    private JButton m_chooserButton = new JButton("...");

    public MainClass() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.m_classname);
        this.add("East", this.m_chooserButton);
        this.m_chooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainClass.this.displayChooser();
            }
        });
    }

    public void dataChanged() {
        this.m_classname.setText(this.m_model.getMainClassName());
    }

    public void updateModel() {
        this.m_model.setMainClassName(this.m_classname.getText());
    }

    public String getLabel() {
        return "MAINCLASS_LABEL";
    }

    public String getDescription() {
        return "MAINCLASS_HELP";
    }

    protected void displayChooser() {
        String[] cp;
        String ejar;
        ClassChooserDialog chooser = new ClassChooserDialog((Frame)Main.MAIN, true);
        Vector<File> jars = new Vector<File>();
        if (this.m_model.getEmbeddedJar() && (ejar = this.m_model.getJarLocation()) != null) {
            File f = this.getAbsolutePath(new File(ejar));
            jars.add(f);
        }
        if ((cp = this.m_model.getClassPath()) != null) {
            for (int i = 0; i < cp.length; ++i) {
                jars.add(this.getAbsolutePath(new File(cp[i])));
            }
        }
        chooser.clear();
        Iterator i = jars.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            System.out.println("Adding jar <" + f + ">");
            try {
                chooser.addJar(new JarFile(f));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        chooser.setClassName(this.m_classname.getText());
        chooser.show();
        if (chooser.validated()) {
            String classname = chooser.getClassName();
            this.m_classname.setText(classname);
        }
    }
}

