/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ExpressionContext;
import it.businesslogic.ireport.gui.BandsDialog;
import it.businesslogic.ireport.gui.JNumberComboBox;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportBandsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ExpressionSheetProperty;
import it.businesslogic.ireport.gui.sheet.ExpressionSheetPropertyComponent;
import it.businesslogic.ireport.gui.sheet.NumberComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class ReportBandSheetPanel
extends CategorySheetPanel
implements ReportListener,
LanguageChangedListener,
ReportFrameActivatedListener {
    private SheetProperty spHeight;
    private SheetProperty spSplitAllowed;
    private ExpressionSheetProperty spPrintWhenExpression;
    public static Color sharedDifferentValueLabelColor = Color.red.darker().darker();
    public static Color mandatoryPropertiesLabelColor = Color.blue;
    public static Color notMandatoryPropertiesLabelColor = Color.black;
    private JReportFrame jrf = null;
    private boolean init = false;
    private Vector bandSelection = new Vector();

    public ReportBandSheetPanel() {
        this.setBackground(Color.BLUE);
        this.initSheetProperties();
        MainFrame mf = MainFrame.getMainInstance();
        mf.addReportListener(this);
        mf.addReportFrameActivatedListener(this);
        I18n.addOnLanguageChangedListener(this);
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() == this.getJrf()) {
            return;
        }
        this.updateSelection(MainFrame.getMainInstance().getActiveReportFrame());
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.removeAllProperties();
        this.initSheetProperties();
        this.updateSelection();
    }

    public void updateSelection() {
        JReportFrame newJrf = MainFrame.getMainInstance().getActiveReportFrame();
        this.updateSelection(newJrf);
    }

    public void applyValueForNumbers() {
        Enumeration e = this.getProperties().elements();
        while (e.hasMoreElements()) {
            JComponent c;
            SheetProperty sp = (SheetProperty)e.nextElement();
            if (sp.getType() != 6) {
                if (sp.getType() != 1) continue;
            }
            if (!(c = sp.getEditor()).hasFocus() || !(c instanceof JNumberField)) continue;
            ((JNumberField)c).focusLost(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(JReportFrame newJrf) {
        this.applyValueForNumbers();
        if (newJrf == null) {
            this.setBandSelection(new Vector());
        } else {
            this.setBandSelection(newJrf.getSelectedBands());
        }
        this.setInit(true);
        this.removeAllProperties();
        this.jrf = newJrf;
        if (this.jrf == null || this.getBandSelection().size() == 0) {
            this.recreateSheet();
            return;
        }
        try {
            Vector selectedElements = this.getBandSelection();
            boolean sameHeight = true;
            boolean sameSplitAllowed = true;
            boolean samePrintWhenExpression = true;
            boolean isTheFirstElement = true;
            for (int i = 0; i < selectedElements.size(); ++i) {
                Band band = (Band)selectedElements.elementAt(i);
                if (sameHeight) {
                    sameHeight = this.setElementNumber(isTheFirstElement, band.getHeight(), (JNumberField)this.spHeight.getEditor());
                }
                if (sameSplitAllowed) {
                    sameSplitAllowed = this.setCheckBox(isTheFirstElement, band.isSplitAllowed(), false, this.spSplitAllowed);
                }
                if (samePrintWhenExpression) {
                    samePrintWhenExpression = this.setTextArea(isTheFirstElement, band.getPrintWhenExpression(), this.spPrintWhenExpression);
                }
                isTheFirstElement = false;
            }
            this.spHeight.setLabelColor(sameHeight ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            ExpressionContext ec = new ExpressionContext();
            ec.setSubDataset(this.jrf.getReport());
            this.spPrintWhenExpression.setExpressionContext(ec);
            this.spPrintWhenExpression.setLabelError(null);
            this.spPrintWhenExpression.updateLabel();
            String commonStr = I18n.getString("bandProperties", "Band Properties");
            this.addSheetProperty(commonStr, this.spHeight);
            this.addSheetProperty(commonStr, this.spSplitAllowed);
            this.addSheetProperty(commonStr, this.spPrintWhenExpression);
            this.spSplitAllowed.setDefaultValue(new Boolean(true));
            this.recreateSheet();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setInit(false);
    }

    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        if (this.isInit()) {
            return;
        }
        Vector selectedElements = this.getBandSelection();
        for (int i = 0; i < selectedElements.size(); ++i) {
            Band band = (Band)selectedElements.elementAt(i);
            this.applyNewProperty(band, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
        this.repaintEditor();
    }

    private void applyNewProperty(Band b, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            return;
        }
        if (this.isInit()) {
            return;
        }
        boolean fireEvent = true;
        if (propertyName.equals("height")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                BandsDialog.updateBandHeight(this.getJrf().getReport(), b, val);
            }
        } else if (propertyName.equals("splitAllowed")) {
            b.setSplitAllowed((Boolean)newValue);
        } else if (propertyName.equals("printWhenExpression")) {
            if (newValue != null) {
                b.setPrintWhenExpression("" + newValue);
            }
            ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
            ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
            fireEvent = false;
            MainFrame.getMainInstance().getBandsDialog().updateBands();
        }
        if (fireEvent) {
            this.getJrf().fireReportListenerReportBandChanged(new ReportBandChangedEvent(this.getJrf(), b, 3));
        }
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
        this.updateSelection();
    }

    protected void initSheetProperties() {
        this.spHeight = new SheetProperty("height", I18n.getString("gui.elementpropertiessheet.height", "Height"), 6);
        this.spHeight.setShowResetButton(false);
        this.spSplitAllowed = new SheetProperty("splitAllowed", I18n.getString("gui.bandpropertiessheet.splitAllowed", "Is split allowed"), 4);
        this.spSplitAllowed.setShowResetButton(false);
        this.spPrintWhenExpression = new ExpressionSheetProperty("printWhenExpression", I18n.getString("gui.elementpropertiessheet.printWhenExpression", "Print When Expression"));
        this.spPrintWhenExpression.setShowResetButton(false);
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    protected boolean setTextArea(boolean firstTime, String value, SheetProperty textProperty) {
        if (!firstTime && !textProperty.getValue().equals(value)) {
            JComponent editor = textProperty.getEditor();
            if (editor instanceof ExpressionSheetPropertyComponent) {
                ((ExpressionSheetPropertyComponent)editor).setExpression("");
                ((ExpressionSheetPropertyComponent)editor).setText(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"));
            }
            return false;
        }
        try {
            textProperty.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setElementNumber(boolean firstTime, double value, JNumberField numberField) {
        if (!firstTime && numberField.getValue() != value) {
            numberField.setText("");
            return false;
        }
        try {
            numberField.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setElementNumber(boolean firstTime, int defaultValue, Object value, NumberComboBoxSheetProperty sp) {
        if (!firstTime && !(sp.getValue() + "").equals("" + value)) {
            boolean setting = sp.isSetting();
            sp.setSetting(true);
            sp.setValue(null);
            sp.setSetting(setting);
            sp.setEditorValue(sp.getEditor(), "");
            return false;
        }
        try {
            boolean setting = sp.isSetting();
            sp.setSetting(true);
            sp.setValue(value);
            if (value == null) {
                if (!firstTime && !(((JNumberComboBox)sp.getEditor()).getSelectedItem() + "").equals("" + defaultValue)) {
                    sp.setEditorValue(sp.getEditor(), "");
                } else {
                    sp.setEditorValue(sp.getEditor(), new Integer(defaultValue));
                }
            }
            sp.setSetting(setting);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setGenericSheetProperty(boolean firstTime, Object value, SheetProperty sp) {
        if (firstTime) {
            try {
                sp.setValue(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Object value2 = sp.getValue();
        if (value2 == value) {
            return true;
        }
        if (value2 != null && ("" + value2).equals(value + "")) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    protected boolean setColorProperty(boolean firstTime, Color color, SheetProperty sp) {
        if (firstTime) {
            try {
                sp.setValue(color);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Color c1 = (Color)sp.getValue();
        if (c1 == color) {
            return true;
        }
        if (c1 != null && color != null && c1.getRGB() == color.getRGB()) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    protected boolean setCheckBox(boolean firstTime, boolean value, boolean isNull, SheetProperty sp) {
        if (firstTime) {
            try {
                if (isNull) {
                    sp.setValue(null);
                    sp.setSetting(true);
                    ((JCheckBox)sp.getEditor()).setSelected(value);
                    sp.setSetting(false);
                } else {
                    sp.setValue("" + value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        if (sp.getValue() == null && isNull) {
            return true;
        }
        if (sp.getValue() != null && sp.getValue().equals("" + value)) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void repaintEditor() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.getJPanelReport().repaint();
    }

    public Vector getBandSelection() {
        return this.bandSelection;
    }

    public void setBandSelection(Vector newBandSelection) {
        this.bandSelection.removeAllElements();
        if (newBandSelection == null) {
            return;
        }
        this.bandSelection.addAll(newBandSelection);
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
    }

    public void reportBandsSelectionChanged(ReportBandsSelectionEvent evt) {
        this.updateSelection();
    }
}

