/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.babylon;

import com.jaspersoft.babylon.JasperBabylonClient;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JasperBabylonTask
extends Task {
    public static final String DOWNLOAD = "download";
    public static final String UPLOAD = "upload";
    public static final String LIST = "list";
    private String appId = "";
    private String languageId = "";
    private String url = "http://127.0.0.1/jasperbabylon";
    private String operation = "download";
    private String inputFile = "";
    private String outputFile = "";
    private String username = "";
    private String password = "";

    public void execute() throws BuildException {
        if (this.appId.trim().length() == 0) {
            throw new BuildException("Missing appId attribute");
        }
        if (!(this.operation.equals(DOWNLOAD) || this.operation.equals(UPLOAD) || this.operation.equals(LIST))) {
            throw new BuildException("Invalid operation (" + this.operation + "). Operation can have one of the following values: download, upload, list.");
        }
        JasperBabylonClient jbc = new JasperBabylonClient();
        jbc.setAppId(this.appId);
        jbc.setJasperBabylonUrl(this.url);
        if (this.getUsername() != null) {
            jbc.setUsername(this.getUsername());
        }
        if (this.getPassword() != null) {
            jbc.setPassword(this.getPassword());
        }
        if (this.operation.equals(DOWNLOAD)) {
            if (this.languageId.trim().length() == 0) {
                throw new BuildException("Language ID required by the download operation");
            }
            if (this.outputFile.trim().length() == 0) {
                throw new BuildException("Invalid output file set");
            }
            try {
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(this.outputFile);
                }
                catch (Exception ex) {
                    throw new BuildException((Throwable)ex);
                }
                this.log("Getting locale...");
                Properties props = jbc.getLocale(this.languageId);
                props.store(os, "# Downloaded by JasperBabylon");
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if (this.operation.equals(UPLOAD)) {
            if (this.languageId.trim().length() == 0) {
                throw new BuildException("Language ID required by the upload operation");
            }
            if (this.inputFile.trim().length() == 0) {
                throw new BuildException("Invalid input file set");
            }
            try {
                FileInputStream is = null;
                Properties props = new Properties();
                try {
                    is = new FileInputStream(this.inputFile);
                }
                catch (Exception ex) {
                    throw new BuildException((Throwable)ex);
                }
                props.load(is);
                this.log("Uploading locale...");
                String msg = jbc.putLocale(this.languageId, props);
                this.log(msg);
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if (this.operation.equals(LIST)) {
            try {
                this.log("Listing locales...");
                List list = jbc.listLocales();
                for (int i = 0; i < list.size(); ++i) {
                    this.log("" + list.get(i));
                }
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

