/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.engine.export.oasis.zip.ByteArrayOasisZipEntry;
import net.sf.jasperreports.engine.export.oasis.zip.EmptyOasisZipEntry;
import net.sf.jasperreports.engine.export.oasis.zip.OasisZipEntry;

public class OasisZip {
    private List oasisZipEntries = new ArrayList();
    private OasisZipEntry contentEntry = new ByteArrayOasisZipEntry("content.xml");
    private OasisZipEntry stylesEntry = null;

    public OasisZip() {
        this.oasisZipEntries.add(this.contentEntry);
        this.oasisZipEntries.add(new EmptyOasisZipEntry("meta.xml"));
        this.oasisZipEntries.add(new EmptyOasisZipEntry("settings.xml"));
        this.stylesEntry = new ByteArrayOasisZipEntry("styles.xml");
        this.oasisZipEntries.add(this.stylesEntry);
        try {
            ByteArrayOasisZipEntry mimeEntry = new ByteArrayOasisZipEntry("mimetype");
            Writer mimeWriter = mimeEntry.getWriter();
            mimeWriter.write("application/vnd.oasis.opendocument.text");
            mimeWriter.flush();
            this.oasisZipEntries.add(mimeEntry);
            ByteArrayOasisZipEntry manifestEntry = new ByteArrayOasisZipEntry("META-INF/manifest.xml");
            Writer manifestWriter = manifestEntry.getWriter();
            manifestWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \r\n");
            manifestWriter.write("<!DOCTYPE manifest:manifest PUBLIC \"-//OpenOffice.org//DTD Manifest 1.0//EN\" \"Manifest.dtd\"> \r\n");
            manifestWriter.write("<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\"> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"application/vnd.oasis.opendocument.text\" manifest:full-path=\"/\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"application/vnd.sun.xml.ui.configuration\" manifest:full-path=\"Configurations2/\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Pictures/\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"content.xml\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"styles.xml\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"meta.xml\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/thumbnail.png\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"settings.xml\"/> \r\n");
            manifestWriter.write("</manifest:manifest> \r\n");
            manifestWriter.flush();
            this.oasisZipEntries.add(manifestEntry);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public OasisZipEntry getContentEntry() {
        return this.contentEntry;
    }

    public OasisZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    public void addEntry(OasisZipEntry entry) {
        this.oasisZipEntries.add(entry);
    }

    public void zipEntries(OutputStream os) throws IOException {
        ZipOutputStream zipos = new ZipOutputStream(os);
        zipos.setMethod(8);
        byte[] bytes = new byte[4096];
        int bytesRead = 0;
        for (int i = 0; i < this.oasisZipEntries.size(); ++i) {
            OasisZipEntry oasisZipEntry = (OasisZipEntry)this.oasisZipEntries.get(i);
            InputStream is = oasisZipEntry.getInputStream();
            ZipEntry zipEntry = new ZipEntry(oasisZipEntry.getName());
            zipos.putNextEntry(zipEntry);
            while ((bytesRead = is.read(bytes)) != -1) {
                zipos.write(bytes, 0, bytesRead);
            }
            is.close();
        }
        zipos.flush();
        zipos.close();
    }
}

