/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRBaseFiller
implements JRDefaultStyleProvider,
JRVirtualPrintPage.IdentityDataProvider {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRBaseFiller == null ? (class$net$sf$jasperreports$engine$fill$JRBaseFiller = JRBaseFiller.class$("net.sf.jasperreports.engine.fill.JRBaseFiller")) : class$net$sf$jasperreports$engine$fill$JRBaseFiller));
    protected final String fillerId;
    protected JRBaseFiller parentFiller = null;
    private JRStyledTextParser styledTextParser = new JRStyledTextParser();
    private boolean isInterrupted = false;
    protected String name = null;
    protected int columnCount = 1;
    protected byte printOrder = 1;
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected byte orientation = 1;
    protected byte whenNoDataType = 1;
    protected int columnWidth = 0;
    protected int columnSpacing = 0;
    protected int leftMargin = 0;
    protected int rightMargin = 0;
    protected int topMargin = 0;
    protected int bottomMargin = 0;
    protected boolean isTitleNewPage = false;
    protected boolean isSummaryNewPage = false;
    protected boolean isFloatColumnFooter = false;
    protected byte whenResourceMissingType = 1;
    protected JRReportFont defaultFont = null;
    protected JRReportFont[] fonts = null;
    protected JRStyle defaultStyle = null;
    protected JRStyle[] styles = null;
    protected JRFillDataset mainDataset;
    protected JRFillGroup[] groups = null;
    protected JRFillBand missingFillBand = null;
    protected JRFillBand background = null;
    protected JRFillBand title = null;
    protected JRFillBand pageHeader = null;
    protected JRFillBand columnHeader = null;
    protected JRFillBand detail = null;
    protected JRFillBand columnFooter = null;
    protected JRFillBand pageFooter = null;
    protected JRFillBand lastPageFooter = null;
    protected JRFillBand summary = null;
    protected JRVirtualizer virtualizer = null;
    protected ClassLoader reportClassLoader = null;
    protected FormatFactory formatFactory = null;
    protected URLStreamHandlerFactory urlHandlerFactory;
    protected JRFillContext fillContext;
    protected Map boundElements;
    protected JasperPrint jasperPrint = null;
    protected JRPrintPage printPage = null;
    protected int printPageStretchHeight = 0;
    protected List bands;
    protected Set subfillers;
    private List identityPages;
    private Thread fillingThread;
    protected JRCalculator calculator;
    protected JRAbstractScriptlet scriptlet;
    protected Map datasetMap;
    protected JasperReport jasperReport;
    private boolean bandOverFlowAllowed;
    protected boolean isPerPageBoundElements;
    protected Map dateFormatCache = new HashMap();
    protected Map numberFormatCache = new HashMap();
    private JRSubreportRunner subreportRunner;
    protected boolean isCreatingNewPage = false;
    protected boolean isNewPage = false;
    protected boolean isNewColumn = false;
    protected boolean isNewGroup = true;
    protected int columnIndex = 0;
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected int columnHeaderOffsetY = 0;
    protected int columnFooterOffsetY = 0;
    protected int lastPageColumnFooterOffsetY = 0;
    protected boolean isLastPageFooter = false;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRBaseFiller;

    protected JRBaseFiller(JasperReport jasperReport, JREvaluator initEvaluator, JRBaseFiller parentFiller) throws JRException {
        this.fillerId = Integer.toString(System.identityHashCode(this));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.fillerId + ": created for " + jasperReport.getName()));
        }
        JRGraphEnvInitializer.initializeGraphEnv();
        this.jasperReport = jasperReport;
        this.parentFiller = parentFiller;
        this.fillContext = parentFiller == null ? new JRFillContext() : parentFiller.fillContext;
        this.name = jasperReport.getName();
        this.columnCount = jasperReport.getColumnCount();
        this.printOrder = jasperReport.getPrintOrder();
        this.pageWidth = jasperReport.getPageWidth();
        this.pageHeight = jasperReport.getPageHeight();
        this.orientation = jasperReport.getOrientation();
        this.whenNoDataType = jasperReport.getWhenNoDataType();
        this.columnWidth = jasperReport.getColumnWidth();
        this.columnSpacing = jasperReport.getColumnSpacing();
        this.leftMargin = jasperReport.getLeftMargin();
        this.rightMargin = jasperReport.getRightMargin();
        this.topMargin = jasperReport.getTopMargin();
        this.bottomMargin = jasperReport.getBottomMargin();
        this.isTitleNewPage = jasperReport.isTitleNewPage();
        this.isSummaryNewPage = jasperReport.isSummaryNewPage();
        this.isFloatColumnFooter = jasperReport.isFloatColumnFooter();
        this.whenResourceMissingType = jasperReport.getWhenResourceMissingType();
        this.jasperPrint = new JasperPrint();
        this.calculator = initEvaluator == null ? JRFillDataset.createCalculator(jasperReport, jasperReport.getMainDataset()) : new JRCalculator(initEvaluator);
        JRFillObjectFactory factory = new JRFillObjectFactory(this);
        this.defaultFont = factory.getReportFont(jasperReport.getDefaultFont());
        JRReportFont[] jrFonts = jasperReport.getFonts();
        if (jrFonts != null && jrFonts.length > 0) {
            this.fonts = new JRReportFont[jrFonts.length];
            for (int i = 0; i < this.fonts.length; ++i) {
                this.fonts[i] = factory.getReportFont(jrFonts[i]);
            }
        }
        this.createDatasets(factory);
        this.mainDataset = factory.getDataset(jasperReport.getMainDataset());
        this.groups = this.mainDataset.groups;
        this.defaultStyle = factory.getStyle(jasperReport.getDefaultStyle());
        JRStyle[] jrStyles = jasperReport.getStyles();
        if (jrStyles != null && jrStyles.length > 0) {
            this.styles = new JRStyle[jrStyles.length];
            for (int i = 0; i < this.styles.length; ++i) {
                this.styles[i] = factory.getStyle(jrStyles[i]);
            }
        }
        this.missingFillBand = factory.getBand(null);
        this.background = factory.getBand(jasperReport.getBackground());
        this.title = factory.getBand(jasperReport.getTitle());
        this.pageHeader = factory.getBand(jasperReport.getPageHeader());
        this.columnHeader = factory.getBand(jasperReport.getColumnHeader());
        this.detail = factory.getBand(jasperReport.getDetail());
        this.columnFooter = factory.getBand(jasperReport.getColumnFooter());
        this.pageFooter = factory.getBand(jasperReport.getPageFooter());
        this.lastPageFooter = factory.getBand(jasperReport.getLastPageFooter());
        this.summary = factory.getBand(jasperReport.getSummary());
        if (this.summary != this.missingFillBand && this.summary.isEmpty()) {
            this.summary = this.missingFillBand;
        }
        this.mainDataset.initElementDatasets(factory);
        this.initDatasets(factory);
        this.mainDataset.checkVariableCalculationReqs(factory);
        this.mainDataset.setCalculator(this.calculator);
        this.mainDataset.initCalculator();
        this.initBands();
    }

    protected Map getParametersMap() {
        return this.mainDataset.parametersMap;
    }

    protected Map getFieldsMap() {
        return this.mainDataset.fieldsMap;
    }

    protected Map getVariablesMap() {
        return this.mainDataset.variablesMap;
    }

    protected JRFillVariable getVariable(String variableName) {
        return (JRFillVariable)this.mainDataset.variablesMap.get(variableName);
    }

    protected JRFillField getField(String fieldName) {
        return (JRFillField)this.mainDataset.fieldsMap.get(fieldName);
    }

    private void initBands() {
        this.bands = new ArrayList(8 + (this.groups == null ? 0 : 2 * this.groups.length));
        this.bands.add(this.title);
        this.bands.add(this.summary);
        this.bands.add(this.pageHeader);
        this.bands.add(this.pageFooter);
        this.bands.add(this.lastPageFooter);
        this.bands.add(this.columnHeader);
        this.bands.add(this.columnFooter);
        this.bands.add(this.detail);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                this.bands.add(group.getGroupHeader());
                this.bands.add(group.getGroupFooter());
            }
        }
        this.initBandsNowEvaluationTimes();
    }

    private void initBandsNowEvaluationTimes() {
        JREvaluationTime[] groupEvaluationTimes;
        if (this.groups == null) {
            groupEvaluationTimes = new JREvaluationTime[]{};
        } else {
            int i;
            groupEvaluationTimes = new JREvaluationTime[this.groups.length];
            for (i = 0; i < this.groups.length; ++i) {
                groupEvaluationTimes[i] = JREvaluationTime.getGroupEvaluationTime(this.groups[i].getName());
            }
            for (i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                JRFillBand footer = (JRFillBand)group.getGroupFooter();
                for (int j = i; j < groupEvaluationTimes.length; ++j) {
                    footer.addNowEvaluationTime(groupEvaluationTimes[j]);
                }
            }
        }
        this.columnFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.summary.addNowEvaluationTimes(groupEvaluationTimes);
    }

    public JRStyledTextParser getStyledTextParser() {
        return this.styledTextParser;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    protected boolean isSubreport() {
        return this.parentFiller != null;
    }

    protected boolean isInterrupted() {
        return this.isInterrupted || this.parentFiller != null && this.parentFiller.isInterrupted();
    }

    protected void setInterrupted(boolean isInterrupted) {
        this.isInterrupted = isInterrupted;
    }

    protected JRPrintPage getCurrentPage() {
        return this.printPage;
    }

    protected JRReportFont[] getFonts() {
        return this.fonts;
    }

    protected int getCurrentPageStretchHeight() {
        return this.printPageStretchHeight;
    }

    protected abstract void setPageHeight(int var1);

    public JasperPrint fill(Map parameterValues, Connection conn) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap();
        }
        this.setConnectionParameterValue(parameterValues, conn);
        return this.fill(parameterValues);
    }

    protected void setConnectionParameterValue(Map parameterValues, Connection conn) {
        this.mainDataset.setConnectionParameterValue(parameterValues, conn);
    }

    public JasperPrint fill(Map parameterValues, JRDataSource ds) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap();
        }
        this.setDatasourceParameterValue(parameterValues, ds);
        return this.fill(parameterValues);
    }

    protected void setDatasourceParameterValue(Map parameterValues, JRDataSource ds) {
        this.mainDataset.setDatasourceParameterValue(parameterValues, ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperPrint fill(Map parameterValues) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.fillerId + ": filling report"));
        }
        this.fillingThread = Thread.currentThread();
        boolean urlHandlerFactorySet = false;
        boolean classLoaderSet = false;
        try {
            int i;
            this.setParameters(parameterValues);
            classLoaderSet = this.setClassLoader(parameterValues);
            urlHandlerFactorySet = this.setUrlHandlerFactory(parameterValues);
            if (this.parentFiller != null) {
                this.parentFiller.registerSubfiller(this);
            }
            this.jasperPrint.setName(this.name);
            this.jasperPrint.setPageWidth(this.pageWidth);
            this.jasperPrint.setPageHeight(this.pageHeight);
            this.jasperPrint.setOrientation(this.orientation);
            this.jasperPrint.setDefaultFont(this.defaultFont);
            this.jasperPrint.setFormatFactoryClass(this.jasperReport.getFormatFactoryClass());
            this.jasperPrint.setLocaleCode(JRDataUtils.getLocaleCode(this.getLocale()));
            this.jasperPrint.setTimeZoneId(JRDataUtils.getTimeZoneId(this.getTimeZone()));
            if (this.fonts != null && this.fonts.length > 0) {
                for (i = 0; i < this.fonts.length; ++i) {
                    this.jasperPrint.addFont(this.fonts[i], true);
                }
            }
            this.jasperPrint.setDefaultStyle(this.defaultStyle);
            if (this.styles != null && this.styles.length > 0) {
                for (i = 0; i < this.styles.length; ++i) {
                    this.jasperPrint.addStyle(this.styles[i], true);
                }
            }
            this.createBoundElemementMaps();
            this.mainDataset.start();
            this.fillReport();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.fillerId + ": ended"));
            }
            JasperPrint jasperPrint = this.jasperPrint;
            return jasperPrint;
        }
        finally {
            this.mainDataset.closeDatasource();
            if (this.parentFiller != null) {
                this.parentFiller.unregisterSubfiller(this);
            }
            this.fillingThread = null;
            this.killSubfillerThreads();
            if (classLoaderSet) {
                JRResourcesUtil.resetClassLoader();
            }
            if (urlHandlerFactorySet) {
                JRResourcesUtil.resetThreadURLHandlerFactory();
            }
        }
    }

    private void createBoundElemementMaps() {
        this.boundElements = new HashMap();
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_REPORT);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_COLUMN);
        if (this.groups != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.createBoundElementMaps(JREvaluationTime.getGroupEvaluationTime(this.groups[i].getName()));
            }
        }
        Iterator i = this.bands.iterator();
        while (i.hasNext()) {
            JRFillBand band = (JRFillBand)i.next();
            this.createBoundElementMaps(JREvaluationTime.getBandEvaluationTime(band));
        }
    }

    private void createBoundElementMaps(JREvaluationTime evaluationTime) {
        BoundElementMap boundElementsMap = new BoundElementMap();
        this.boundElements.put(evaluationTime, boundElementsMap);
    }

    private void killSubfillerThreads() {
        if (this.subfillers != null && !this.subfillers.isEmpty()) {
            Iterator it = this.subfillers.iterator();
            while (it.hasNext()) {
                JRBaseFiller subfiller = (JRBaseFiller)it.next();
                if (subfiller.fillingThread == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.fillerId + ": Interrupting subfiller thread " + subfiller.fillingThread));
                }
                subfiller.fillingThread.interrupt();
            }
        }
    }

    protected abstract void fillReport() throws JRException;

    protected void setParameters(Map parameterValues) throws JRException {
        if (!this.isSubreport()) {
            this.virtualizer = (JRVirtualizer)parameterValues.get("REPORT_VIRTUALIZER");
            if (this.virtualizer != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.fillerId + ": using virtualizer " + this.virtualizer));
                }
                this.fillContext.setUsingVirtualizer(true);
                this.fillContext.setPerPageBoundElements(true);
                JRVirtualizationContext.register(this.fillContext.getVirtualizationContext(), this.jasperPrint);
            }
        }
        this.isPerPageBoundElements = this.fillContext.isPerPageBoundElements();
        this.setFormatFactory(parameterValues);
        this.setIgnorePagination(parameterValues);
        this.mainDataset.setParameterValues(parameterValues);
        this.scriptlet = this.mainDataset.scriptlet;
        if (!this.isSubreport()) {
            this.fillContext.setMasterFormatFactory(this.getFormatFactory());
            this.fillContext.setMasterLocale(this.getLocale());
            this.fillContext.setMasterTimeZone(this.getTimeZone());
        }
    }

    private void setFormatFactory(Map parameterValues) {
        this.formatFactory = (FormatFactory)parameterValues.get("REPORT_FORMAT_FACTORY");
        if (this.formatFactory == null) {
            this.formatFactory = DefaultFormatFactory.createFormatFactory(this.jasperReport.getFormatFactoryClass());
            parameterValues.put("REPORT_FORMAT_FACTORY", this.formatFactory);
        }
    }

    private boolean setClassLoader(Map parameterValues) {
        boolean setClassLoader;
        this.reportClassLoader = (ClassLoader)parameterValues.get("REPORT_CLASS_LOADER");
        boolean bl = setClassLoader = this.reportClassLoader != null;
        if (setClassLoader) {
            JRResourcesUtil.setThreadClassLoader(this.reportClassLoader);
        }
        return setClassLoader;
    }

    private boolean setUrlHandlerFactory(Map parameterValues) {
        boolean setUrlHandlerFactory;
        this.urlHandlerFactory = (URLStreamHandlerFactory)parameterValues.get("REPORT_URL_HANDLER_FACTORY");
        boolean bl = setUrlHandlerFactory = this.urlHandlerFactory != null;
        if (setUrlHandlerFactory) {
            JRResourcesUtil.setThreadURLHandlerFactory(this.urlHandlerFactory);
        }
        return setUrlHandlerFactory;
    }

    private void setIgnorePagination(Map parameterValues) {
        if (this.parentFiller == null) {
            Boolean isIgnorePaginationParam = (Boolean)parameterValues.get("IS_IGNORE_PAGINATION");
            if (isIgnorePaginationParam != null) {
                this.fillContext.setIgnorePagination(isIgnorePaginationParam);
            } else {
                boolean ignorePagination = this.jasperReport.isIgnorePagination();
                this.fillContext.setIgnorePagination(ignorePagination);
                parameterValues.put("IS_IGNORE_PAGINATION", ignorePagination ? Boolean.TRUE : Boolean.FALSE);
            }
        } else {
            boolean ignorePagination = this.fillContext.isIgnorePagination();
            parameterValues.put("IS_IGNORE_PAGINATION", ignorePagination ? Boolean.TRUE : Boolean.FALSE);
        }
        if (this.fillContext.isIgnorePagination()) {
            this.isTitleNewPage = false;
            this.isSummaryNewPage = false;
            if (this.groups != null) {
                for (int i = 0; i < this.groups.length; ++i) {
                    this.groups[i].setStartNewPage(false);
                    this.groups[i].setResetPageNumber(false);
                    this.groups[i].setStartNewColumn(false);
                }
            }
            this.setPageHeight(Integer.MAX_VALUE);
        }
    }

    protected Locale getLocale() {
        return this.mainDataset.locale;
    }

    protected TimeZone getTimeZone() {
        return this.mainDataset.timeZone;
    }

    protected FormatFactory getFormatFactory() {
        return this.formatFactory;
    }

    protected Format getDateFormat(String pattern) {
        Locale lc = this.getLocale();
        TimeZone tz = this.getTimeZone();
        String key = pattern + "|" + JRDataUtils.getLocaleCode(lc) + "|" + JRDataUtils.getTimeZoneId(tz);
        Format format = (Format)this.dateFormatCache.get(key);
        if (format == null && (format = this.getFormatFactory().createDateFormat(pattern, lc, tz)) != null) {
            this.dateFormatCache.put(key, format);
        }
        return format;
    }

    protected Format getNumberFormat(String pattern) {
        Locale lc = this.getLocale();
        String key = pattern + "|" + JRDataUtils.getLocaleCode(lc);
        Format format = (Format)this.numberFormatCache.get(key);
        if (format == null && (format = this.getFormatFactory().createNumberFormat(pattern, lc)) != null) {
            this.numberFormatCache.put(key, format);
        }
        return format;
    }

    protected boolean hasMasterFormatFactory() {
        return !this.isSubreport() || this.getFormatFactory().getClass().getName().equals(this.fillContext.getMasterFormatFactory().getClass().getName());
    }

    protected boolean hasMasterLocale() {
        return !this.isSubreport() || this.getLocale().equals(this.fillContext.getMasterLocale());
    }

    protected boolean hasMasterTimeZone() {
        return !this.isSubreport() || this.getTimeZone().equals(this.fillContext.getMasterTimeZone());
    }

    protected void setParameter(String parameterName, Object value) throws JRException {
        this.mainDataset.setParameter(parameterName, value);
    }

    protected void setParameter(JRFillParameter parameter, Object value) throws JRException {
        this.mainDataset.setParameter(parameter, value);
    }

    protected boolean next() throws JRException {
        return this.mainDataset.next();
    }

    private void resolveBoundElements(Map boundElementsMap, byte evaluation, JREvaluationTime evaluationTime) throws JRException {
        if (boundElementsMap != null) {
            Iterator it = boundElementsMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                JRPrintElement element = (JRPrintElement)entry.getKey();
                JRFillElement fillElement = (JRFillElement)entry.getValue();
                fillElement.resolveElement(element, evaluation, evaluationTime);
            }
        }
    }

    protected void resolveBoundElements(JREvaluationTime evaluationTime, byte evaluation) throws JRException {
        BoundElementMap boundElementsMap = (BoundElementMap)this.boundElements.get(evaluationTime);
        if (this.isPerPageBoundElements) {
            Map perPageElementsMap = boundElementsMap.getMap();
            Iterator it = perPageElementsMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                JRPrintPage page = (JRPrintPage)entry.getKey();
                page.getElements();
                Map elementsMap = (Map)entry.getValue();
                this.resolveBoundElements(elementsMap, evaluation, evaluationTime);
            }
            boundElementsMap.clear();
        } else {
            this.resolveBoundElements(boundElementsMap.getMap(), evaluation, evaluationTime);
            boundElementsMap.clear();
        }
    }

    protected void resolveReportBoundElements() throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_REPORT, (byte)3);
    }

    protected void resolvePageBoundElements(byte evaluation) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_PAGE, evaluation);
    }

    protected void resolveColumnBoundElements(byte evaluation) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_COLUMN, evaluation);
    }

    protected void resolveGroupBoundElements(byte evaluation, boolean isFinal) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                if ((!group.hasChanged() || !group.isFooterPrinted()) && !isFinal) continue;
                String groupName = group.getName();
                this.resolveBoundElements(JREvaluationTime.getGroupEvaluationTime(groupName), evaluation);
            }
        }
    }

    protected JRPrintPage newPage() {
        Serializable page;
        if (this.virtualizer != null) {
            JRVirtualPrintPage virtualPage = new JRVirtualPrintPage(this.jasperPrint, this.virtualizer, this.fillContext.getVirtualizationContext());
            JRBaseFiller.addIdentityDataProviders(virtualPage, this);
            page = virtualPage;
        } else {
            page = new JRBasePrintPage();
        }
        return page;
    }

    public Object getVariableValue(String variableName) {
        return this.mainDataset.getVariableValue(variableName);
    }

    protected void resolveBandBoundElements(JRFillBand band, byte evaluation) throws JRException {
        this.resolveBoundElements(JREvaluationTime.getBandEvaluationTime(band), evaluation);
    }

    protected void addVariableCalculationReq(String variableName, byte calculation) {
        this.mainDataset.addVariableCalculationReq(variableName, calculation);
    }

    public void cancelFill() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.fillerId + ": cancelling"));
        }
        if (this.fillContext.cancelRunningQuery()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.fillerId + ": query cancelled"));
            }
        } else {
            Thread t = this.fillingThread;
            if (t != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.fillerId + ": Interrupting thread " + t));
                }
                t.interrupt();
            }
        }
    }

    protected void registerSubfiller(JRBaseFiller subfiller) {
        if (this.subfillers == null) {
            this.subfillers = new HashSet();
        }
        if (this.subfillers.add(subfiller) && this.fillContext.isUsingVirtualizer()) {
            subfiller.identityPages = new ArrayList();
            JRVirtualPrintPage masterPrintPage = (JRVirtualPrintPage)this.fillContext.getPrintPage();
            subfiller.identityPages.add(masterPrintPage);
            JRBaseFiller.addIdentityDataProviders(masterPrintPage, subfiller);
        }
    }

    protected void unregisterSubfiller(JRBaseFiller subfiller) {
        if (this.subfillers != null && this.subfillers.remove(subfiller) && this.fillContext.isUsingVirtualizer()) {
            this.removeIdentityDataProviders(subfiller);
        }
    }

    private static void addIdentityDataProviders(JRVirtualPrintPage page, JRBaseFiller filler) {
        page.addIdentityDataProvider(filler);
        if (filler.subfillers != null) {
            Iterator i = filler.subfillers.iterator();
            while (i.hasNext()) {
                JRBaseFiller subfiller = (JRBaseFiller)i.next();
                subfiller.identityPages.add(page);
                JRBaseFiller.addIdentityDataProviders(page, subfiller);
            }
        }
    }

    private void removeIdentityDataProviders(JRBaseFiller filler) {
        if (filler.identityPages != null) {
            Iterator it = filler.identityPages.iterator();
            while (it.hasNext()) {
                JRVirtualPrintPage page = (JRVirtualPrintPage)it.next();
                page.removeIdentityDataProvider(filler);
            }
            filler.identityPages = null;
        }
    }

    protected void addPage(JRPrintPage page) {
        if (!this.isSubreport()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.fillerId + ": adding page " + (this.jasperPrint.getPages().size() + 1)));
            }
            this.jasperPrint.addPage(page);
            this.fillContext.setPrintPage(page);
        }
    }

    protected void addPageIdentityDataProvider() {
        JRVirtualPrintPage.IdentityDataProvider pageProvider = PageIdentityDataProvider.getIdentityDataProvider(this.printPage);
        JRVirtualPrintPage masterPage = (JRVirtualPrintPage)this.fillContext.getPrintPage();
        masterPage.addIdentityDataProvider(pageProvider);
    }

    protected void removePageIdentityDataProvider() {
        JRVirtualPrintPage.IdentityDataProvider pageProvider = PageIdentityDataProvider.removeIdentityDataProvider(this.printPage);
        if (pageProvider != null) {
            ((JRVirtualPrintPage)this.fillContext.getPrintPage()).removeIdentityDataProvider(pageProvider);
        }
    }

    protected Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.mainDataset.calculator.evaluate(expression, evaluation);
    }

    private void createDatasets(JRFillObjectFactory factory) throws JRException {
        this.datasetMap = new HashMap();
        JRDataset[] datasets = this.jasperReport.getDatasets();
        if (datasets != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                JRFillDataset fillDataset = factory.getDataset(datasets[i]);
                fillDataset.createCalculator(this.jasperReport);
                this.datasetMap.put(datasets[i].getName(), fillDataset);
            }
        }
    }

    private void initDatasets(JRFillObjectFactory factory) {
        Iterator it = this.datasetMap.values().iterator();
        while (it.hasNext()) {
            JRFillDataset dataset = (JRFillDataset)it.next();
            dataset.inheritFromMain();
            dataset.initElementDatasets(factory);
        }
    }

    protected byte getWhenResourceMissingType() {
        return this.mainDataset.whenResourceMissingType;
    }

    protected JasperReport getJasperReport() {
        return this.jasperReport;
    }

    protected boolean isBandOverFlowAllowed() {
        return this.bandOverFlowAllowed;
    }

    protected void setBandOverFlowAllowed(boolean splittableBand) {
        this.bandOverFlowAllowed = splittableBand;
    }

    protected int getMasterColumnCount() {
        JRBaseFiller filler = this.parentFiller;
        int colCount = 1;
        while (filler != null) {
            colCount *= filler.columnCount;
            filler = filler.parentFiller;
        }
        return colCount;
    }

    public JRFillDataset getMainDataset() {
        return this.mainDataset;
    }

    protected void addBoundElement(JRFillElement element, JRPrintElement printElement, byte evaluationType, JRGroup group, JRFillBand band) {
        JREvaluationTime evaluationTime = JREvaluationTime.getEvaluationTime(evaluationType, group, band);
        this.addBoundElement(element, printElement, evaluationTime);
    }

    protected void addBoundElement(JRFillElement element, JRPrintElement printElement, JREvaluationTime evaluationTime) {
        BoundElementMap boundElementsMap = (BoundElementMap)this.boundElements.get(evaluationTime);
        boundElementsMap.put(printElement, element);
    }

    public JRVirtualPrintPage.ObjectIDPair[] getIdentityData(JRVirtualPrintPage page) {
        HashMap allElements = new HashMap();
        ArrayList<JRVirtualPrintPage.ObjectIDPair> identityList = new ArrayList<JRVirtualPrintPage.ObjectIDPair>();
        Iterator it = this.boundElements.values().iterator();
        while (it.hasNext()) {
            BoundElementMap pageBoundElementsMap = (BoundElementMap)it.next();
            Map map = pageBoundElementsMap.getMap(page);
            if (map == null || map.isEmpty()) continue;
            HashMap idMap = new HashMap();
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Integer id = (Integer)allElements.get(key);
                if (id == null) {
                    JRVirtualPrintPage.ObjectIDPair idPair = new JRVirtualPrintPage.ObjectIDPair(key);
                    identityList.add(idPair);
                    id = new Integer(idPair.getIdentity());
                    allElements.put(key, id);
                }
                idMap.put(id, entry.getValue());
            }
            pageBoundElementsMap.putMap(page, idMap);
        }
        JRVirtualPrintPage.ObjectIDPair[] identityData = null;
        if (!identityList.isEmpty()) {
            identityData = new JRVirtualPrintPage.ObjectIDPair[identityList.size()];
            identityList.toArray(identityData);
        }
        return identityData;
    }

    public void setIdentityData(JRVirtualPrintPage page, JRVirtualPrintPage.ObjectIDPair[] identityData) {
        if (identityData == null || identityData.length == 0) {
            return;
        }
        Iterator it = this.boundElements.values().iterator();
        while (it.hasNext()) {
            BoundElementMap pageBoundElementsMap = (BoundElementMap)it.next();
            Map idMap = pageBoundElementsMap.getMap(page);
            if (idMap == null || idMap.isEmpty()) continue;
            HashMap map = new HashMap();
            for (int i = 0; i < identityData.length; ++i) {
                JRVirtualPrintPage.ObjectIDPair idPair = identityData[i];
                Integer id = new Integer(idPair.getIdentity());
                Object value = idMap.get(id);
                if (value == null) continue;
                map.put(idPair.getObject(), value);
            }
            pageBoundElementsMap.putMap(page, map);
        }
    }

    protected void setSubreportRunner(JRSubreportRunner runner) {
        this.subreportRunner = runner;
    }

    protected void suspendSubreportRunner() throws JRException {
        if (this.subreportRunner == null) {
            throw new JRRuntimeException("No subreport runner set.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.fillerId + ": suspeding subreport runner"));
        }
        this.subreportRunner.suspend();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static final class PageIdentityDataProvider
    implements JRVirtualPrintPage.IdentityDataProvider {
        private static final Map providers = new HashMap();
        private final JRPrintPage printPage;

        protected PageIdentityDataProvider(JRPrintPage printPage) {
            this.printPage = printPage;
        }

        public JRVirtualPrintPage.ObjectIDPair[] getIdentityData(JRVirtualPrintPage page) {
            return null;
        }

        public void setIdentityData(JRVirtualPrintPage page, JRVirtualPrintPage.ObjectIDPair[] identityData) {
            if (identityData != null && identityData.length > 0) {
                HashMap<Integer, Object> idMap = new HashMap<Integer, Object>();
                for (int i = 0; i < identityData.length; ++i) {
                    idMap.put(new Integer(identityData[i].getIdentity()), identityData[i].getObject());
                }
                ListIterator i = this.printPage.getElements().listIterator();
                while (i.hasNext()) {
                    Object element = i.next();
                    Integer id = new Integer(System.identityHashCode(element));
                    Object idObject = idMap.get(id);
                    if (idObject == null) continue;
                    i.set(idObject);
                }
            }
        }

        public static JRVirtualPrintPage.IdentityDataProvider getIdentityDataProvider(JRPrintPage printPage) {
            JRVirtualPrintPage.IdentityDataProvider provider = (JRVirtualPrintPage.IdentityDataProvider)providers.get(printPage);
            if (provider == null) {
                provider = new PageIdentityDataProvider(printPage);
                providers.put(printPage, provider);
            }
            return provider;
        }

        public static JRVirtualPrintPage.IdentityDataProvider removeIdentityDataProvider(JRPrintPage printPage) {
            JRVirtualPrintPage.IdentityDataProvider provider = (JRVirtualPrintPage.IdentityDataProvider)providers.remove(printPage);
            return provider;
        }
    }

    public class BoundElementMap {
        private static final long serialVersionUID = 10200L;
        private final Map map = new HashMap();

        BoundElementMap() {
        }

        public Object put(Object key, Object value, JRPrintPage keyPage) {
            HashMap<Object, Object> pageMap = (HashMap<Object, Object>)this.map.get(keyPage);
            if (pageMap == null) {
                pageMap = new HashMap<Object, Object>();
                this.map.put(keyPage, pageMap);
            }
            return pageMap.put(key, value);
        }

        public Object put(Object key, Object value) {
            if (JRBaseFiller.this.isPerPageBoundElements) {
                return this.put(key, value, JRBaseFiller.this.fillContext.getPrintPage());
            }
            return this.map.put(key, value);
        }

        public void clear() {
            this.map.clear();
        }

        public Map getMap() {
            return this.map;
        }

        public Map getMap(JRPrintPage page) {
            return (Map)this.map.get(page);
        }

        public Map putMap(JRPrintPage page, Map valueMap) {
            return this.map.put(page, valueMap);
        }
    }
}

