/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.io.InputStream;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.view.JRPreviewBuilder;
import net.sf.jasperreports.view.JRViewer;

public class JRDesignViewer
extends JRViewer {
    private boolean isXML;

    public JRDesignViewer(String fileName, boolean isXML) throws JRException {
        this(fileName, isXML, null);
    }

    public JRDesignViewer(InputStream is, boolean isXML) throws JRException {
        this(is, isXML, null);
    }

    public JRDesignViewer(JasperPrint jrPrint) {
        this(jrPrint, null);
    }

    public JRDesignViewer(JasperPrint jrPrint, boolean isXML) {
        this(jrPrint, isXML, null);
    }

    public JRDesignViewer(String fileName, boolean isXML, Locale locale) throws JRException {
        this(fileName, isXML, locale, null);
    }

    public JRDesignViewer(InputStream is, boolean isXML, Locale locale) throws JRException {
        this(is, isXML, locale, null);
    }

    public JRDesignViewer(JasperPrint jrPrint, Locale locale) {
        this(jrPrint, locale, null);
    }

    public JRDesignViewer(JasperPrint jrPrint, boolean isXML, Locale locale) {
        this(jrPrint, isXML, locale, null);
    }

    public JRDesignViewer(String fileName, boolean isXML, Locale locale, ResourceBundle resBundle) throws JRException {
        super(fileName, isXML, locale, resBundle);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(InputStream is, boolean isXML, Locale locale, ResourceBundle resBundle) throws JRException {
        super(is, isXML, locale, resBundle);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(JasperPrint jrPrint, boolean isXML, Locale locale, ResourceBundle resBundle) {
        this(jrPrint, locale, resBundle);
        this.loadReport(jrPrint, isXML);
    }

    public JRDesignViewer(JasperPrint jrPrint, Locale locale, ResourceBundle resBundle) {
        super(jrPrint, locale, resBundle);
        this.hideUnusedComponents();
    }

    private void hideUnusedComponents() {
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrevious.setVisible(false);
        this.btnNext.setVisible(false);
        this.txtGoTo.setVisible(false);
        this.pnlStatus.setVisible(false);
    }

    protected void loadReport(String fileName, boolean isXmlReport) throws JRException {
        if (fileName != null && fileName.endsWith(".jrxml")) {
            JasperDesign jasperDesign = JRXmlLoader.load(fileName);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(fileName));
        }
        this.isXML = isXmlReport;
        this.reportFileName = fileName;
    }

    protected void loadReport(InputStream is, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(is);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(is));
        }
        this.isXML = isXmlReport;
    }

    protected void loadReport(JasperPrint jrPrint, boolean isXmlFile) {
        this.jasperPrint = jrPrint;
        if (isXmlFile) {
            this.reportFileName = this.jasperPrint.getName() + ".jrxml";
        }
    }

    protected void loadReport(JasperPrint jrPrint) {
        this.jasperPrint = jrPrint;
        if (this.isXML) {
            this.reportFileName = this.jasperPrint.getName() + ".jrxml";
        }
    }

    private void setReport(JRReport report) throws JRException {
        if (report instanceof JasperDesign) {
            this.verifyDesign((JasperDesign)report);
        }
        this.jasperPrint = new JRPreviewBuilder(report).getJasperPrint();
    }

    private void verifyDesign(JasperDesign jasperDesign) throws JRException {
        Collection brokenRules = JasperCompileManager.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            throw new JRValidationException(brokenRules);
        }
    }
}

