/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import mondrian.olap.Category;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunCall;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.util.Format;
import org.apache.log4j.Logger;
import org.eigenbase.xom.XOMUtil;

public class Util
extends XOMUtil {
    public static final String nl = System.getProperty("line.separator");
    private static final Logger LOGGER = Logger.getLogger((Class)Util.class);
    public static final Object nullValue = new NullCellValue();
    private static long databaseMillis = 0L;
    private static final Random metaRandom = Util.createRandom(MondrianProperties.instance().TestSeed.get());
    private static final Format.LocaleFormatFactory localeFormatFactory = Util.createLocaleFormatFactory();

    private static Format.LocaleFormatFactory createLocaleFormatFactory() {
        Format.LocaleFormatFactory factory = new Format.LocaleFormatFactory(){

            public Format.FormatLocale get(Locale locale) {
                MondrianResource res = MondrianResource.instance(locale);
                if (res == null || !res.getLocale().equals(locale)) {
                    return null;
                }
                char thousandSeparator = res.FormatThousandSeparator.str().charAt(0);
                char decimalPlaceholder = res.FormatDecimalPlaceholder.str().charAt(0);
                String dateSeparator = res.FormatDateSeparator.str();
                String timeSeparator = res.FormatTimeSeparator.str();
                String currencySymbol = res.FormatCurrencySymbol.str();
                String currencyFormat = res.FormatCurrencyFormat.str();
                String[] daysOfWeekShort = new String[]{res.FormatShortDaysSun.str(), res.FormatShortDaysMon.str(), res.FormatShortDaysTue.str(), res.FormatShortDaysWed.str(), res.FormatShortDaysThu.str(), res.FormatShortDaysFri.str(), res.FormatShortDaysSat.str()};
                String[] daysOfWeekLong = new String[]{res.FormatLongDaysSunday.str(), res.FormatLongDaysMonday.str(), res.FormatLongDaysTuesday.str(), res.FormatLongDaysWednesday.str(), res.FormatLongDaysThursday.str(), res.FormatLongDaysFriday.str(), res.FormatLongDaysSaturday.str()};
                String[] monthsShort = new String[]{res.FormatShortMonthsJan.str(), res.FormatShortMonthsFeb.str(), res.FormatShortMonthsMar.str(), res.FormatShortMonthsApr.str(), res.FormatShortMonthsMay.str(), res.FormatShortMonthsJun.str(), res.FormatShortMonthsJul.str(), res.FormatShortMonthsAug.str(), res.FormatShortMonthsSep.str(), res.FormatShortMonthsOct.str(), res.FormatShortMonthsNov.str(), res.FormatShortMonthsDec.str()};
                String[] monthsLong = new String[]{res.FormatLongMonthsJanuary.str(), res.FormatLongMonthsFebruary.str(), res.FormatLongMonthsMarch.str(), res.FormatLongMonthsApril.str(), res.FormatLongMonthsMay.str(), res.FormatLongMonthsJune.str(), res.FormatLongMonthsJuly.str(), res.FormatLongMonthsAugust.str(), res.FormatLongMonthsSeptember.str(), res.FormatLongMonthsOctober.str(), res.FormatLongMonthsNovember.str(), res.FormatLongMonthsDecember.str()};
                return Format.createLocale(thousandSeparator, decimalPlaceholder, dateSeparator, timeSeparator, currencySymbol, currencyFormat, daysOfWeekShort, daysOfWeekLong, monthsShort, monthsLong, locale);
            }
        };
        Format.setLocaleFormatFactory(factory);
        return factory;
    }

    public static String mdxEncodeString(String st) {
        StringBuffer retString = new StringBuffer(st.length() + 20);
        for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            if (c == ']' && i + 1 < st.length() && st.charAt(i + 1) != '.') {
                retString.append(']');
            }
            retString.append(c);
        }
        return retString.toString();
    }

    public static String quoteForMdx(String val) {
        StringBuffer buf = new StringBuffer(val.length() + 20);
        buf.append("\"");
        String s0 = Util.replace(val, "\"", "\"\"");
        buf.append(s0);
        buf.append("\"");
        return buf.toString();
    }

    public static String quoteMdxIdentifier(String id) {
        StringBuffer buf = new StringBuffer(id.length() + 20);
        Util.quoteMdxIdentifier(id, buf);
        return buf.toString();
    }

    public static void quoteMdxIdentifier(String id, StringBuffer buf) {
        buf.append('[');
        int start = buf.length();
        buf.append(id);
        Util.replace(buf, start, "]", "]]");
        buf.append(']');
    }

    public static String quoteMdxIdentifier(String[] ids) {
        StringBuffer sb = new StringBuffer(64);
        Util.quoteMdxIdentifier(ids, sb);
        return sb.toString();
    }

    public static void quoteMdxIdentifier(String[] ids, StringBuffer sb) {
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            Util.quoteMdxIdentifier(ids[i], sb);
        }
    }

    public static boolean equals(Object s, Object t) {
        return s == null ? t == null : s.equals(t);
    }

    public static boolean equals(String s, String t) {
        return Util.equals((Object)s, (Object)t);
    }

    public static boolean equalName(String s, String t) {
        if (s == null) {
            return t == null;
        }
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        return caseSensitive ? s.equals(t) : s.equalsIgnoreCase(t);
    }

    public static String normalizeName(String s) {
        return MondrianProperties.instance().CaseSensitive.get() ? s : s.toUpperCase();
    }

    public static String replace(String s, String find, String replace) {
        int found = s.indexOf(find);
        if (found == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() + 20);
        int start = 0;
        char[] chars = s.toCharArray();
        int step = find.length();
        if (step == 0) {
            sb.append(s);
            Util.replace(sb, 0, find, replace);
        } else {
            while (true) {
                sb.append(chars, start, found - start);
                if (found == s.length()) break;
                sb.append(replace);
                start = found + step;
                if ((found = s.indexOf(find, start)) != -1) continue;
                found = s.length();
            }
        }
        return sb.toString();
    }

    public static StringBuffer replace(StringBuffer buf, int start, String find, String replace) {
        int i;
        int findLength = find.length();
        if (findLength == 0) {
            for (int j = buf.length(); j >= 0; --j) {
                buf.insert(j, replace);
            }
            return buf;
        }
        int k = buf.length();
        while (k > 0 && (i = buf.lastIndexOf(find, k)) >= start) {
            buf.replace(i, i + find.length(), replace);
            k = i - findLength;
        }
        return buf;
    }

    public static String[] explode(String s) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != '[') {
                throw MondrianResource.instance().MdxInvalidMember.ex(s);
            }
            int j = s.indexOf("].", i);
            if (j == -1) {
                j = s.lastIndexOf(93);
            }
            if (j <= i) {
                throw MondrianResource.instance().MdxInvalidMember.ex(s);
            }
            String sub = s.substring(i + 1, j);
            sub = Util.replace(sub, "]]", "]");
            list.add(sub);
            if (j + 1 < s.length() && s.charAt(j + 1) != '.') {
                throw MondrianResource.instance().MdxInvalidMember.ex(s);
            }
            i = j + 2;
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    public static String implode(String[] names) {
        StringBuffer sb = new StringBuffer(64);
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            Util.quoteMdxIdentifier(names[i], sb);
        }
        return sb.toString();
    }

    public static String makeFqName(String name) {
        return Util.quoteMdxIdentifier(name);
    }

    public static String makeFqName(OlapElement parent, String name) {
        if (parent == null) {
            return Util.quoteMdxIdentifier(name);
        }
        StringBuffer buf = new StringBuffer(64);
        buf.append(parent.getUniqueName());
        buf.append('.');
        Util.quoteMdxIdentifier(name, buf);
        return buf.toString();
    }

    public static String makeFqName(String parentUniqueName, String name) {
        if (parentUniqueName == null) {
            return Util.quoteMdxIdentifier(name);
        }
        StringBuffer buf = new StringBuffer(64);
        buf.append(parentUniqueName);
        buf.append('.');
        Util.quoteMdxIdentifier(name, buf);
        return buf.toString();
    }

    public static OlapElement lookupCompound(SchemaReader schemaReader, OlapElement parent, String[] names, boolean failIfNotFound, int category) {
        Util.assertPrecondition(parent != null, "parent != null");
        if (LOGGER.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Util.lookupCompound: ");
            buf.append("parent.name=");
            buf.append(parent.getName());
            buf.append(", category=");
            buf.append(Category.instance.getName(category));
            buf.append(", names=");
            Util.quoteMdxIdentifier(names, buf);
            LOGGER.debug((Object)buf.toString());
        }
        switch (category) {
            case 0: 
            case 6: {
                Member member = schemaReader.getCalculatedMember(names);
                if (member == null) break;
                return member;
            }
        }
        switch (category) {
            case 0: 
            case 8: {
                NamedSet namedSet = schemaReader.getNamedSet(names);
                if (namedSet == null) break;
                return namedSet;
            }
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            OlapElement child = schemaReader.getElementChild(parent, name);
            if (child == null) {
                if (LOGGER.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("Util.lookupCompound: ");
                    buf.append("parent.name=");
                    buf.append(parent.getName());
                    buf.append(" has no child with name=");
                    buf.append(name);
                    LOGGER.debug((Object)buf.toString());
                }
                if (failIfNotFound) {
                    throw MondrianResource.instance().MdxChildObjectNotFound.ex(name, parent.getQualifiedName());
                }
                return null;
            }
            parent = child;
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Util.lookupCompound: ");
            buf.append("found child.name=");
            buf.append(parent.getName());
            buf.append(", child.class=");
            buf.append(parent.getClass().getName());
            LOGGER.debug((Object)buf.toString());
        }
        switch (category) {
            case 2: {
                if (parent instanceof Dimension) {
                    return parent;
                }
                if (parent instanceof Hierarchy) {
                    return parent.getDimension();
                }
                if (failIfNotFound) {
                    throw Util.newError("Can not find dimension '" + Util.implode(names) + "'");
                }
                return null;
            }
            case 3: {
                if (parent instanceof Hierarchy) {
                    return parent;
                }
                if (parent instanceof Dimension) {
                    return parent.getHierarchy();
                }
                if (failIfNotFound) {
                    throw Util.newError("Can not find hierarchy '" + Util.implode(names) + "'");
                }
                return null;
            }
            case 4: {
                if (parent instanceof Level) {
                    return parent;
                }
                if (failIfNotFound) {
                    throw Util.newError("Can not find level '" + Util.implode(names) + "'");
                }
                return null;
            }
            case 6: {
                if (parent instanceof Member) {
                    return parent;
                }
                if (failIfNotFound) {
                    throw MondrianResource.instance().MdxCantFindMember.ex(Util.implode(names));
                }
                return null;
            }
            case 0: {
                Util.assertPostcondition(parent != null, "return != null");
                return parent;
            }
        }
        throw Util.newInternal("Bad switch " + category);
    }

    public static OlapElement lookup(Query q, String[] nameParts) {
        return (OlapElement)Util.lookup(q, nameParts, false);
    }

    public static Exp lookup(Query q, String[] nameParts, boolean allowProp) {
        Role role;
        String fullName = Util.quoteMdxIdentifier(nameParts);
        SchemaReader schemaReader = q.getSchemaReader(false);
        OlapElement olapElement = schemaReader.lookupCompound(q.getCube(), nameParts, false, 0);
        if (olapElement != null && !(role = q.getConnection().getRole()).canAccess(olapElement)) {
            olapElement = null;
        }
        if (olapElement == null) {
            if (allowProp && nameParts.length > 1) {
                String[] namePartsButOne = new String[nameParts.length - 1];
                System.arraycopy(nameParts, 0, namePartsButOne, 0, nameParts.length - 1);
                String propertyName = nameParts[nameParts.length - 1];
                olapElement = schemaReader.lookupCompound(q.getCube(), namePartsButOne, false, 6);
                if (olapElement != null && Util.isValidProperty((Member)olapElement, propertyName)) {
                    return new FunCall(propertyName, Syntax.Property, new Exp[]{olapElement});
                }
            }
            throw MondrianResource.instance().MdxChildObjectNotFound.ex(fullName, q.getCube().getQualifiedName());
        }
        return olapElement;
    }

    public static Member lookupHierarchyRootMember(SchemaReader reader, Hierarchy hierarchy, String memberName) {
        Member[] rootMembers = reader.getHierarchyRootMembers(hierarchy);
        for (int i = 0; i < rootMembers.length; ++i) {
            if (!rootMembers[i].getName().equalsIgnoreCase(memberName)) continue;
            return rootMembers[i];
        }
        return rootMembers.length == 1 && rootMembers[0].isAll() ? reader.lookupMemberChildByName(rootMembers[0], memberName) : null;
    }

    public static Level lookupHierarchyLevel(Hierarchy hierarchy, String s) {
        Level[] levels = hierarchy.getLevels();
        for (int i = 0; i < levels.length; ++i) {
            if (!levels[i].getName().equalsIgnoreCase(s)) continue;
            return levels[i];
        }
        return null;
    }

    public static int getMemberOrdinalInParent(SchemaReader reader, Member member) {
        Member parent = member.getParentMember();
        Member[] siblings = parent == null ? reader.getHierarchyRootMembers(member.getHierarchy()) : reader.getMemberChildren(parent);
        for (int i = 0; i < siblings.length; ++i) {
            if (siblings[i] != member) continue;
            return i;
        }
        throw Util.newInternal("could not find member " + member + " amongst its siblings");
    }

    public static Member getFirstDescendantOnLevel(SchemaReader reader, Member parent, Level level) {
        Member m = parent;
        while (m.getLevel() != level) {
            Member[] children = reader.getMemberChildren(m);
            m = children[0];
        }
        return m;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String singleQuoteString(String val) {
        StringBuffer buf = new StringBuffer(64);
        Util.singleQuoteString(val, buf);
        return buf.toString();
    }

    public static void singleQuoteString(String val, StringBuffer buf) {
        buf.append('\'');
        String s0 = Util.replace(val, "'", "''");
        buf.append(s0);
        buf.append('\'');
    }

    public static Random createRandom(long seed) {
        if (seed == 0L) {
            seed = new Random().nextLong();
            System.out.println("random: seed=" + seed);
        } else if (seed == -1L && metaRandom != null) {
            seed = metaRandom.nextLong();
        }
        return new Random(seed);
    }

    public static boolean isValidProperty(Member member, String propertyName) {
        return Util.lookupProperty(member.getLevel(), propertyName) != null;
    }

    protected static Property lookupProperty(Level level, String propertyName) {
        do {
            Property[] properties = level.getProperties();
            for (int i = 0; i < properties.length; ++i) {
                Property property = properties[i];
                if (!property.getName().equals(propertyName)) continue;
                return property;
            }
        } while ((level = level.getParentLevel()) != null);
        Property property = Property.lookup(propertyName);
        if (property != null && property.isMemberProperty() && property.isStandard()) {
            return property;
        }
        return null;
    }

    public static void assertTrue(boolean b) {
        if (!b) {
            throw Util.newInternal("assert failed");
        }
    }

    public static void assertTrue(boolean b, String message) {
        if (!b) {
            throw Util.newInternal("assert failed: " + message);
        }
    }

    public static RuntimeException newInternal(String message) {
        return MondrianResource.instance().Internal.ex(message);
    }

    public static RuntimeException newInternal(Throwable e, String message) {
        return MondrianResource.instance().Internal.ex(message, e);
    }

    public static RuntimeException newError(String message) {
        return Util.newInternal(message);
    }

    public static RuntimeException newError(Throwable e, String message) {
        return Util.newInternal(e, message);
    }

    public static void assertPrecondition(boolean b) {
        Util.assertTrue(b);
    }

    public static void assertPrecondition(boolean b, String condition) {
        Util.assertTrue(b, condition);
    }

    public static void assertPostcondition(boolean b) {
        Util.assertTrue(b);
    }

    public static void assertPostcondition(boolean b, String condition) {
        Util.assertTrue(b, condition);
    }

    public static String[] convertStackToString(Throwable e) {
        ArrayList<String> list = new ArrayList<String>();
        while (e != null) {
            String sMsg = Util.getErrorMessage(e);
            list.add(sMsg);
            e = e.getCause();
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getErrorMessage(Throwable err) {
        boolean prependClassName = !(err instanceof SQLException) && err.getClass() != Exception.class;
        return Util.getErrorMessage(err, prependClassName);
    }

    public static String getErrorMessage(Throwable err, boolean prependClassName) {
        String errMsg = err.getMessage();
        if (errMsg == null || err instanceof RuntimeException) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            err.printStackTrace(pw);
            return sw.toString();
        }
        return prependClassName ? err.getClass().getName() + ": " + errMsg : errMsg;
    }

    public static String unparse(Exp exp) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exp.unparse(pw);
        return sw.toString();
    }

    public static URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        String fs = System.getProperty("file.separator");
        if (fs.length() == 1) {
            char sep = fs.charAt(0);
            if (sep != '/') {
                path = path.replace(sep, '/');
            }
            if (path.charAt(0) != '/') {
                path = '/' + path;
            }
        }
        path = "file://" + path;
        return new URL(path);
    }

    public static PropertyList parseConnectString(String s) {
        return new ConnectStringParser(s).parse();
    }

    public static List makeMutable(List list) {
        return list instanceof ArrayList ? list : new ArrayList(list);
    }

    public static int hash(int i, int j) {
        return i << 4 ^ j;
    }

    public static int hash(int h, Object o) {
        int k = o == null ? 0 : o.hashCode();
        return (h << 4 | h) ^ k;
    }

    public static int hashArray(int h, Object[] a) {
        if (a == null) {
            return Util.hash(h, 19690429);
        }
        if (a.length == 0) {
            return Util.hash(h, 19690721);
        }
        for (int i = 0; i < a.length; ++i) {
            h = Util.hash(h, a[i]);
        }
        return h;
    }

    public static long dbTimeMillis() {
        return databaseMillis;
    }

    public static void addDatabaseTime(long millis) {
        databaseMillis += millis;
    }

    public static long nonDbTimeMillis() {
        long systemMillis = System.currentTimeMillis();
        return systemMillis - databaseMillis;
    }

    public static Validator createSimpleValidator(final FunTable funTable) {
        return new Validator(){

            public Query getQuery() {
                throw new UnsupportedOperationException();
            }

            public Exp validate(Exp exp, boolean scalar) {
                return exp;
            }

            public Parameter validate(Parameter parameter) {
                return parameter;
            }

            public void validate(MemberProperty memberProperty) {
            }

            public void validate(QueryAxis axis) {
            }

            public void validate(Formula formula) {
            }

            public Exp convert(Exp fromExp, int to) {
                return FunUtil.convert(fromExp, to, this);
            }

            public boolean canConvert(Exp fromExp, int to, int[] conversionCount) {
                return true;
            }

            public boolean requiresExpression() {
                return false;
            }

            public FunTable getFunTable() {
                return funTable;
            }

            public Parameter createOrLookupParam(FunCall call) {
                return null;
            }
        };
    }

    private static class ConnectStringParser {
        private final String s;
        private final int n;
        private int i;
        private final StringBuffer nameBuf;
        private final StringBuffer valueBuf;

        private ConnectStringParser(String s) {
            this.s = s;
            this.i = 0;
            this.n = s.length();
            this.nameBuf = new StringBuffer(64);
            this.valueBuf = new StringBuffer(64);
        }

        PropertyList parse() {
            PropertyList list = new PropertyList();
            while (this.i < this.n) {
                this.parsePair(list);
            }
            return list;
        }

        void parsePair(PropertyList list) {
            String value;
            String name = this.parseName();
            if (this.i >= this.n) {
                value = "";
            } else if (this.s.charAt(this.i) == ';') {
                ++this.i;
                value = "";
            } else {
                value = this.parseValue();
            }
            list.put(name, value);
        }

        String parseName() {
            this.nameBuf.setLength(0);
            block4: while (true) {
                char c = this.s.charAt(this.i);
                switch (c) {
                    case '=': {
                        ++this.i;
                        if (this.i < this.n && (c = this.s.charAt(this.i)) == '=') {
                            ++this.i;
                            this.nameBuf.append(c);
                            continue block4;
                        }
                        String name = this.nameBuf.toString();
                        name = name.trim();
                        return name;
                    }
                    case ' ': {
                        if (this.nameBuf.length() != 0) break;
                        ++this.i;
                        continue block4;
                    }
                }
                this.nameBuf.append(c);
                ++this.i;
                if (this.i >= this.n) break;
            }
            return this.nameBuf.toString().trim();
        }

        String parseValue() {
            String value;
            char c;
            while ((c = this.s.charAt(this.i)) == ' ') {
                ++this.i;
                if (this.i < this.n) continue;
                return "";
            }
            if (c == '\"' || c == '\'') {
                String value2 = this.parseQuoted(c);
                while (this.i < this.n && (c = this.s.charAt(this.i)) == ' ') {
                    ++this.i;
                }
                if (this.i >= this.n) {
                    return value2;
                }
                if (this.s.charAt(this.i) == ';') {
                    ++this.i;
                    return value2;
                }
                throw new RuntimeException("quoted value ended too soon, at position " + this.i + " in '" + this.s + "'");
            }
            int semi = this.s.indexOf(59, this.i);
            if (semi >= 0) {
                value = this.s.substring(this.i, semi);
                this.i = semi + 1;
            } else {
                value = this.s.substring(this.i);
                this.i = this.n;
            }
            return value.trim();
        }

        String parseQuoted(char q) {
            char c;
            Util.assertTrue((c = this.s.charAt(this.i++)) == q);
            this.valueBuf.setLength(0);
            while (this.i < this.n) {
                c = this.s.charAt(this.i);
                if (c == q) {
                    ++this.i;
                    if (this.i < this.n && (c = this.s.charAt(this.i)) == q) {
                        this.valueBuf.append(c);
                        ++this.i;
                        continue;
                    }
                    return this.valueBuf.toString();
                }
                this.valueBuf.append(c);
                ++this.i;
            }
            throw new RuntimeException("Connect string '" + this.s + "' contains unterminated quoted value '" + this.valueBuf.toString() + "'");
        }
    }

    public static class PropertyList {
        List list = new ArrayList();

        public String get(String key) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                String[] pair = (String[])this.list.get(i);
                if (!pair[0].equalsIgnoreCase(key)) continue;
                return pair[1];
            }
            return key.equalsIgnoreCase("Provider") ? "MSDASQL" : null;
        }

        public String put(String key, String value) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                String[] pair = (String[])this.list.get(i);
                if (!pair[0].equalsIgnoreCase(key)) continue;
                String old = pair[1];
                if (!key.equalsIgnoreCase("Provider")) {
                    pair[1] = value;
                }
                return old;
            }
            this.list.add(new String[]{key, value});
            return null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                String[] pair = (String[])this.list.get(i);
                if (i > 0) {
                    sb.append("; ");
                }
                sb.append(pair[0]);
                sb.append('=');
                if (pair[1].indexOf(59) >= 0 && pair[1].charAt(0) != '\'') {
                    sb.append("'");
                }
                sb.append(pair[1]);
                if (pair[1].indexOf(59) < 0 || pair[1].charAt(pair[1].length() - 1) == '\'') continue;
                sb.append("'");
            }
            return sb.toString();
        }

        public Iterator iterator() {
            return this.list.iterator();
        }
    }

    public static class ErrorCellValue {
        public String toString() {
            return "#ERR";
        }
    }

    public static class NullCellValue
    implements Comparable {
        public String toString() {
            return "#NULL";
        }

        public int compareTo(Object o) {
            if (o == this) {
                return 0;
            }
            return -1;
        }
    }
}

