/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.eigenbase.resgen.JavaBaseGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.Util;

public class JavaFunctorBaseGenerator
extends JavaBaseGenerator {
    private final Map functorMap = new HashMap();
    private final StringWriter functorSw = new StringWriter();
    private final PrintWriter functorPw = new PrintWriter(this.functorSw);

    JavaFunctorBaseGenerator(File file, File file2, String string, String string2, ResourceDef.ResourceBundle resourceBundle) {
        super(file, file2, string, string2, resourceBundle);
    }

    public void generateResource(ResourceDef.Resource resource, PrintWriter printWriter) {
        String string;
        Object object;
        if (resource.text == null) {
            throw new BuildException("Resource '" + resource.name + "' has no message");
        }
        String string2 = resource.text.cdata;
        String string3 = ResourceGen.getComment(resource);
        String string4 = ResourceGen.getResourceInitcap(resource);
        String string5 = this.getParameterList(string2);
        String string6 = this.getArgumentList(string2);
        String string7 = this.getPropList(resource);
        if (resource instanceof ResourceDef.Exception) {
            object = (ResourceDef.Exception)resource;
            string = this.getErrorClass((ResourceDef.Exception)((Object)object));
        } else {
            string = null;
        }
        object = this.getFunctorType(string5, string6, string);
        printWriter.println();
        Util.generateCommentBlock(printWriter, resource.name, string2, string3);
        printWriter.println("    public final " + (String)object + " " + string4 + " = new " + (String)object + "(" + Util.quoteForJava(string4) + ", " + Util.quoteForJava(string2) + ", " + string7 + ");");
    }

    private String getPropList(ResourceDef.Resource resource) {
        if (resource.properties == null || resource.properties.length == 0) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("new String[] {");
        for (int i = 0; i < resource.properties.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            ResourceDef.Property property = resource.properties[i];
            stringBuffer.append(Util.quoteForJava(property.name));
            stringBuffer.append(", ");
            stringBuffer.append(Util.quoteForJava(property.cdata));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private String getFunctorType(String string, String string2, String string3) {
        List<String> list = Arrays.asList(string, string3);
        String string4 = (String)this.functorMap.get(list);
        if (string4 == null) {
            string4 = "_Def" + this.functorMap.size();
            this.functorMap.put(list, string4);
            this.genFunctor(string4, string, string2, string3, this.functorPw);
        }
        return string4;
    }

    private void genFunctor(String string, String string2, String string3, String string4, PrintWriter printWriter) {
        String string5 = "org.eigenbase.resgen.ResourceDefinition";
        String string6 = Util.removePackage(this.className);
        String string7 = string6 + ".this";
        String string8 = string3.equals("") ? "emptyObjectArray" : "new Object[] {" + string3 + "}";
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Definition for resources which");
        if (string4 != null) {
            printWriter.println("     * return a {@link " + string4 + "} exception and");
        }
        printWriter.println("     * take arguments '" + string2 + "'.");
        printWriter.println("     */");
        printWriter.println("    public class " + string + " extends " + string5 + " {");
        printWriter.println("        " + string + "(String key, String baseMessage, String[] props) {");
        printWriter.println("            super(key, baseMessage, props);");
        printWriter.println("        }");
        printWriter.println("        public String str(" + string2 + ") {");
        printWriter.println("            return instantiate(" + JavaFunctorBaseGenerator.addLists(string7, string8) + ").toString();");
        printWriter.println("        }");
        if (string4 != null) {
            JavaBaseGenerator.ExceptionDescription exceptionDescription = new JavaBaseGenerator.ExceptionDescription(string4);
            if (exceptionDescription.hasInstCon) {
                printWriter.println("        public " + string4 + " ex(" + string2 + ") {");
                printWriter.println("            return new " + string4 + "(instantiate(" + JavaFunctorBaseGenerator.addLists(string7, string8) + "));");
                printWriter.println("        }");
            } else if (exceptionDescription.hasInstThrowCon) {
                printWriter.println("        public " + string4 + " ex(" + string2 + ") {");
                printWriter.println("            return new " + string4 + "(instantiate(" + JavaFunctorBaseGenerator.addLists(string7, string8) + "), null);");
                printWriter.println("        }");
            } else if (exceptionDescription.hasStringCon) {
                printWriter.println("        public " + string4 + " ex(" + string2 + ") {");
                printWriter.println("            return new " + string4 + "(instantiate(" + JavaFunctorBaseGenerator.addLists(string7, string8) + ").toString());");
                printWriter.println("        }");
            } else if (exceptionDescription.hasStringThrowCon) {
                printWriter.println("        public " + string4 + " ex(" + string2 + ") {");
                printWriter.println("            return new " + string4 + "(instantiate(" + JavaFunctorBaseGenerator.addLists(string7, string8) + ").toString(), null);");
                printWriter.println("        }");
            }
            if (exceptionDescription.hasInstThrowCon) {
                printWriter.println("        public " + string4 + " ex(" + JavaFunctorBaseGenerator.addLists(string2, "Throwable err") + ") {");
                printWriter.println("            return new " + string4 + "(instantiate(" + JavaFunctorBaseGenerator.addLists(string7, string8) + "), err);");
                printWriter.println("        }");
            } else if (exceptionDescription.hasStringThrowCon) {
                printWriter.println("        public " + string4 + " ex(" + JavaFunctorBaseGenerator.addLists(string2, "Throwable err") + ") {");
                printWriter.println("            return new " + string4 + "(instantiate(" + JavaFunctorBaseGenerator.addLists(string7, string8) + ").toString(), err);");
                printWriter.println("        }");
            }
        }
        printWriter.println("    }");
    }

    protected void postModule(PrintWriter printWriter) {
        this.functorPw.flush();
        printWriter.println(this.functorSw.toString());
    }
}

