/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public class CodeSwitcher {
    private static final String ls = System.getProperty("line.separator", "\n");
    private Vector vList = new Vector();
    private Vector vSwitchOn = new Vector();
    private Vector vSwitchOff = new Vector();
    private Vector vSwitches = new Vector();
    private boolean bAdd;
    private boolean bRemove;
    private static final int MAX_LINELENGTH = 82;

    public static void main(String[] stringArray) {
        CodeSwitcher codeSwitcher = new CodeSwitcher();
        if (stringArray.length == 0) {
            CodeSwitcher.showUsage();
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.startsWith("+")) {
                if (string.length() == 1) {
                    codeSwitcher.bAdd = true;
                } else {
                    codeSwitcher.vSwitchOn.addElement(string.substring(1));
                }
            } else if (string.startsWith("-")) {
                if (string.length() == 1) {
                    codeSwitcher.bRemove = true;
                } else {
                    codeSwitcher.vSwitchOff.addElement(string.substring(1));
                }
            } else {
                codeSwitcher.addDir(string);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            CodeSwitcher.printError("no path specified");
            CodeSwitcher.showUsage();
        }
        codeSwitcher.process();
        if (codeSwitcher.vSwitchOff.size() == 0 && codeSwitcher.vSwitchOn.size() == 0) {
            codeSwitcher.printSwitches();
        }
    }

    static void showUsage() {
        System.out.print("Usage: java CodeSwitcher [paths] [labels] [+][-]\nIf no labels are specified then all used\nlabels in the source code are shown.\nUse +MODE to switch on the things labeld MODE\nUse -MODE to switch off the things labeld MODE\nPath: Any number of path or files may be\nspecified. Use . for the current directory\n(including sub-directories).\nExample: java CodeSwitcher +JAVA2 .\nThis example switches on code labeled JAVA2\nin all *.java files in the current directory\nand all subdirectories.\njava CodeSwitcher + .\nAdds test code to the code.\njava CodeSwitcher - .\nRemoved test code from the code.\n");
    }

    CodeSwitcher() {
    }

    void process() {
        int n = this.vList.size();
        int n2 = 0;
        while (n2 < n) {
            System.out.print(".");
            String string = (String)this.vList.elementAt(n2);
            if (this.bAdd || this.bRemove) {
                int n3 = this.testFile(string);
                if (this.bAdd && !this.bRemove) {
                    this.addTest(string, n3);
                } else {
                    this.removeTest(string);
                }
            } else if (!this.processFile(string)) {
                System.out.println("in file " + string + " !");
            }
            ++n2;
        }
        System.out.println("");
    }

    void printSwitches() {
        System.out.println("Used labels:");
        int n = 0;
        while (n < this.vSwitches.size()) {
            System.out.println((String)this.vSwitches.elementAt(n));
            ++n;
        }
    }

    void addDir(String string) {
        File file = new File(string);
        if (file.isFile() && string.endsWith(".java")) {
            this.vList.addElement(string);
        } else if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                this.addDir(string + File.separatorChar + stringArray[n]);
                ++n;
            }
        }
    }

    void removeTest(String string) {
        File file = new File(string);
        File file2 = new File(string + ".new");
        try {
            Object object;
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            FileWriter fileWriter = new FileWriter(file2);
            while ((object = lineNumberReader.readLine()) != null) {
                if (((String)object).startsWith("Profile.visit(")) {
                    int n = ((String)object).indexOf(59);
                    object = ((String)object).substring(n + 1);
                }
                fileWriter.write((String)object + ls);
            }
            lineNumberReader.close();
            fileWriter.flush();
            fileWriter.close();
            object = new File(string + ".bak");
            ((File)object).delete();
            file.renameTo((File)object);
            File file3 = new File(string);
            file2.renameTo(file3);
            ((File)object).delete();
        }
        catch (Exception exception) {
            CodeSwitcher.printError(exception.getMessage());
        }
    }

    void addTest(String string, int n) {
        File file = new File(string);
        File file2 = new File(string + ".new");
        String string2 = string;
        string2 = string2.replace('\\', '.');
        try {
            Object object;
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            FileWriter fileWriter = new FileWriter(file2);
            int n2 = 0;
            boolean bl = false;
            while ((object = lineNumberReader.readLine()) != null) {
                if (((String)object).startsWith(" ")) {
                    int n3 = 0;
                    while (n3 < ((String)object).length()) {
                        if (((String)object).charAt(n3) != ' ') break;
                        ++n3;
                    }
                    if (n3 > 3 && this.testLine((String)object) && !bl) {
                        object = "org.hsqldb.test.Profile.visit(\"" + string2 + "\"," + n2 + "," + n + ");" + (String)object;
                        ++n2;
                    } else {
                        bl = this.isLongline((String)object);
                    }
                }
                fileWriter.write((String)object + ls);
            }
            lineNumberReader.close();
            fileWriter.flush();
            fileWriter.close();
            object = new File(string + ".bak");
            ((File)object).delete();
            file.renameTo((File)object);
            File file3 = new File(string);
            file2.renameTo(file3);
            ((File)object).delete();
        }
        catch (Exception exception) {
            CodeSwitcher.printError(exception.getMessage());
        }
    }

    int testFile(String string) {
        File file = new File(string);
        try {
            String string2;
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            int n = 1;
            int n2 = 0;
            boolean bl = false;
            while ((string2 = lineNumberReader.readLine()) != null) {
                if (string2.length() > 82 && !string2.startsWith("org.hsqldb.test.Profile.")) {
                    System.out.println("long line in " + string + " at line " + n);
                }
                if (string2.startsWith(" ")) {
                    int n3 = 0;
                    while (n3 < string2.length()) {
                        if (string2.charAt(n3) != ' ') break;
                        ++n3;
                    }
                    if (n3 > 3 && this.testLine(string2) && !bl) {
                        ++n2;
                    } else {
                        bl = this.isLongline(string2);
                    }
                    String string3 = string2.substring(n3);
                    if (string3.startsWith("if(")) {
                        if (!string3.endsWith(" {")) {
                            System.out.println("if( without { in " + string + " at line " + n);
                        }
                    } else if (string3.startsWith("} else if(")) {
                        if (!string3.endsWith(" {")) {
                            System.out.println("} else if without { in " + string + " at line " + n);
                        }
                    } else if (string3.startsWith("while(")) {
                        if (!string3.endsWith(" {")) {
                            System.out.println("while( without { in " + string + " at line " + n);
                        }
                    } else if (string3.startsWith("switch(")) {
                        if (!string3.endsWith(" {")) {
                            System.out.println("switch( without { in " + string + " at line " + n);
                        }
                    } else if (string3.startsWith("do ") && !string3.endsWith(" {")) {
                        System.out.println("do without { in " + string + " at line " + n);
                    }
                }
                ++n;
            }
            lineNumberReader.close();
            return n2;
        }
        catch (Exception exception) {
            CodeSwitcher.printError(exception.getMessage());
            return -1;
        }
    }

    boolean testLine(String string) {
        if (!string.endsWith(";")) {
            return false;
        }
        return !string.trim().startsWith("super(");
    }

    boolean isLongline(String string) {
        char c = string.charAt(string.length() - 1);
        return ",(+-&|".indexOf(c) >= 0;
    }

    boolean processFile(String string) {
        File file = new File(string);
        File file2 = new File(string + ".new");
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            Vector vector = CodeSwitcher.getFileLines(file);
            Vector vector2 = new Vector(vector.size());
            int n2 = 0;
            while (n2 < vector.size()) {
                vector2.addElement(vector.elementAt(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                String string2 = (String)vector.elementAt(n3);
                if (string2 == null) break;
                if (bl2 && (string2.equals("/*") || string2.equals("*/"))) {
                    vector.removeElementAt(n3--);
                } else if (string2.startsWith("//#")) {
                    if (string2.startsWith("//#ifdef ")) {
                        if (n != 0) {
                            CodeSwitcher.printError("'#ifdef' not allowed inside '#ifdef'");
                            return false;
                        }
                        n = 1;
                        String string3 = string2.substring(9);
                        if (this.vSwitchOn.indexOf(string3) != -1) {
                            bl2 = true;
                            bl = false;
                        } else if (this.vSwitchOff.indexOf(string3) != -1) {
                            bl2 = true;
                            vector.insertElementAt("/*", ++n3);
                            bl = true;
                        }
                        if (this.vSwitches.indexOf(string3) == -1) {
                            this.vSwitches.addElement(string3);
                        }
                    } else if (string2.startsWith("//#else")) {
                        if (n != 1) {
                            CodeSwitcher.printError("'#else' without '#ifdef'");
                            return false;
                        }
                        n = 2;
                        if (bl2) {
                            if (bl) {
                                if (vector.elementAt(n3 - 1).equals("")) {
                                    vector.insertElementAt("*/", n3 - 1);
                                    ++n3;
                                } else {
                                    vector.insertElementAt("*/", n3++);
                                }
                                bl = false;
                            } else {
                                vector.insertElementAt("/*", ++n3);
                                bl = true;
                            }
                        }
                    } else if (string2.startsWith("//#endif")) {
                        if (n == 0) {
                            CodeSwitcher.printError("'#endif' without '#ifdef'");
                            return false;
                        }
                        n = 0;
                        if (bl2 && bl) {
                            if (vector.elementAt(n3 - 1).equals("")) {
                                vector.insertElementAt("*/", n3 - 1);
                                ++n3;
                            } else {
                                vector.insertElementAt("*/", n3++);
                            }
                        }
                        bl2 = false;
                    }
                }
                ++n3;
            }
            if (n != 0) {
                CodeSwitcher.printError("'#endif' missing");
                return false;
            }
            boolean bl3 = false;
            int n4 = 0;
            while (n4 < vector.size()) {
                if (!vector2.elementAt(n4).equals(vector.elementAt(n4))) {
                    bl3 = true;
                    break;
                }
                ++n4;
            }
            if (!bl3) {
                return true;
            }
            CodeSwitcher.writeFileLines(vector, file2);
            File file3 = new File(string + ".bak");
            file3.delete();
            file.renameTo(file3);
            File file4 = new File(string);
            file2.renameTo(file4);
            file3.delete();
            return true;
        }
        catch (Exception exception) {
            CodeSwitcher.printError(exception.getMessage());
            return false;
        }
    }

    static Vector getFileLines(File file) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        Vector<String> vector = new Vector<String>();
        while ((string = lineNumberReader.readLine()) != null) {
            vector.addElement(string);
        }
        lineNumberReader.close();
        return vector;
    }

    static void writeFileLines(Vector vector, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        int n = 0;
        while (n < vector.size()) {
            fileWriter.write((String)vector.elementAt(n));
            fileWriter.write(ls);
            ++n;
        }
        fileWriter.flush();
        fileWriter.close();
    }

    static void printError(String string) {
        System.out.println("");
        System.out.println("ERROR: " + string);
    }
}

