/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.wizard;

import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.wizard.BaseWizardPanel;
import it.businesslogic.ireport.gui.wizard.GenericWizard;
import it.businesslogic.ireport.gui.wizard.SubreportWizardExistingReport;
import it.businesslogic.ireport.gui.wizard.SubreportWizardNewReport;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class SubreportWizard
extends JPanel
implements GenericWizard {
    private String reportFileName = null;
    private SubReportElement subReportElement = null;
    private JReportFrame jReportFrame = null;
    private JDialog wizardDialog = null;
    private BaseWizardPanel firstStep = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonBrowse;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JTextField jTextFieldReportFileName;

    public SubreportWizard() {
        this.initComponents();
        this.applyI18n();
        this.jTextFieldReportFileName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (SubreportWizard.this.firstStep != null) {
                    SubreportWizard.this.firstStep.updateButtons();
                }
            }

            public void insertUpdate(DocumentEvent e) {
                if (SubreportWizard.this.firstStep != null) {
                    SubreportWizard.this.firstStep.updateButtons();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (SubreportWizard.this.firstStep != null) {
                    SubreportWizard.this.firstStep.updateButtons();
                }
            }
        });
    }

    public void startWizard() {
        this.setJReportFrame(MainFrame.getMainInstance().getActiveReportFrame());
        this.wizardDialog = new JDialog((Frame)MainFrame.getMainInstance(), true);
        this.firstStep = new BaseWizardPanel();
        this.firstStep.setGenericWizard(this);
        this.wizardDialog.getContentPane().add(this.firstStep);
        this.wizardDialog.pack();
        Misc.centerFrame(this.wizardDialog);
        this.wizardDialog.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jRadioButton2 = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jTextFieldReportFileName = new JTextField();
        this.jButtonBrowse = new JButton();
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SubreportWizard.this.jPanel1PropertyChange(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Create a new report");
        this.jRadioButton1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton1.setFocusPainted(false);
        this.jRadioButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton1.setMinimumSize(new Dimension(115, 20));
        this.jRadioButton1.setPreferredSize(new Dimension(115, 20));
        this.jRadioButton1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SubreportWizard.this.jRadioButton1ItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.jPanel1.add((Component)this.jRadioButton1, gridBagConstraints);
        this.jLabel1.setForeground(new Color(255, 0, 0));
        this.jLabel1.setText("Save the current report first!");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("Use an exsisting report");
        this.jRadioButton2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton2.setFocusPainted(false);
        this.jRadioButton2.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton2.setPreferredSize(new Dimension(129, 20));
        this.jRadioButton2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SubreportWizard.this.jRadioButton2ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 20, 0, 0);
        this.jPanel1.add((Component)this.jRadioButton2, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jTextFieldReportFileName.setMinimumSize(new Dimension(100, 19));
        this.jTextFieldReportFileName.setPreferredSize(new Dimension(250, 19));
        this.jTextFieldReportFileName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizard.this.jTextFieldReportFileNameActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.jTextFieldReportFileName, new GridBagConstraints());
        this.jButtonBrowse.setText("Browse");
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizard.this.jButtonBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 40, 0, 0);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.setLayout(new BorderLayout());
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".xml") || filename.endsWith(".jrxml") || filename.endsWith(".jasper") || file.isDirectory();
            }

            public String getDescription() {
                return "JasperReports Report file *.xml;*jrxml;*.jasper";
            }
        });
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldReportFileName.setText(jfc.getSelectedFile().getPath());
            this.jRadioButton2.setSelected(true);
        }
        this.firstStep.updateButtons();
    }

    private void jRadioButton1ItemStateChanged(ItemEvent evt) {
        this.firstStep.updateButtons();
    }

    private void jRadioButton2ItemStateChanged(ItemEvent evt) {
        this.firstStep.updateButtons();
    }

    private void jPanel1PropertyChange(PropertyChangeEvent evt) {
    }

    private void jTextFieldReportFileNameActionPerformed(ActionEvent evt) {
        this.firstStep.updateButtons();
    }

    public String[] getStepsNames() {
        String[] names = new String[]{I18n.getString("subreportWizard.stepsnames.reportSelection", "Report selection")};
        return names;
    }

    public String getStepDescription(int step) {
        if (step == 0) {
            return I18n.getString("subreportWizard.stepdescription.step0", "New or exsisting report...");
        }
        return "";
    }

    public void initWizard() {
        this.jLabel1.setVisible(MainFrame.getMainInstance().getActiveReportFrame().getReport().getFilename() == null || MainFrame.getMainInstance().getActiveReportFrame().getReport().getFilename().trim().length() <= 0);
    }

    public void finish(int currentStep) {
        if (currentStep == -1) {
            this.wizardDialog.setVisible(false);
            this.wizardDialog.dispose();
        }
    }

    public boolean nextStep(int nextStep) {
        if (nextStep == 1) {
            if (this.jRadioButton1.isSelected()) {
                SubreportWizardNewReport wizard2 = new SubreportWizardNewReport();
                wizard2.setSubReportElement(this.getSubReportElement());
                wizard2.setReportFileName(this.jTextFieldReportFileName.getText());
                wizard2.setWizardPanel(this.firstStep);
                wizard2.setWizardDialog(this.wizardDialog);
                this.firstStep.setGenericWizard(wizard2);
            } else {
                SubreportWizardExistingReport wizard2 = new SubreportWizardExistingReport();
                wizard2.setSubReportElement(this.getSubReportElement());
                wizard2.setReportFileName(this.jTextFieldReportFileName.getText());
                wizard2.setWizardPanel(this.firstStep);
                wizard2.setWizardDialog(this.wizardDialog);
                this.firstStep.setGenericWizard(wizard2);
            }
            return false;
        }
        return true;
    }

    public boolean previousStep(int previousStep) {
        return true;
    }

    public boolean canFinish(int currentStep) {
        return false;
    }

    public boolean canNext(int currentStep) {
        if (this.jRadioButton1.isSelected() && MainFrame.getMainInstance().getActiveReportFrame().getReport().getFilename() != null && MainFrame.getMainInstance().getActiveReportFrame().getReport().getFilename().trim().length() > 0) {
            return true;
        }
        return this.jTextFieldReportFileName.getText().trim().length() > 0;
    }

    public boolean canPrevious(int currentStep) {
        return false;
    }

    public JPanel getStepPanel(int step) {
        return this.jPanel1;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    public SubReportElement getSubReportElement() {
        return this.subReportElement;
    }

    public void setSubReportElement(SubReportElement subReportElement) {
        this.subReportElement = subReportElement;
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
    }

    public void applyI18n() {
        this.jRadioButton1.setText(I18n.getString("subreportWizard.radioButton1", "Create a new report"));
        this.jRadioButton2.setText(I18n.getString("subreportWizard.radioButton2", "Use an exsisting report"));
        this.jButtonBrowse.setText(I18n.getString("subreportWizard.buttonBrowse", "Browse"));
        this.jLabel1.setText(I18n.getString("subreportWizard.label1", "Save the current report first!"));
    }
}

