/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist.xml;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.flexdock.docking.state.DockingPath;
import org.flexdock.docking.state.DockingState;
import org.flexdock.docking.state.FloatingGroup;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.docking.state.PersistenceException;
import org.flexdock.docking.state.tree.DockableNode;
import org.flexdock.docking.state.tree.DockingPortNode;
import org.flexdock.docking.state.tree.SplitNode;
import org.flexdock.perspective.Layout;
import org.flexdock.perspective.LayoutSequence;
import org.flexdock.perspective.Perspective;
import org.flexdock.perspective.persist.Persister;
import org.flexdock.perspective.persist.PerspectiveModel;
import org.flexdock.perspective.persist.xml.DimensionSerializer;
import org.flexdock.perspective.persist.xml.DockableNodeSerializer;
import org.flexdock.perspective.persist.xml.DockingPathSerializer;
import org.flexdock.perspective.persist.xml.DockingPortNodeSerializer;
import org.flexdock.perspective.persist.xml.DockingStateSerializer;
import org.flexdock.perspective.persist.xml.FloatingGroupSerializer;
import org.flexdock.perspective.persist.xml.ISerializer;
import org.flexdock.perspective.persist.xml.LayoutNodeSerializer;
import org.flexdock.perspective.persist.xml.LayoutSequenceSerializer;
import org.flexdock.perspective.persist.xml.LayoutSerializer;
import org.flexdock.perspective.persist.xml.PerspectiveModelSerializer;
import org.flexdock.perspective.persist.xml.PerspectiveSerializer;
import org.flexdock.perspective.persist.xml.PointSerializer;
import org.flexdock.perspective.persist.xml.RectangleSerializer;
import org.flexdock.perspective.persist.xml.SerializerRegistry;
import org.flexdock.perspective.persist.xml.SplitNodeSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLPersister
implements Persister {
    public boolean store(OutputStream os, PerspectiveModel perspectiveModel) throws IOException, PersistenceException {
        DocumentBuilder documentBuilder = this.createDocumentBuilder();
        Document document = documentBuilder.newDocument();
        ISerializer perspectiveModelSerializer = SerializerRegistry.getSerializer(PerspectiveModel.class);
        Element perspectiveModelElement = perspectiveModelSerializer.serialize(document, perspectiveModel);
        document.appendChild(perspectiveModelElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new OutputStreamWriter(os));
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException ex) {
            throw new PersistenceException("Unable to serialize perspectiveModel", ex);
        }
        catch (TransformerException ex) {
            throw new PersistenceException("Unable to serialize perspectiveModel", ex);
        }
        return true;
    }

    public PerspectiveModel load(InputStream is) throws IOException, PersistenceException {
        try {
            InputSource inputSource = new InputSource(is);
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            ISerializer perspectiveModelSerializer = SerializerRegistry.getSerializer(PerspectiveModel.class);
            NodeList perspectiveModelNodeList = document.getElementsByTagName("PerspectiveModel");
            if (perspectiveModelNodeList.getLength() > 0 && perspectiveModelNodeList.item(0) instanceof Element) {
                Element perspectiveModelElement = (Element)perspectiveModelNodeList.item(0);
                return (PerspectiveModel)perspectiveModelSerializer.deserialize(perspectiveModelElement);
            }
            return null;
        }
        catch (SAXException ex) {
            throw new PersistenceException("Unable to deserialize perspectiveModel from xml", ex);
        }
    }

    private void registerSerializers() {
        SerializerRegistry.registerSerializer(Perspective.class, new PerspectiveSerializer());
        SerializerRegistry.registerSerializer(Layout.class, new LayoutSerializer());
        SerializerRegistry.registerSerializer(LayoutSequence.class, new LayoutSequenceSerializer());
        SerializerRegistry.registerSerializer(DockingState.class, new DockingStateSerializer());
        SerializerRegistry.registerSerializer(Point.class, new PointSerializer());
        SerializerRegistry.registerSerializer(Dimension.class, new DimensionSerializer());
        SerializerRegistry.registerSerializer(Rectangle.class, new RectangleSerializer());
        SerializerRegistry.registerSerializer(FloatingGroup.class, new FloatingGroupSerializer());
        SerializerRegistry.registerSerializer(DockingPath.class, new DockingPathSerializer());
        SerializerRegistry.registerSerializer(PerspectiveModel.class, new PerspectiveModelSerializer());
        SerializerRegistry.registerSerializer(LayoutNode.class, new LayoutNodeSerializer());
        SerializerRegistry.registerSerializer(SplitNode.class, new SplitNodeSerializer());
        SerializerRegistry.registerSerializer(DockingPortNode.class, new DockingPortNodeSerializer());
        SerializerRegistry.registerSerializer(DockableNode.class, new DockableNodeSerializer());
    }

    public static XMLPersister newDefaultInstance() {
        XMLPersister persister = new XMLPersister();
        persister.registerSerializers();
        return persister;
    }

    private DocumentBuilder createDocumentBuilder() throws PersistenceException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder;
        }
        catch (ParserConfigurationException ex) {
            throw new PersistenceException("Unable to create document builder", ex);
        }
    }
}

