/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.ConstraintCore;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;

class Constraint {
    static final int FOREIGN_KEY = 0;
    static final int MAIN = 1;
    static final int UNIQUE = 2;
    private ConstraintCore core;
    private HsqlName constName;
    private int iType;

    Constraint(HsqlName hsqlName, Table table, Index index) {
        this.core = new ConstraintCore();
        this.constName = hsqlName;
        this.iType = 2;
        this.core.tMain = table;
        this.core.iMain = index;
        this.core.iColMain = index.getColumns();
        this.core.iLen = this.core.iColMain.length;
    }

    Constraint(HsqlName hsqlName, Constraint constraint) {
        this.constName = hsqlName;
        this.iType = 1;
        this.core = constraint.core;
    }

    Constraint(HsqlName hsqlName, HsqlName hsqlName2, Table table, Table table2, int[] nArray, int[] nArray2, Index index, Index index2, boolean bl) throws SQLException {
        this.core = new ConstraintCore();
        this.core.pkName = hsqlName;
        this.core.fkName = hsqlName2;
        this.constName = hsqlName2;
        this.iType = 0;
        this.core.tMain = table;
        this.core.tRef = table2;
        this.core.iColMain = nArray;
        this.core.iLen = this.core.iColMain.length;
        this.core.iColRef = nArray2;
        this.core.oColRef = new Object[this.core.iColRef.length];
        this.core.iMain = index;
        this.core.iRef = index2;
        this.core.bCascade = bl;
        this.setTableRows();
    }

    private Constraint() {
    }

    private void setTableRows() throws SQLException {
        this.core.oMain = this.core.tMain.getNewRow();
        if (this.core.tRef != null) {
            this.core.oRef = this.core.tRef.getNewRow();
        }
    }

    HsqlName getName() {
        return this.constName;
    }

    private void setName(String string, boolean bl) {
        this.constName.rename(string, bl);
    }

    String getPkName() {
        return this.core.pkName == null ? null : this.core.pkName.name;
    }

    String getFkName() {
        return this.core.fkName == null ? null : this.core.fkName.name;
    }

    int getType() {
        return this.iType;
    }

    Table getMain() {
        return this.core.tMain;
    }

    Index getMainIndex() {
        return this.core.iMain;
    }

    Table getRef() {
        return this.core.tRef;
    }

    Index getRefIndex() {
        return this.core.iRef;
    }

    boolean isCascade() {
        return this.core.bCascade;
    }

    int[] getMainColumns() {
        return this.core.iColMain;
    }

    int[] getRefColumns() {
        return this.core.iColRef;
    }

    boolean isIndexFK(Index index) {
        return !(this.iType != 0 && this.iType != 1 || this.core.iMain != index && this.core.iRef != index);
    }

    boolean isIndexUnique(Index index) {
        return this.iType == 2 && this.core.iMain == index;
    }

    boolean isEquivalent(int[] nArray, int n) {
        return n == this.iType && this.iType == 2 && this.core.iLen == nArray.length && ArrayUtil.haveEqualSets(this.core.iColMain, nArray, this.core.iLen);
    }

    void replaceTable(Table table, Table table2, int n, int n2) throws SQLException {
        if (table == this.core.tMain) {
            this.core.tMain = table2;
            this.setTableRows();
            this.core.iMain = this.core.tMain.getIndex(this.core.iMain.getName().name);
            this.core.iColMain = ArrayUtil.getAdjustedColumnArray(this.core.iColMain, this.core.iLen, n, n2);
        }
        if (table == this.core.tRef) {
            this.core.tRef = table2;
            this.setTableRows();
            if (this.core.iRef != null) {
                this.core.iRef = this.core.tRef.getIndex(this.core.iRef.getName().name);
                if (this.core.iRef != this.core.iMain) {
                    this.core.iColRef = ArrayUtil.getAdjustedColumnArray(this.core.iColRef, this.core.iLen, n, n2);
                }
            }
        }
    }

    void checkInsert(Object[] objectArray) throws SQLException {
        if (this.iType == 1 || this.iType == 2) {
            return;
        }
        int n = 0;
        while (n < this.core.iLen) {
            Object object = objectArray[this.core.iColRef[n]];
            if (object == null) {
                return;
            }
            this.core.oMain[this.core.iColMain[n]] = object;
            ++n;
        }
        Trace.check(this.core.iMain.find(this.core.oMain) != null, 8, this.core.fkName.name + " table: " + this.core.tMain.getName().name);
    }

    private void checkDelete(Object[] objectArray) throws SQLException {
        Object object;
        int n = 0;
        while (n < this.core.iLen) {
            object = objectArray[this.core.iColMain[n]];
            if (object == null) {
                return;
            }
            this.core.oRef[this.core.iColRef[n]] = object;
            ++n;
        }
        object = this.core.iRef.find(this.core.oRef);
        Trace.check(object == null, 8, this.core.fkName.name + " table: " + this.core.tRef.getName().name);
    }

    Node findFkRef(Object[] objectArray) throws SQLException {
        Object object;
        int n = 0;
        while (n < this.core.iLen) {
            object = objectArray[this.core.iColMain[n]];
            if (object == null) {
                return null;
            }
            this.core.oColRef[n] = object;
            ++n;
        }
        object = this.core.iRef.findSimple(this.core.oColRef, this.core.bCascade);
        Trace.check(object == null || this.core.bCascade, 8, this.core.fkName.name + " table: " + this.core.tRef.getName().name);
        return object;
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws SQLException {
        block7: {
            block6: {
                if (this.iType == 2) {
                    return;
                }
                if (this.iType != 1) break block6;
                if (!ArrayUtil.haveCommonElement(nArray, this.core.iColMain, this.core.iLen)) {
                    return;
                }
                Record record = result.rRoot;
                while (record != null) {
                    if (this.core.iMain.find(record.data) == null) {
                        this.checkDelete(record.data);
                    }
                    record = record.next;
                }
                break block7;
            }
            if (this.iType != 0) break block7;
            if (!ArrayUtil.haveCommonElement(nArray, this.core.iColMain, this.core.iLen)) {
                return;
            }
            Record record = result2.rRoot;
            while (record != null) {
                this.checkInsert(record.data);
                record = record.next;
            }
        }
    }
}

