/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaExplorer;
import mondrian.olap.MondrianDef;

public class SchemaPropertyCellRenderer
extends DefaultTableCellRenderer {
    JLabel stringRenderer = new JLabel();
    JCheckBox booleanRenderer;
    JLabel integerRenderer;
    JTable tableRenderer;

    public SchemaPropertyCellRenderer() {
        this.stringRenderer.setFont(Font.decode("Dialog"));
        this.booleanRenderer = new JCheckBox();
        this.booleanRenderer.setBackground(Color.white);
        this.integerRenderer = new JLabel();
        this.integerRenderer.setHorizontalAlignment(4);
        this.integerRenderer.setFont(Font.decode("Courier"));
        this.tableRenderer = new JTable();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column == 1) {
            if (value instanceof String) {
                this.stringRenderer.setText((String)value);
                return this.stringRenderer;
            }
            if (value instanceof Boolean) {
                this.booleanRenderer.setSelected((Boolean)value);
                return this.booleanRenderer;
            }
            if (value instanceof Integer) {
                this.integerRenderer.setText((String)value);
                return this.integerRenderer;
            }
            if (value == null) {
                return null;
            }
            if (value.getClass() == MondrianDef.Join.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_JOIN);
                this.tableRenderer.setModel(ptm);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianDef.OrdinalExpression.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_SQL);
                this.tableRenderer.setModel(ptm);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianDef.Relation.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_RELATION);
                this.tableRenderer.setModel(ptm);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianDef.Table.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_TABLE);
                this.tableRenderer.setModel(ptm);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianDef.Property.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_PROPERTY);
                this.tableRenderer.setModel(ptm);
                return this.tableRenderer;
            }
            return null;
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

