/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.aggmatcher.AggGen;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerBase;

public class FastBatchingCellReader
implements CellReader {
    private static final Logger LOGGER = Logger.getLogger((Class)FastBatchingCellReader.class);
    private static boolean generateAggregateSql = MondrianProperties.instance().GenerateAggregateSql.get();
    private final RolapCube cube;
    private final Set pinnedSegments;
    private final Map batches;
    private int requestCount;
    RolapAggregationManager aggMgr = AggregationManager.instance();
    private boolean dirty;
    private static final Logger BATCH_LOGGER;

    public FastBatchingCellReader(RolapCube cube) {
        this.cube = cube;
        this.pinnedSegments = new HashSet();
        this.batches = new HashMap();
    }

    public Object get(Evaluator evaluator) {
        RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
        Member[] currentMembers = rolapEvaluator.getCurrentMembers();
        CellRequest request = RolapAggregationManager.makeRequest(currentMembers, false);
        if (request == null) {
            return Util.nullValue;
        }
        Object o = this.aggMgr.getCellFromCache(request, this.pinnedSegments);
        if (o == Boolean.TRUE) {
            return RolapUtil.valueNotReadyException;
        }
        if (o != null) {
            return o;
        }
        this.recordCellRequest(request);
        return RolapUtil.valueNotReadyException;
    }

    void recordCellRequest(CellRequest request) {
        ++this.requestCount;
        BitKey key = request.getBatchKey();
        Batch batch = (Batch)this.batches.get(key);
        if (batch == null) {
            batch = new Batch(request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("FastBatchingCellReader: bitkey=" + request.getBatchKey()));
                RolapStar star = this.cube.getStar();
                if (star != null) {
                    RolapStar.Column[] columns = star.lookupColumns(request.getBatchKey());
                    for (int i = 0; i < columns.length; ++i) {
                        LOGGER.debug((Object)("  " + columns[i]));
                    }
                }
            }
            this.batches.put(key, batch);
        }
        batch.add(request);
    }

    boolean isDirty() {
        return this.dirty || !this.batches.isEmpty();
    }

    boolean loadAggregations() {
        long t1 = System.currentTimeMillis();
        this.requestCount = 0;
        if (this.batches.isEmpty() && !this.dirty) {
            return false;
        }
        Iterator it = this.batches.values().iterator();
        while (it.hasNext()) {
            ((Batch)it.next()).loadAggregation();
        }
        this.batches.clear();
        if (LOGGER.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            LOGGER.debug((Object)("loadAggregation (millis): " + (t2 - t1)));
        }
        this.dirty = false;
        return true;
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    static {
        MondrianProperties.instance().GenerateAggregateSql.addTrigger((Trigger)new TriggerBase(true){

            public void execute(Property property, String value) {
                generateAggregateSql = property.booleanValue();
            }
        });
        BATCH_LOGGER = Logger.getLogger((Class)Batch.class);
    }

    class Batch {
        final RolapStar.Column[] columns;
        final BitKey bitKey;
        final List measuresList = new ArrayList();
        final Set[] valueSets;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Batch(CellRequest request) {
            this.columns = request.getColumns();
            this.bitKey = request.getBatchKey();
            this.valueSets = new HashSet[this.columns.length];
            for (int i = 0; i < this.valueSets.length; ++i) {
                this.valueSets[i] = new HashSet();
            }
        }

        public void add(CellRequest request) {
            List values = request.getValueList();
            for (int j = 0; j < this.columns.length; ++j) {
                this.valueSets[j].add(values.get(j));
            }
            RolapStar.Measure measure = request.getMeasure();
            if (!this.measuresList.contains(measure)) {
                if (!$assertionsDisabled && this.measuresList.size() != 0 && measure.getStar() != ((RolapStar.Measure)this.measuresList.get(0)).getStar()) {
                    throw new AssertionError((Object)"Measure must belong to same star as other measures");
                }
                this.measuresList.add(measure);
            }
        }

        void loadAggregation() {
            RolapStar.Measure distinctMeasure;
            if (generateAggregateSql) {
                if (FastBatchingCellReader.this.cube.isVirtual()) {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("AggGen: Sorry, can not create SQL for virtual Cube \"");
                    buf.append(FastBatchingCellReader.this.cube.getName());
                    buf.append("\", operation not currently supported");
                    BATCH_LOGGER.error((Object)buf.toString());
                } else {
                    AggGen aggGen = new AggGen(FastBatchingCellReader.this.cube.getStar(), this.columns);
                    if (aggGen.isReady()) {
                        System.out.println("createLost:" + Util.nl + aggGen.createLost());
                        System.out.println("insertIntoLost:" + Util.nl + aggGen.insertIntoLost());
                        System.out.println("createCollapsed:" + Util.nl + aggGen.createCollapsed());
                        System.out.println("insertIntoCollapsed:" + Util.nl + aggGen.insertIntoCollapsed());
                    } else {
                        BATCH_LOGGER.error((Object)"AggGen failed");
                    }
                }
            }
            long t1 = System.currentTimeMillis();
            AggregationManager aggmgr = AggregationManager.instance();
            ColumnConstraint[][] constraintses = new ColumnConstraint[this.columns.length][];
            for (int j = 0; j < this.columns.length; ++j) {
                Set valueSet = this.valueSets[j];
                ColumnConstraint[] constraints = valueSet == null ? null : valueSet.toArray(new ColumnConstraint[valueSet.size()]);
                constraintses[j] = constraints;
            }
            while ((distinctMeasure = this.getFirstDistinctMeasure(this.measuresList)) != null) {
                String expr = distinctMeasure.getExpression().getGenericExpression();
                ArrayList<RolapStar.Measure> distinctMeasuresList = new ArrayList<RolapStar.Measure>();
                int i = 0;
                while (i < this.measuresList.size()) {
                    RolapStar.Measure measure = (RolapStar.Measure)this.measuresList.get(i);
                    if (measure.getAggregator().isDistinct() && measure.getExpression().getGenericExpression().equals(expr)) {
                        this.measuresList.remove(i);
                        distinctMeasuresList.add(distinctMeasure);
                        continue;
                    }
                    ++i;
                }
                RolapStar.Measure[] measures = distinctMeasuresList.toArray(new RolapStar.Measure[distinctMeasuresList.size()]);
                aggmgr.loadAggregation(measures, this.columns, this.bitKey, constraintses, FastBatchingCellReader.this.pinnedSegments);
            }
            int measureCount = this.measuresList.size();
            if (measureCount > 0) {
                RolapStar.Measure[] measures = this.measuresList.toArray(new RolapStar.Measure[measureCount]);
                aggmgr.loadAggregation(measures, this.columns, this.bitKey, constraintses, FastBatchingCellReader.this.pinnedSegments);
            }
            if (BATCH_LOGGER.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                BATCH_LOGGER.debug((Object)("Batch.loadAggregation (millis) " + (t2 - t1)));
            }
        }

        RolapStar.Measure getFirstDistinctMeasure(List measuresList) {
            for (int i = 0; i < measuresList.size(); ++i) {
                RolapStar.Measure measure = (RolapStar.Measure)measuresList.get(i);
                if (!measure.getAggregator().isDistinct()) continue;
                return measure;
            }
            return null;
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$FastBatchingCellReader == null ? (class$mondrian$rolap$FastBatchingCellReader = FastBatchingCellReader.class$("mondrian.rolap.FastBatchingCellReader")) : class$mondrian$rolap$FastBatchingCellReader).desiredAssertionStatus();
        }
    }
}

