/*
 * EJBQLConnectionEditor.java
 *
 * Created on March 27, 2007, 1:18 PM
 */

package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.JRDataSourceProviderConnection;
import it.businesslogic.ireport.util.I18n;

/**
 *
 * @author  gtoffoli
 */
public class JRDataSourceProviderConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public JRDataSourceProviderConnectionEditor() {
        initComponents();
        applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelDatasourceProvider = new javax.swing.JPanel();
        jLabel17 = new javax.swing.JLabel();
        jTextFieldJRDataSourceProvider = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        jPanelDatasourceProvider.setLayout(new java.awt.GridBagLayout());

        jLabel17.setText("JasperReports DataSource Provider class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 1, 3);
        jPanelDatasourceProvider.add(jLabel17, gridBagConstraints);

        jTextFieldJRDataSourceProvider.setText("it.businesslogic.ireport.examples.PersonBeansDataSource");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelDatasourceProvider.add(jTextFieldJRDataSourceProvider, gridBagConstraints);

        add(jPanelDatasourceProvider, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel17;
    private javax.swing.JPanel jPanelDatasourceProvider;
    private javax.swing.JTextField jTextFieldJRDataSourceProvider;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof JRDataSourceProviderConnection)
        {
            JRDataSourceProviderConnection con = (JRDataSourceProviderConnection)iReportConnection;
            this.jTextFieldJRDataSourceProvider.setText( it.businesslogic.ireport.util.Misc.nvl(con.getProperties().get("JRDataSourceProvider"), "") ); 
        }
    }

    public IReportConnection getIReportConnection() {
        
        IReportConnection irConn = new JRDataSourceProviderConnection();
        ((JRDataSourceProviderConnection)irConn).getProperties().put("JRDataSourceProvider", this.jTextFieldJRDataSourceProvider.getText().trim() );
        iReportConnection = irConn;
        return iReportConnection;
    }
    
    public void applyI18n(){
          jLabel17.setText(I18n.getString("connectionDialog.label17","JasperReports DataSource Provider class"));
    }
    
    
}
