/*
 * EJBQLConnectionEditor.java
 *
 * Created on March 27, 2007, 1:18 PM
 */

package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.connection.EJBQLConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.JRSpringLoadedHibernateConnection;
import it.businesslogic.ireport.util.I18n;

/**
 *
 * @author  gtoffoli
 */
public class JRSpringLoadedHibernateConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public JRSpringLoadedHibernateConnectionEditor() {
        initComponents();
        applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelSpringLoadedHibernate = new javax.swing.JPanel();
        jLabel21 = new javax.swing.JLabel();
        jTextFieldSLHSpringConfig = new javax.swing.JTextField();
        jLabel22 = new javax.swing.JLabel();
        jTextFieldSLHSessionFactory = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jPanelSpringLoadedHibernate.setLayout(new java.awt.GridBagLayout());

        jLabel21.setText("Spring configuration");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        jPanelSpringLoadedHibernate.add(jLabel21, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        jPanelSpringLoadedHibernate.add(jTextFieldSLHSpringConfig, gridBagConstraints);

        jLabel22.setText("Session Factory Bean ID");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        jPanelSpringLoadedHibernate.add(jLabel22, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        jPanelSpringLoadedHibernate.add(jTextFieldSLHSessionFactory, gridBagConstraints);

        jLabel16.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel16.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/hibernate.png")));
        jLabel16.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        jLabel16.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelSpringLoadedHibernate.add(jLabel16, gridBagConstraints);

        add(jPanelSpringLoadedHibernate, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JPanel jPanelSpringLoadedHibernate;
    private javax.swing.JTextField jTextFieldSLHSessionFactory;
    private javax.swing.JTextField jTextFieldSLHSpringConfig;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof JRSpringLoadedHibernateConnection)
        {
            this.jTextFieldSLHSpringConfig.setText( ((JRSpringLoadedHibernateConnection)iReportConnection).getSpringConfig() );
            this.jTextFieldSLHSessionFactory.setText( ((JRSpringLoadedHibernateConnection)iReportConnection).getSessionFactoryBeanId() );
        }
    }

    public IReportConnection getIReportConnection() {
        
        IReportConnection irConn = new JRSpringLoadedHibernateConnection();
        ((JRSpringLoadedHibernateConnection)irConn).setSessionFactoryBeanId(jTextFieldSLHSessionFactory.getText());
        ((JRSpringLoadedHibernateConnection)irConn).setSpringConfig(jTextFieldSLHSpringConfig.getText());

        iReportConnection = irConn;
        return iReportConnection;
    }
    
    public void applyI18n(){

                jLabel21.setText(I18n.getString("connectionDialog.label21","Spring configuration"));
                jLabel22.setText(I18n.getString("connectionDialog.label22","Session Factory Bean ID"));
                                
    }
    
    
}
