/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.ArrayList;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class BeanNameUrlHandlerMapping
extends AbstractUrlHandlerMapping {
    public void initApplicationContext() throws ApplicationContextException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for URL mappings in application context: " + this.getApplicationContext()));
        }
        String[] beanNames = this.getApplicationContext().getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            String[] urls = this.checkForUrl(beanNames[i]);
            if (urls.length > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found URL mapping [" + beanNames[i] + "]"));
                }
                for (int j = 0; j < urls.length; ++j) {
                    this.registerHandler(urls[j], beanNames[i]);
                }
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Rejected bean name '" + beanNames[i] + "'"));
        }
    }

    protected String[] checkForUrl(String beanName) {
        ArrayList<String> urls = new ArrayList<String>();
        if (beanName.startsWith("/")) {
            urls.add(beanName);
        }
        String[] aliases = this.getApplicationContext().getAliases(beanName);
        for (int j = 0; j < aliases.length; ++j) {
            if (!aliases[j].startsWith("/")) continue;
            urls.add(aliases[j]);
        }
        return urls.toArray(new String[urls.size()]);
    }
}

