/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective;

import java.io.Serializable;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.state.DockingState;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.perspective.Layout;
import org.flexdock.perspective.LayoutSequence;
import org.flexdock.perspective.event.LayoutListener;

public class Perspective
implements Cloneable,
Serializable {
    private String m_persistentId;
    private String m_perspectiveName;
    private Layout m_layout;
    private LayoutSequence m_initalSequence;

    public Perspective(String persistentId, String perspectiveName) {
        this(persistentId, perspectiveName, false);
    }

    public Perspective(String persistentId, String perspectiveName, boolean defaultMode) {
        if (persistentId == null) {
            throw new NullPointerException("persistentId cannot be null");
        }
        if (perspectiveName == null) {
            throw new NullPointerException("perspectiveName cannot be null");
        }
        this.m_persistentId = persistentId;
        this.m_perspectiveName = perspectiveName;
        this.m_layout = new Layout();
    }

    public String getName() {
        return this.m_perspectiveName;
    }

    public String getPersistentId() {
        return this.m_persistentId;
    }

    public void addDockable(String dockableId) {
        this.getLayout().add(dockableId);
    }

    public boolean removeDockable(String dockableId) {
        return this.getLayout().remove(dockableId) != null;
    }

    public Dockable getDockable(String dockableId) {
        return this.getLayout().getDockable(dockableId);
    }

    public void addLayoutListener(LayoutListener listener) {
        this.getLayout().addListener(listener);
    }

    public void removeLayoutListener(LayoutListener listener) {
        this.getLayout().removeListener(listener);
    }

    public Dockable[] getDockables() {
        return this.getLayout().getDockables();
    }

    public DockingState getDockingState(String dockable) {
        return this.getLayout().getDockingState(dockable, false);
    }

    public DockingState getDockingState(Dockable dockable) {
        return this.getLayout().getDockingState(dockable, false);
    }

    public DockingState getDockingState(String dockable, boolean load) {
        return this.getLayout().getDockingState(dockable, load);
    }

    public DockingState getDockingState(Dockable dockable, boolean load) {
        return this.getLayout().getDockingState(dockable, load);
    }

    public LayoutSequence getInitialSequence() {
        return this.getInitialSequence(false);
    }

    public LayoutSequence getInitialSequence(boolean create) {
        if (this.m_initalSequence == null && create) {
            this.m_initalSequence = new LayoutSequence();
        }
        return this.m_initalSequence;
    }

    public void setInitialSequence(LayoutSequence sequence) {
        this.m_initalSequence = sequence;
    }

    public Layout getLayout() {
        return this.m_layout;
    }

    public void setLayout(Layout layout) {
        this.m_layout = layout;
    }

    public void reset(DockingPort port) {
        if (this.m_initalSequence != null) {
            this.m_initalSequence.apply(port);
            Layout layout = this.getLayout();
            if (layout != null) {
                layout.update(this.m_initalSequence);
            }
        }
    }

    public void load(DockingPort port) {
        Layout layout = this.getLayout();
        if (layout.isInitialized()) {
            layout.apply(port);
        } else {
            this.reset(port);
        }
    }

    public void unload() {
        Dockable[] dockables = this.getLayout().getDockables();
        for (int i = 0; i < dockables.length; ++i) {
            DockingManager.close(dockables[i]);
        }
    }

    public void cacheLayoutState(DockingPort port) {
        if (port != null) {
            Layout layout = this.getLayout();
            LayoutNode node = port.exportLayout();
            layout.setRestorationLayout(node);
        }
    }

    public Object clone() {
        Perspective clone = new Perspective(this.m_persistentId, this.m_perspectiveName);
        clone.m_layout = (Layout)this.m_layout.clone();
        clone.m_initalSequence = this.m_initalSequence == null ? null : (LayoutSequence)this.m_initalSequence.clone();
        return clone;
    }
}

