/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.restore.handlers;

import java.awt.Component;
import java.util.Map;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.state.DockingState;
import org.flexdock.perspective.PerspectiveManager;
import org.flexdock.perspective.restore.handlers.RestorationHandler;

public class UnknownStateHandler
implements RestorationHandler,
DockingConstants {
    private static final String[] REGIONS = new String[]{"CENTER", "WEST", "EAST", "SOUTH", "NORTH"};

    public boolean restore(Dockable dockable, DockingState info, Map context) {
        DockingPort port = PerspectiveManager.getMainDockingPort();
        if (port == null) {
            return false;
        }
        Component comp = port.getDockedComponent();
        if (comp == null) {
            return this.dock(dockable, port);
        }
        DockingInfo dockingInfo = this.getDeepestWest(port);
        if (dockingInfo.dockable == null) {
            return this.dock(dockable, dockingInfo.port);
        }
        return this.dock(dockable, dockingInfo.dockable);
    }

    private boolean dock(Dockable dockable, DockingPort port) {
        return this.dock(dockable, null, port);
    }

    private boolean dock(Dockable dockable, Dockable parent) {
        return this.dock(dockable, parent, null);
    }

    private boolean dock(Dockable dockable, Dockable parent, DockingPort port) {
        boolean ret = false;
        for (int i = 0; i < REGIONS.length; ++i) {
            ret = parent == null ? DockingManager.dock(dockable, port, REGIONS[i]) : DockingManager.dock(dockable, parent, REGIONS[i]);
            if (!ret) continue;
            return true;
        }
        return false;
    }

    private DockingInfo getDeepestWest(DockingPort port) {
        Component comp = port.getDockedComponent();
        if (comp instanceof JTabbedPane) {
            Dockable d = port.getDockable("CENTER");
            return new DockingInfo(d, port);
        }
        if (comp instanceof JSplitPane && (comp = ((JSplitPane)comp).getLeftComponent()) instanceof DockingPort) {
            return this.getDeepestWest((DockingPort)((Object)comp));
        }
        return new DockingInfo(DockingManager.getDockable(comp), port);
    }

    private static class DockingInfo {
        private Dockable dockable;
        private DockingPort port;

        private DockingInfo(Dockable d, DockingPort p) {
            this.dockable = d;
            this.port = p;
        }
    }
}

