/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application;

import com.wutka.jox.JOXBeanReader;
import com.wutka.jox.JOXBeanWriter;
import java.beans.XMLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import net.charabia.jsmoothgen.application.JSmoothModelBean;

public class JSmoothModelPersistency {
    public static JSmoothModelBean load(File fin) throws IOException {
        FileInputStream fis = new FileInputStream(fin);
        try {
            JSmoothModelBean jobj = new JSmoothModelBean();
            String INVALID = "INVALID";
            jobj.setSkeletonName(INVALID);
            FileReader fr = new FileReader(fin);
            JOXBeanReader jbr = new JOXBeanReader(fr);
            jbr.readObject(jobj);
            jbr.close();
            fr.close();
            if (jobj.getSkeletonName() == INVALID) {
                throw new Exception("Not a JOX File");
            }
            if (jobj.getJarLocation() != null && jobj.getJarLocation().length() > 0) {
                jobj.setEmbeddedJar(true);
            }
            return jobj;
        }
        catch (Exception exc) {
            try {
                XMLDecoder dec = new XMLDecoder(fis);
                JSmoothModelBean xobj = (JSmoothModelBean)dec.readObject();
                fis.close();
                if (xobj.getJarLocation() != null && xobj.getJarLocation().length() > 0) {
                    xobj.setEmbeddedJar(true);
                }
                return xobj;
            }
            catch (Exception exc2) {
                exc2.printStackTrace();
                throw new IOException(exc2.toString());
            }
        }
    }

    public static void save(File fout, JSmoothModelBean obj) throws IOException {
        try {
            String jarloc = obj.getJarLocation();
            if (!obj.getEmbeddedJar()) {
                obj.setJarLocation(null);
            }
            FileWriter fw = new FileWriter(fout);
            JOXBeanWriter jbw = new JOXBeanWriter(fw);
            jbw.writeObject("jsmoothproject", obj);
            jbw.close();
            fw.close();
            obj.setJarLocation(jarloc);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    public static File makePathRelativeIfPossible(File root, File f) {
        int i;
        int cursor;
        String n;
        File cur;
        File orgfile = f;
        try {
            if (!f.isAbsolute()) {
                f = new File(root, f.toString());
            }
            f = f.getCanonicalFile();
            f = f.getAbsoluteFile();
            root = root.getCanonicalFile();
            root = root.getAbsoluteFile();
        }
        catch (IOException iox) {
            iox.printStackTrace();
            System.out.println("Failed, returning " + orgfile);
            return orgfile;
        }
        Vector<String> rootvec = new Vector<String>();
        Vector<String> targetvec = new Vector<String>();
        for (cur = root; cur != null; cur = cur.getParentFile()) {
            n = cur.getName();
            if (n.equals("")) {
                n = cur.getAbsolutePath();
            }
            rootvec.add(0, n);
        }
        for (cur = f; cur != null; cur = cur.getParentFile()) {
            n = cur.getName();
            if (n.equals("")) {
                n = cur.getAbsolutePath();
            }
            targetvec.add(0, n);
        }
        for (cursor = 0; cursor < rootvec.size() && cursor < targetvec.size() && rootvec.elementAt(cursor).equals(targetvec.elementAt(cursor)); ++cursor) {
        }
        if (cursor == 0) {
            return f;
        }
        if (cursor == rootvec.size() && cursor == targetvec.size()) {
            return new File(".");
        }
        StringBuffer buffer = new StringBuffer();
        for (i = cursor; i < rootvec.size(); ++i) {
            buffer.append("../");
        }
        for (i = cursor; i < targetvec.size(); ++i) {
            buffer.append(targetvec.elementAt(i).toString());
            buffer.append("/");
        }
        return new File(buffer.toString());
    }

    public static void main(String[] args) {
        File root = new File("z:/a/b/c/d");
        File t1 = new File("z:/a/b/e/f");
        File t2 = new File("c:/t/r");
        File t3 = new File("z:/a/b/c/d/i/m");
        File t4 = new File("z:/a/b/c/d");
        System.out.println("Rel root, t1: " + JSmoothModelPersistency.makePathRelativeIfPossible(root, t1));
        System.out.println("Rel root, t2: " + JSmoothModelPersistency.makePathRelativeIfPossible(root, t2));
        System.out.println("Rel root, t3: " + JSmoothModelPersistency.makePathRelativeIfPossible(root, t3));
        System.out.println("Rel root, t4: " + JSmoothModelPersistency.makePathRelativeIfPossible(root, t4));
        File f1 = new File("f:\\a\\b");
        File f2 = new File("f:\\a\\c");
        File f3 = new File(f1, f2.toString());
        System.out.println("f3 = " + f3.toString());
    }
}

