/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.library.objects;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.gui.library.AbstractLibraryObject;
import it.businesslogic.ireport.gui.library.objects.TotalObjectDialog;
import it.businesslogic.ireport.util.I18n;
import java.awt.Frame;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Vector;
import javax.swing.ImageIcon;

public class TotalObject
extends AbstractLibraryObject {
    private static ImageIcon defaultIcon = new ImageIcon(AbstractLibraryObject.class.getResource("/it/businesslogic/ireport/icons/library/total.png"));

    public String getName() {
        return I18n.getString("gui.library.objects.total", "Total");
    }

    public void drop(DropTargetDropEvent dtde) {
        TotalObjectDialog tod = new TotalObjectDialog((Frame)this.getReportFrame().getMainFrame(), true);
        tod.setJrf(this.getReportFrame());
        tod.setVisible(true);
        if (tod.getDialogResult() == 0) {
            Object obj = tod.getSelectedObject();
            if (obj == null) {
                return;
            }
            String clazz = "java.lang.Integer";
            String expression = "";
            String tot_name = "";
            if (obj instanceof JRField) {
                clazz = ((JRField)obj).getClassType();
                expression = "$F{" + obj + "}";
                tot_name = tot_name + obj + "_";
            } else if (obj instanceof JRParameter) {
                clazz = ((JRParameter)obj).getClassType();
                expression = "$P{" + obj + "}";
                tot_name = tot_name + obj + "_";
            } else if (obj instanceof JRVariable) {
                clazz = ((JRVariable)obj).getClassType();
                expression = "$V{" + obj + "}";
                tot_name = tot_name + obj + "_";
            } else {
                expression = "" + obj;
            }
            String var_name = "SUM_" + tot_name;
            String time = "Report";
            String tmp_name = var_name;
            Vector variables = this.getReportFrame().getReport().getVariables();
            int i = 1;
            while (true) {
                var_name = tmp_name + i;
                boolean found = false;
                for (int k = 0; k < variables.size(); ++k) {
                    if (!((JRVariable)variables.get(k)).getName().equals(var_name)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                ++i;
            }
            Band b = this.getReportFrame().getBandAt(dtde.getLocation());
            JRVariable jrv = new JRVariable(var_name, false);
            jrv.setClassType(clazz);
            jrv.setExpression(expression);
            if (b.getName().equals("pageFooter")) {
                time = "Page";
            } else if (b.getName().equals("lastPageFooter")) {
                time = "Report";
            } else if (b.getName().equals("columnFooter")) {
                time = "Column";
            } else if (b.getName().endsWith("Footer")) {
                time = "Group";
                jrv.setResetGroup(b.getName().substring(0, b.getName().length() - "Footer".length()));
            }
            jrv.setResetType(time);
            jrv.setCalculation("Sum");
            this.getReportFrame().getReport().addVariable(jrv);
            this.getReportFrame().dropNewTextField(dtde.getLocation(), "$V{" + var_name + "}", clazz, "Now");
        }
    }

    public ImageIcon getIcon() {
        return defaultIcon;
    }
}

