/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.logpane;

import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.gui.ElementPropertiesDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.logpane.LogPane;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class LogTextArea
extends JPanel
implements LanguageChangedListener {
    private StringBuffer outputBuffer;
    private String title = null;
    private LogPane logPane = null;
    private boolean removable = false;
    private Properties properties;
    private int maxlines = 5000;
    private JEditorPane jEditorPaneOutput;
    private JMenuItem jMenuItemClearLog;
    private JMenuItem jMenuItemCloseLog;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemSelectAll;
    private JPopupMenu jPopupMenuLog;
    private JScrollPane jScrollPaneOutput;
    private JSeparator jSeparator1;
    private EventListenerList listenerList = null;

    public LogTextArea(String title) {
        this.initComponents();
        this.outputBuffer = new StringBuffer();
        this.setTitle(title);
        this.jEditorPaneOutput.setContentType("text/html");
        this.jEditorPaneOutput.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !LogTextArea.parseError(e.getURL())) {
                    JOptionPane.showMessageDialog(MainFrame.getMainInstance(), " HyperlinkEvent " + e.getURL());
                }
            }
        });
        try {
            this.maxlines = Integer.parseInt(System.getProperty("ireport.maxoutputlines", "5000"));
        }
        catch (Exception ex) {
            this.maxlines = 5000;
        }
        this.clearConsole();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean parseError(URL url) {
        if (url == null) {
            return false;
        }
        JInternalFrame[] frames = MainFrame.getMainInstance().getJMDIDesktopPane().getAllFrames();
        JReportFrame jrf = null;
        for (int k = 0; k < frames.length; ++k) {
            if (!(frames[k] instanceof JReportFrame) || ((JReportFrame)frames[k]).getWindowID() != url.getPort()) continue;
            jrf = (JReportFrame)frames[k];
            if (frames[k].isSelected()) continue;
            try {
                frames[k].setSelected(true);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (jrf == null) {
            return false;
        }
        try {
            if (url.getHost().equalsIgnoreCase("error")) {
                String expression = url.getFile();
                if (expression == null || expression.length() <= 0) return false;
                if (expression.startsWith("/variable")) {
                    // empty if block
                }
                if (expression.startsWith("/textField_")) {
                    int index = 0;
                    int number = Integer.parseInt(expression.substring("/textField_".length()).trim());
                    Enumeration e = jrf.getReport().getElements().elements();
                    while (e.hasMoreElements()) {
                        ReportElement re = (ReportElement)e.nextElement();
                        if (!(re instanceof TextFieldReportElement) || ++index != number) continue;
                        jrf.setSelectedElement(re);
                        MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
                        ElementPropertiesDialog elementPropertiesDialog = MainFrame.getMainInstance().getElementPropertiesDialog();
                        MainFrame.getMainInstance().getElementPropertiesDialog();
                        elementPropertiesDialog.gotoTab(7);
                        return true;
                    }
                    return false;
                } else {
                    if (!expression.startsWith("/parameterDefaultValue_")) return false;
                    boolean index = false;
                    String name = expression.substring("/parameterDefaultValue_".length()).trim();
                    Enumeration e = jrf.getReport().getParameters().elements();
                    while (e.hasMoreElements()) {
                        JRParameter param = (JRParameter)e.nextElement();
                        if (!param.getName().equals(name)) continue;
                        MainFrame.getMainInstance().getValuesDialog().setVisible(true);
                        MainFrame.getMainInstance().getValuesDialog().modifyErrorParameter(param);
                        return true;
                    }
                }
                return false;
            }
            if (!url.getHost().equals("warning")) return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void initComponents() {
        this.jPopupMenuLog = new JPopupMenu();
        this.jMenuItemClearLog = new JMenuItem();
        this.jMenuItemCloseLog = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemSelectAll = new JMenuItem();
        this.jScrollPaneOutput = new JScrollPane();
        this.jEditorPaneOutput = new JEditorPane();
        this.jMenuItemClearLog.setText("Clear log");
        this.jMenuItemClearLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemClearLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemClearLog);
        this.jMenuItemCloseLog.setText("Close log");
        this.jMenuItemCloseLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemCloseLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemCloseLog);
        this.jPopupMenuLog.add(this.jSeparator1);
        this.jMenuItemCopy.setText("Copy");
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemCopy);
        this.jMenuItemSelectAll.setText("Select all");
        this.jMenuItemSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemSelectAllActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemSelectAll);
        this.setLayout(new BorderLayout());
        this.jScrollPaneOutput.setHorizontalScrollBarPolicy(32);
        this.jScrollPaneOutput.setVerticalScrollBarPolicy(22);
        this.jScrollPaneOutput.setMinimumSize(new Dimension(22, 75));
        this.jScrollPaneOutput.setPreferredSize(new Dimension(3, 100));
        this.jEditorPaneOutput.setBackground(new Color(204, 204, 204));
        this.jEditorPaneOutput.setEditable(false);
        this.jEditorPaneOutput.setFont(new Font("Courier New", 0, 12));
        this.jEditorPaneOutput.setOpaque(false);
        this.jEditorPaneOutput.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LogTextArea.this.jEditorPaneOutputMouseClicked(evt);
            }
        });
        this.jScrollPaneOutput.setViewportView(this.jEditorPaneOutput);
        this.add((Component)this.jScrollPaneOutput, "Center");
    }

    private void jMenuItemSelectAllActionPerformed(ActionEvent evt) {
        this.jEditorPaneOutput.selectAll();
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        this.jEditorPaneOutput.copy();
    }

    private void jMenuItemCloseLogActionPerformed(ActionEvent evt) {
        this.getLogPane().removeLog(this);
    }

    private void jMenuItemClearLogActionPerformed(ActionEvent evt) {
        this.clearConsole();
    }

    private void jEditorPaneOutputMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            this.jPopupMenuLog.show(this, evt.getPoint().x, evt.getPoint().y);
        }
    }

    public void logOnConsole(String noHTML) {
        noHTML = LogTextArea.tail(noHTML, this.maxlines);
        this.logOnConsole(noHTML, false);
    }

    public void logOnConsole(String text, int messageType) {
        if (text == null) {
            return;
        }
        if (!text.startsWith("<html>")) {
            text = text.replaceAll("\\>", "&gt;");
            text = text.replaceAll("\\<", "&lt;");
            text = text.replaceAll("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            text = text.replaceAll("\\n", "<br>");
            text = text.replaceAll("\\s", "&nbsp;");
            text = "<font face=\"SansSerif\" size=\"3\" color=\"#000000\">" + text + "</font>";
        } else {
            text = text.substring(6);
        }
        URL img_url = null;
        try {
            switch (messageType) {
                case 1: {
                    img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/log/information.png");
                    break;
                }
                case 2: {
                    img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/log/warning.png");
                    break;
                }
                case 0: {
                    img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/log/error.png");
                    break;
                }
                case 3: {
                    img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/log/question.png");
                    break;
                }
                default: {
                    img_url = null;
                    break;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (img_url != null) {
            text = "<img align=\"right\" src=\"" + img_url + "\">" + text;
        }
        this.logOnConsole(text, true);
    }

    public void logOnConsole(String s, boolean isHTML) {
        try {
            if (this.jEditorPaneOutput == null) {
                this.outputBuffer.append(s);
            } else {
                this.jEditorPaneOutput.setContentType("text/html");
                if (!isHTML) {
                    s = s.replaceAll("\\>", "&gt;");
                    s = s.replaceAll("\\<", "&lt;");
                    s = s.replaceAll("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
                    s = s.replaceAll("\\n", "<br>");
                    s = s.replaceAll("\\s", "&nbsp;");
                }
                HTMLDocument doc = (HTMLDocument)this.jEditorPaneOutput.getDocument();
                HTMLEditorKit editorKit = (HTMLEditorKit)this.jEditorPaneOutput.getEditorKit();
                if (!s.startsWith("<")) {
                    s = "<font face=\"Courier New\" size=\"3\" >" + s + "</font>";
                }
                editorKit.insertHTML(doc, doc.getLength(), s, 0, 0, null);
                this.logPane.setActiveLog(this);
            }
        }
        catch (Exception exsx) {
            JOptionPane.showMessageDialog(this, "" + exsx.getMessage());
        }
    }

    public void clearConsole() {
        this.jEditorPaneOutput.setContentType("text/html");
        this.outputBuffer.setLength(0);
        this.jEditorPaneOutput.setText("");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, title));
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? LogTextArea.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public LogPane getLogPane() {
        return this.logPane;
    }

    public void setLogPane(LogPane logPane) {
        this.logPane = logPane;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public void applyI18n() {
        this.jMenuItemClearLog.setText(I18n.getString("clearLog"));
        this.jMenuItemCloseLog.setText(I18n.getString("closeLog"));
        this.jMenuItemCopy.setText(I18n.getString("copy"));
        this.jMenuItemSelectAll.setText(I18n.getString("selectAll"));
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public static int countMatches(String str, String sub) {
        if (str == null || str.length() == 0 || sub == null || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String tail(String str, int lines) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int total = LogTextArea.countMatches(str, "\n");
        int splitTo = total - lines;
        if (splitTo <= 0) {
            return str;
        }
        int count = 0;
        int idx = 0;
        while (count < splitTo && (idx = str.indexOf("\n", idx)) != -1) {
            ++count;
            ++idx;
        }
        return str.substring(idx);
    }
}

