/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.LegacyHighlighter;

public class ResetDTCRColorHighlighter
extends LegacyHighlighter {
    public ResetDTCRColorHighlighter() {
        super(null, null, true);
    }

    public Component highlight(Component renderer, ComponentAdapter adapter) {
        if (renderer instanceof DefaultTableCellRenderer) {
            return super.highlight(renderer, adapter);
        }
        return renderer;
    }

    protected void applyBackground(Component renderer, ComponentAdapter adapter) {
        if (!adapter.isSelected()) {
            Object colorMemory = ((JComponent)renderer).getClientProperty("rendererColorMemory.background");
            if (colorMemory instanceof ColorMemory) {
                renderer.setBackground(((ColorMemory)colorMemory).color);
            } else {
                ((JComponent)renderer).putClientProperty("rendererColorMemory.background", new ColorMemory(renderer.getBackground()));
            }
        }
    }

    protected void applyForeground(Component renderer, ComponentAdapter adapter) {
        if (!adapter.isSelected()) {
            Object colorMemory = ((JComponent)renderer).getClientProperty("rendererColorMemory.foreground");
            if (colorMemory instanceof ColorMemory) {
                renderer.setForeground(((ColorMemory)colorMemory).color);
            } else {
                ((JComponent)renderer).putClientProperty("rendererColorMemory.foreground", new ColorMemory(renderer.getForeground()));
            }
        }
    }

    private static class ColorMemory {
        Color color;

        public ColorMemory(Color color) {
            this.color = color;
        }
    }
}

