<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['abouttobeinstalled'] = 'about to be installed';
$string['action'] = 'Action';
$string['actionchoice'] = 'What do you want to do with the file \'{$a}\'?';
$string['actions'] = 'Actions';
$string['active'] = 'Active';
$string['activeusers'] = 'Active users';
$string['activities'] = 'Activities';
$string['activities_help'] = 'Activities, such as forums, quizzes and wikis, enable interactive content to be added to the course.';
$string['activity'] = 'Activity';
$string['activityclipboard'] = 'Moving this activity: {$a}';
$string['activityiscurrentlyhidden'] = 'Sorry, this activity is currently hidden';
$string['activitymodule'] = 'Activity module';
$string['activitymodules'] = 'Activity modules';
$string['activityreport'] = 'Activity report';
$string['activityreports'] = 'Activity reports';
$string['activityselect'] = 'Select this activity to be moved elsewhere';
$string['activitysince'] = 'Activity since {$a}';
$string['activityweighted'] = 'Activity per user';
$string['add'] = 'Add';
$string['addactivity'] = 'Add an activity...';
$string['addactivitytosection'] = 'Add an activity to section \'{$a}\'';
$string['addadmin'] = 'Add admin';
$string['addblock'] = 'Add a block';
$string['addcomment'] = 'Add a comment...';
$string['addcountertousername'] = 'Create user by adding number to username';
$string['addcreator'] = 'Add course creator';
$string['adddots'] = 'Add...';
$string['added'] = 'Added {$a}';
$string['addedrecip'] = 'Added {$a} new recipient';
$string['addedrecips'] = 'Added {$a} new recipients';
$string['addedtogroup'] = 'Added to group "{$a}"';
$string['addedtogroupnot'] = 'Not added to group "{$a}"';
$string['addedtogroupnotenrolled'] = 'Not added to group "{$a}", because not enrolled in course';
$string['addfilehere'] = 'Add file(s) here';
$string['addinganew'] = 'Adding a new {$a}';
$string['addinganewto'] = 'Adding a new {$a->what} to {$a->to}';
$string['addingdatatoexisting'] = 'Adding data to existing';
$string['additionalnames'] = 'Additional names';
$string['addlinkhere'] = 'Add link here';
$string['addnewcategory'] = 'Add new category';
$string['addnewcourse'] = 'Add a new course';
$string['addnewuser'] = 'Add a new user';
$string['addnousersrecip'] = 'Add users who haven\'t accessed this {$a} to recipient list';
$string['addpagehere'] = 'Add text here';
$string['addresource'] = 'Add a resource...';
$string['addresourceoractivity'] = 'Add an activity or resource';
$string['addresourcetosection'] = 'Add a resource to section \'{$a}\'';
$string['address'] = 'Address';
$string['addstudent'] = 'Add student';
$string['addsubcategory'] = 'Add a subcategory';
$string['addteacher'] = 'Add teacher';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'To manually create a new user account';
$string['adminhelpassignadmins'] = 'Admins can do anything and go anywhere in the site';
$string['adminhelpassigncreators'] = 'Course creators can create new courses';
$string['adminhelpassignsiteroles'] = 'Apply defined site roles to specific users';
$string['adminhelpassignstudents'] = 'Go into a course and add students from the admin menu';
$string['adminhelpauthentication'] = 'You can use internal user accounts or external databases';
$string['adminhelpbackup'] = 'Configure automated backups and their schedule';
$string['adminhelpconfiguration'] = 'Configure how the site looks and works';
$string['adminhelpconfigvariables'] = 'Configure variables that affect general operation of the site';
$string['adminhelpcourses'] = 'Define courses and categories and assign people to them, edit pending courses';
$string['adminhelpeditorsettings'] = 'Define basic settings for HTML editor';
$string['adminhelpedituser'] = 'Browse the list of user accounts and edit any of them';
$string['adminhelpenvironment'] = 'Check how your server suits current and future installation requirements';
$string['adminhelpfailurelogs'] = 'Browse logs of failed logins';
$string['adminhelplanguage'] = 'For checking and editing the current language pack';
$string['adminhelplogs'] = 'Browse logs of all activity on this site';
$string['adminhelpmanageblocks'] = 'Manage installed blocks and their settings';
$string['adminhelpmanagedatabase'] = 'Access the database directly (be careful!)';
$string['adminhelpmanagefilters'] = 'Choose text filters and related settings';
$string['adminhelpmanagemodules'] = 'Manage installed modules and their settings';
$string['adminhelpmanageroles'] = 'Create and define roles that may be applied to users';
$string['adminhelpmymoodle'] = 'Configure the My Moodle blocks for users';
$string['adminhelpreports'] = 'Site level reports';
$string['adminhelpsitefiles'] = 'For publishing general files or uploading external backups';
$string['adminhelpsitesettings'] = 'Define how the front page of the site looks';
$string['adminhelpstickyblocks'] = 'Configure Moodle-wide sticky blocks';
$string['adminhelpthemes'] = 'Choose how the site looks (colours, fonts etc)';
$string['adminhelpuploadusers'] = 'Import new user accounts from a text file';
$string['adminhelpusers'] = 'Define your users and set up authentication';
$string['adminhelpxmldbeditor'] = 'Interface to edit the XMLDB files. Only for developers.';
$string['administration'] = 'Administration';
$string['administrationsite'] = 'Site administration';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administrators can usually do anything on the site, in all courses.';
$string['administrators'] = 'Administrators';
$string['administratorsall'] = 'All administrators';
$string['administratorsandteachers'] = 'Administrators and teachers';
$string['advanced'] = 'Advanced';
$string['advancedfilter'] = 'Advanced search';
$string['advancedsettings'] = 'Advanced settings';
$string['afterresource'] = 'After resource "{$a}"';
$string['aftersection'] = 'After section "{$a}"';
$string['again'] = 'again';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX and Javascript';
$string['all'] = 'All';
$string['allactions'] = 'All actions';
$string['allactivities'] = 'All activities';
$string['allcategories'] = 'All categories';
$string['alldays'] = 'All days';
$string['allfieldsrequired'] = 'All fields are required';
$string['allfiles'] = 'All files';
$string['allgroups'] = 'All groups';
$string['allchanges'] = 'All changes';
$string['alllogs'] = 'All logs';
$string['allmods'] = 'All {$a}';
$string['allow'] = 'Allow';
$string['allowinternal'] = 'Allow internal methods as well';
$string['allownone'] = 'Allow none';
$string['allownot'] = 'Do not allow';
$string['allparticipants'] = 'All participants';
$string['allteachers'] = 'All teachers';
$string['alphanumerical'] = 'Can only contain alphanumeric characters, hyphen (-) or period (.)';
$string['alreadyconfirmed'] = 'Registration has already been confirmed';
$string['alternatename'] = 'Alternate name';
$string['always'] = 'Always';
$string['and'] = '{$a->one} and {$a->two}';
$string['answer'] = 'Answer';
$string['any'] = 'Any';
$string['approve'] = 'Approve';
$string['appearance'] = 'Appearance';
$string['areyousure'] = 'Are you sure?';
$string['areyousuretorestorethis'] = 'Do you want to continue?';
$string['areyousuretorestorethisinfo'] = 'Later in this process you will have a choice of adding this backup to an existing course or creating a completely new course.';
$string['asc'] = 'Ascending';
$string['assessment'] = 'Assessment';
$string['assignadmins'] = 'Assign admins';
$string['assigncreators'] = 'Assign creators';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Assign site-wide roles';
$string['authenticateduser'] = 'Authenticated user';
$string['authenticateduserdescription'] = 'All logged in users.';
$string['authentication'] = 'Authentication';
$string['authenticationplugins'] = 'Authentication plugins';
$string['autosubscribe'] = 'Forum auto-subscribe';
$string['autosubscribeno'] = 'No: don\'t automatically subscribe me to forum discussions';
$string['autosubscribeyes'] = 'Yes: when I post, subscribe me to that forum discussion';
$string['availability'] = 'Availability';
$string['availablecourses'] = 'Available courses';
$string['back'] = 'Back';
$string['backto'] = 'Back to {$a}';
$string['backtocourselisting'] = 'Back to course listing';
$string['backtopageyouwereon'] = 'Back to the page you were on';
$string['backtoparticipants'] = 'Back to participants list';
$string['backup'] = 'Backup';
$string['backupactivehelp'] = 'Choose whether or not to do automated backups.';
$string['backupcancelled'] = 'Backup cancelled';
$string['backupcoursefileshelp'] = 'If enabled then course files will be included in automated backups';
$string['backupdate'] = 'Backup date';
$string['backupdatenew'] = '&nbsp; {$a->TAG} is now {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} was {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Backup details';
$string['backupexecuteathelp'] = 'Choose what time automated backups should run at.';
$string['backupfailed'] = 'Some of your courses weren\'t saved!!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Backup completed successfully';
$string['backupfromthissite'] = 'Backup was made on this site?';
$string['backupgradebookhistoryhelp'] = 'If enabled then gradebook history will be included in automated backups. Note that grade history must not be disabled in server settings (disablegradehistory) in order for this to work';
$string['backupincludemoduleshelp'] = 'Choose whether you want to include course modules, with or without user data, in automated backups';
$string['backupincludemoduleuserdatahelp'] = 'Choose whether you want to include module user data in automated backups.';
$string['backupkeephelp'] = 'How many recent backups for each course do you want to keep? (older ones will be deleted automatically)';
$string['backuplogdetailed'] = 'Detailed execution log';
$string['backuploglaststatus'] = 'Last execution log';
$string['backupmissinguserinfoperms'] = 'Note: This backup contains no user data. Exercise and Workshop activities will not be included in the backup, since these modules are not compatible with this type of backup.';
$string['backupnext'] = 'Next backup';
$string['backupnonisowarning'] = 'Warning: this backup is from a non-Unicode version of Moodle (pre 1.6).  If this backup contains any non-ISO-8859-1 texts then they may be CORRUPTED if you try to restore them to this Unicode version of Moodle.  See the <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> for more information about how to recover this backup correctly.';
$string['backupnotyetrun'] = 'Automated backup pending';
$string['backuporiginalname'] = 'Backup name';
$string['backuproleassignments'] = 'Backup role assignments for these roles';
$string['backupsavetohelp'] = 'Full path to the directory where you want to save the backup files<br />(leave blank to save in its course default dir)';
$string['backupsitefileshelp'] = 'If enabled then site files used in courses will be included in automated backups';
$string['backuptakealook'] = 'Please take a look at your backup logs in:
  {$a}';
$string['backupuserfileshelp'] = 'Choose whether user files (eg profile images) should be included in automated backups';
$string['backupversion'] = 'Backup version';
$string['badges'] = 'Badges';
$string['block'] = 'Block';
$string['blockconfiga'] = 'Configuring a {$a} block';
$string['blockconfigbad'] = 'This block has not been implemented correctly and thus cannot provide a configuration interface.';
$string['blocks'] = 'Blocks';
$string['blocksaddedit'] = 'Add/Edit blocks';
$string['blockseditoff'] = 'Blocks editing off';
$string['blocksediton'] = 'Blocks editing on';
$string['blocksetup'] = 'Setting up block tables';
$string['blocksuccess'] = '{$a} tables have been set up correctly';
$string['brief'] = 'Brief';
$string['bulkactions'] = 'Bulk actions';
$string['bulkactionselect'] = '{$a} bulk action selection';
$string['bulkmovecoursessuccess'] = 'Successfully moved {$a->courses} courses into {$a->category}';
$string['bycourseorder'] = 'By course order';
$string['byname'] = 'by {$a}';
$string['bypassed'] = 'Bypassed';
$string['cachecontrols'] = 'Cache controls';
$string['cancel'] = 'Cancel';
$string['cancelled'] = 'Cancelled';
$string['categories'] = 'Course categories';
$string['categoriesandcoures'] = 'Course categories and courses';
$string['category'] = 'Category';
$string['categoryadded'] = 'The category \'{$a}\' was added';
$string['categorybulkaction'] = 'Bulk actions for selected categories';
$string['categorycontents'] = 'Subcategories and courses';
$string['categorycurrentcontents'] = 'Contents of {$a}';
$string['categorydeleted'] = 'The category \'{$a}\' was deleted';
$string['categoryduplicate'] = 'A category named \'{$a}\' already exists!';
$string['categorymodifiedcancel'] = 'Category was modified! Please cancel and try again.';
$string['categoryname'] = 'Category name';
$string['categorysubcategoryof'] = '{$a->category} - subcategory of {$a->parentcategory}';
$string['idnumbercoursecategory'] = 'Category ID number';
$string['idnumbercoursecategory_help'] = 'The ID number of a course category  is only used when matching the category against external systems and is not displayed anywhere on the site. If the category has an official code name it may be entered, otherwise the field can be left blank.';
$string['categoryupdated'] = 'The category \'{$a}\' was updated';
$string['changesmadereallygoaway'] = 'You have made changes. Are you sure you want to navigate away and lose your changes?';
$string['city'] = 'City/town';
$string['clambroken'] = 'Your administrator has enabled virus checking for file uploads but has misconfigured something.<br />Your file upload was NOT successful. Your administrator has been emailed to notify them so they can fix it.<br />Maybe try uploading this file later.';
$string['clamdeletedfile'] = 'The file has been deleted';
$string['clamdeletedfilefailed'] = 'The file could not be deleted';
$string['clamemailsubject'] = '{$a} :: Clam AV notification';
$string['clamfailed'] = 'Clam AV has failed to run.  The return error message was {$a}. Here is the output from Clam:';
$string['clamlost'] = 'Moodle is configured to run clam on file upload, but the path supplied to Clam AV, {$a},  is invalid.';
$string['clamlostandactinglikevirus'] = 'In addition, Moodle is configured so that if clam fails to run, files are treated like viruses.  This essentially means that no student can upload a file successfully until you fix this.';
$string['clammovedfile'] = 'The file has been moved to your specified quarantine directory, the new location is {$a}';
$string['clammovedfilebasic'] = 'The file has been moved to a quarantine directory.';
$string['clamquarantinedirfailed'] = 'Could not move the file into your specified quarantine directory, {$a}. You need to fix this as files are being deleted if they\'re found to be infected.';
$string['clamunknownerror'] = 'There was an unknown error with clam.';
$string['cleaningtempdata'] = 'Cleaning temp data';
$string['clear'] = 'Clear';
$string['clickhelpiconformoreinfo'] = '... continues ... Click on the help icon to read the full article';
$string['clickhere'] = 'Click here ...';
$string['clicktohideshow'] = 'Click to expand or collapse';
$string['clicktochangeinbrackets'] = '{$a} (Click to change)';
$string['closewindow'] = 'Close this window';
$string['closebuttontitle'] = 'Close';
$string['collapse'] = 'Collapse';
$string['collapseall'] = 'Collapse all';
$string['collapsecategory'] = 'Collapse {$a}';
$string['commentincontext'] = 'Find this comment in context';
$string['comments'] = 'Comments';
$string['commentscount'] = 'Comments ({$a})';
$string['commentsnotenabled'] = 'Comments feature is not enabled';
$string['commentsrequirelogin'] = 'You need to log in to view the comments.';
$string['comparelanguage'] = 'Compare and edit current language';
$string['complete'] = 'Complete';
$string['completereport'] = 'Complete report';
$string['configuration'] = 'Configuration';
$string['confirm'] = 'Confirm';
$string['confirmed'] = 'Your registration has been confirmed';
$string['confirmednot'] = 'Your registration has not yet been confirmed!';
$string['confirmcheckfull'] = 'Are you absolutely sure you want to confirm {$a} ?';
$string['confirmcoursemove'] = 'Are you sure you want to move this course ({$a->course}) into this category ({$a->category})?';
$string['content'] = 'Content';
$string['continue'] = 'Continue';
$string['continuetocourse'] = 'Click here to enter your course';
$string['convertingwikitomarkdown'] = 'Converting wiki to Markdown';
$string['cookiesenabled'] = 'Cookies must be enabled in your browser';
$string['cookiesenabled_help'] = 'Two cookies are used by this site:

The essential one is the session cookie, usually called MoodleSession. You must allow this cookie into your browser to provide continuity and maintain your login from page to page. When you log out or close the browser this cookie is destroyed (in your browser and on the server).

The other cookie is purely for convenience, usually called something like MOODLEID. It just remembers your username within the browser. This means when you return to this site the username field on the login page will be already filled out for you. It is safe to refuse this cookie - you will just have to retype your username every time you log in.';
$string['cookiesnotenabled'] = 'Unfortunately, cookies are currently not enabled in your browser';
$string['copy'] = 'copy';
$string['copyasnoun'] = 'copy';
$string['copyingcoursefiles'] = 'Copying course files';
$string['copyingsitefiles'] = 'Copying site files used in course';
$string['copyinguserfiles'] = 'Copying user files';
$string['copyingzipfile'] = 'Copying zip file';
$string['copyrightnotice'] = 'Copyright notice';
$string['coresystem'] = 'System';
$string['cost'] = 'Cost';
$string['costdefault'] = 'Default cost';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Country';
$string['course'] = 'Course';
$string['courseadministration'] = 'Course administration';
$string['courseapprovedemail'] = 'Your requested course, {$a->name}, has been approved and you have been made a {$a->teacher}.  To access your new course, go to {$a->url}';
$string['courseapprovedemail2'] = 'Your requested course, {$a->name}, has been approved.  To access your new course, go to {$a->url}';
$string['courseapprovedfailed'] = 'Failed to save the course as approved!';
$string['courseapprovedsubject'] = 'Your course has been approved!';
$string['courseavailable'] = 'This course is available to students';
$string['courseavailablenot'] = 'This course is not available to students';
$string['coursebackup'] = 'Course backup';
$string['coursebulkaction'] = 'Bulk actions for selected courses';
$string['coursecategories'] = 'Course categories';
$string['coursecategory'] = 'Course category';
$string['coursecategory_help'] = 'This setting determines the category in which the course will appear in the list of courses.';
$string['coursecategorydeleted'] = 'Deleted course category {$a}';
$string['coursecatmanagement'] = 'Course and category management';
$string['coursecompletion'] = 'Course completion';
$string['coursecompletions'] = 'Course completions';
$string['coursecreators'] = 'Course creator';
$string['coursecreatorsdescription'] = 'Course creators can create new courses.';
$string['coursedisplay'] = 'Course layout';
$string['coursedisplay_help'] = 'This setting determines whether the whole course is displayed on one page or split over several pages.';
$string['coursedisplay_single'] = 'Show all sections on one page';
$string['coursedisplay_multi'] = 'Show one section per page';
$string['coursedeleted'] = 'Deleted course {$a}';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Legacy course files';
$string['coursefilesedit'] = 'Edit legacy course files';
$string['coursefileswarning'] = 'Course files are deprecated';
$string['coursefileswarning_help'] = 'Course files are deprecated since Moodle 2.0, please use external repositories instead as much as possible.';
$string['courseformatdata'] = 'Course format data';
$string['courseformats'] = 'Course formats';
$string['courseformatoptions'] = 'Formatting options for {$a}';
$string['courseformatudpate'] = 'Update format';
$string['coursegrades'] = 'Course grades';
$string['coursehelpcategory'] = 'Position the course on the course listing and may make it easier for students to find it.';
$string['coursehelpforce'] = 'Force the course group mode to every activity in the course.';
$string['coursehelpformat'] = 'The course main page will be displayed in this format.';
$string['coursehelphiddensections'] = 'How the hidden sections in the course are displayed to students.';
$string['coursehelpmaximumupload'] = 'Define the largest size of file that can be uploaded in this course, limited by the site-wide setting.';
$string['coursehelpnewsitemsnumber'] = 'Number of recent items from the news forum appearing in the latest news block on the course page. If set to zero, the latest news block will not be displayed.';
$string['coursehelpnumberweeks'] = 'Number of sections in the course (applies to certain course formats only).';
$string['coursehelpshowgrades'] = 'Enable the display of the gradebook. It does not prevent grades from being displayed within the individual activities.';
$string['coursehidden'] = 'This course is currently unavailable to students';
$string['courseoverviewfiles'] = 'Course summary files';
$string['courseoverviewfilesext'] = 'Course summary files extensions';
$string['courseoverviewfileslimit'] = 'Course summary files limit';
$string['courseoverviewfiles_help'] = 'Course summary files, such as images, are displayed in the list of courses together with the summary.';
$string['courseinfo'] = 'Course info';
$string['coursemessage'] = 'Message course users';
$string['coursenotaccessible'] = 'This course does not allow public access';
$string['courselegacyfiles'] = 'Legacy course files';
$string['courselegacyfiles_help'] = 'The course files area provides some backward compatibility with Moodle 1.9 and earlier.  All files in this area are always accessible to all participants in the course (whether you link to them or not) and there is no way to know where any of these files are being used in Moodle.

If you use this area to store course files, you can expose yourself to a number of privacy and security issues, as well as experiencing missing files in backups, course imports and any time content is shared or re-used.  It is therefore recommended that you do not use this area unless you really know what you are doing.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Legacy course files: {$a}';
$string['courseoverview'] = 'Course overview';
$string['courseoverviewgraph'] = 'Course overview graph';
$string['courseprofiles'] = 'Course profiles';
$string['coursereasonforrejecting'] = 'Your reasons for rejecting this request';
$string['coursereasonforrejectingemail'] = 'This will be emailed to the requester';
$string['coursereject'] = 'Reject a course request';
$string['courserejected'] = 'Course has been rejected and the requester has been notified.';
$string['courserejectemail'] = 'Sorry, but the course you requested has been rejected. Here is the reason provided:

{$a}';
$string['courserejectreason'] = 'Outline your reasons for rejecting this course<br />(this will be emailed to the requester)';
$string['courserejectsubject'] = 'Your course has been rejected';
$string['coursereport'] = 'Course report';
$string['coursereports'] = 'Course reports';
$string['courserequest'] = 'Course request';
$string['courserequestdetails'] = 'Details of the course you are requesting';
$string['courserequestfailed'] = 'For some reason, your course request could not be saved';
$string['courserequestintro'] = 'Use this form to request a course to be created for you.<br />Try and fill in as much information as you can to allow<br />the administrators to understand your reasons for wanting this course.';
$string['courserequestreason'] = 'Reasons for wanting this course';
$string['courserequestsuccess'] = 'Your course request has been saved successfully. You will be sent an email to inform you whether your request was approved.';
$string['courserequestsupport'] = 'Supporting information to help the administrator evaluate this request';
$string['courserestore'] = 'Course restore';
$string['courses'] = 'Courses';
$string['coursesectionsummaries'] = 'Course section summaries';
$string['coursesectiontitle'] = 'Course: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'Course default settings';
$string['coursesmovedout'] = 'Courses moved out from {$a}';
$string['coursespending'] = 'Courses pending approval';
$string['coursestart'] = 'Course start';
$string['coursesummary'] = 'Course summary';
$string['coursesummary_help'] = 'The course summary is displayed in the list of courses. A course search searches course summary text in addition to course names.';
$string['coursetitle'] = 'Course: {$a->course}';
$string['courseupdates'] = 'Course updates';
$string['create'] = 'Create';
$string['createaccount'] = 'Create my new account';
$string['createcategory'] = 'Create category';
$string['createfolder'] = 'Create a folder in {$a}';
$string['createnew'] = 'Create new';
$string['createnewcategory'] = 'Create new category';
$string['createnewcourse'] = 'Create new course';
$string['createnewsubcategory'] = 'Create new subcategory';
$string['createsubcategoryof'] = 'Create subcategory of {$a}';
$string['createuserandpass'] = 'Choose your username and password';
$string['createuser'] = 'Create user';
$string['createziparchive'] = 'Create zip archive';
$string['creatingblocks'] = 'Creating blocks';
$string['creatingblocksroles'] = 'Creating block level role assignments and overrides';
$string['creatingblogsinfo'] = 'Creating blogs info';
$string['creatingcategoriesandquestions'] = 'Creating categories and questions';
$string['creatingcoursemodules'] = 'Creating course modules';
$string['creatingcourseroles'] = 'Creating course level role assignments and overrides';
$string['creatingevents'] = 'Creating events';
$string['creatinggradebook'] = 'Creating gradebook';
$string['creatinggroupings'] = 'Creating groupings';
$string['creatinggroupingsgroups'] = 'Adding groups into groupings';
$string['creatinggroups'] = 'Creating groups';
$string['creatinglogentries'] = 'Creating log entries';
$string['creatingmessagesinfo'] = 'Creating messages info';
$string['creatingmodroles'] = 'Creating module level role assignments and overrides';
$string['creatingnewcourse'] = 'Creating new course';
$string['creatingrolesdefinitions'] = 'Creating roles definitions';
$string['creatingscales'] = 'Creating scales';
$string['creatingsections'] = 'Creating sections';
$string['creatingtemporarystructures'] = 'Creating temporary structures';
$string['creatinguserroles'] = 'Creating user level role assignments and overrides';
$string['creatingusers'] = 'Creating users';
$string['creatingxmlfile'] = 'Creating XML file';
$string['currency'] = 'Currency';
$string['currentcourse'] = 'Current course';
$string['currentcourseadding'] = 'Current course, adding data to it';
$string['currentcoursedeleting'] = 'Current course, deleting it first';
$string['currentlanguage'] = 'Current language';
$string['currentlocaltime'] = 'your current local time';
$string['currentlyselectedusers'] = 'Currently selected users';
$string['currentpicture'] = 'Current picture';
$string['currentrelease'] = 'Current release information';
$string['currentversion'] = 'Current version';
$string['databasechecking'] = 'Upgrading Moodle database from version {$a->oldversion} to {$a->newversion}';
$string['databaseperformance'] = 'Database performance';
$string['databasesetup'] = 'Setting up database';
$string['databasesuccess'] = 'Database was successfully upgraded';
$string['databaseupgradebackups'] = 'Backup version is now {$a}';
$string['databaseupgradeblocks'] = 'Blocks version is now {$a}';
$string['databaseupgradegroups'] = 'Groups version is now {$a}';
$string['databaseupgradelocal'] = 'Local database customisations version is now {$a}';
$string['databaseupgrades'] = 'Upgrading database';
$string['date'] = 'Date';
$string['datechanged'] = 'Date changed';
$string['datemostrecentfirst'] = 'Date - most recent first';
$string['datemostrecentlast'] = 'Date - most recent last';
$string['day'] = 'day';
$string['days'] = 'days';
$string['decodinginternallinks'] = 'Decoding internal links';
$string['default'] = 'Default';
$string['defaulteditor'] = 'Default editor';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Students generally have fewer privileges within a course.';
$string['defaultcoursestudents'] = 'Students';
$string['defaultcoursesummary'] = 'Write a concise and interesting paragraph here that explains what this course is about';
$string['defaultcourseteacher'] = 'Teacher';
$string['defaultcourseteacherdescription'] = 'Teachers can do anything within a course, including changing the activities and grading students.';
$string['defaultcourseteachers'] = 'Teachers';
$string['delete'] = 'Delete';
$string['deleteablock'] = 'Delete a block';
$string['deleteall'] = 'Delete all';
$string['deleteallcannotundo'] = 'Delete all - cannot be undone';
$string['deleteallcomments'] = 'Delete all comments';
$string['deleteallratings'] = 'Delete all ratings';
$string['deletecategory'] = 'Delete category: {$a}';
$string['deletecategoryempty'] = 'This category is empty.';
$string['deletecategorycheck'] = 'Are you absolutely sure you want to completely delete this category <b>\'{$a}\'</b>?<br />This will move all courses into the parent category if there is one, or into Miscellaneous.';
$string['deletecategorycheck2'] = 'If you delete this category, you need to choose what to do with the courses and subcategories it contains.';
$string['deletecomment'] = 'Delete this comment';
$string['deletecompletely'] = 'Delete completely';
$string['deletecourse'] = 'Delete a course';
$string['deletecoursecheck'] = 'Are you absolutely sure you want to completely delete this course and all the data it contains?';
$string['deleted'] = 'Deleted';
$string['deletedactivity'] = 'Deleted {$a}';
$string['deletedcourse'] = '{$a} has been completely deleted';
$string['deletednot'] = 'Could not delete {$a} !';
$string['deletecheck'] = 'Delete {$a} ?';
$string['deletechecktype'] = 'Are you sure that you want to delete this {$a->type}?';
$string['deletechecktypename'] = 'Are you sure that you want to delete the {$a->type} "{$a->name}"?';
$string['deletecheckfiles'] = 'Are you absolutely sure you want to delete these files?';
$string['deletecheckfull'] = 'Are you absolutely sure you want to completely delete the user {$a}, including their enrolments, activity and other user data?';
$string['deletecheckwarning'] = 'You are about to delete these files';
$string['deleteselected'] = 'Delete selected';
$string['deleteselectedkey'] = 'Delete selected key';
$string['deletingcourse'] = 'Deleting {$a}';
$string['deletingexistingcoursedata'] = 'Deleting existing course data';
$string['deletingolddata'] = 'Deleting old data';
$string['department'] = 'Department';
$string['desc'] = 'Descending';
$string['description'] = 'Description';
$string['deselectall'] = 'Deselect all';
$string['detailedless'] = 'Less detailed';
$string['detailedmore'] = 'More detailed';
$string['directory'] = 'Directory';
$string['disable'] = 'Disable';
$string['disabledcomments'] = 'Comments are disabled';
$string['displayingfirst'] = 'Only the first {$a->count} {$a->things} are displayed';
$string['displayingrecords'] = 'Displaying {$a} records';
$string['displayingusers'] = 'Displaying users {$a->start} to {$a->end}';
$string['displayonpage'] = 'Display on page';
$string['dndcourse'] = 'You can drag and drop this course to alter its sorting or to move it to another category.';
$string['dndenabled_inbox'] = 'You can drag and drop files here to add them.';
$string['dndnotsupported'] = 'Drag and drop upload not supported';
$string['dndnotsupported_help'] = 'Your browser does not support drag and drop upload.<br />This feature is available in all recent versions of Chrome, Firefox and Safari, as well as Internet Explorer v10 and above.';
$string['dndnotsupported_insentence'] = 'drag and drop not supported';
$string['dnduploadwithoutcontent'] = 'This upload does not have any content';
$string['dndworkingfiletextlink'] = 'Drag and drop files, text or links onto course sections to upload them';
$string['dndworkingfilelink'] = 'Drag and drop files or links onto course sections to upload them';
$string['dndworkingfiletext'] = 'Drag and drop files or text onto course sections to upload them';
$string['dndworkingfile'] = 'Drag and drop files onto course sections to upload them';
$string['dndworkingtextlink'] = 'Drag and drop text or links onto course sections to upload them';
$string['dndworkingtext'] = 'Drag and drop text onto course sections to upload it';
$string['dndworkinglink'] = 'Drag and drop links onto course sections to upload them';
$string['documentation'] = 'Moodle documentation';
$string['dontsortcategories'] = 'Don\'t sort categories';
$string['dontsortcourses'] = 'Don\'t sort courses';
$string['down'] = 'Down';
$string['download'] = 'Download';
$string['downloadall'] = 'Download all';
$string['downloadexcel'] = 'Download in Excel format';
$string['downloadfile'] = 'Download file';
$string['downloadods'] = 'Download in ODS format';
$string['downloadtext'] = 'Download in text format';
$string['doyouagree'] = 'Have you read these conditions and understood them?';
$string['droptoupload'] = 'Drop files here to upload';
$string['duplicate'] = 'Duplicate';
$string['edhelpaspellpath'] = 'To use spell-checking within the editor, you MUST have <strong>aspell 0.50</strong> or later installed on your server, and you must specify the correct path to access the aspell binary.  On Unix/Linux systems, this path is usually <strong>/usr/bin/aspell</strong>, but it might be something else.';
$string['edhelpbgcolor'] = 'Define the edit area\'s background color.<br />Valid values are, for example: #FFFFFF or white';
$string['edhelpcleanword'] = 'This setting enables or disables Word-specific format filtering.';
$string['edhelpenablespelling'] = 'Enable or disable spell-checking. When enabled, <strong>aspell</strong> must be installed on the server. The second value is the <strong>default dictionary</strong>. This value will be used if aspell doesn\'t have dictionary for users own language.';
$string['edhelpfontfamily'] = 'The font-family property is a list of font family names and/or generic family names. Family names must be separated with comma.';
$string['edhelpfontlist'] = 'Define the fonts used on editors dropdown menu.';
$string['edhelpfontsize'] = 'The default font-size sets the size of a font. <br />Valid values are for example: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Edit';
$string['edita'] = 'Edit {$a}';
$string['editcategorysettings'] = 'Edit category settings';
$string['editcategorythis'] = 'Edit this category';
$string['editcoursesettings'] = 'Edit course settings';
$string['editsettings'] = 'Edit settings';
$string['editfiles'] = 'Edit files';
$string['editgroupprofile'] = 'Edit group profile';
$string['editinga'] = 'Editing {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'This value cannot be edited!';
$string['editmyprofile'] = 'Edit profile';
$string['editorbgcolor'] = 'Background-color';
$string['editorcleanonpaste'] = 'Clean Word HTML on paste';
$string['editorcommonsettings'] = 'Common settings';
$string['editordefaultfont'] = 'Default font';
$string['editorenablespelling'] = 'Enable spellchecking';
$string['editorfontlist'] = 'Fontlist';
$string['editorfontsize'] = 'Default font-size';
$string['editorresettodefaults'] = 'Reset to default values';
$string['editorsettings'] = 'Editor settings';
$string['editorshortcutkeys'] = 'Editor shortcut keys';
$string['editsettings'] = 'Edit settings';
$string['editsummary'] = 'Edit summary';
$string['edittitle'] = 'Edit title';
$string['edittitleinstructions'] = 'Escape to cancel, Enter when finished';
$string['editthisactivity'] = 'Edit this activity';
$string['editthiscategory'] = 'Edit this category';
$string['edituser'] = 'Edit user accounts';
$string['edulevelother'] = 'Other';
$string['edulevelteacher'] = 'Teaching';
$string['edulevelparticipating'] = 'Participating';
$string['edulevel'] = 'Educational level';
$string['email'] = 'Email address';
$string['emailalreadysent'] = 'A password reset email has already been sent. Please check your email.';
$string['emailactive'] = 'Email activated';
$string['emailagain'] = 'Email (again)';
$string['emailconfirm'] = 'Confirm your account';
$string['emailconfirmation'] = 'Hi {$a->firstname},

A new account has been requested at \'{$a->sitename}\'
using your email address.

To confirm your new account, please go to this web address:

{$a->link}

In most mail programs, this should appear as a blue link
which you can just click on.  If that doesn\'t work,
then cut and paste the address into the address
line at the top of your web browser window.

If you need help, please contact the site administrator,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: account confirmation';
$string['emailconfirmsent'] = '<p>An email should have been sent to your address at <b>{$a}</b></p>
   <p>It contains easy instructions to complete your registration.</p>
   <p>If you continue to have difficulty, contact the site administrator.</p>';
$string['emaildigest'] = 'Email digest type';
$string['emaildigest_help'] = 'This is the daily digest setting that forums will use by default.

* No digest - you will receive one e-mail per forum post;
* Digest - complete posts - you will receive one digest e-mail per day containing the complete contents of each forum post;
* Digest - subjects only - you will receive one digest e-mail per day containing just the subject of each forum post.

You can also choose a different setting for each forum if you wish.';
$string['emaildigestcomplete'] = 'Complete (daily email with full posts)';
$string['emaildigestoff'] = 'No digest (single email per forum post)';
$string['emaildigestsubjects'] = 'Subjects (daily email with subjects only)';
$string['emaildisable'] = 'This email address is disabled';
$string['emaildisableclick'] = 'Click here to disable all email from being sent to this address';
$string['emaildisplay'] = 'Email display';
$string['emaildisplaycourse'] = 'Allow only other course members to see my email address';
$string['emaildisplayhidden'] = 'Email hidden';
$string['emaildisplayno'] = 'Hide my email address from everyone';
$string['emaildisplayyes'] = 'Allow everyone to see my email address';
$string['emailenable'] = 'This email address is enabled';
$string['emailenableclick'] = 'Click here to re-enable all email being sent to this address';
$string['emailexists'] = 'This email address is already registered.';
$string['emailformat'] = 'Email format';
$string['emailcharset'] = 'Email charset';
$string['emailmustbereal'] = 'Note: your email address must be a real one';
$string['emailnotallowed'] = 'Email addresses in these domains are not allowed ({$a})';
$string['emailnotfound'] = 'The email address was not found in the database';
$string['emailonlyallowed'] = 'This email is not one of those that are allowed ({$a})';
$string['emailpasswordconfirmation'] = 'Hi {$a->firstname},

Someone (probably you) has requested a new password for your
account on \'{$a->sitename}\'.

To confirm this and have a new password sent to you via email,
go to the following web address:

{$a->link}

In most mail programs, this should appear as a blue link
which you can just click on.  If that doesn\'t work,
then cut and paste the address into the address
line at the top of your web browser window.

If you need help, please contact the site administrator,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Change password confirmation';
$string['emailpasswordconfirmmaybesent'] = '<p>If you supplied a correct username or email address then an email should have been sent to you.</p>
   <p>It contains easy instructions to confirm and complete this password change.
If you continue to have difficulty, please contact the site administrator.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>The user account you specified does not have a recorded email address.</p>
   <p>Please contact the site administrator.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>The user detail you supplied does not identify an existing user account.</p>
   <p>Please check the information you entered, then try again.
If you continue to have difficulty, please contact the site administrator.</p>';
$string['emailpasswordconfirmsent'] = 'An email should have been sent to your address at <b>{$a}</b>.
<br />It contains easy instructions to confirm and complete this password change.
If you continue to have difficulty, contact the site administrator.';
$string['emailpasswordchangeinfo'] = 'Hi {$a->firstname},

Someone (probably you) has requested a new password for your
account on \'{$a->sitename}\'.

To change your password, please go to the following web address:

{$a->link}

In most mail programs, this should appear as a blue link
which you can just click on.  If that doesn\'t work,
then cut and paste the address into the address
line at the top of your web browser window.

If you need help, please contact the site administrator,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hi {$a->firstname},

Someone (probably you) has requested a new password for your
account on \'{$a->sitename}\'.

Unfortunately your account on this site is disabled and can not be reset,
please contact the site administrator,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hi {$a->firstname},

Someone (probably you) has requested a new password for your
account on \'{$a->sitename}\'.

Unfortunately passwords can not be reset on this site,
please contact the site administrator,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Change password information';
$string['emailpasswordsent'] = 'Thank you for confirming the change of password.
An email containing your new password has been sent to your address at<br /><b>{$a->email}</b>.<br />
The new password was automatically generated - you might like to
<a href="{$a->link}">change your password</a> to something easier to remember.';
$string['emailresetconfirmation'] = 'Hi {$a->firstname},

A password reset was requested for your account \'{$a->username}\' at {$a->sitename}.

To confirm this request, and set a new password for your account, please
go to the following web address:

{$a->link}
(This link is valid for {$a->resetminutes} minutes from the time this reset was first requested)

If this password reset was not requested by you, no action is needed.

If you need help, please contact the site administrator,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Password reset request';
$string['emailresetconfirmsent'] = 'An email has been sent to your address at <b>{$a}</b>.
<br />It contains easy instructions to confirm and complete this password change.
If you continue to have difficulty, contact the site administrator.';
$string['emailtoprivatefiles'] = 'You can also e-mail files as attachments straight to your private files space. Simply attach your files to an e-mail and send it to {$a}';
$string['emailtoprivatefilesdenied'] = 'Your administrator has disabled the option to upload your own private files.';
$string['emptydragdropregion'] = 'empty region';
$string['enable'] = 'Enable';
$string['encryptedcode'] = 'Encrypted code';
$string['english'] = 'English';
$string['enrolmentmethods'] = 'Enrolment methods';
$string['entercourse'] = 'Click to enter this course';
$string['enteremail'] = 'Enter your email address';
$string['enteremailaddress'] = 'Enter in your email address to reset your
   password and have the new password sent to you via email.';
$string['enterusername'] = 'Enter your username';
$string['entries'] = 'Entries';
$string['error'] = 'Error';
$string['errorcreatingactivity'] = 'Unable to create an instance of activity \'{$a}\'';
$string['errorfiletoobig'] = 'The file was bigger than the limit of {$a} bytes';
$string['errornouploadrepo'] = 'There is no upload repository enabled for this site';
$string['errorwhenconfirming'] = 'You are not confirmed yet because an error occurred.  If you clicked on a link in an email to get here, make sure that the line in your email wasn\'t broken or wrapped. You may have to use cut and paste to reconstruct the link properly.';
$string['eventcommentcreated'] = 'Comment created';
$string['eventcommentdeleted'] = 'Comment deleted';
$string['eventcommentsviewed'] = 'Comments viewed';
$string['eventcoursecategorycreated'] = 'Category created';
$string['eventcoursecategorydeleted'] = 'Category deleted';
$string['eventcoursecategoryupdated'] = 'Category updated';
$string['eventcoursecontentdeleted'] = 'Course content deleted';
$string['eventcoursecreated'] = 'Course created';
$string['eventcoursedeleted'] = 'Course deleted';
$string['eventcoursemodulecreated'] = 'Course module created';
$string['eventcoursemoduledeleted'] = 'Course module deleted';
$string['eventcoursemoduleupdated'] = 'Course module updated';
$string['eventcoursemoduleviewed'] = 'Course module viewed';
$string['eventcourseresetended'] = 'Course reset ended';
$string['eventcourseresetstarted'] = 'Course reset started';
$string['eventcourserestored'] = 'Course restored';
$string['eventcourseupdated'] = 'Course updated';
$string['eventcoursesectionupdated'] = 'Course section updated';
$string['eventcoursemoduleinstancelistviewed'] = 'Course module instance list viewed';
$string['eventcourseuserreportviewed'] = 'Course user report viewed';
$string['eventcourseviewed'] = 'Course viewed';
$string['eventemailfailed'] = 'Email failed to send';
$string['eventname'] = 'Event name';
$string['eventrecentactivityviewed'] = 'Recent activity viewed';
$string['eventunknownlogged'] = 'Unknown event';
$string['eventusercreated'] = 'User created';
$string['eventuserdeleted'] = 'User deleted';
$string['eventuserlistviewed'] = 'User list viewed';
$string['eventuserloggedout'] = 'User logged out';
$string['eventuserpasswordupdated'] = 'User password updated';
$string['eventuserprofileviewed'] = 'User profile viewed';
$string['eventuserupdated'] = 'User updated';
$string['everybody'] = 'Everybody';
$string['executeat'] = 'Execute at';
$string['existing'] = 'Existing';
$string['existingadmins'] = 'Existing admins';
$string['existingcourse'] = 'Existing course';
$string['existingcourseadding'] = 'Existing course, adding data to it';
$string['existingcoursedeleting'] = 'Existing course, deleting it first';
$string['existingcreators'] = 'Existing course creators';
$string['existingstudents'] = 'Enrolled students';
$string['existingteachers'] = 'Existing teachers';
$string['expand'] = 'Expand';
$string['expandall'] = 'Expand all';
$string['expandcategory'] = 'Expand {$a}';
$string['explanation'] = 'Explanation';
$string['extendenrol'] = 'Extend enrolment (individual)';
$string['extendperiod'] = 'Extended period';
$string['failedloginattempts'] = '{$a->attempts} failed logins since your last login';
$string['feedback'] = 'Feedback';
$string['file'] = 'File';
$string['fileexists'] = 'There is already a file called {$a}';
$string['filemissing'] = '{$a} is missing';
$string['filetoolarge'] = 'is too large to upload';
$string['files'] = 'Files';
$string['filesanduploads'] = 'Files and uploads';
$string['filesfolders'] = 'Files/folders';
$string['fileuploadwithcontent'] = 'File uploads should not include the content parameter';
$string['filloutallfields'] = 'Please fill out all fields in this form';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Find more courses...';
$string['first'] = 'First';
$string['firstaccess'] = 'First access';
$string['firstname'] = 'First name';
$string['firstnamephonetic'] = 'First name - phonetic';
$string['firstsiteaccess'] = 'First access to site';
$string['firsttime'] = 'Is this your first time here?';
$string['folder'] = 'Folder';
$string['folderclosed'] = 'Closed folder';
$string['folderopened'] = 'Opened folder';
$string['followingoptional'] = 'The following items are optional';
$string['followingrequired'] = 'The following items are required';
$string['for'] = 'For';
$string['force'] = 'Force';
$string['forcelanguage'] = 'Force language';
$string['forceno'] = 'Do not force';
$string['forcepasswordchange'] = 'Force password change';
$string['forcepasswordchange_help'] = 'If this checkbox is ticked, the user will be prompted to change their password on their next login';
$string['forcepasswordchangecheckfull'] = 'Are you absolutely sure you want to force a password change to {$a} ?';
$string['forcepasswordchangenot'] = 'Could not force a password change to {$a}';
$string['forcepasswordchangenotice'] = 'You must change your password to proceed.';
$string['forcetheme'] = 'Force theme';
$string['forgotaccount'] = 'Lost password?';
$string['forgotten'] = 'Forgotten your username or password?';
$string['forgottenduplicate'] = 'The email address is shared by several accounts, please enter username instead';
$string['forgotteninvalidurl'] = 'Invalid password reset URL';
$string['format'] = 'Format';
$string['format_help'] = 'The course format determines the layout of the course page.

* Single activity format - For displaying a single activity or resource (such as a Quiz or SCORM package) on the course page
* Social format - A forum is displayed on the course page
* Topics format - The course page is organised into topic sections
* Weekly format - The course page is organised into weekly sections, with the first week starting on the course start date';
$string['formathtml'] = 'HTML format';
$string['formatmarkdown'] = 'Markdown format';
$string['formatplain'] = 'Plain text format';
$string['formattext'] = 'Moodle auto-format';
$string['formattexttype'] = 'Formatting';
$string['framesetinfo'] = 'This frameset document contains:';
$string['from'] = 'From';
$string['frontpagecategorycombo'] = 'Combo list';
$string['frontpagecategorynames'] = 'List of categories';
$string['frontpagecourselist'] = 'List of courses';
$string['frontpagecoursesearch'] = 'Course search box';
$string['frontpageenrolledcourselist'] = 'Enrolled courses';
$string['frontpagedescription'] = 'Front page summary';
$string['frontpagedescriptionhelp'] = 'This summary can be displayed on the front page using the course/site summary block.';
$string['frontpageformat'] = 'Front page format';
$string['frontpageformatloggedin'] = 'Front page format when logged in';
$string['frontpagenews'] = 'News items';
$string['frontpagesettings'] = 'Front page settings';
$string['fulllistofcourses'] = 'All courses';
$string['fullname'] = 'Full name'; // @deprecated - use fullnamecourse or fullnameuser or some own context specific string
$string['fullnamecourse'] = 'Course full name';
$string['fullnamecourse_help'] = 'The full name of the course is displayed at the top of each page in the course and in the list of courses.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'User full name';
$string['fullprofile'] = 'Full profile';
$string['fullsitename'] = 'Full site name';
$string['functiondisabled'] = 'That functionality is currently disabled';
$string['general'] = 'General';
$string['geolocation'] = 'latitude - longitude';
$string['gettheselogs'] = 'Get these logs';
$string['go'] = 'Go';
$string['gpl'] = 'Copyright (C) 1999 onwards  Martin Dougiamas  (http://moodle.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the Moodle License information page for full details:
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL license';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the Moodle License information page for full details:
http://docs.moodle.org/dev/License';
$string['grade'] = 'Grade';
$string['grades'] = 'Grades';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> has been enabled for this site. If you don\'t upload a profile picture Moodle will attempt to load a profile picture for you from Gravatar.';
$string['group'] = 'Group';
$string['groupadd'] = 'Add new group';
$string['groupaddusers'] = 'Add selected to group';
$string['groupextendenrol'] = 'Extend enrolment (common)';
$string['groupfor'] = 'for group';
$string['groupinfo'] = 'Info about selected group';
$string['groupinfoedit'] = 'Edit group settings';
$string['groupinfomembers'] = 'Info about selected members';
$string['groupinfopeople'] = 'Info about selected people';
$string['groupmembers'] = 'Group members';
$string['groupmemberssee'] = 'See group members';
$string['groupmembersselected'] = 'Members of selected group';
$string['groupmode'] = 'Group mode';
$string['groupmodeforce'] = 'Force group mode';
$string['groupmy'] = 'My group';
$string['groupnonmembers'] = 'People not in a group';
$string['groupnotamember'] = 'Sorry, you are not a member of that group';
$string['grouprandomassign'] = 'Randomly assign all to groups';
$string['groupremove'] = 'Remove selected group';
$string['groupremovemembers'] = 'Remove selected members';
$string['groups'] = 'Groups';
$string['groupsnone'] = 'No groups';
$string['groupsseparate'] = 'Separate groups';
$string['groupsvisible'] = 'Visible groups';
$string['guest'] = 'Guest';
$string['guestdescription'] = 'Guests have minimal privileges and usually can not enter text anywhere.';
$string['guestskey'] = 'Allow guests who have the key';
$string['guestsno'] = 'Do not allow guests in';
$string['guestsnotallowed'] = 'Sorry, \'{$a}\' does not allow guests to enter.';
$string['guestsyes'] = 'Allow guests without the key';
$string['guestuser'] = 'Guest user';
$string['guestuserinfo'] = 'This user is a special user that allows read-only access to some courses.';
$string['help'] = 'Help';
$string['helpprefix2'] = 'Help with {$a}';
$string['helpwiththis'] = 'Help with this';
$string['hiddenassign'] = 'Hidden assignment';
$string['hiddenfromstudents'] = 'Hidden from students';
$string['hiddensections'] = 'Hidden sections';
$string['hiddensections_help'] = 'This setting determines whether hidden sections are displayed to students in collapsed form (perhaps for a course in weekly format to indicate holidays) or are completely hidden.';
$string['hiddensectionscollapsed'] = 'Hidden sections are shown in collapsed form';
$string['hiddensectionsinvisible'] = 'Hidden sections are completely invisible';
$string['hide'] = 'Hide';
$string['hideadvancedsettings'] = 'Hide advanced settings';
$string['hidepicture'] = 'Hide picture';
$string['hidesection'] = 'Hide section {$a}';
$string['hidesettings'] = 'Hide settings';
$string['hideshowblocks'] = 'Hide or show blocks';
$string['hits'] = 'Hits';
$string['hitsoncourse'] = 'Hits on {$a->coursename} by {$a->username}';
$string['hitsoncoursetoday'] = 'Today\'s hits on {$a->coursename} by {$a->username}';
$string['home'] = 'Home';
$string['hour'] = 'hour';
$string['hours'] = 'hours';
$string['howtomakethemes'] = 'How to make new themes';
$string['htmleditor'] = 'Use HTML editor';
$string['htmleditoravailable'] = 'The HTML editor is available';
$string['htmleditordisabled'] = 'You have disabled the HTML editor in your user profile';
$string['htmleditordisabledadmin'] = 'The administrator has disabled the HTML editor on this site';
$string['htmleditordisabledbrowser'] = 'The HTML editor is unavailable because your web browser is not compatible';
$string['htmlfilesonly'] = 'HTML files only';
$string['htmlformat'] = 'Pretty HTML format';
$string['changedpassword'] = 'Changed password';
$string['changepassword'] = 'Change password';
$string['changessaved'] = 'Changes saved';
$string['check'] = 'Check';
$string['checkall'] = 'Check all';
$string['checkingbackup'] = 'Checking backup';
$string['checkingcourse'] = 'Checking course';
$string['checkingforbbexport'] = 'Checking for BlackBoard export';
$string['checkinginstances'] = 'Checking instances';
$string['checkingsections'] = 'Checking sections';
$string['checklanguage'] = 'Check language';
$string['checknone'] = 'Check none';
$string['childcoursenotfound'] = 'Child course not found!';
$string['childcourses'] = 'Child courses';
$string['choose'] = 'Choose';
$string['choosecourse'] = 'Choose a course';
$string['choosedots'] = 'Choose...';
$string['chooselivelogs'] = 'Or watch current activity';
$string['chooselogs'] = 'Choose which logs you want to see';
$string['choosereportfilter'] = 'Choose a filter for the report';
$string['choosetheme'] = 'Choose theme';
$string['chooseuser'] = 'Choose a user';
$string['eventcontentviewed'] = 'Content viewed';
$string['icqnumber'] = 'ICQ number';
$string['icon'] = 'Icon';
$string['idnumber'] = 'ID number';
$string['idnumbercourse'] = 'Course ID number';
$string['idnumbercourse_help'] = 'The ID number of a course is only used when matching the course against external systems and is not displayed anywhere on the site. If the course has an official code name it may be entered, otherwise the field can be left blank.';
$string['idnumbergroup'] = 'Group ID number';
$string['idnumbergroup_help'] = 'The ID number of a group is only used when matching the group against external systems and is not displayed anywhere on the site. If the group has an official code name it may be entered, otherwise the field can be left blank.';
$string['idnumbergrouping'] = 'Grouping ID number';
$string['idnumbergrouping_help'] = 'The ID number of a grouping is only used when matching the grouping against external systems and is not displayed anywhere on the site. If the grouping has an official code name it may be entered, otherwise the field can be left blank.';
$string['idnumbermod'] = 'ID number';
$string['idnumbermod_help'] = 'Setting an ID number provides a way of identifying the activity for grade calculation purposes. If the activity is not included in any grade calculation then the ID number field may be left blank.

The ID number can also be set in the gradebook, though it can only be edited on the activity settings page.';
$string['idnumbertaken'] = 'This ID number is already taken';
$string['imagealt'] = 'Picture description';
$string['import'] = 'Import';
$string['importdata'] = 'Import course data';
$string['importdataexported'] = 'Exported data from \'from\' course successfully.<br /> Continue to import into your \'to\' course.';
$string['importdatafinished'] = 'Import complete! Continue to your course';
$string['importdatafrom'] = 'Find a course to import data from:';
$string['inactive'] = 'Inactive';
$string['include'] = 'Include';
$string['includeallusers'] = 'Include all users';
$string['includecoursefiles'] = 'Include course files';
$string['includecourseusers'] = 'Include course users';
$string['included'] = 'Included';
$string['includelogentries'] = 'Include log entries';
$string['includemodules'] = 'Include modules';
$string['includemoduleuserdata'] = 'Include module user data';
$string['includeneededusers'] = 'Include needed users';
$string['includenoneusers'] = 'Include no users';
$string['includeroleassignments'] = 'Include role assignments';
$string['includesitefiles'] = 'Include site files used in this course';
$string['includeuserfiles'] = 'Include user files';
$string['increasesections'] = 'Increase the number of sections';
$string['info'] = 'Information';
$string['institution'] = 'Institution';
$string['instudentview'] = 'in student view';
$string['interests'] = 'Interests';
$string['interestslist'] = 'List of interests';
$string['interestslist_help'] = 'Enter your interests separated by commas. Your interests will be displayed on your profile page as tags.';
$string['invalidemail'] = 'Invalid email address';
$string['invalidlogin'] = 'Invalid login, please try again';
$string['invalidusername'] = 'The username can only contain alphanumeric lowercase characters, underscore (_), hyphen (-), period (.) or at symbol (@)';
$string['invalidusernameupload'] = 'Invalid username';
$string['ip_address'] = 'IP address';
$string['jump'] = 'Jump';
$string['jumpto'] = 'Jump to...';
$string['keep'] = 'Keep';
$string['keepsearching'] = 'Keep searching';
$string['langltr'] = 'Language direction left-to-right';
$string['langrtl'] = 'Language direction right-to-left';
$string['language'] = 'Language';
$string['languagegood'] = 'This language pack is up-to-date! :-)';
$string['last'] = 'Last';
$string['lastaccess'] = 'Last access';
$string['lastcourseaccess'] = 'Last access to course';
$string['lastedited'] = 'Last edited';
$string['lastip'] = 'Last IP address';
$string['lastlogin'] = 'Last login';
$string['lastmodified'] = 'Last modified';
$string['lastname'] = 'Surname';
$string['lastnamephonetic'] = 'Surname - phonetic';
$string['lastsiteaccess'] = 'Last access to site';
$string['lastyear'] = 'Last year';
$string['latestlanguagepack'] = 'Check for latest language pack on moodle.org';
$string['layouttable'] = 'Layout table';
$string['leavetokeep'] = 'Leave blank to keep current password';
$string['legacythemeinuse'] = 'This site is being displayed to you in compatibility mode because your browser is too old.';
$string['license'] = 'Licence';
$string['licenses'] = 'Licences';
$string['liketologin'] = 'Would you like to log in now with a full user account?';
$string['list'] = 'List';
$string['listfiles'] = 'List of files in {$a}';
$string['listofallpeople'] = 'List of all people';
$string['listofcourses'] = 'List of courses';
$string['loadinghelp'] = 'Loading...';
$string['local'] = 'Local';
$string['localplugins'] = 'Local plugins';
$string['localpluginsmanage'] = 'Manage local plugins';
$string['location'] = 'Location';
$string['locktimeout'] = 'The operation timed out while waiting for a lock.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'You are logged in as {$a}';
$string['loggedinasguest'] = 'You are currently using guest access';
$string['loggedinnot'] = 'You are not logged in.';
$string['login'] = 'Log in';
$string['loginalready'] = 'You are already logged in';
$string['loginas'] = 'Log in as';
$string['loginaspasswordexplain'] = '<p>You must enter the special "loginas password" to use this feature.<br />If you do not know it, ask your server administrator.</p>';
$string['login_failure_logs'] = 'Login failure logs';
$string['loginguest'] = 'Log in as a guest';
$string['loginsite'] = 'Log in to the site';
$string['loginsteps'] = 'Hi! For full access to courses you\'ll need to take
   a minute to create a new account for yourself on this web site.
   Each of the individual courses may also have a one-time
   "enrolment key", which you won\'t need until later. Here are
   the steps:
   <ol>
   <li>Fill out the <a href="{$a}">New Account</a> form with your details.</li>
   <li>An email will be immediately sent to your email address.</li>
   <li>Read your email, and click on the web link it contains.</li>
   <li>Your account will be confirmed and you will be logged in.</li>
   <li>Now, select the course you want to participate in.</li>
   <li>If you are prompted for an "enrolment key" - use the one
   that your teacher has given you. This will "enrol" you in the
   course.</li>
   <li>You can now access the full course. From now on you will only need
   to enter your personal username and password (in the form on this page)
   to log in and access any course you have enrolled in.</li>
   </ol>';
$string['loginstepsnone'] = '<p>Hi!</p>
<p>For full access to courses you\'ll need to create yourself an account.</p>
<p>All you need to do is make up a username and password and use it in the form on this page!</p>
<p>If someone else has already chosen your username then you\'ll have to try again using a different username.</p>';
$string['loginto'] = 'Log in to {$a}';
$string['logout'] = 'Log out';
$string['logoutconfirm'] = 'Do you really want to log out?';
$string['logs'] = 'Logs';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">more</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">more</a> ]';
$string['lookback'] = 'Look back';
$string['mailadmins'] = 'Inform admins';
$string['mailstudents'] = 'Inform students';
$string['mailteachers'] = 'Inform teachers';
$string['maincoursepage'] = 'Main course page';
$string['makeafolder'] = 'Create folder';
$string['makeeditable'] = 'If you make \'{$a}\' editable by the web server process (eg apache) then you could edit this file directly from this page';
$string['makethismyhome'] = 'Make this my default home page';
$string['manageblocks'] = 'Blocks';
$string['managecategorythis'] = 'Manage this category';
$string['managecourses'] = 'Manage courses';
$string['managedatabase'] = 'Database';
$string['manageeditorfiles'] = 'Manage files used by editor';
$string['managefilters'] = 'Filters';
$string['managemodules'] = 'Modules';
$string['manageroles'] = 'Roles and permissions';
$string['markedthistopic'] = 'This topic is highlighted as the current topic';
$string['markthistopic'] = 'Highlight this topic as the current topic';
$string['matchingsearchandrole'] = 'Matching \'{$a->search}\' and {$a->role}';
$string['maxareabytesreached'] = 'The file (or the total size of several files) is larger than the space remaining in this area.';
$string['maxbytesforfile'] = 'The file {$a} is larger than the maximum size allowed.';
$string['maxfilesize'] = 'Maximum size for new files: {$a}';
$string['maxfilesreached'] = 'You are allowed to attach a maximum of {$a} file(s) to this item';
$string['maximumchars'] = 'Maximum of {$a} characters';
$string['maximumgrade'] = 'Maximum grade';
$string['maximumgradex'] = 'Maximum grade: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Maximum upload size';
$string['maximumupload_help'] = 'This setting determines the largest size of file that can be uploaded to the course, limited by the site-wide setting set by an administrator. Activity modules also include a maximum upload size setting for further restricting the file size.';
$string['maxnumberweeks'] = 'Maximum number of sections';
$string['maxnumberweeks_desc'] = 'The maximum value in the number of sections dropdown menu (applies to certain course formats only).';
$string['maxnumcoursesincombo'] = 'Browse <a href="{$a->link}">{$a->numberofcourses} courses</a>.';
$string['maxsize'] = 'Max size: {$a}';
$string['maxsizeandareasize'] = 'Maximum size for new files: {$a->size}, overall limit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maximum size for new files: {$a->size}, maximum attachments: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maximum size for new files: {$a->size}, maximum attachments: {$a->attachments}, overall limit: {$a->areasize}';
$string['memberincourse'] = 'People in the course';
$string['messagebody'] = 'Message body';
$string['messagedselectedusers'] = 'Selected users have been messaged and the recipient list has been reset.';
$string['messagedselectedusersfailed'] = 'Something went wrong while messaging selected users.  Some may have received the email.';
$string['messageprovider:availableupdate'] = 'Available update notifications';
$string['messageprovider:backup'] = 'Backup notifications';
$string['messageprovider:badgecreatornotice'] = 'Badge creator notifications';
$string['messageprovider:badgerecipientnotice'] = 'Badge recipient notifications';
$string['messageprovider:courserequestapproved'] = 'Course creation request approval notification';
$string['messageprovider:courserequested'] = 'Course creation request notification';
$string['messageprovider:courserequestrejected'] = 'Course creation request rejection notification';
$string['messageprovider:errors'] = 'Important errors with the site';
$string['messageprovider:errors_help'] = 'These are important errors that an administrator should know about.';
$string['messageprovider:notices'] = 'Notices about minor problems';
$string['messageprovider:notices_help'] = 'These are notices that an administrator might be interested in seeing.';
$string['messageprovider:instantmessage'] = 'Personal messages between users';
$string['messageprovider:instantmessage_help'] = 'This section configures what happens to messages that are sent to you directly from other users on this site.';
$string['messageselect'] = 'Select this user as a message recipient';
$string['messageselectadd'] = 'Send a message';
$string['middlename'] = 'Middle name';
$string['migratinggrades'] = 'Migrating grades';
$string['min'] = 'min';
$string['mins'] = 'mins';
$string['minute'] = 'minute';
$string['minutes'] = 'minutes';
$string['miscellaneous'] = 'Miscellaneous';
$string['missingcategory'] = 'You need to choose a category';
$string['missingdescription'] = 'Missing description';
$string['missingemail'] = 'Missing email address';
$string['missingfirstname'] = 'Missing given name';
$string['missingfromdisk'] = 'Missing from disk';
$string['missingfullname'] = 'Missing full name';
$string['missinglastname'] = 'Missing surname';
$string['missingname'] = 'Missing name';
$string['missingnewpassword'] = 'Missing new password';
$string['missingpassword'] = 'Missing password';
$string['missingrecaptchachallengefield'] = 'Missing reCAPTCHA challenge field';
$string['missingreqreason'] = 'Missing reason';
$string['missingshortname'] = 'Missing short name';
$string['missingshortsitename'] = 'Missing short site name';
$string['missingsitedescription'] = 'Missing site description';
$string['missingsitename'] = 'Missing site name';
$string['missingstrings'] = 'Check for untranslated words or phrases';
$string['missingstudent'] = 'Must choose something';
$string['missingsummary'] = 'Missing summary';
$string['missingteacher'] = 'Must choose something';
$string['missingurl'] = 'Missing URL';
$string['missingusername'] = 'Missing username';
$string['moddoesnotsupporttype'] = 'Module {$a->modname} does not support uploads of type {$a->type}';
$string['month'] = 'Month';
$string['months'] = 'Months';
$string['modified'] = 'Modified';
$string['modchooserenable'] = 'Activity chooser on';
$string['modchooserdisable'] = 'Activity chooser off';
$string['moduleintro'] = 'Description';
$string['modulesetup'] = 'Setting up module tables';
$string['modulesuccess'] = '{$a} tables have been set up correctly';
$string['modulesused'] = 'Modules used';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Moodle Docs for this page';
$string['moodleversion'] = 'Moodle version';
$string['moodlerelease'] = 'Moodle release';
$string['more'] = 'more';
$string['morehelp'] = 'More help';
$string['moreinfo'] = 'More info';
$string['moreinformation'] = 'More information about this error';
$string['moreprofileinfoneeded'] = 'Please tell us more about yourself';
$string['mostrecently'] = 'most recently';
$string['move'] = 'Move';
$string['movecoursemodule'] = 'Move resource';
$string['movecoursesection'] = 'Move section';
$string['movecontent'] = 'Move {$a}';
$string['movecategorycontentto'] = 'Move into';
$string['movecategorysuccess'] = 'Successfully moved category \'{$a->moved}\' into category \'{$a->to}\'';
$string['movecategoriessuccess'] = 'Successfully moved {$a->count} categories into category \'{$a->to}\'';
$string['movecategorytotopsuccess'] = 'Successfully moved category \'{$a->moved}\' to top level';
$string['movecategoriestotopsuccess'] = 'Successfully moved {$a->count} categories to top level';
$string['movecategoryto'] = 'Move category to:';
$string['movecontentstoanothercategory'] = 'Move contents to another category';
$string['movecourseto'] = 'Move course to:';
$string['movedown'] = 'Move down';
$string['movefilestohere'] = 'Move files to here';
$string['movefull'] = 'Move {$a} to this location';
$string['movehere'] = 'Move to here';
$string['moveleft'] = 'Move left';
$string['moveright'] = 'Move right';
$string['movesection'] = 'Move section {$a}';
$string['moveselectedcategoriesto'] = 'Move selected categories to';
$string['moveselectedcoursesto'] = 'Move selected courses to...';
$string['movetoanotherfolder'] = 'Move to another folder';
$string['moveup'] = 'Move up';
$string['msnid'] = 'MSN ID';
$string['mustconfirm'] = 'You need to confirm your login';
$string['mustchangepassword'] = 'The new password must be different than the current one';
$string['mycourses'] = 'My courses';
$string['myfiles'] = 'My private files';
$string['myfilesmanage'] = 'Manage my private files';
$string['myhome'] = 'My home';
$string['mymoodledashboard'] = 'My Moodle dashboard';
$string['myprofile'] = 'My profile';
$string['name'] = 'Name';
$string['nameforlink'] = 'What do you want to call this link?';
$string['nameforpage'] = 'Name';
$string['navigation'] = 'Navigation';
$string['needed'] = 'Needed';
$string['networkdropped'] = 'We have detected that your Internet connection is unreliable or has been interrupted.<br />
Please be aware that changes may not be saved properly until your connection improves.';
$string['never'] = 'Never';
$string['neverdeletelogs'] = 'Never delete logs';
$string['new'] = 'New';
$string['newaccount'] = 'New account';
$string['newcourse'] = 'New course';
$string['newpassword'] = 'New password';
$string['newpassword_help'] = 'Enter a new password or leave blank to keep current password.';
$string['newpasswordfromlost'] = '<strong>NOTICE:</strong> Your <strong>Current password</strong> will have been sent to you in the <strong>second</strong> of the two emails sent as part of the lost password recovery process. Make sure you have received your replacement password before continuing with this screen.';
$string['newpasswordtext'] = 'Hi {$a->firstname},

Your account password at \'{$a->sitename}\' has been reset
and you have been issued with a new temporary password.

Your current login information is now:
   username: {$a->username}
   password: {$a->newpassword}

Please go to this page to change your password:
   {$a->link}

In most mail programs, this should appear as a blue link
which you can just click on.  If that doesn\'t work,
then cut and paste the address into the address
line at the top of your web browser window.

Cheers from the \'{$a->sitename}\' administrator,
{$a->signoff}';
$string['newpicture'] = 'New picture';
$string['newpicture_help'] = 'To add a new picture, browse and select an image (in JPG or PNG format) then click "Update profile". The image will be cropped to a square and resized to 100x100 pixels.';
$string['newsitem'] = 'news item';
$string['newsitems'] = 'news items';
$string['newsitemsnumber'] = 'News items to show';
$string['newsitemsnumber_help'] = 'This setting determines how many recent items appear in the latest news block on the course page. If set to "0 news items" then the latest news block will not be displayed.';
$string['newuser'] = 'New user';
$string['newusernewpasswordsubj'] = 'New user account';
$string['newusernewpasswordtext'] = 'Hi {$a->firstname},

A new account has been created for you at \'{$a->sitename}\'
and you have been issued with a new temporary password.

Your current login information is now:
   username: {$a->username}
   password: {$a->newpassword}
             (you will have to change your password
              when you login for the first time)

To start using \'{$a->sitename}\', login at
   {$a->link}

In most mail programs, this should appear as a blue link
which you can just click on.  If that doesn\'t work,
then cut and paste the address into the address
line at the top of your web browser window.

Cheers from the \'{$a->sitename}\' administrator,
{$a->signoff}';
$string['newusers'] = 'New users';
$string['newwindow'] = 'New window';
$string['next'] = 'Next';
$string['nextsection'] = 'Next section';
$string['no'] = 'No';
$string['noblockstoaddhere'] = 'There are no blocks that you can add to this page.';
$string['nobody'] = 'Nobody';
$string['nocourses'] = 'No courses';
$string['nocoursesfound'] = 'No courses were found with the words \'{$a}\'';
$string['nocoursesyet'] = 'No courses in this category';
$string['nocomments'] = 'No comments';
$string['nodstpresets'] = 'The administrator has not enabled Daylight Savings Time support.';
$string['nofilesselected'] = 'No files have been selected to restore';
$string['nofilesyet'] = 'No files have been uploaded to your course yet';
$string['nograde'] = 'No grade';
$string['nohelpforactivityorresource'] = 'There is currently no help associated with this resource or activity';
$string['nochange'] = 'No change';
$string['noimagesyet'] = 'No images have been uploaded to your course yet';
$string['nologsfound'] = 'No logs have been found';
$string['nomatchingusers'] = 'No users match \'{$a}\'';
$string['nomorecourses'] = 'No more matching courses could be found';
$string['nomoreidnumber'] = 'Not using an idnumber to avoid collisions';
$string['none'] = 'None';
$string['noneditingteacher'] = 'Non-editing teacher';
$string['noneditingteacherdescription'] = 'Non-editing teachers can teach in courses and grade students, but may not alter activities.';
$string['nonstandard'] = 'Non-standard';
$string['nopendingcourses'] = 'There are no courses pending approval';
$string['nopotentialadmins'] = 'No potential admins';
$string['nopotentialcreators'] = 'No potential course creators';
$string['nopotentialstudents'] = 'No potential students';
$string['nopotentialteachers'] = 'No potential teachers';
$string['norecentactivity'] = 'No recent activity';
$string['noreplybouncemessage'] = 'You have replied to a no-reply email address. If you were attempting to reply to a forum post, please instead reply using the {$a} forums.

Following is the content of your email:';
$string['noreplybouncesubject'] = '{$a} - bounced email.';
$string['noreplyname'] = 'Do not reply to this email';
$string['noresetrecord'] = 'There is no record of that reset request. Please initiate a new password reset request.';
$string['noresults'] = 'No results';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Normal search';
$string['nosite'] = 'Could not find site-level course';
$string['nostudentsfound'] = 'No {$a} found';
$string['nostudentsingroup'] = 'There are no students in this group yet';
$string['nostudentsyet'] = 'No students enrolled in this course yet';
$string['nosuchemail'] = 'No such email address';
$string['notavailable'] = 'Not available';
$string['notavailablecourse'] = '{$a} is not available';
$string['noteachersyet'] = 'No teachers in this course yet';
$string['notenrolled'] = '{$a} is not enrolled in this course.';
$string['notenrolledprofile'] = 'This profile is not available because this user is not enrolled in this course.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Note:</strong> The ability to roll dates when restoring this backup has been disabled because you lack the required permissions.';
$string['noteuserschangednonetocourse'] = '<strong>Note:</strong> Course users need to be restored when restoring user data (in activities, files or messages). This setting has been changed for you.';
$string['nothingnew'] = 'No recent activity';
$string['nothingtodisplay'] = 'Nothing to display';
$string['notice'] = 'Notice';
$string['noticenewerbackup'] = 'This backup file has been created with Moodle {$a->backuprelease} ({$a->backupversion}) and it\'s newer than your currently installed Moodle {$a->serverrelease} ({$a->serverversion}). This could cause some inconsistencies because backwards compatibility of backup files cannot be guaranteed.';
$string['notifications'] = 'Notifications';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, User: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'You can view these logs at {$a}';
$string['notifyloginfailuresmessagestart'] = 'Here is a list of failed login attempts at {$a} since you were last notified';
$string['notifyloginfailuressubject'] = '{$a} :: Failed logins notification';
$string['notincluded'] = 'Not included';
$string['notingroup'] = 'Sorry, but you need to be part of a group to see this activity.';
$string['notpublic'] = 'Not public!';
$string['nousersfound'] = 'No users found';
$string['nousersmatching'] = 'No users matching \'{$a}\' were found';
$string['nousersyet'] = 'There are no users yet';
$string['novalidcourses'] = 'No valid courses to be shown';
$string['now'] = 'now';
$string['numattempts'] = '{$a} failed login attempt(s)';
$string['numberofcourses'] = 'Number of courses';
$string['numberweeks'] = 'Number of sections';
$string['numdays'] = '{$a} days';
$string['numhours'] = '{$a} hours';
$string['numletters'] = '{$a} letters';
$string['numminutes'] = '{$a} minutes';
$string['nummonths'] = '{$a} months';
$string['numseconds'] = '{$a} seconds';
$string['numviews'] = '{$a} views';
$string['numweeks'] = '{$a} weeks';
$string['numwords'] = '{$a} words';
$string['numyears'] = '{$a} years';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Current password';
$string['olduserdirectory'] = 'This is the OLD users directory, and is no longer needed. You may safely delete it. The files it contains have been copied to the NEW user directory.';
$string['optional'] = 'optional';
$string['options'] = 'options';
$string['order'] = 'Order';
$string['originalpath'] = 'Original path';
$string['orphanedactivitiesinsectionno'] = 'Orphaned activities (section {$a})';
$string['other'] = 'Other';
$string['outline'] = 'Outline';
$string['outlinereport'] = 'Outline report';
$string['page'] = 'Page';
$string['pagea'] = 'Page {$a}';
$string['pageheaderconfigablock'] = 'Configuring a block in {$a->fullname}';
$string['pagepath'] = 'Page path';
$string['pageshouldredirect'] = 'This page should automatically redirect. If nothing is happening please use the continue link below.';
$string['parentcategory'] = 'Parent category';
$string['parentcoursenotfound'] = 'Parent course not found!';
$string['parentfolder'] = 'Parent folder';
$string['participants'] = 'Participants';
$string['participantslist'] = 'Participants list';
$string['participationratio'] = 'Participation ratio';
$string['participationreport'] = 'Participation report';
$string['password'] = 'Password';
$string['passwordconfirmchange'] = 'Confirm password change';
$string['passwordextlink'] = 'The following link has been provided to recover your lost password. This will take you out of Moodle.';
$string['passwordforgotten'] = 'Forgotten password';
$string['passwordforgotteninstructions'] = 'Your details must first be found in the user database. Please enter <strong>either</strong> your username or your registered email address in the appropriate box. There is no need to enter both.';
$string['passwordforgotteninstructions2'] = 'To reset your password, submit your username or your email address below. If we can find you in the database, an email will be sent to your email address, with instructions how to get access again.';
$string['passwordchanged'] = 'Password has been changed';
$string['passwordnohelp'] = 'No help is available to find your lost password. Please contact your Moodle administrator.';
$string['passwordrecovery'] = 'Yes, help me log in';
$string['passwordsdiffer'] = 'These passwords do not match';
$string['passwordsent'] = 'Password has been sent';
$string['passwordset'] = 'Your password has been set.';
$string['passwordsenttext'] = '<p>An email has been sent to your address at {$a->email}.</p>
   <p><b>Please check your email for your new password</b></p>
   <p>The new password was automatically generated, so you might like to
   <a href="{$a->link}">change it to something easier to remember</a>.</p>';
$string['path'] = 'Path';
$string['pathnotexists'] = 'Path doesn\'t exist in your server!';
$string['pathslasherror'] = 'Path can\'t end with a slash!!';
$string['paymentinstant'] = 'Use the button below to pay and be enrolled within minutes!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pending</small>)';
$string['paymentrequired'] = 'This course requires a payment for entry.';
$string['payments'] = 'Payments';
$string['paymentsorry'] = 'Thank you for your payment!  Unfortunately your payment has not yet been fully processed, and you are not yet registered to enter the course "{$a->fullname}".  Please try continuing to the course in a few seconds, but if you continue to have trouble then please alert the {$a->teacher} or the site administrator';
$string['paymentthanks'] = 'Thank you for your payment!  You are now enrolled in your course:<br />"{$a}"';
$string['pendingrequests'] = 'Pending requests';
$string['periodending'] = 'Period ending ({$a})';
$string['perpage'] = 'Per page';
$string['perpagea'] = 'Per page: {$a}';
$string['personal'] = 'Personal';
$string['personalprofile'] = 'Personal profile';
$string['phone'] = 'Phone';
$string['phone2'] = 'Mobile phone';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = 'Picture of {$a}';
$string['pictureofuser'] = 'User picture';
$string['pleaseclose'] = 'Please close this window now.';
$string['pleasesearchmore'] = 'Please search some more';
$string['pleaseusesearch'] = 'Please use the search';
$string['plugin'] = 'Plugin';
$string['plugindeletefiles'] = 'All data associated with the plugin \'{$a->name}\' has been deleted from the database. To prevent the plugin re-installing itself, you should now delete this directory from your server: {$a->directory}';
$string['plugincheck'] = 'Plugins check';
$string['pluginsetup'] = 'Setting up plugin tables';
$string['policyaccept'] = 'I understand and agree';
$string['policyagree'] = 'You must agree to this policy to continue using this site.  Do you agree?';
$string['policyagreement'] = 'Site policy agreement';
$string['policyagreementclick'] = 'Link to site policy agreement';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Open file in new window';
$string['popupwindowname'] = 'Popup window';
$string['post'] = 'Post';
$string['posts'] = 'Posts';
$string['potentialadmins'] = 'Potential admins';
$string['potentialcreators'] = 'Potential course creators';
$string['potentialstudents'] = 'Potential students';
$string['potentialteachers'] = 'Potential teachers';
$string['preferences'] = 'Preferences';
$string['preferredlanguage'] = 'Preferred language';
$string['preferredtheme'] = 'Preferred theme';
$string['preprocessingbackupfile'] = 'Preprocessing backup file';
$string['prev'] = 'Prev';
$string['preview'] = 'Preview';
$string['previewhtml'] = 'HTML format preview';
$string['previeworchoose'] = 'Preview or choose a theme';
$string['previous'] = 'Previous';
$string['previouslyselectedusers'] = 'Previously selected users not matching \'{$a}\'';
$string['previoussection'] = 'Previous section';
$string['primaryadminsetup'] = 'Setup administrator account';
$string['private_files_handler'] = 'Store attachments to an e-mail in the user\'s private files storage space.';
$string['private_files_handler_name'] = 'Email to Private files';
$string['profile'] = 'Profile';
$string['profilenotshown'] = 'This profile description will not be shown until this person is enrolled in at least one course.';
$string['publicprofile'] = 'Public profile';
$string['publicsitefileswarning'] = 'Note: files placed here can be accessed by anyone';
$string['publicsitefileswarning2'] = 'Note: Files placed here can be accessed by anyone who knows (or can guess) the URL. For security reasons, it is recommended that any backup files are deleted immediately after restoring them.';
$string['publicsitefileswarning3'] = 'Note: Files placed here can be accessed by anyone who knows (or can guess) the URL. <br />For security reasons, backup files should be saved in the secure backupdata folder only.';
$string['publish'] = 'Publish';
$string['question'] = 'Question';
$string['questionsinthequestionbank'] = 'Questions in the question bank';
$string['readinginfofrombackup'] = 'Reading info from backup';
$string['readme'] = 'README';
$string['recentactivity'] = 'Recent activity';
$string['recentactivityreport'] = 'Full report of recent activity...';
$string['recipientslist'] = 'Recipients list';
$string['recreatedcategory'] = 'Recreated category {$a}';
$string['redirect'] = 'Redirect';
$string['reducesections'] = 'Reduce the number of sections';
$string['refresh'] = 'Refresh';
$string['refreshingevents'] = 'Refreshing events';
$string['registration'] = 'Moodle registration';
$string['registrationcontact'] = 'Contact from the public';
$string['registrationcontactno'] = 'No, I do not want a contact form in the site listing';
$string['registrationcontactyes'] = 'Yes, provide a form for prospective Moodlers to contact me';
$string['registrationemail'] = 'Email notifications';
$string['registrationinfo'] = '<p>This page allows you to register your Moodle site with moodle.org.  Registration is free.
The main benefit of registering is that you will be added to a low-volume mailing list
for important notifications such as security alerts and new releases of Moodle.</p>
<p>By default, your information will be kept private, and will never be sold or passed on to anyone else.  The only
   reason for collecting this information is for support purposes, and to help build up a statistical
   picture of the Moodle community as a whole.</p>
<p>If you choose, you can allow your site name, country and URL to be added to the public list of Moodle Sites.</p>
<p>All new registrations are verified manually before they are added to the list, but once you are added you can update your registration (and your entry on the public list) at any time by resubmitting this form.</p>';
$string['registrationinfotitle'] = 'Registration information';
$string['registrationno'] = 'No, I do not want to receive email';
$string['registrationsend'] = 'Send registration information to moodle.org';
$string['registrationyes'] = 'Yes, please notify me about important issues';
$string['reject'] = 'Reject';
$string['rejectdots'] = 'Reject...';
$string['reload'] = 'Reload';
$string['remoteappuser'] = 'Remote {$a} User';
$string['remove'] = 'Remove';
$string['removeadmin'] = 'Remove admin';
$string['removecreator'] = 'Remove course creator';
$string['removestudent'] = 'Remove student';
$string['removeteacher'] = 'Remove teacher';
$string['rename'] = 'Rename';
$string['renamefileto'] = 'Rename <b>{$a}</b> to';
$string['report'] = 'Report';
$string['reports'] = 'Reports';
$string['repositories'] = 'Repositories';
$string['requestcourse'] = 'Request a course';
$string['requestedby'] = 'Requested by';
$string['requestedcourses'] = 'Requested courses';
$string['requestreason'] = 'Reason for course request';
$string['required'] = 'Required';
$string['requirespayment'] = 'This course requires payment for access';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Component';
$string['resetcourse'] = 'Reset course';
$string['resetinfo'] = 'This page allows you to empty a course of user data, while retaining the activities and other settings.  Please be warned that by choosing items below and submitting this page you will delete your chosen user data from this course forever!';
$string['resetnotimplemented'] = 'Reset not implemented';
$string['resetrecordexpired'] = 'The password reset link you used is more than {$a} minutes old and has expired. Please initiate a new password reset.';
$string['resetstartdate'] = 'Reset start date';
$string['resetstatus'] = 'Status';
$string['resettask'] = 'Task';
$string['resettodefaults'] = 'Reset to defaults';
$string['resortsubcategoriesby'] = 'Sort subcategories by {$a} ascending';
$string['resortsubcategoriesbyreverse'] = 'Sort subcategories by {$a} descending';
$string['resortcourses'] = 'Sort courses';
$string['resource'] = 'Resource';
$string['resourcedisplayauto'] = 'Automatic';
$string['resourcedisplaydownload'] = 'Force download';
$string['resourcedisplayembed'] = 'Embed';
$string['resourcedisplayframe'] = 'In frame';
$string['resourcedisplaynew'] = 'New window';
$string['resourcedisplayopen'] = 'Open';
$string['resourcedisplaypopup'] = 'In pop-up';
$string['resources'] = 'Resources';
$string['resources_help'] = 'Resource types enable almost any kind of web content to be inserted into the course.';
$string['restore'] = 'Restore';
$string['restorecancelled'] = 'Restore cancelled';
$string['restorecannotassignroles'] = 'Restore needs to assign roles and you do not have permission to do so';
$string['restorecannotcreateorassignroles'] = 'Restore needs to create or assign roles and you do not have permission to do so';
$string['restorecannotcreateuser'] = 'Restore needs to create user \'{$a}\' from backup file and you do not have permission to do so';
$string['restorecannotoverrideperms'] = 'Restore needs to override permissions and you do not have permission to do so';
$string['restorecoursenow'] = 'Restore this course now!';
$string['restoredaccount'] = 'Restored account';
$string['restoredaccountinfo'] = 'This account was imported from another server and the password has been lost. To set a new password by email, please click "Continue"';
$string['restorefinished'] = 'Restore completed successfully';
$string['restoreto'] = 'Restore to';
$string['restoretositeadding'] = 'Warning: You are about to restore to the site front page, adding data to it!';
$string['restoretositedeleting'] = 'Warning: You are about to restore to the site front page, deleting data from it first!';
$string['restoreuserconflict'] = 'Trying to restore user \'{$a}\' from backup file will cause conflict';
$string['restoreuserinfofailed'] = 'The restore process has stopped because you don\'t have permission to restore user data.';
$string['restoreusersprecheck'] = 'Checking user data';
$string['restoreusersprecheckerror'] = 'Some problems were detected when checking user data';
$string['restricted'] = 'Restricted';
$string['returningtosite'] = 'Returning to this web site?';
$string['returntooriginaluser'] = 'Return to {$a}';
$string['revert'] = 'Revert';
$string['role'] = 'Role';
$string['roleassignments'] = 'Role assignments';
$string['rolemappings'] = 'Role mappings';
$string['rolerenaming'] = 'Role renaming';
$string['rolerenaming_help'] = 'This setting allows the displayed names for roles used in the course to be changed. Only the displayed name is changed - role permissions are not affected.  New role names will appear on the course participants page and elsewhere within the course. If the renamed role is one that the administrator has selected as a course manager role, then the new role name will also appear as part of the course listings.';
$string['roles'] = 'Roles';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Number of RSS recent articles';
$string['rsserror'] = 'Error reading RSS data';
$string['rsserrorauth'] = 'Your RSS link does not contain a valid authentication token.';
$string['rsserrorguest'] = 'This feed uses guest access to access the data, but guest does not have permission to read the data. Visit the original location that this feed comes from (URL) as a valid user and get a new RSS link from there.';
$string['rsskeyshelp'] = '<p>To ensure security and privacy, RSS feed URLs contain a special token that identifies the user they are for. This prevents other users from accessing areas of the site where they are not allowed.</p><p>The token is automatically created the first time you access an area that produces an RSS feed. If you think that your RSS feed token has been compromised, you can request a new one by clicking the reset link. Please note that your current RSS feed URLs will then become invalid.</p>';
$string['rsstype'] = 'RSS feed for this activity';
$string['saveandnext'] = 'Save and show next';
$string['savedat'] = 'Saved at:';
$string['savechanges'] = 'Save changes';
$string['savechangesanddisplay'] = 'Save and display';
$string['savechangesandreturntocourse'] = 'Save and return to course';
$string['savecomment'] = 'Save comment';
$string['savepreferences'] = 'Save preferences';
$string['saveto'] = 'Save to';
$string['scale'] = 'Scale';
$string['scale_help'] = 'A scale provides a way of evaluating or grading performance in an activity. It is defined by an ordered list of values, ranging from negative to positive, separated by commas, for example "Disappointing, Not good enough, Average, Good, Very good, Excellent!"';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Scales';
$string['scalescustom'] = 'Custom scales';
$string['scalescustomcreate'] = 'Add a new scale';
$string['scalescustomno'] = 'No custom scales have been created yet';
$string['scalesstandard'] = 'Standard scales';
$string['scalestandard'] = 'Standard scale';
$string['scalestandard_help'] = 'A standard scale is available site-wide, for all courses.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'To create custom scales, use the \'Scales...\' link in your course administration menu.';
$string['scalestip2'] = 'To create custom scales, click the Grades link in the course administration menu, then choose Edit, Scales.';
$string['screenshot'] = 'Screenshot';
$string['search'] = 'Search'; // TODO MDL-34652 rename to searchforums and move to mod_forum
$string['search_help'] = 'For basic searching of one or more words anywhere in the text, just type them separated by spaces. All words longer than two characters are used.

For advanced searching, press the search button without typing anything in the search box to access the advanced search form.';
$string['searchagain'] = 'Search again';
$string['searchbyemail'] = 'Search by email address';
$string['searchbyusername'] = 'Search by username';
$string['searchcourses'] = 'Search courses';
$string['searchhelp'] = '<p>You can search for multiple words at once and can refine your search as follows:</p>
<ul>
<li>word - find any match of this word within the text.</li>
<li>+word - only exact matching words will be found.</li>
<li>-word - don\'t include results containing this word.</li>
</ul>';
$string['searchoptions'] = 'Search options';
$string['searchresults'] = 'Search results';
$string['sec'] = 'sec';
$string['secondsleft'] = '{$a} secs';
$string['seconds'] = 'seconds';
$string['secondstotime172800'] = '2 days';
$string['secondstotime259200'] = '3 days';
$string['secondstotime345600'] = '4 days';
$string['secondstotime432000'] = '5 days';
$string['secondstotime518400'] = '6 days';
$string['secondstotime604800'] = '1 Week';
$string['secondstotime86400'] = '1 day';
$string['secretalreadyused'] = 'Change password confirmation link was already used, password was not changed.';
$string['secs'] = 'secs';
$string['section'] = 'Section';
$string['sectionname'] = 'Section name';
$string['sections'] = 'Sections';
$string['sectionusedefaultname'] = 'Use default section name';
$string['seealsostats'] = 'See also: stats';
$string['select'] = 'Select';
$string['selectacategory'] = 'Please select a category';
$string['selectacountry'] = 'Select a country';
$string['selectacourse'] = 'Select a course';
$string['selectacoursesite'] = 'Select a course or site';
$string['selectanaction'] = 'Select an action';
$string['selectagroup'] = 'Select a group';
$string['selectaregion'] = 'Select a region';
$string['selctauser'] = 'Select a user';
$string['selectall'] = 'Select all';
$string['selectamodule'] = 'Please select an activity module';
$string['selectanoptions'] = 'Select an option';
$string['selectdefault'] = 'Select default';
$string['selectedfile'] = 'Selected file';
$string['selectedcategories'] = 'Selected categories';
$string['selectednowmove'] = '{$a} files selected for moving. Now go into the destination folder and press \'Move files to here\'';
$string['selectfiles'] = 'Select files';
$string['selectmoduletoviewhelp'] = 'Select an activity or resource to view its help.

Double-click on an activity or resource name to quickly add it.';
$string['selectnos'] = 'Select all \'No\'';
$string['selectperiod'] = 'Select period';
$string['selectcategorysort'] = 'Which categories would you like to sort?';
$string['selectcategorysortby'] = 'Select how you would like to sort categories';
$string['selectcoursesortby'] = 'Select how you would like to sort courses';
$string['senddetails'] = 'Send my details via email';
$string['separate'] = 'Separate';
$string['separateandconnected'] = 'Separate and Connected ways of knowing';
$string['separateandconnectedinfo'] = 'The scale based on the theory of separate and connected knowing. This theory describes two different ways that we can evaluate and learn about the things we see and hear.<ul><li><strong>Separate knowers</strong> remain as objective as possible without including feelings and emotions. In a discussion with other people, they like to defend their own ideas, using logic to find holes in opponent\'s ideas.</li><li><strong>Connected knowers</strong> are more sensitive to other people. They are skilled at empathy and tends to listen and ask questions until they feel they can connect and "understand things from their point of view". They learn by trying to share the experiences that led to the knowledge they find in other people.</li></ul>';
$string['servererror'] = 'An error occurred whilst communicating with the server';
$string['serverlocaltime'] = 'Server\'s local time';
$string['setcategorytheme'] = 'Set category theme';
$string['setpassword'] = 'Set password';
$string['setpasswordinstructions'] = 'Please enter and repeat your new password below, then click "Set password". <br />Your new password will be saved, and you will be logged in.';
$string['settings'] = 'Settings';
$string['shortname'] = 'Short name'; // @deprecated MDL-34652 - use shortnamecourse or shortnameuser or some own context specific string
$string['shortnamecollisionwarning'] = '[*] = This shortname is already in use by a course and will need to be changed upon approval';
$string['shortnamecourse'] = 'Course short name';
$string['shortnamecourse_help'] = 'The short name of the course is displayed in the navigation and is used in the subject line of course email messages.';
$string['shortnametaken'] = 'Short name is already used for another course ({$a})';
$string['shortnameuser'] = 'User short name';
$string['shortsitename'] = 'Short name for site (eg single word)';
$string['show'] = 'Show';
$string['showactions'] = 'Show actions';
$string['showadvancedsettings'] = 'Show advanced settings';
$string['showall'] = 'Show all {$a}';
$string['showallcourses'] = 'Show all courses';
$string['showallusers'] = 'Show all users';
$string['showblockcourse'] = 'Show list of courses containing block';
$string['showcategory'] = 'Show {$a}';
$string['showcomments'] = 'Show/hide comments';
$string['showcommentsnonjs'] = 'Show comments';
$string['showdescription'] = 'Display description on course page';
$string['showdescription_help'] = 'If enabled, the description above will be displayed on the course page just below the link to the activity or resource.';
$string['showgrades'] = 'Show gradebook to students';
$string['showgrades_help'] = 'Many activities in the course allow grades to be set. This setting determines whether a student can view a list of all their grades for the course via a grades link in the course administration block.';
$string['showingacourses'] = 'Showing all {$a} courses';
$string['showingxofycourses'] = 'Showing courses {$a->start} to {$a->end} of {$a->total} courses';
$string['showlistofcourses'] = 'Show list of courses';
$string['showmodulecourse'] = 'Show list of courses containing activity';
$string['showonly'] = 'Show only';
$string['showperpage'] = 'Show {$a} per page';
$string['showrecent'] = 'Show recent activity';
$string['showreports'] = 'Show activity reports';
$string['showreports_help'] = 'Activity reports are available for each participant that show their activity in the course. As well as listings of their contributions, such as forum posts or assignment submissions, these reports also include access logs. This setting determines whether a student can view their own activity reports via their profile page.';
$string['showsettings'] = 'Show settings';
$string['showtheselogs'] = 'Show these logs';
$string['showthishelpinlanguage'] = 'Show this help in language: {$a}';
$string['schedule'] = 'Schedule';
$string['since'] = 'Since';
$string['sincelast'] = 'since last login';
$string['site'] = 'Site';
$string['sitedefault'] = 'Site default';
$string['siteerrors'] = 'Site errors';
$string['sitefiles'] = 'Site files';
$string['sitefilesused'] = 'Site files used in this course';
$string['sitehome'] = 'Site home';
$string['sitelegacyfiles'] = 'Legacy site files';
$string['sitelogs'] = 'Site logs';
$string['sitemessage'] = 'Message users';
$string['sitenews'] = 'Site news';
$string['sitepages'] = 'Site pages';
$string['sitepartlist'] = 'You do not have the required permissions to view the participants list';
$string['sitepartlist0'] = 'You must be a site teacher to be allowed to see the site participants list';
$string['sitepartlist1'] = 'You must be a teacher to be allowed to see the site participants list';
$string['sites'] = 'Sites';
$string['sitesection'] = 'Include a topic section';
$string['sitesettings'] = 'Site settings';
$string['siteteachers'] = 'Site teachers';
$string['size'] = 'Size';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Skipped';
$string['skiptocategorylisting'] = 'Skip to the category listings';
$string['skiptocourselisting'] = 'Skip to the course listings';
$string['skiptocoursedetails'] = 'Skip to the detailed course information';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Social forum - latest topics';
$string['someallowguest'] = 'Some courses may allow guest access';
$string['someerrorswerefound'] = 'Some information was missing or incorrect. Look below for details.';
$string['sort'] = 'Sort';
$string['sortby'] = 'Sort by';
$string['sortbyx'] = 'Sort by {$a} ascending';
$string['sortbyxreverse'] = 'Sort by {$a} descending';
$string['sorting'] = 'Sorting';
$string['sourcerole'] = 'Source role';
$string['specifyname'] = 'You must specify a name.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = course pending approval)';
$string['startdate'] = 'Course start date';
$string['startdate_help'] = 'This setting determines the start of the first week for a course in weekly format. It also determines the earliest date that logs of course activities are available for. If the course is reset and the course start date changed, all dates in the course will be moved in relation to the new start date.';
$string['startingfrom'] = 'Starting from';
$string['startsignup'] = 'Create new account';
$string['state'] = 'State/Province';
$string['statistics'] = 'Statistics';
$string['statisticsgraph'] = 'Statistics graph';
$string['stats'] = 'Statistics';
$string['statslogins'] = 'Logins';
$string['statsmodedetailed'] = 'Detailed (user) view';
$string['statsmodegeneral'] = 'General view';
$string['statsnodata'] = 'There is no available data for that combination of course and time period.';
$string['statsnodatauser'] = 'There is no available data for that combination of course, user and time period.';
$string['statsoff'] = 'Statistics is not currently enabled';
$string['statsreads'] = 'Views';
$string['statsreportactivity'] = 'All activity (all roles)';
$string['statsreportactivitybyrole'] = 'All activity (views and posts)';
$string['statsreportforuser'] = 'for';
$string['statsreportlogins'] = 'Logins';
$string['statsreportreads'] = 'Views (all roles)';
$string['statsreporttype'] = 'Report type';
$string['statsreportwrites'] = 'Posts (all roles)';
$string['statsreport1'] = 'Logins';
$string['statsreport10'] = 'User activity';
$string['statsreport11'] = 'Most active courses';
$string['statsreport12'] = 'Most active courses (weighted)';
$string['statsreport13'] = 'Most participatory courses (enrolments)';
$string['statsreport14'] = 'Most participatory courses (views/posts)';
$string['statsreport2'] = 'Views (all roles)';
$string['statsreport3'] = 'Posts (all roles)';
$string['statsreport4'] = 'All activity (all roles)';
$string['statsreport5'] = 'All activity (views and posts)';
$string['statsreport7'] = 'User activity (views and posts)';
$string['statsreport8'] = 'All user activity';
$string['statsreport9'] = 'Logins (site course)';
$string['statsstudentactivity'] = 'Student activity';
$string['statsstudentreads'] = 'Student views';
$string['statsstudentwrites'] = 'Student posts';
$string['statsteacheractivity'] = 'Teacher activity';
$string['statsteacherreads'] = 'Teacher views';
$string['statsteacherwrites'] = 'Teacher posts';
$string['statstimeperiod'] = 'Time period - last:';
$string['statsuniquelogins'] = 'Unique logins';
$string['statsuseractivity'] = 'All activity';
$string['statsuserlogins'] = 'Logins';
$string['statsuserreads'] = 'Views';
$string['statsuserwrites'] = 'Posts';
$string['statswrites'] = 'Posts';
$string['status'] = 'Status';
$string['stringsnotset'] = 'The following strings are not defined in {$a}';
$string['studentnotallowed'] = 'Sorry, but you can not enter this course as \'{$a}\'';
$string['students'] = 'Students';
$string['studentsandteachers'] = 'Students and teachers';
$string['subcategories'] = 'Subcategories';
$string['subcategory'] = 'Subcategory';
$string['subcategoryof'] = 'Subcategory of {$a}';
$string['submit'] = 'Submit';
$string['success'] = 'Success';
$string['summary'] = 'Summary';
$string['summary_help'] = 'The idea of a summary is a short text to prepare students for the activities within the topic or week. The text is shown on the course page under the section name.';
$string['summaryof'] = 'Summary of {$a}';
$string['supplyinfo'] = 'More details';
$string['suspended'] = 'Suspended';
$string['suspendedusers'] = 'Suspended users';
$string['switchdevicedefault'] = 'Switch to the standard theme';
$string['switchdevicerecommended'] = 'Switch to the recommended theme for your device';
$string['switchrolereturn'] = 'Return to my normal role';
$string['switchroleto'] = 'Switch role to...';
$string['tag'] = 'Tag';
$string['tagalready'] = 'This tag already exists';
$string['tagmanagement'] = 'Add/delete tags ...';
$string['tags'] = 'Tags';
$string['targetrole'] = 'Target role';
$string['teacheronly'] = 'for the {$a} only';
$string['teacherroles'] = '{$a} roles';
$string['teachers'] = 'Teachers';
$string['textediting'] = 'Text editor';
$string['texteditor'] = 'Use standard web forms';
$string['textformat'] = 'Plain text format';
$string['thanks'] = 'Thanks';
$string['theme'] = 'Theme';
$string['themes'] = 'Themes';
$string['themesaved'] = 'New theme saved';
$string['thereareno'] = 'There are no {$a} in this course';
$string['therearecourses'] = 'There are {$a} courses';
$string['thiscategory'] = 'This category';
$string['thiscategorycontains'] = 'This category contains';
$string['time'] = 'Time';
$string['timecreatedcourse'] = 'Course time created';
$string['timezone'] = 'Timezone';
$string['to'] = 'To';
$string['tocreatenewaccount'] = 'Skip to create new account';
$string['tocontent'] = 'To item "{$a}"';
$string['today'] = 'Today';
$string['todaylogs'] = 'Today\'s logs';
$string['toeveryone'] = 'to everyone';
$string['toomanybounces'] = 'That email address has had too many bounces. You <b>must</b> change it to continue.';
$string['toomanytoshow'] = 'There are too many users to show.';
$string['toomanyusersmatchsearch'] = 'Too many users ({$a->count}) match \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Too many users ({$a}) to show';
$string['toonly'] = 'to {$a} only';
$string['top'] = 'Top';
$string['toplevelcategory'] = 'Top level category';
$string['topic'] = 'Topic';
$string['topicoutline'] = 'Topic outline';
$string['topicshow'] = 'Show this topic to {$a}';
$string['topichide'] = 'Hide this topic from {$a}';
$string['total'] = 'Total';
$string['totopofsection'] = 'To the top of section "{$a}"';
$string['trackforums'] = 'Forum tracking';
$string['trackforumsno'] = 'No: don\'t keep track of posts I have seen';
$string['trackforumsyes'] = 'Yes: highlight new posts for me';
$string['trysearching'] = 'Try searching instead.';
$string['turneditingoff'] = 'Turn editing off';
$string['turneditingon'] = 'Turn editing on';
$string['unauthorisedlogin'] = 'The user account "{$a}" is not available on this site';
$string['undecided'] = 'Undecided';
$string['unfinished'] = 'Unfinished';
$string['unknowncategory'] = 'Unknown category';
$string['unknownerror'] = 'Unknown error';
$string['unlimited'] = 'Unlimited';
$string['unpacking'] = 'Unpacking {$a}';
$string['unsafepassword'] = 'Unsafe password - try something else';
$string['untilcomplete'] = 'Until complete';
$string['unusedaccounts'] = 'Accounts unused for more than {$a} days are automatically unenrolled';
$string['unzip'] = 'Unzip';
$string['unzippingbackup'] = 'Unzipping backup';
$string['up'] = 'Up';
$string['update'] = 'Update';
$string['updated'] = 'Updated {$a}';
$string['updatemymoodleoff'] = 'Stop customising this page';
$string['updatemymoodleon'] = 'Customise this page';
$string['updatemyprofile'] = 'Update profile';
$string['updatesevery'] = 'Updates every {$a} seconds';
$string['updatethis'] = 'Update this {$a}';
$string['updatethiscourse'] = 'Update this course';
$string['updatinga'] = 'Updating: {$a}';
$string['updatingain'] = 'Updating {$a->what} in {$a->in}';
$string['upload'] = 'Upload';
$string['uploadafile'] = 'Upload a file';
$string['uploadcantwrite'] = 'Failed to write file to disk';
$string['uploadedfile'] = 'File uploaded successfully';
$string['uploadedfileto'] = 'Uploaded {$a->file} to {$a->directory}';
$string['uploadedfiletoobig'] = 'Sorry, but that file is too big (limit is {$a} bytes)';
$string['uploadextension'] = 'File upload stopped by a PHP extension';
$string['uploadfailednotrecovering'] = 'Your file upload has failed because there was a problem with one of the files, {$a->name}.<br /> Here is a log of the problems:<br />{$a->problem}<br />Not recovering.';
$string['uploadfilelog'] = 'Upload log for file {$a}';
$string['uploadformlimit'] = 'Uploaded file {$a} exceeded the maximum size limit set by the form';
$string['uploadlabel'] = 'Title:';
$string['uploadlimitwithsize'] = '{$a->contextname} upload limit ({$a->displaysize})';
$string['uploadnewfile'] = 'Upload new file';
$string['uploadnofilefound'] = 'No file was found - are you sure you selected one to upload?';
$string['uploadnotallowed'] = 'Uploads are not allowed';
$string['uploadnotempdir'] = 'Missing a temporary folder';
$string['uploadoldfilesdeleted'] = 'The old file(s) in your upload area have been deleted';
$string['uploadpartialfile'] = 'File was only partially uploaded';
$string['uploadproblem'] = 'An unknown problem occurred while uploading the file \'{$a}\' (perhaps it was too large?)';
$string['uploadrenamedcollision'] = 'File was renamed from {$a->oldname} to {$a->newname} because there was a filename conflict.';
$string['uploadrenamedchars'] = 'File was renamed from {$a->oldname} to {$a->newname} because of invalid characters.';
$string['uploadserverlimit'] = 'Uploaded file exceeded the maximum size limit set by the server';
$string['uploadthisfile'] = 'Upload this file';
$string['url'] = 'URL';
$string['used'] = 'Used';
$string['usedinnplaces'] = 'Used in {$a} places';
$string['usemessageform'] = 'or use the form below to send a message to the selected students';
$string['user'] = 'User';
$string['userconfirmed'] = 'Confirmed {$a}';
$string['usercurrentsettings'] = 'My profile settings';
$string['useractivity'] = 'Activity';
$string['userdata'] = 'User data';
$string['userdeleted'] = 'This user account has been deleted';
$string['userdescription'] = 'Description';
$string['userdescription_help'] = 'This box enables you to enter some text about yourself which will then be displayed on your profile page for others to view.';
$string['userdetails'] = 'User details';
$string['userfiles'] = 'User files';
$string['userlist'] = 'User list';
$string['usermenu'] = 'User menu';
$string['username'] = 'Username';
$string['usernameemail'] = 'Username / email';
$string['usernameemailmatch'] = 'The username and email address do not relate to the same user';
$string['usernameexists'] = 'This username already exists, choose another';
$string['usernamelowercase'] = 'Only lowercase letters allowed';
$string['usernamenotfound'] = 'The username was not found in the database';
$string['usernameoremail'] = 'Enter either username or email address';
$string['usernotconfirmed'] = 'Could not confirm {$a}';
$string['userpic'] = 'User picture';
$string['users'] = 'Users';
$string['userselectorautoselectunique'] = 'If only one user matches the search, select them automatically';
$string['userselectorpreserveselected'] = 'Keep selected users, even if they no longer match the search';
$string['userselectorsearchanywhere'] = 'Match the search text anywhere in the displayed fields';
$string['usersnew'] = 'New users';
$string['usersnoaccesssince'] = 'Inactive for more than';
$string['userswithfiles'] = 'Users with files';
$string['useruploadtype'] = 'User upload type: {$a}';
$string['userviewingsettings'] = 'Profile settings for {$a}';
$string['userzones'] = 'User zones';
$string['usetheme'] = 'Use theme';
$string['usingexistingcourse'] = 'Using existing course';
$string['valuealreadyused'] = 'This value has already been used.';
$string['version'] = 'Version';
$string['view'] = 'View';
$string['viewing'] = 'Viewing:';
$string['viewallcourses'] = 'View all courses';
$string['viewallcoursescategories'] = 'View all courses and categories';
$string['viewmore'] = 'View more';
$string['viewallsubcategories'] = 'View all subcategories';
$string['viewfileinpopup'] = 'View file in a popup window';
$string['viewprofile'] = 'View profile';
$string['views'] = 'Views';
$string['viewsolution'] = 'view solution';
$string['virusfound'] = 'Attention administrator! Clam AV has found a virus in a file uploaded by {$a->user} for the course {$a->course}. Here is the output of clamscan:';
$string['virusfoundlater'] = 'A file you uploaded on {$a->date} with the filename {$a->filename} for the course {$a->course} has since been found to contain a virus.  Here is a summary of what has happened to your file:

{$a->action}

If this was submitted work, you may want to resubmit it so that your tutor can see it.';
$string['virusfoundlateradmin'] = 'Attention administrator! A file that was uploaded on {$a->date} with the filename {$a->filename} for the course {$a->course} by the user {$a->user} has since been found to contain a virus.  Here is a summary of what has happened to the file:

{$a->action}

The user has also been notified.';
$string['virusfoundlateradminnolog'] = 'Attention administrator! A file that was uploaded with the filename {$a->filename} has since been found to contain a virus. Moodle was unable to resolve this file back to the user that originally uploaded it.

Here is a summary of what has happened to the file:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Virus found!';
$string['virusfounduser'] = 'The file you have uploaded, {$a->filename}, has been scanned by a virus checker and found to be infected! Your file upload was NOT successful.';
$string['virusplaceholder'] = 'This file that has been uploaded was found to contain a virus and has been moved or deleted and the user notified.';
$string['visible'] = 'Visible';
$string['visible_help'] = 'This setting determines whether the course appears in the list of courses. Apart from teachers and administrators, users are not allowed to enter the course.';
$string['visibletostudents'] = 'Visible to {$a}';
$string['warning'] = 'Warning';
$string['warningdeleteresource'] = 'Warning: {$a} is referred in a resource. Would you like to update the resource?';
$string['webpage'] = 'Web page';
$string['week'] = 'Week';
$string['weeks'] = 'weeks';
$string['weekhide'] = 'Hide this week from {$a}';
$string['weeklyoutline'] = 'Weekly outline';
$string['weekshow'] = 'Show this week to {$a}';
$string['welcometocourse'] = 'Welcome to {$a}';
$string['welcometocoursetext'] = 'Welcome to {$a->coursename}!

If you have not done so already, you should edit your profile page so that we can learn more about you:

  {$a->profileurl}';
$string['whatforlink'] = 'What do you want to do with the link?';
$string['whatforpage'] = 'What do you want to do with the text?';
$string['whattocallzip'] = 'What do you want to call the zip file?';
$string['whattodo'] = 'What to do';
$string['windowclosing'] = 'This window should close automatically. If not, please close it now.';
$string['withchosenfiles'] = 'With chosen files';
$string['withdisablednote'] = '{$a} (disabled)';
$string['withoutuserdata'] = 'without user data';
$string['withselectedusers'] = 'With selected users...';
$string['withselectedusers_help'] = '* Send message - For sending a message to one or more participants
* Add a new note - For adding a note to a selected participant
* Add a common note - For adding the same note to more than one participant';
$string['withuserdata'] = 'with user data';
$string['wordforstudent'] = 'Your word for Student';
$string['wordforstudenteg'] = 'eg Student, Participant etc';
$string['wordforstudents'] = 'Your word for Students';
$string['wordforstudentseg'] = 'eg Students, Participants etc';
$string['wordforteacher'] = 'Your word for Teacher';
$string['wordforteachereg'] = 'eg Teacher, Tutor, Facilitator etc';
$string['wordforteachers'] = 'Your word for Teachers';
$string['wordforteacherseg'] = 'eg Teachers, Tutors, Facilitators etc';
$string['writingblogsinfo'] = 'Writing blogs info';
$string['writingcategoriesandquestions'] = 'Writing categories and questions';
$string['writingcoursedata'] = 'Writing course data';
$string['writingeventsinfo'] = 'Writing events info';
$string['writinggeneralinfo'] = 'Writing general info';
$string['writinggradebookinfo'] = 'Writing gradebook info';
$string['writinggroupingsgroupsinfo'] = 'Writing groupings-groups info';
$string['writinggroupingsinfo'] = 'Writing groupings info';
$string['writinggroupsinfo'] = 'Writing groups info';
$string['writingheader'] = 'Writing header';
$string['writingloginfo'] = 'Writing logs info';
$string['writingmessagesinfo'] = 'Writing messages info';
$string['writingmoduleinfo'] = 'Writing modules info';
$string['writingscalesinfo'] = 'Writing scales info';
$string['writinguserinfo'] = 'Writing users info';
$string['wrongpassword'] = 'Incorrect password for this username';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'year';
$string['years'] = 'years';
$string['yes'] = 'Yes';
$string['youareabouttocreatezip'] = 'You are about to create a zip file containing';
$string['youaregoingtorestorefrom'] = 'You are about to start the restore process for';
$string['youneedtoenrol'] = 'To perform that action you need to enrol in this course.';
$string['yourlastlogin'] = 'Your last login was';
$string['yourself'] = 'yourself';
$string['yourteacher'] = 'your {$a}';
$string['yourwordforx'] = 'Your word for \'{$a}\'';
$string['zippingbackup'] = 'Zipping backup';
