<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Competency language file.
 *
 * @package    core_competency
 * @copyright  2016 Frédéric Massart - FMCorz.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'All children are complete';
$string['competencies'] = 'Competencies';
$string['competenciesarenotenabled'] = 'Competencies are not enabled.';
$string['competenciessettings'] = 'Competencies settings';
$string['completeplanstask'] = 'Complete learning plans which are due';
$string['coursecompetencyoutcome_complete'] = 'Complete the competency';
$string['coursecompetencyoutcome_evidence'] = 'Attach evidence';
$string['coursecompetencyoutcome_none'] = 'Do nothing';
$string['coursecompetencyoutcome_recommend'] = 'Send for review';
$string['coursemodulecompetencyoutcome_complete'] = 'Complete the competency';
$string['coursemodulecompetencyoutcome_evidence'] = 'Attach evidence';
$string['coursemodulecompetencyoutcome_none'] = 'Do nothing';
$string['coursemodulecompetencyoutcome_recommend'] = 'Send for review';
$string['deletecompetencyratings'] = 'Delete competency ratings';
$string['duplicateditemname'] = '{$a} (copy)';
$string['enablecompetencies'] = 'Enable competencies';
$string['enablecompetencies_desc'] = 'Competencies allow users to be assessed according to learning plans.';
$string['errorcannotchangeapastduedate'] = 'The due date has passed; it cannot be changed.';
$string['errorcannotsetduedateinthepast'] = 'The due date cannot be set in the past.';
$string['errorcannotsetduedatetoosoon'] = 'The due date is too soon.';
$string['errorcompetencyrule'] = 'Course competency rule \'{$a}\' unknown';
$string['errorcoursecompetencyrule'] = 'Course competency rule \'{$a}\' unknown';
$string['errorinvalidcourse'] = 'Invalid course.';
$string['errornocompetency'] = '{$a} competency can not be found';
$string['errorplanstatus'] = 'Learning plans \'{$a}\' status unknown';
$string['errorscalealreadyused'] = 'The scale cannot be changed, as it is already in use.';
$string['errorscaleconfiguration'] = 'The scale needs to be configured by selecting default and proficient items.';
$string['errorusercomptencystatus'] = 'User competency status \'{$a}\' unknown';
$string['eventcompetencycreated'] = 'Competency created.';
$string['eventcompetencydeleted'] = 'Competency deleted.';
$string['eventcompetencyframeworkcreated'] = 'Competency framework created.';
$string['eventcompetencyframeworkdeleted'] = 'Competency framework deleted.';
$string['eventcompetencyframeworkupdated'] = 'Competency framework updated.';
$string['eventcompetencyframeworkviewed'] = 'Competency framework viewed.';
$string['eventcompetencyupdated'] = 'Competency updated.';
$string['eventcompetencyviewed'] = 'Competency viewed.';
$string['eventevidencecreated'] = 'Evidence created.';
$string['eventplanapproved'] = 'Learning plan approved.';
$string['eventplancompleted'] = 'Learning plan completed.';
$string['eventplancreated'] = 'Learning plan created.';
$string['eventplandeleted'] = 'Learning plan deleted.';
$string['eventplanreopened'] = 'Learning plan reopened.';
$string['eventplanreviewrequestcancelled'] = 'Learning plan review request cancelled.';
$string['eventplanreviewrequested'] = 'Learning plan review requested.';
$string['eventplanreviewstarted'] = 'Learning plan review started.';
$string['eventplanreviewstopped'] = 'Learning plan review stopped.';
$string['eventplanunapproved'] = 'Learning plan unapproved.';
$string['eventplanunlinked'] = 'Learning plan unlinked.';
$string['eventplanupdated'] = 'Learning plan updated.';
$string['eventplanviewed'] = 'Learning plan viewed.';
$string['eventtemplatecreated'] = 'Learning plan template created.';
$string['eventtemplatedeleted'] = 'Learning plan template deleted.';
$string['eventtemplateupdated'] = 'Learning plan template updated.';
$string['eventtemplateviewed'] = 'Learning plan template viewed.';
$string['eventusercompetencyplanviewed'] = 'User competency plan viewed.';
$string['eventusercompetencyrated'] = 'User competency rated.';
$string['eventusercompetencyratedincourse'] = 'User competency rated in course.';
$string['eventusercompetencyratedinplan'] = 'User competency rated in a learning plan.';
$string['eventusercompetencyreviewrequestcancelled'] = 'User competency review request cancelled.';
$string['eventusercompetencyreviewrequested'] = 'User competency review requested.';
$string['eventusercompetencyreviewstarted'] = 'User competency review started.';
$string['eventusercompetencyreviewstopped'] = 'User competency review stopped.';
$string['eventusercompetencyviewed'] = 'User competency viewed.';
$string['eventusercompetencyviewedincourse'] = 'User competency viewed in a course.';
$string['eventusercompetencyviewedinplan'] = 'User competency viewed in a learning plan.';
$string['eventuserevidencecreated'] = 'Evidence of prior learning created.';
$string['eventuserevidencedeleted'] = 'Evidence of prior learning deleted.';
$string['eventuserevidenceupdated'] = 'Evidence of prior learning updated.';
$string['evidence_competencyrule'] = 'The rule of the competency was met.';
$string['evidence_coursecompleted'] = 'The course \'{$a}\' was completed.';
$string['evidence_coursemodulecompleted'] = 'The activity \'{$a}\' was completed.';
$string['evidence_courserestored'] = 'The rating was restored along with the course \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'The evidence of prior learning \'{$a}\' was linked.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'The evidence of prior learning \'{$a}\' was unlinked.';
$string['evidence_manualoverride'] = 'The competency rating was manually set.';
$string['evidence_manualoverrideincourse'] = 'The competency rating was manually set in the course \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'The competency rating was manually set in the learning plan \'{$a}\'.';
$string['invalidevidencedesc'] = 'Invalid evidence description';
$string['invalidgrade'] = 'Invalid rating';
$string['invalidpersistenterror'] = 'Error: {$a}';
$string['invalidplan'] = 'Invalid learning plan';
$string['invalidtaxonomy'] = 'Invalid taxonomy: {$a}';
$string['invalidurl'] = 'The URL is not valid. Make sure it starts with \'http://\' or \'https://\'.';
$string['planstatusactive'] = 'Active';
$string['planstatuscomplete'] = 'Complete';
$string['planstatusdraft'] = 'Draft';
$string['planstatusinreview'] = 'In review';
$string['planstatuswaitingforreview'] = 'Waiting for review';
$string['pointsrequiredaremet'] = 'Points required are met';
$string['pushcourseratingstouserplans'] = 'Push course ratings to individual learning plans';
$string['pushcourseratingstouserplans_desc'] = 'Default value for the course setting to update individual learning plans when course competencies are rated.';
$string['syncplanscohorts'] = 'Sync plans from learning plan template cohorts';
$string['taxonomy_behaviour'] = 'Behaviour';
$string['taxonomy_competency'] = 'Competency';
$string['taxonomy_concept'] = 'Concept';
$string['taxonomy_domain'] = 'Domain';
$string['taxonomy_indicator'] = 'Indicator';
$string['taxonomy_level'] = 'Level';
$string['taxonomy_outcome'] = 'Outcome';
$string['taxonomy_practice'] = 'Practice';
$string['taxonomy_proficiency'] = 'Proficiency';
$string['taxonomy_skill'] = 'Skill';
$string['taxonomy_value'] = 'Value';
$string['usercommentedonacompetency'] = '{$a->fullname} commented on the competency "{$a->competency}":

{$a->comment}

See: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} commented on the competency "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>See: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} commented on the competency "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} commented on a competency.';
$string['usercommentedonaplan'] = '{$a->fullname} commented on the learning plan "{$a->plan}":

{$a->comment}

See: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} commented on the learning plan "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>See: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} commented on the learning plan "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} commented on a learning plan.';
$string['usercompetencystatus_idle'] = 'Idle';
$string['usercompetencystatus_inreview'] = 'In review';
$string['usercompetencystatus_waitingforreview'] = 'Waiting for review';
$string['userplans'] = 'Learning plans';

// Deprecated since Moodle 3.2.
$string['invalidpersistent'] = 'Invalid persistent';
