/*
  +----------------------------------------------------------------------+
  | PHP Version 4                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2002 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 2.02 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/2_02.txt.                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author:                                                              |
  +----------------------------------------------------------------------+

  $Id: header,v 1.10 2002/02/28 08:25:27 sebastian Exp $ 
*/

#ifndef PHP_OPENFILER_H
#define PHP_OPENFILER_H

extern zend_module_entry openfiler_module_entry;
#define phpext_openfiler_ptr &openfiler_module_entry

#ifdef PHP_WIN32
#define PHP_OPENFILER_API __declspec(dllexport)
#else
#define PHP_OPENFILER_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(openfiler);
PHP_MSHUTDOWN_FUNCTION(openfiler);
PHP_RINIT_FUNCTION(openfiler);
PHP_RSHUTDOWN_FUNCTION(openfiler);
PHP_MINFO_FUNCTION(openfiler);

PHP_FUNCTION(confirm_openfiler_compiled);	/* For testing, remove later. */
PHP_FUNCTION(getpwent);
PHP_FUNCTION(endpwent);
PHP_FUNCTION(getgrent);
PHP_FUNCTION(endgrent);
PHP_FUNCTION(getnetent);
PHP_FUNCTION(endnetent);

/* 
  	Declare any global variables you may need between the BEGIN
	and END macros here:     

ZEND_BEGIN_MODULE_GLOBALS(openfiler)
	int   global_value;
	char *global_string;
ZEND_END_MODULE_GLOBALS(openfiler)
*/

/* In every utility function you add that needs to use variables 
   in php_openfiler_globals, call TSRM_FETCH(); after declaring other 
   variables used by that function, or better yet, pass in TSRMG_CC
   after the last function argument and declare your utility function
   with TSRMG_DC after the last declared argument.  Always refer to
   the globals in your function as OPENFILER_G(variable).  You are 
   encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define OPENFILER_G(v) TSRMG(openfiler_globals_id, zend_openfiler_globals *, v)
#else
#define OPENFILER_G(v) (openfiler_globals.v)
#endif

#endif	/* PHP_OPENFILER_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: t
 * End:
 */
