#!/bin/sh
#
# Creates X.509 certificates for Openfiler HTTPS (running under Apache 2.x.x)
#
# Copyright (C) 2004 Voluna Software. All rights reserved.
#

/usr/bin/openssl genrsa -out /opt/openfiler/etc/httpd/conf/ssl.key/openfiler-dummy-ca.key 1024
/bin/chmod 600 /opt/openfiler/etc/httpd/conf/ssl.key/openfiler-dummy-ca.key
/usr/bin/openssl req -new -key /opt/openfiler/etc/httpd/conf/ssl.key/openfiler-dummy-ca.key -x509 -days 365 -out /opt/openfiler/etc/httpd/conf/ssl.crt/openfiler-dummy-ca.crt
/bin/chmod 600 /opt/openfiler/etc/httpd/conf/ssl.crt/openfiler-dummy-ca.crt
/usr/bin/openssl genrsa -out /opt/openfiler/etc/httpd/conf/ssl.key/openfiler-dummy-server.key
/bin/chmod 600 /opt/openfiler/etc/httpd/conf/ssl.key/openfiler-dummy-server.key
/usr/bin/openssl req -new -key /opt/openfiler/etc/httpd/conf/ssl.key/openfiler-dummy-server.key -out /opt/openfiler/etc/httpd/conf/ssl.csr/openfiler-dummy-server.csr
/bin/chmod 600 /opt/openfiler/etc/httpd/conf/ssl.csr/openfiler-dummy-server.csr
/usr/bin/openssl x509 -req -days 365 -in /opt/openfiler/etc/httpd/conf/ssl.csr/openfiler-dummy-server.csr -CA /opt/openfiler/etc/httpd/conf/ssl.crt/openfiler-dummy-ca.crt -CAkey /opt/openfiler/etc/httpd/conf/ssl.key/openfiler-dummy-ca.key -CAcreateserial -out /opt/openfiler/etc/httpd/conf/ssl.crt/openfiler-dummy-server.crt
/bin/chmod 600 /opt/openfiler/etc/httpd/conf/ssl.crt/openfiler-dummy-server.crt

pushd .
cd /opt/openfiler/etc/httpd/conf/ssl.crt/
/usr/bin/make -fMakefile.crt
popd

