#region PDFsharp - A .NET library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005-2007 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
// http://sourceforge.net/projects/pdfsharp
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.
#endregion

using System;
using System.Runtime.InteropServices;
using System.ComponentModel;
using System.IO;
#if Gdip
using System.Drawing;
using System.Drawing.Drawing2D;
#endif
#if Wpf
using System.Windows.Media;
#endif
using PdfSharp.Internal;
using PdfSharp.Fonts.TrueType;
using PdfSharp.Pdf;
using PdfSharp.Pdf.Advanced;

namespace PdfSharp.Drawing
{
  /// <summary>
  /// Specifies details about the font used in PDF files.
  /// This class is still under construction and may change in future implementations.
  /// </summary>
  public class XPdfFontOptions
  {
    internal XPdfFontOptions()
    {
    }

    /// <summary>
    /// Initializes a new instance of the <see cref="XPdfFontOptions"/> class.
    /// </summary>
    /// <param name="embed">If set to <c>true</c> the font is embedded.</param>
    /// <param name="unicode">If set to <c>true</c> Unicode encoding is used.</param>
    /// <param name="baseFont">Not yet implemented. Should be "".</param>
    /// <param name="fontFile">Not yet implemented. Should be "".</param>
    public XPdfFontOptions(bool embed, bool unicode, string baseFont, string fontFile)
    {
      this.embed = embed;
      this.unicode = unicode;
      this.baseFont = baseFont == null ? "" : baseFont;
      this.fontFile = fontFile == null ? "" : fontFile;
    }

    /// <summary>
    /// Initializes a new instance of the <see cref="XPdfFontOptions"/> class.
    /// </summary>
    /// <param name="embed">If set to <c>true</c> the font is embedded.</param>
    /// <param name="baseFont">Not yet implemented. Should be "".</param>
    public XPdfFontOptions(bool embed, string baseFont)
      : this(embed, false, baseFont, "")
    { }

    /// <summary>
    /// Initializes a new instance of the <see cref="XPdfFontOptions"/> class.
    /// </summary>
    /// <param name="embed">If set to <c>true</c> the font is embedded.</param>
    /// <param name="unicode">If set to <c>true</c> Unicode encoding is used.</param>
    public XPdfFontOptions(bool embed, bool unicode)
      : this(embed, unicode, "", "")
    { }

    /// <summary>
    /// Initializes a new instance of the <see cref="XPdfFontOptions"/> class.
    /// </summary>
    /// <param name="embed">If set to <c>true</c> the font is embedded.</param>
    public XPdfFontOptions(bool embed)
      : this(embed, false, "", "")
    { }

    public bool Embed
    {
      get { return this.embed; }
    }
    bool embed;

    //public bool Subset
    //{
    //  get {return this.subset;}
    //}
    //bool subset;

    public bool Unicode
    {
      get { return this.unicode; }
    }
    bool unicode;

    public string BaseFont
    {
      get { return this.baseFont; }
    }
    string baseFont = "";

    public string FontFile
    {
      get { return this.fontFile; }
    }
    string fontFile = "";

    // this is part of XGraphics
    //    public double CharacterSpacing;
    //    public double WordSpacing;
    //    public double HorizontalScaling;
    //    public double Leading;
    //    public double TextRise;
    //    Kerning
  }
}
