#region PDFsharp - A .NET library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005-2007 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
// http://sourceforge.net/projects/pdfsharp
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.
#endregion

using System;
using System.Globalization;
using System.ComponentModel;
#if Gdip
using System.Drawing;
#endif
#if Wpf
using System.Windows.Media;
#endif
using PdfSharp.Internal;

namespace PdfSharp.Drawing
{
  ///<summary>
  /// Represents a set of 141 pre-defined RGB colors. Incidentally the values are the same
  /// as in System.Drawing.Color.
  /// </summary>
  public sealed class XColors
  {
    private XColors()
    { }

    ///<summary>Gets a predefined color.</summary>
    public static XColor AliceBlue { get { return new XColor(XKnownColor.AliceBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor AntiqueWhite { get { return new XColor(XKnownColor.AntiqueWhite); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Aqua { get { return new XColor(XKnownColor.Aqua); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Aquamarine { get { return new XColor(XKnownColor.Aquamarine); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Azure { get { return new XColor(XKnownColor.Azure); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Beige { get { return new XColor(XKnownColor.Beige); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Bisque { get { return new XColor(XKnownColor.Bisque); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Black { get { return new XColor(XKnownColor.Black); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor BlanchedAlmond { get { return new XColor(XKnownColor.BlanchedAlmond); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Blue { get { return new XColor(XKnownColor.Blue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor BlueViolet { get { return new XColor(XKnownColor.BlueViolet); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Brown { get { return new XColor(XKnownColor.Brown); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor BurlyWood { get { return new XColor(XKnownColor.BurlyWood); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor CadetBlue { get { return new XColor(XKnownColor.CadetBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Chartreuse { get { return new XColor(XKnownColor.Chartreuse); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Chocolate { get { return new XColor(XKnownColor.Chocolate); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Coral { get { return new XColor(XKnownColor.Coral); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor CornflowerBlue { get { return new XColor(XKnownColor.CornflowerBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Cornsilk { get { return new XColor(XKnownColor.Cornsilk); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Crimson { get { return new XColor(XKnownColor.Crimson); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Cyan { get { return new XColor(XKnownColor.Cyan); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkBlue { get { return new XColor(XKnownColor.DarkBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkCyan { get { return new XColor(XKnownColor.DarkCyan); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkGoldenrod { get { return new XColor(XKnownColor.DarkGoldenrod); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkGray { get { return new XColor(XKnownColor.DarkGray); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkGreen { get { return new XColor(XKnownColor.DarkGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkKhaki { get { return new XColor(XKnownColor.DarkKhaki); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkMagenta { get { return new XColor(XKnownColor.DarkMagenta); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkOliveGreen { get { return new XColor(XKnownColor.DarkOliveGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkOrange { get { return new XColor(XKnownColor.DarkOrange); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkOrchid { get { return new XColor(XKnownColor.DarkOrchid); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkRed { get { return new XColor(XKnownColor.DarkRed); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkSalmon { get { return new XColor(XKnownColor.DarkSalmon); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkSeaGreen { get { return new XColor(XKnownColor.DarkSeaGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkSlateBlue { get { return new XColor(XKnownColor.DarkSlateBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkSlateGray { get { return new XColor(XKnownColor.DarkSlateGray); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkTurquoise { get { return new XColor(XKnownColor.DarkTurquoise); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkViolet { get { return new XColor(XKnownColor.DarkViolet); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DeepPink { get { return new XColor(XKnownColor.DeepPink); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DeepSkyBlue { get { return new XColor(XKnownColor.DeepSkyBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DimGray { get { return new XColor(XKnownColor.DimGray); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor DodgerBlue { get { return new XColor(XKnownColor.DodgerBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Firebrick { get { return new XColor(XKnownColor.Firebrick); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor FloralWhite { get { return new XColor(XKnownColor.FloralWhite); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor ForestGreen { get { return new XColor(XKnownColor.ForestGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Fuchsia { get { return new XColor(XKnownColor.Fuchsia); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Gainsboro { get { return new XColor(XKnownColor.Gainsboro); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor GhostWhite { get { return new XColor(XKnownColor.GhostWhite); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Gold { get { return new XColor(XKnownColor.Gold); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Goldenrod { get { return new XColor(XKnownColor.Goldenrod); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Gray { get { return new XColor(XKnownColor.Gray); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Green { get { return new XColor(XKnownColor.Green); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor GreenYellow { get { return new XColor(XKnownColor.GreenYellow); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Honeydew { get { return new XColor(XKnownColor.Honeydew); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor HotPink { get { return new XColor(XKnownColor.HotPink); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor IndianRed { get { return new XColor(XKnownColor.IndianRed); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Indigo { get { return new XColor(XKnownColor.Indigo); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Ivory { get { return new XColor(XKnownColor.Ivory); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Khaki { get { return new XColor(XKnownColor.Khaki); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Lavender { get { return new XColor(XKnownColor.Lavender); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LavenderBlush { get { return new XColor(XKnownColor.LavenderBlush); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LawnGreen { get { return new XColor(XKnownColor.LawnGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LemonChiffon { get { return new XColor(XKnownColor.LemonChiffon); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightBlue { get { return new XColor(XKnownColor.LightBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightCoral { get { return new XColor(XKnownColor.LightCoral); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightCyan { get { return new XColor(XKnownColor.LightCyan); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightGoldenrodYellow { get { return new XColor(XKnownColor.LightGoldenrodYellow); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightGray { get { return new XColor(XKnownColor.LightGray); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightGreen { get { return new XColor(XKnownColor.LightGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightPink { get { return new XColor(XKnownColor.LightPink); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSalmon { get { return new XColor(XKnownColor.LightSalmon); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSeaGreen { get { return new XColor(XKnownColor.LightSeaGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSkyBlue { get { return new XColor(XKnownColor.LightSkyBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSlateGray { get { return new XColor(XKnownColor.LightSlateGray); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSteelBlue { get { return new XColor(XKnownColor.LightSteelBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightYellow { get { return new XColor(XKnownColor.LightYellow); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Lime { get { return new XColor(XKnownColor.Lime); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor LimeGreen { get { return new XColor(XKnownColor.LimeGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Linen { get { return new XColor(XKnownColor.Linen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Magenta { get { return new XColor(XKnownColor.Magenta); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Maroon { get { return new XColor(XKnownColor.Maroon); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumAquamarine { get { return new XColor(XKnownColor.MediumAquamarine); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumBlue { get { return new XColor(XKnownColor.MediumBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumOrchid { get { return new XColor(XKnownColor.MediumOrchid); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumPurple { get { return new XColor(XKnownColor.MediumPurple); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumSeaGreen { get { return new XColor(XKnownColor.MediumSeaGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumSlateBlue { get { return new XColor(XKnownColor.MediumSlateBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumSpringGreen { get { return new XColor(XKnownColor.MediumSpringGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumTurquoise { get { return new XColor(XKnownColor.MediumTurquoise); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumVioletRed { get { return new XColor(XKnownColor.MediumVioletRed); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MidnightBlue { get { return new XColor(XKnownColor.MidnightBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MintCream { get { return new XColor(XKnownColor.MintCream); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor MistyRose { get { return new XColor(XKnownColor.MistyRose); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Moccasin { get { return new XColor(XKnownColor.Moccasin); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor NavajoWhite { get { return new XColor(XKnownColor.NavajoWhite); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Navy { get { return new XColor(XKnownColor.Navy); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor OldLace { get { return new XColor(XKnownColor.OldLace); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Olive { get { return new XColor(XKnownColor.Olive); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor OliveDrab { get { return new XColor(XKnownColor.OliveDrab); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Orange { get { return new XColor(XKnownColor.Orange); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor OrangeRed { get { return new XColor(XKnownColor.OrangeRed); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Orchid { get { return new XColor(XKnownColor.Orchid); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor PaleGoldenrod { get { return new XColor(XKnownColor.PaleGoldenrod); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor PaleGreen { get { return new XColor(XKnownColor.PaleGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor PaleTurquoise { get { return new XColor(XKnownColor.PaleTurquoise); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor PaleVioletRed { get { return new XColor(XKnownColor.PaleVioletRed); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor PapayaWhip { get { return new XColor(XKnownColor.PapayaWhip); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor PeachPuff { get { return new XColor(XKnownColor.PeachPuff); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Peru { get { return new XColor(XKnownColor.Peru); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Pink { get { return new XColor(XKnownColor.Pink); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Plum { get { return new XColor(XKnownColor.Plum); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor PowderBlue { get { return new XColor(XKnownColor.PowderBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Purple { get { return new XColor(XKnownColor.Purple); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Red { get { return new XColor(XKnownColor.Red); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor RosyBrown { get { return new XColor(XKnownColor.RosyBrown); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor RoyalBlue { get { return new XColor(XKnownColor.RoyalBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor SaddleBrown { get { return new XColor(XKnownColor.SaddleBrown); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Salmon { get { return new XColor(XKnownColor.Salmon); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor SandyBrown { get { return new XColor(XKnownColor.SandyBrown); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor SeaGreen { get { return new XColor(XKnownColor.SeaGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor SeaShell { get { return new XColor(XKnownColor.SeaShell); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Sienna { get { return new XColor(XKnownColor.Sienna); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Silver { get { return new XColor(XKnownColor.Silver); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor SkyBlue { get { return new XColor(XKnownColor.SkyBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor SlateBlue { get { return new XColor(XKnownColor.SlateBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor SlateGray { get { return new XColor(XKnownColor.SlateGray); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Snow { get { return new XColor(XKnownColor.Snow); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor SpringGreen { get { return new XColor(XKnownColor.SpringGreen); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor SteelBlue { get { return new XColor(XKnownColor.SteelBlue); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Tan { get { return new XColor(XKnownColor.Tan); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Teal { get { return new XColor(XKnownColor.Teal); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Thistle { get { return new XColor(XKnownColor.Thistle); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Tomato { get { return new XColor(XKnownColor.Tomato); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Transparent { get { return new XColor(XKnownColor.Transparent); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Turquoise { get { return new XColor(XKnownColor.Turquoise); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Violet { get { return new XColor(XKnownColor.Violet); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Wheat { get { return new XColor(XKnownColor.Wheat); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor White { get { return new XColor(XKnownColor.White); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor WhiteSmoke { get { return new XColor(XKnownColor.WhiteSmoke); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor Yellow { get { return new XColor(XKnownColor.Yellow); } }
    ///<summary>Gets a predefined color.</summary>
    public static XColor YellowGreen { get { return new XColor(XKnownColor.YellowGreen); } }
  }

  internal class XKnownColorTable
  {
    private static uint[] colorTable;

    public static uint KnownColorToArgb(XKnownColor color)
    {
      if (XKnownColorTable.colorTable == null)
        InitColorTable();
      if (color <= XKnownColor.YellowGreen)
        return XKnownColorTable.colorTable[(int)color];
      return 0;
    }

    private static void InitColorTable()
    {
      // Same values as in GDI+ and System.Windows.Media.XColors
      uint[] colors = new uint[141];
      colors[0] = 0xFFF0F8FF;  // AliceBlue
      colors[1] = 0xFFFAEBD7;  // AntiqueWhite
      colors[2] = 0xFF00FFFF;  // Aqua
      colors[3] = 0xFF7FFFD4;  // Aquamarine
      colors[4] = 0xFFF0FFFF;  // Azure
      colors[5] = 0xFFF5F5DC;  // Beige
      colors[6] = 0xFFFFE4C4;  // Bisque
      colors[7] = 0xFF000000;  // Black
      colors[8] = 0xFFFFEBCD;  // BlanchedAlmond
      colors[9] = 0xFF0000FF;  // Blue
      colors[10] = 0xFF8A2BE2;  // BlueViolet
      colors[11] = 0xFFA52A2A;  // Brown
      colors[12] = 0xFFDEB887;  // BurlyWood
      colors[13] = 0xFF5F9EA0;  // CadetBlue
      colors[14] = 0xFF7FFF00;  // Chartreuse
      colors[15] = 0xFFD2691E;  // Chocolate
      colors[16] = 0xFFFF7F50;  // Coral
      colors[17] = 0xFF6495ED;  // CornflowerBlue
      colors[18] = 0xFFFFF8DC;  // Cornsilk
      colors[29] = 0xFFDC143C;  // Crimson
      colors[20] = 0xFF00FFFF;  // Cyan
      colors[21] = 0xFF00008B;  // DarkBlue
      colors[22] = 0xFF008B8B;  // DarkCyan
      colors[23] = 0xFFB8860B;  // DarkGoldenrod
      colors[24] = 0xFFA9A9A9;  // DarkGray
      colors[25] = 0xFF006400;  // DarkGreen
      colors[26] = 0xFFBDB76B;  // DarkKhaki
      colors[27] = 0xFF8B008B;  // DarkMagenta
      colors[28] = 0xFF556B2F;  // DarkOliveGreen
      colors[29] = 0xFFFF8C00;  // DarkOrange
      colors[30] = 0xFF9932CC;  // DarkOrchid
      colors[31] = 0xFF8B0000;  // DarkRed
      colors[32] = 0xFFE9967A;  // DarkSalmon
      colors[33] = 0xFF8FBC8B;  // DarkSeaGreen
      colors[34] = 0xFF483D8B;  // DarkSlateBlue
      colors[35] = 0xFF2F4F4F;  // DarkSlateGray
      colors[36] = 0xFF00CED1;  // DarkTurquoise
      colors[37] = 0xFF9400D3;  // DarkViolet
      colors[38] = 0xFFFF1493;  // DeepPink
      colors[39] = 0xFF00BFFF;  // DeepSkyBlue
      colors[40] = 0xFF696969;  // DimGray
      colors[41] = 0xFF1E90FF;  // DodgerBlue
      colors[42] = 0xFFB22222;  // Firebrick
      colors[43] = 0xFFFFFAF0;  // FloralWhite
      colors[44] = 0xFF228B22;  // ForestGreen
      colors[45] = 0xFFFF00FF;  // Fuchsia
      colors[46] = 0xFFDCDCDC;  // Gainsboro
      colors[47] = 0xFFF8F8FF;  // GhostWhite
      colors[48] = 0xFFFFD700;  // Gold
      colors[49] = 0xFFDAA520;  // Goldenrod
      colors[50] = 0xFF808080;  // Gray
      colors[51] = 0xFF008000;  // Green
      colors[52] = 0xFFADFF2F;  // GreenYellow
      colors[53] = 0xFFF0FFF0;  // Honeydew
      colors[54] = 0xFFFF69B4;  // HotPink
      colors[55] = 0xFFCD5C5C;  // IndianRed
      colors[56] = 0xFF4B0082;  // Indigo
      colors[57] = 0xFFFFFFF0;  // Ivory
      colors[58] = 0xFFF0E68C;  // Khaki
      colors[59] = 0xFFE6E6FA;  // Lavender
      colors[60] = 0xFFFFF0F5;  // LavenderBlush
      colors[61] = 0xFF7CFC00;  // LawnGreen
      colors[62] = 0xFFFFFACD;  // LemonChiffon
      colors[63] = 0xFFADD8E6;  // LightBlue
      colors[64] = 0xFFF08080;  // LightCoral
      colors[65] = 0xFFE0FFFF;  // LightCyan
      colors[66] = 0xFFFAFAD2;  // LightGoldenrodYellow
      colors[67] = 0xFFD3D3D3;  // LightGray
      colors[68] = 0xFF90EE90;  // LightGreen
      colors[69] = 0xFFFFB6C1;  // LightPink
      colors[70] = 0xFFFFA07A;  // LightSalmon
      colors[71] = 0xFF20B2AA;  // LightSeaGreen
      colors[72] = 0xFF87CEFA;  // LightSkyBlue
      colors[73] = 0xFF778899;  // LightSlateGray
      colors[74] = 0xFFB0C4DE;  // LightSteelBlue
      colors[75] = 0xFFFFFFE0;  // LightYellow
      colors[76] = 0xFF00FF00;  // Lime
      colors[77] = 0xFF32CD32;  // LimeGreen
      colors[78] = 0xFFFAF0E6;  // Linen
      colors[79] = 0xFFFF00FF;  // Magenta
      colors[80] = 0xFF800000;  // Maroon
      colors[81] = 0xFF66CDAA;  // MediumAquamarine
      colors[82] = 0xFF0000CD;  // MediumBlue
      colors[83] = 0xFFBA55D3;  // MediumOrchid
      colors[84] = 0xFF9370DB;  // MediumPurple
      colors[85] = 0xFF3CB371;  // MediumSeaGreen
      colors[86] = 0xFF7B68EE;  // MediumSlateBlue
      colors[87] = 0xFF00FA9A;  // MediumSpringGreen
      colors[88] = 0xFF48D1CC;  // MediumTurquoise
      colors[89] = 0xFFC71585;  // MediumVioletRed
      colors[90] = 0xFF191970;  // MidnightBlue
      colors[91] = 0xFFF5FFFA;  // MintCream
      colors[92] = 0xFFFFE4E1;  // MistyRose
      colors[93] = 0xFFFFE4B5;  // Moccasin
      colors[94] = 0xFFFFDEAD;  // NavajoWhite
      colors[95] = 0xFF000080;  // Navy
      colors[96] = 0xFFFDF5E6;  // OldLace
      colors[97] = 0xFF808000;  // Olive
      colors[98] = 0xFF6B8E23;  // OliveDrab
      colors[99] = 0xFFFFA500;  // Orange
      colors[100] = 0xFFFF4500;  // OrangeRed
      colors[101] = 0xFFDA70D6;  // Orchid
      colors[102] = 0xFFEEE8AA;  // PaleGoldenrod
      colors[103] = 0xFF98FB98;  // PaleGreen
      colors[104] = 0xFFAFEEEE;  // PaleTurquoise
      colors[105] = 0xFFDB7093;  // PaleVioletRed
      colors[106] = 0xFFFFEFD5;  // PapayaWhip
      colors[107] = 0xFFFFDAB9;  // PeachPuff
      colors[108] = 0xFFCD853F;  // Peru
      colors[109] = 0xFFFFC0CB;  // Pink
      colors[110] = 0xFFDDA0DD;  // Plum
      colors[111] = 0xFFB0E0E6;  // PowderBlue
      colors[112] = 0xFF800080;  // Purple
      colors[113] = 0xFFFF0000;  // Red
      colors[114] = 0xFFBC8F8F;  // RosyBrown
      colors[115] = 0xFF4169E1;  // RoyalBlue
      colors[116] = 0xFF8B4513;  // SaddleBrown
      colors[117] = 0xFFFA8072;  // Salmon
      colors[118] = 0xFFF4A460;  // SandyBrown
      colors[119] = 0xFF2E8B57;  // SeaGreen
      colors[120] = 0xFFFFF5EE;  // SeaShell
      colors[121] = 0xFFA0522D;  // Sienna
      colors[122] = 0xFFC0C0C0;  // Silver
      colors[123] = 0xFF87CEEB;  // SkyBlue
      colors[124] = 0xFF6A5ACD;  // SlateBlue
      colors[125] = 0xFF708090;  // SlateGray
      colors[126] = 0xFFFFFAFA;  // Snow
      colors[127] = 0xFF00FF7F;  // SpringGreen
      colors[128] = 0xFF4682B4;  // SteelBlue
      colors[129] = 0xFFD2B48C;  // Tan
      colors[130] = 0xFF008080;  // Teal
      colors[131] = 0xFFD8BFD8;  // Thistle
      colors[132] = 0xFFFF6347;  // Tomato
      colors[133] = 0x00FFFFFF;  // Transparent
      colors[134] = 0xFF40E0D0;  // Turquoise
      colors[135] = 0xFFEE82EE;  // Violet
      colors[136] = 0xFFF5DEB3;  // Wheat
      colors[137] = 0xFFFFFFFF;  // White
      colors[138] = 0xFFF5F5F5;  // WhiteSmoke
      colors[139] = 0xFFFFFF00;  // Yellow
      colors[140] = 0xFF9ACD32;  // YellowGreen

      XKnownColorTable.colorTable = colors;
    }
  }

  struct ColorHack
  {
    public ColorHack(XColor color, int RGB, string Name, string NameDE)
    {
      this.color = color;
      this.RGB = RGB;
      this.Name = Name;
      this.NameDE = NameDE;
    }
    public XColor color;
    public int RGB;
    public string Name;
    public string NameDE;
  }

  public class XColorTable
  {
    static public void Test()
    {

      for (int idx = 0; idx < table.Length; idx++)
      {
        ColorHack c2 = table[idx];
        if (c2.RGB != c2.color.Rgb)
          c2.GetType();
      }
    }
    // http://unnecessary.de/wuest/farbtab/farbtabelle-w.html
    // http://blog.patrickkempf.de/archives/2004/04/10/html-farben/
    // http://www.grafikwunder.de/Grafikecke/Farbtabelle/farbtabelle-006.php
    static ColorHack[] table = new ColorHack[]
    {
      new ColorHack(XColors.Black, 0x000000, "Black", "Schwarz"),
      new ColorHack(XColors.DarkSlateGray, 0x8FBC8F, "Darkslategray", "Dunkles Schiefergrau"),
      new ColorHack(XColors.SlateGray, 0x708090, "Slategray", "Schiefergrau"),
      new ColorHack(XColors.LightSlateGray, 0x778899, "Lightslategray", "Helles Schiefergrau"),
      new ColorHack(XColors.LightSteelBlue, 0xB0C4DE, "Lightsteelblue", "Helles Stahlblau"),
      new ColorHack(XColors.DimGray, 0x696969, "Dimgray", "Mattes Grau"),
      new ColorHack(XColors.Gray, 0x808080, "Gray", "Grau"),
      new ColorHack(XColors.DarkGray, 0xA9A9A9, "Darkgray", "Dunkelgrau"),
      new ColorHack(XColors.Silver, 0xC0C0C0, "Silver", "Silber"),
      new ColorHack(XColors.Gainsboro, 0xDCDCDC, "Gainsboro", "Gainsboro"),
      new ColorHack(XColors.WhiteSmoke, 0xF5F5F5, "Whitesmoke", "Rauchiges Wei"),
      new ColorHack(XColors.GhostWhite, 0xF8F8FF, "Ghostwhite", "Geisterwei"),
      new ColorHack(XColors.White, 0xFFFFFF, "White", "Wei"),
      new ColorHack(XColors.Snow, 0xFFFAFA, "Snow", "Schneewei"),
      new ColorHack(XColors.Ivory, 0xFFFFF0, "Ivory", "Elfenbein"),
      new ColorHack(XColors.FloralWhite, 0xFFFAF0, "Floralwhite", "Bltenwei"),
      new ColorHack(XColors.SeaShell, 0xFFF5EE, "Seashell", "Muschel"),
      new ColorHack(XColors.OldLace, 0xFDF5E6, "Oldlace", "Altgold"),
      new ColorHack(XColors.Linen, 0xFAF0E6, "Linen", "Leinenfarbe"),
      new ColorHack(XColors.AntiqueWhite, 0xFAEBD7, "Antiquewhite", "Antikes Wei"),
      new ColorHack(XColors.BlanchedAlmond, 0xFFEBCD, "Blanchedalmond", "Mandelwei"),
      new ColorHack(XColors.PapayaWhip, 0xFFEFD5, "Papayawhip", "Cremiges Papaya"),
      new ColorHack(XColors.Beige, 0xF5F5DC, "Beige", "Beige"),
      new ColorHack(XColors.Cornsilk, 0xFFF8DC, "Cornsilk", "Mais"),
      new ColorHack(XColors.LightGoldenrodYellow, 0xFAFAD2, "Lightgoldenrodyellow", "Helles Goldrutengelb"),
      new ColorHack(XColors.LightYellow, 0xFFFFE0, "Lightyellow", "Hellgelb"),
      new ColorHack(XColors.LemonChiffon, 0xFFFACD, "Lemonchiffon", "Chiffongelb"),
      new ColorHack(XColors.PaleGoldenrod, 0xEEE8AA, "Palegoldenrod", "Blasse Goldrutenfarbe"),
      new ColorHack(XColors.Khaki, 0xF0E68C, "Khaki", "Khaki"),
      new ColorHack(XColors.Yellow, 0xFFFF00, "Yellow", "Gelb"),
      new ColorHack(XColors.Gold, 0xFFD700, "Gold", "Gold"),
      new ColorHack(XColors.Orange, 0xFFA500, "Orange", "Orange"),
      new ColorHack(XColors.DarkOrange, 0xFF8C00, "Darkorange", "Dunkles Orange"),
      new ColorHack(XColors.Goldenrod, 0xDAA520, "Goldenrod", "Goldrute"),
      new ColorHack(XColors.DarkGoldenrod, 0xB8860B, "Darkgoldenrod", "dunkle Goldrutenfarbe"),
      new ColorHack(XColors.Peru, 0xCD853F, "Peru", "Peru"),
      new ColorHack(XColors.Chocolate, 0xD2691E, "Chocolate", "Schokolade"),
      new ColorHack(XColors.SaddleBrown, 0x8B4513, "Saddlebrown", "Sattelbraun"),
      new ColorHack(XColors.Sienna, 0xA0522D, "Sienna", "Ocker"),
      new ColorHack(XColors.Brown, 0xA52A2A, "Brown", "Braun"),
      new ColorHack(XColors.DarkRed, 0x8B0000, "Darkred", "Dunkelrot"),
      new ColorHack(XColors.Maroon, 0x800000, "Maroon", "Kastanienbraun"),
      new ColorHack(XColors.PaleTurquoise, 0xAFEEEE, "Paleturquoise", "Blasses Trkis"),
      new ColorHack(XColors.Firebrick, 0xB22222, "Firebrick", "Ziegelfarbe"),
      new ColorHack(XColors.IndianRed, 0xCD5C5C, "Indianred", "Indischrot"),
      new ColorHack(XColors.Crimson, 0xDC143C, "Crimson", "Karmesinrot"),
      new ColorHack(XColors.Red, 0xFF0000, "Red", "Rot"),
      new ColorHack(XColors.OrangeRed, 0xFF4500, "Orangered", "Orangenrot"),
      new ColorHack(XColors.Tomato, 0xFF6347, "Tomato", "Tomatenrot"),
      new ColorHack(XColors.Coral, 0xFF7F50, "Coral", "Koralle"),
      new ColorHack(XColors.Salmon, 0xFA8072, "Salmon", "Lachs"),
      new ColorHack(XColors.LightCoral, 0xF08080, "Lightcoral", "Helles Korallenrot"),
      new ColorHack(XColors.DarkSalmon, 0xE9967A, "Darksalmon", "Dunkle Lachsfarbe"),
      new ColorHack(XColors.LightSalmon, 0xFFA07A, "Lightsalmon", "Helle Lachsfarbe"),
      new ColorHack(XColors.SandyBrown, 0xF4A460, "Sandybrown", "Sandbraun"),
      new ColorHack(XColors.RosyBrown, 0xBC8F8F, "Rosybrown", "Rosiges Braun"),
      new ColorHack(XColors.Tan, 0xD2B48C, "Tan", "Gelbbraun"),
      new ColorHack(XColors.BurlyWood, 0xDEB887, "Burlywood", "Grobes Braun"),
      new ColorHack(XColors.Wheat, 0xF5DEB3, "Wheat", "Weizen"),
      new ColorHack(XColors.PeachPuff, 0xFFDAB9, "Peachpuff", "Pfirsich"),
      new ColorHack(XColors.NavajoWhite, 0xFFDEAD, "Navajowhite", "Navajowei"),
      new ColorHack(XColors.Bisque, 0xFFE4C4, "Bisque", "Tomatencreme"),
      new ColorHack(XColors.LavenderBlush, 0xFFF0F5, "Lavenderblush", "Rosige Lavenderfarbe"),
      new ColorHack(XColors.MistyRose, 0xFFE4E1, "Mistyrose", "Altrosa"),
      new ColorHack(XColors.Pink, 0xFFC0CB, "Pink", "Rosa"),
      new ColorHack(XColors.LightPink, 0xFFB6C1, "Lightpink", "Hellrosa"),
      new ColorHack(XColors.HotPink, 0xFF69B4, "Hotpink", "Leuchtendes Rosa"),
      new ColorHack(XColors.Fuchsia, 0xFF00FF, "Fuchsia", "Fuchsie"),
      new ColorHack(XColors.Magenta, 0xFF00FF, "Magenta", "Magentarot"),
      new ColorHack(XColors.DeepPink, 0xFF1493, "Deeppink", "Tiefrosa"),
      new ColorHack(XColors.MediumVioletRed, 0xC71585, "Mediumvioletred", "Mittleres Violettrot"),
      new ColorHack(XColors.PaleVioletRed, 0xDB7093, "Palevioletred", "Blasses Violettrot"),
      new ColorHack(XColors.Plum, 0xDDA0DD, "Plum", "Pflaume"),
      new ColorHack(XColors.Thistle, 0xD8BFD8, "Thistle", "Distel"),
      new ColorHack(XColors.Lavender, 0xE6E6FA, "Lavender", "Lavendelfarbe"),
      new ColorHack(XColors.Violet, 0xEE82EE, "Violet", "Violett"),
      new ColorHack(XColors.Orchid, 0xDA70D6, "Orchid", "Orchidee"),
      new ColorHack(XColors.DarkMagenta, 0x8B008B, "Darkmagenta", "Dunkles Magentarot"),
      new ColorHack(XColors.Purple, 0x800080, "Purple", "Violett"),
      new ColorHack(XColors.Indigo, 0x4B0082, "Indigo", "Indigo"),
      new ColorHack(XColors.BlueViolet, 0x8A2BE2, "Blueviolet", "Blauviolett"),
      new ColorHack(XColors.DarkViolet, 0x9400D3, "Darkviolet", "Dunkles Violett"),
      new ColorHack(XColors.DarkOrchid, 0x9932CC, "Darkorchid", "Dunkle Orchideenfarbe"),
      new ColorHack(XColors.MediumPurple, 0x9370DB, "Mediumpurple", "Mittleres Violett"),
      new ColorHack(XColors.MediumOrchid, 0xBA55D3, "Mediumorchid", "Mittlere Orchideenfarbe"),
      new ColorHack(XColors.MediumSlateBlue, 0x7B68EE, "Mediumslateblue", "Mittleres Schieferblau"),
      new ColorHack(XColors.SlateBlue, 0x6A5ACD, "Slateblue", "Schieferblau"),
      new ColorHack(XColors.DarkSlateBlue, 0x483D8B, "Darkslateblue", "Dunkles Schiefergrau"),
      new ColorHack(XColors.MidnightBlue, 0x191970, "Midnightblue", "Mitternachtsblau"),
      new ColorHack(XColors.Navy, 0x000080, "Navy", "Marineblau"),
      new ColorHack(XColors.DarkBlue, 0x00008B, "Darkblue", "Dunkelblau"),
      new ColorHack(XColors.LightGray, 0xD3D3D3, "Lightgray", "Hellgrau"),
      new ColorHack(XColors.MediumBlue, 0x0000CD, "Mediumblue", "Mittelblau"),
      new ColorHack(XColors.Blue, 0x0000FF, "Blue", "Blau"),
      new ColorHack(XColors.RoyalBlue, 0x4169E1, "Royalblue", "Knigsblau"),
      new ColorHack(XColors.SteelBlue, 0x4682B4, "Steelblue", "Stahlblau"),
      new ColorHack(XColors.CornflowerBlue, 0x6495ED, "Cornflowerblue", "Kornblumenblau"),
      new ColorHack(XColors.DodgerBlue, 0x1E90FF, "Dodgerblue", "Dodger-Blau"),
      new ColorHack(XColors.DeepSkyBlue, 0x00BFFF, "Deepskyblue", "Tiefes Himmelblau"),
      new ColorHack(XColors.LightSkyBlue, 0x87CEFA, "Lightskyblue", "Helles Himmelblau"),
      new ColorHack(XColors.SkyBlue, 0x87CEEB, "Skyblue", "Himmelblau"),
      new ColorHack(XColors.LightBlue, 0xADD8E6, "Lightblue", "Hellblau"),
      new ColorHack(XColors.Cyan, 0x00FFFF, "Cyan", "Zyanblau"),
      new ColorHack(XColors.Aqua, 0x00FFFF, "Aqua", "Blaugrn"),
      new ColorHack(XColors.PowderBlue, 0xB0E0E6, "Powderblue", "Taubenblau"),
      new ColorHack(XColors.LightCyan, 0xE0FFFF, "Lightcyan", "Helles Cyanblau"),
      new ColorHack(XColors.AliceBlue, 0xA0CE00, "Aliceblue", "Aliceblau"),
      new ColorHack(XColors.Azure, 0xF0FFFF, "Azure", "Himmelblau"),
      new ColorHack(XColors.MintCream, 0xF5FFFA, "Mintcream", "Cremige Pfefferminzfarbe"),
      new ColorHack(XColors.Honeydew, 0xF0FFF0, "Honeydew", "Honigmelone"),
      new ColorHack(XColors.Aquamarine, 0x7FFFD4, "Aquamarine", "Aquamarinblau"),
      new ColorHack(XColors.Turquoise, 0x40E0D0, "Turquoise", "Trkis"),
      new ColorHack(XColors.MediumTurquoise, 0x48D1CC, "Mediumturqoise", "Mittleres Trkis"),
      new ColorHack(XColors.DarkTurquoise, 0x00CED1, "Darkturquoise", "Dunkles Trkis"),
      new ColorHack(XColors.MediumAquamarine, 0x66CDAA, "Mediumaquamarine", "Mittleres Aquamarinblau"),
      new ColorHack(XColors.LightSeaGreen, 0x20B2AA, "Lightseagreen", "Helles Seegrn"),
      new ColorHack(XColors.DarkCyan, 0x008B8B, "Darkcyan", "Dunkles Zyanblau"),
      new ColorHack(XColors.Teal, 0x008080, "Teal", "Entenbraun"),
      new ColorHack(XColors.CadetBlue, 0x5F9EA0, "Cadetblue", "Kadettblau"),
      new ColorHack(XColors.MediumSeaGreen, 0x3CB371, "Mediumseagreen", "Mittleres Seegrn"),
      new ColorHack(XColors.DarkSeaGreen, 0x8FBC8F, "Darkseagreen", "Dunkles Seegrn"),
      new ColorHack(XColors.LightGreen, 0x90EE90, "Lightgreen", "Hellgrn"),
      new ColorHack(XColors.PaleGreen, 0x98FB98, "Palegreen", "Blassgrn"),
      new ColorHack(XColors.MediumSpringGreen, 0x00FA9A, "Mediumspringgreen", "Mittleres Frhlingsgrn"),
      new ColorHack(XColors.SpringGreen, 0x00FF7F, "Springgreen", "Frhlingsgrn"),
      new ColorHack(XColors.Lime, 0x00FF00, "Lime", "Zitronengrn"),
      new ColorHack(XColors.LimeGreen, 0x32CD32, "Limegreen", "Gelbgrn"),
      new ColorHack(XColors.SeaGreen, 0x2E8B57, "Seagreen", "Seegrn"),
      new ColorHack(XColors.ForestGreen, 0x228B22, "Forestgreen", "Waldgrn"),
      new ColorHack(XColors.Green, 0x008000, "Green", "Grn"),
      new ColorHack(XColors.DarkGreen, 0x006400, "Darkgreen", "Dunkelgrn"),
      new ColorHack(XColors.OliveDrab, 0x6B8E23, "Olivedrab", "Olivfarbiges Graubraun"),
      new ColorHack(XColors.DarkOliveGreen, 0x556B2F, "Darkolivegreen", "Dunkles Olivgrn"),
      new ColorHack(XColors.Olive, 0x808000, "Olive", "Olivgrn"),
      new ColorHack(XColors.DarkKhaki, 0xBDB76B, "Darkkhaki", "Dunkles Khaki"),
      new ColorHack(XColors.YellowGreen, 0x9ACD32, "Yellowgreen", "Gelbgrn"),
      new ColorHack(XColors.Chartreuse, 0x7FFF00, "Chartreuse", "Hellgrn"),
      new ColorHack(XColors.GreenYellow, 0xADFF2F, "Greenyellow", "Grngelb"),
    };
  }

  /*
    enum KnownColor
    {
      AliceBlue            =   0,
      AntiqueWhite         =   1,
      Aqua                 =   2,
      Aquamarine           =   3,
      Azure                =   4,
      Beige                =   5,
      Bisque               =   6,
      Black                =   7,
      BlanchedAlmond       =   8,
      Blue                 =   9,
      BlueViolet           =  10,
      Brown                =  11,
      BurlyWood            =  12,
      CadetBlue            =  13,
      Chartreuse           =  14,
      Chocolate            =  15,
      Coral                =  16,
      CornflowerBlue       =  17,
      Cornsilk             =  18,
      Crimson              =  29,
      Cyan                 =  20,
      DarkBlue             =  21,
      DarkCyan             =  22,
      DarkGoldenrod        =  23,
      DarkGray             =  24,
      DarkGreen            =  25,
      DarkKhaki            =  26,
      DarkMagenta          =  27,
      DarkOliveGreen       =  28,
      DarkOrange           =  29,
      DarkOrchid           =  30,
      DarkRed              =  31,
      DarkSalmon           =  32,
      DarkSeaGreen         =  33,
      DarkSlateBlue        =  34,
      DarkSlateGray        =  35,
      DarkTurquoise        =  36,
      DarkViolet           =  37,
      DeepPink             =  38,
      DeepSkyBlue          =  39,
      DimGray              =  40,
      DodgerBlue           =  41,
      Firebrick            =  42,
      FloralWhite          =  43,
      ForestGreen          =  44,
      Fuchsia              =  45,
      Gainsboro            =  46,
      GhostWhite           =  47,
      Gold                 =  48,
      Goldenrod            =  49,
      Gray                 =  50,
      Green                =  51,
      GreenYellow          =  52,
      Honeydew             =  53,
      HotPink              =  54,
      IndianRed            =  55,
      Indigo               =  56,
      Ivory                =  57,
      Khaki                =  58,
      Lavender             =  59,
      LavenderBlush        =  60,
      LawnGreen            =  61,
      LemonChiffon         =  62,
      LightBlue            =  63,
      LightCoral           =  64,
      LightCyan            =  65,
      LightGoldenrodYellow =  66,
      LightGray            =  67,
      LightGreen           =  68,
      LightPink            =  69,
      LightSalmon          =  70,
      LightSeaGreen        =  71,
      LightSkyBlue         =  72,
      LightSlateGray       =  73,
      LightSteelBlue       =  74,
      LightYellow          =  75,
      Lime                 =  76,
      LimeGreen            =  77,
      Linen                =  78,
      Magenta              =  79,
      Maroon               =  80,
      MediumAquamarine     =  81,
      MediumBlue           =  82,
      MediumOrchid         =  83,
      MediumPurple         =  84,
      MediumSeaGreen       =  85,
      MediumSlateBlue      =  86,
      MediumSpringGreen    =  87,
      MediumTurquoise      =  88,
      MediumVioletRed      =  89,
      MidnightBlue         =  90,
      MintCream            =  91,
      MistyRose            =  92,
      Moccasin             =  93,
      NavajoWhite          =  94,
      Navy                 =  95,
      OldLace              =  96,
      Olive                =  97,
      OliveDrab            =  98,
      Orange               =  99,
      OrangeRed            = 100,
      Orchid               = 101,
      PaleGoldenrod        = 102,
      PaleGreen            = 103,
      PaleTurquoise        = 104,
      PaleVioletRed        = 105,
      PapayaWhip           = 106,
      PeachPuff            = 107,
      Peru                 = 108,
      Pink                 = 109,
      Plum                 = 110,
      PowderBlue           = 111,
      Purple               = 112,
      Red                  = 113,
      RosyBrown            = 114,
      RoyalBlue            = 115,
      SaddleBrown          = 116,
      Salmon               = 117,
      SandyBrown           = 118,
      SeaGreen             = 119,
      SeaShell             = 120,
      Sienna               = 121,
      Silver               = 122,
      SkyBlue              = 123,
      SlateBlue            = 124,
      SlateGray            = 125,
      Snow                 = 126,
      SpringGreen          = 127,
      SteelBlue            = 128,
      Tan                  = 129,
      Teal                 = 130,
      Thistle              = 131,
      Tomato               = 132,
      Transparent          = 133,
      Turquoise            = 134,
      Violet               = 135,
      Wheat                = 136,
      White                = 137,
      WhiteSmoke           = 138,
      Yellow               = 139,
      YellowGreen          = 140,
    }

    /*
    internal class Kct
    {
      private static int[] colorTable;

      private static void InitColorTable()
      {
        int[] colors = new int[141];

        colors[  0] = 0xFFF0F8FF;  // AliceBlue
        colors[  1] = 0xFFFAEBD7;  // AntiqueWhite
        colors[  2] = 0xFF00FFFF;  // Aqua
        colors[  3] = 0xFF7FFFD4;  // Aquamarine
        colors[  4] = 0xFFF0FFFF;  // Azure
        colors[  5] = 0xFFF5F5DC;  // Beige
        colors[  6] = 0xFFFFE4C4;  // Bisque
        colors[  7] = 0xFF000000;  // Black
        colors[  8] = 0xFFFFEBCD;  // BlanchedAlmond
        colors[  9] = 0xFF0000FF;  // Blue
        colors[ 10] = 0xFF8A2BE2;  // BlueViolet
        colors[ 11] = 0xFFA52A2A;  // Brown
        colors[ 12] = 0xFFDEB887;  // BurlyWood
        colors[ 13] = 0xFF5F9EA0;  // CadetBlue
        colors[ 14] = 0xFF7FFF00;  // Chartreuse
        colors[ 15] = 0xFFD2691E;  // Chocolate
        colors[ 16] = 0xFFFF7F50;  // Coral
        colors[ 17] = 0xFF6495ED;  // CornflowerBlue
        colors[ 18] = 0xFFFFF8DC;  // Cornsilk
        colors[ 29] = 0xFFDC143C;  // Crimson
        colors[ 20] = 0xFF00FFFF;  // Cyan
        colors[ 21] = 0xFF00008B;  // DarkBlue
        colors[ 22] = 0xFF008B8B;  // DarkCyan
        colors[ 23] = 0xFFB8860B;  // DarkGoldenrod
        colors[ 24] = 0xFFA9A9A9;  // DarkGray
        colors[ 25] = 0xFF006400;  // DarkGreen
        colors[ 26] = 0xFFBDB76B;  // DarkKhaki
        colors[ 27] = 0xFF8B008B;  // DarkMagenta
        colors[ 28] = 0xFF556B2F;  // DarkOliveGreen
        colors[ 29] = 0xFFFF8C00;  // DarkOrange
        colors[ 30] = 0xFF9932CC;  // DarkOrchid
        colors[ 31] = 0xFF8B0000;  // DarkRed
        colors[ 32] = 0xFFE9967A;  // DarkSalmon
        colors[ 33] = 0xFF8FBC8B;  // DarkSeaGreen
        colors[ 34] = 0xFF483D8B;  // DarkSlateBlue
        colors[ 35] = 0xFF2F4F4F;  // DarkSlateGray
        colors[ 36] = 0xFF00CED1;  // DarkTurquoise
        colors[ 37] = 0xFF9400D3;  // DarkViolet
        colors[ 38] = 0xFFFF1493;  // DeepPink
        colors[ 39] = 0xFF00BFFF;  // DeepSkyBlue
        colors[ 40] = 0xFF696969;  // DimGray
        colors[ 41] = 0xFF1E90FF;  // DodgerBlue
        colors[ 42] = 0xFFB22222;  // Firebrick
        colors[ 43] = 0xFFFFFAF0;  // FloralWhite
        colors[ 44] = 0xFF228B22;  // ForestGreen
        colors[ 45] = 0xFFFF00FF;  // Fuchsia
        colors[ 46] = 0xFFDCDCDC;  // Gainsboro
        colors[ 47] = 0xFFF8F8FF;  // GhostWhite
        colors[ 48] = 0xFFFFD700;  // Gold
        colors[ 49] = 0xFFDAA520;  // Goldenrod
        colors[ 50] = 0xFF808080;  // Gray
        colors[ 51] = 0xFF008000;  // Green
        colors[ 52] = 0xFFADFF2F;  // GreenYellow
        colors[ 53] = 0xFFF0FFF0;  // Honeydew
        colors[ 54] = 0xFFFF69B4;  // HotPink
        colors[ 55] = 0xFFCD5C5C;  // IndianRed
        colors[ 56] = 0xFF4B0082;  // Indigo
        colors[ 57] = 0xFFFFFFF0;  // Ivory
        colors[ 58] = 0xFFF0E68C;  // Khaki
        colors[ 59] = 0xFFE6E6FA;  // Lavender
        colors[ 60] = 0xFFFFF0F5;  // LavenderBlush
        colors[ 61] = 0xFF7CFC00;  // LawnGreen
        colors[ 62] = 0xFFFFFACD;  // LemonChiffon
        colors[ 63] = 0xFFADD8E6;  // LightBlue
        colors[ 64] = 0xFFF08080;  // LightCoral
        colors[ 65] = 0xFFE0FFFF;  // LightCyan
        colors[ 66] = 0xFFFAFAD2;  // LightGoldenrodYellow
        colors[ 67] = 0xFFD3D3D3;  // LightGray
        colors[ 68] = 0xFF90EE90;  // LightGreen
        colors[ 69] = 0xFFFFB6C1;  // LightPink
        colors[ 70] = 0xFFFFA07A;  // LightSalmon
        colors[ 71] = 0xFF20B2AA;  // LightSeaGreen
        colors[ 72] = 0xFF87CEFA;  // LightSkyBlue
        colors[ 73] = 0xFF778899;  // LightSlateGray
        colors[ 74] = 0xFFB0C4DE;  // LightSteelBlue
        colors[ 75] = 0xFFFFFFE0;  // LightYellow
        colors[ 76] = 0xFF00FF00;  // Lime
        colors[ 77] = 0xFF32CD32;  // LimeGreen
        colors[ 78] = 0xFFFAF0E6;  // Linen
        colors[ 79] = 0xFFFF00FF;  // Magenta
        colors[ 80] = 0xFF800000;  // Maroon
        colors[ 81] = 0xFF66CDAA;  // MediumAquamarine
        colors[ 82] = 0xFF0000CD;  // MediumBlue
        colors[ 83] = 0xFFBA55D3;  // MediumOrchid
        colors[ 84] = 0xFF9370DB;  // MediumPurple
        colors[ 85] = 0xFF3CB371;  // MediumSeaGreen
        colors[ 86] = 0xFF7B68EE;  // MediumSlateBlue
        colors[ 87] = 0xFF00FA9A;  // MediumSpringGreen
        colors[ 88] = 0xFF48D1CC;  // MediumTurquoise
        colors[ 89] = 0xFFC71585;  // MediumVioletRed
        colors[ 90] = 0xFF191970;  // MidnightBlue
        colors[ 91] = 0xFFF5FFFA;  // MintCream
        colors[ 92] = 0xFFFFE4E1;  // MistyRose
        colors[ 93] = 0xFFFFE4B5;  // Moccasin
        colors[ 94] = 0xFFFFDEAD;  // NavajoWhite
        colors[ 95] = 0xFF000080;  // Navy
        colors[ 96] = 0xFFFDF5E6;  // OldLace
        colors[ 97] = 0xFF808000;  // Olive
        colors[ 98] = 0xFF6B8E23;  // OliveDrab
        colors[ 99] = 0xFFFFA500;  // Orange
        colors[100] = 0xFFFF4500;  // OrangeRed
        colors[101] = 0xFFDA70D6;  // Orchid
        colors[102] = 0xFFEEE8AA;  // PaleGoldenrod
        colors[103] = 0xFF98FB98;  // PaleGreen
        colors[104] = 0xFFAFEEEE;  // PaleTurquoise
        colors[105] = 0xFFDB7093;  // PaleVioletRed
        colors[106] = 0xFFFFEFD5;  // PapayaWhip
        colors[107] = 0xFFFFDAB9;  // PeachPuff
        colors[108] = 0xFFCD853F;  // Peru
        colors[109] = 0xFFFFC0CB;  // Pink
        colors[110] = 0xFFDDA0DD;  // Plum
        colors[111] = 0xFFB0E0E6;  // PowderBlue
        colors[112] = 0xFF800080;  // Purple
        colors[113] = 0xFFFF0000;  // Red
        colors[114] = 0xFFBC8F8F;  // RosyBrown
        colors[115] = 0xFF4169E1;  // RoyalBlue
        colors[116] = 0xFF8B4513;  // SaddleBrown
        colors[117] = 0xFFFA8072;  // Salmon
        colors[118] = 0xFFF4A460;  // SandyBrown
        colors[119] = 0xFF2E8B57;  // SeaGreen
        colors[120] = 0xFFFFF5EE;  // SeaShell
        colors[121] = 0xFFA0522D;  // Sienna
        colors[122] = 0xFFC0C0C0;  // Silver
        colors[123] = 0xFF87CEEB;  // SkyBlue
        colors[124] = 0xFF6A5ACD;  // SlateBlue
        colors[125] = 0xFF708090;  // SlateGray
        colors[126] = 0xFFFFFAFA;  // Snow
        colors[127] = 0xFF00FF7F;  // SpringGreen
        colors[128] = 0xFF4682B4;  // SteelBlue
        colors[129] = 0xFFD2B48C;  // Tan
        colors[130] = 0xFF008080;  // Teal
        colors[131] = 0xFFD8BFD8;  // Thistle
        colors[132] = 0xFFFF6347;  // Tomato
        colors[133] = 0x00FFFFFF;  // Transparent
        colors[134] = 0xFF40E0D0;  // Turquoise
        colors[135] = 0xFFEE82EE;  // Violet
        colors[136] = 0xFFF5DEB3;  // Wheat
        colors[137] = 0xFFFFFFFF;  // White
        colors[138] = 0xFFF5F5F5;  // WhiteSmoke
        colors[139] = 0xFFFFFF00;  // Yellow
        colors[140] = 0xFF9ACD32;  // YellowGreen
      }
    }
    */
}

//{Colors.Black, 0x000000, "Black", "Schwarz"},
//{Colors.Darkslategray, 0x8FBC8F, "Darkslategray", "Dunkles Schiefergrau"},
//{Colors.Slategray, 0x708090, "Slategray", "Schiefergrau"},
//{Colors.Lightslategray, 0x778899, "Lightslategray", "Helles Schiefergrau"},
//{Colors.Lightsteelblue, 0xB0C4DE, "Lightsteelblue", "Helles Stahlblau"},
//{Colors.Dimgray, 0x696969, "Dimgray", "Mattes Grau"},
//{Colors.Gray, 0x808080, "Gray", "Grau"},
//{Colors.Darkgray, 0xA9A9A9, "Darkgray", "Dunkelgrau"},
//{Colors.Silver, 0xC0C0C0, "Silver", "Silber"},
//{Colors.Gainsboro, 0xDCDCDC, "Gainsboro", "Gainsboro"},
//{Colors.Whitesmoke, 0xF5F5F5, "Whitesmoke", "Rauchiges Wei"},
//{Colors.Ghostwhite, 0xF8F8FF, "Ghostwhite", "Geisterwei"},
//{Colors.White, 0xFFFFFF, "White", "Wei"},
//{Colors.Snow, 0xFFFAFA, "Snow", "Schneewei"},
//{Colors.Ivory, 0xFFFFF0, "Ivory", "Elfenbein"},
//{Colors.Floralwhite, 0xFFFAF0, "Floralwhite", "Bltenwei"},
//{Colors.Seashell, 0xFFF5EE, "Seashell", "Muschel"},
//{Colors.Oldlace, 0xFDF5E6, "Oldlace", "Altgold"},
//{Colors.Linen, 0xFAF0E6, "Linen", "Leinenfarbe"},
//{Colors.Antiquewhite, 0xFAEBD7, "Antiquewhite", "Antikes Wei"},
//{Colors.Blanchedalmond, 0xFFEBCD, "Blanchedalmond", "Mandelwei"},
//{Colors.Papayawhip, 0xFFEFD5, "Papayawhip", "Cremiges Papaya"},
//{Colors.Beige, 0xF5F5DC, "Beige", "Beige"},
//{Colors.Cornsilk, 0xFFF8DC, "Cornsilk", "Mais"},
//{Colors.Lightgoldenrodyellow, 0xFAFAD2, "Lightgoldenrodyellow", "Helles Goldrutengelb"},
//{Colors.Lightyellow, 0xFFFFE0, "Lightyellow", "Hellgelb"},
//{Colors.Lemonchiffon, 0xFFFACD, "Lemonchiffon", "Chiffongelb"},
//{Colors.Palegoldenrod, 0xEEE8AA, "Palegoldenrod", "Blasse Goldrutenfarbe"},
//{Colors.Khaki, 0xF0E68C, "Khaki", "Khaki"},
//{Colors.Yellow, 0xFFFF00, "Yellow", "Gelb"},
//{Colors.Gold, 0xFFD700, "Gold", "Gold"},
//{Colors.Orange, 0xFFA500, "Orange", "Orange"},
//{Colors.Darkorange, 0xFF8C00, "Darkorange", "Dunkles Orange"},
//{Colors.Goldenrod, 0xDAA520, "Goldenrod", "Goldrute"},
//{Colors.Darkgoldenrod, 0xB8860B, "Darkgoldenrod", "dunkle Goldrutenfarbe"},
//{Colors.Peru, 0xCD853F, "Peru", "Peru"},
//{Colors.Chocolate, 0xD2691E, "Chocolate", "Schokolade"},
//{Colors.Saddlebrown, 0x8B4513, "Saddlebrown", "Sattelbraun"},
//{Colors.Sienna, 0xA0522D, "Sienna", "Ocker"},
//{Colors.Brown, 0xA52A2A, "Brown", "Braun"},
//{Colors.Darkred, 0x8B0000, "Darkred", "Dunkelrot"},
//{Colors.Maroon, 0x800000, "Maroon", "Kastanienbraun"},
//{Colors.Paletturquoise, 0xAFEEEE, "Paletturquoise", "Blasses Trkis"},
//{Colors.Firebrick, 0xB22222, "Firebrick", "Ziegelfarbe"},
//{Colors.Indianred, 0xCD5C5C, "Indianred", "Indischrot"},
//{Colors.Crimson, 0xDC143C, "Crimson", "Karmesinrot"},
//{Colors.Red, 0xFF0000, "Red", "Rot"},
//{Colors.Orangered, 0xFF4500, "Orangered", "Orangenrot"},
//{Colors.Tomato, 0xFF6347, "Tomato", "Tomatenrot"},
//{Colors.Coral, 0xFF7F50, "Coral", "Koralle"},
//{Colors.Salmon, 0xFA8072, "Salmon", "Lachs"},
//{Colors.Lightcoral, 0xF08080, "Lightcoral", "Helles Korallenrot"},
//{Colors.Darksalmon, 0xE9967A, "Darksalmon", "Dunkle Lachsfarbe"},
//{Colors.Lightsalmon, 0xFFA07A, "Lightsalmon", "Helle Lachsfarbe"},
//{Colors.Sandybrown, 0xF4A460, "Sandybrown", "Sandbraun"},
//{Colors.Rosybrown, 0xBC8F8F, "Rosybrown", "Rosiges Braun"},
//{Colors.Tan, 0xD2B48C, "Tan", "Gelbbraun"},
//{Colors.Burlywood, 0xDEB887, "Burlywood", "Grobes Braun"},
//{Colors.Wheat, 0xF5DEB3, "Wheat", "Weizen"},
//{Colors.Peachpuff, 0xFFDAB9, "Peachpuff", "Pfirsich"},
//{Colors.Navajowhite, 0xFFDEAD, "Navajowhite", "Navajowei"},
//{Colors.Bisque, 0xFFE4C4, "Bisque", "Tomatencreme"},
//{Colors.Lavenderblush, 0xFFF0F5, "Lavenderblush", "Rosige Lavenderfarbe"},
//{Colors.Mistyrose, 0xFFE4E1, "Mistyrose", "Altrosa"},
//{Colors.Pink, 0xFFC0CB, "Pink", "Rosa"},
//{Colors.Lightpink, 0xFFB6C1, "Lightpink", "Hellrosa"},
//{Colors.Hotpink, 0xFF69B4, "Hotpink", "Leuchtendes Rosa"},
//{Colors.Fuchsia, 0xFF00FF, "Fuchsia", "Fuchsie"},
//{Colors.Magenta, 0xFF00FF, "Magenta", "Magentarot"},
//{Colors.Deeppink, 0xFF1493, "Deeppink", "Tiefrosa"},
//{Colors.Mediumvioletred, 0xC71585, "Mediumvioletred", "Mittleres Violettrot"},
//{Colors.Palevioletred, 0xDB7093, "Palevioletred", "Blasses Violettrot"},
//{Colors.Plum, 0xDDA0DD, "Plum", "Pflaume"},
//{Colors.Thistle, 0xD8BFD8, "Thistle", "Distel"},
//{Colors.Lavender, 0xE6E6FA, "Lavender", "Lavendelfarbe"},
//{Colors.Violet, 0xEE82EE, "Violet", "Violett"},
//{Colors.Orchid, 0xDA70D6, "Orchid", "Orchidee"},
//{Colors.Darkmagenta, 0x8B008B, "Darkmagenta", "Dunkles Magentarot"},
//{Colors.Purple, 0x800080, "Purple", "Violett"},
//{Colors.Indigo, 0x4B0082, "Indigo", "Indigo"},
//{Colors.Blueviolet, 0x8A2BE2, "Blueviolet", "Blauviolett"},
//{Colors.Darkviolet, 0x9400D3, "Darkviolet", "Dunkles Violett"},
//{Colors.Darkorchid, 0x9932CC, "Darkorchid", "Dunkle Orchideenfarbe"},
//{Colors.Mediumpurple, 0x9370DB, "Mediumpurple", "Mittleres Violett"},
//{Colors.Mediumorchid, 0xBA55D3, "Mediumorchid", "Mittlere Orchideenfarbe"},
//{Colors.Mediumslateblue, 0x7B68EE, "Mediumslateblue", "Mittleres Schieferblau"},
//{Colors.Slateblue, 0x6A5ACD, "Slateblue", "Schieferblau"},
//{Colors.Darkslateblue, 0x483D8B, "Darkslateblue", "Dunkles Schiefergrau"},
//{Colors.Midnightblue, 0x191970, "Midnightblue", "Mitternachtsblau"},
//{Colors.Navy, 0x000080, "Navy", "Marineblau"},
//{Colors.Darkblue, 0x00008B, "Darkblue", "Dunkelblau"},
//{Colors.Lightgray, 0xD3D3D3, "Lightgray", "Hellgrau"},
//{Colors.Mediumblue, 0x0000CD, "Mediumblue", "Mittelblau"},
//{Colors.Blue, 0x0000FF, "Blue", "Blau"},
//{Colors.Royalblue, 0x4169E1, "Royalblue", "Knigsblau"},
//{Colors.Steelblue, 0x4682B4, "Steelblue", "Stahlblau"},
//{Colors.Cornflowerblue, 0x6495ED, "Cornflowerblue", "Kornblumenblau"},
//{Colors.Dodgerblue, 0x1E90FF, "Dodgerblue", "Dodger-Blau"},
//{Colors.Deepskyblue, 0x00BFFF, "Deepskyblue", "Tiefes Himmelblau"},
//{Colors.Lightskyblue, 0x87CEFA, "Lightskyblue", "Helles Himmelblau"},
//{Colors.Skyblue, 0x87CEEB, "Skyblue", "Himmelblau"},
//{Colors.Lightblue, 0xADD8E6, "Lightblue", "Hellblau"},
//{Colors.Cyan, 0x00FFFF, "Cyan", "Zyanblau"},
//{Colors.Aqua, 0x00FFFF, "Aqua", "Blaugrn"},
//{Colors.Powderblue, 0xB0E0E6, "Powderblue", "Taubenblau"},
//{Colors.Lightcyan, 0xE0FFFF, "Lightcyan", "Helles Cyanblau"},
//{Colors.Aliceblue, 0xA0CE00, "Aliceblue", "Aliceblau"},
//{Colors.Azure, 0xF0FFFF, "Azure", "Himmelblau"},
//{Colors.Mintcream, 0xF5FFFA, "Mintcream", "Cremige Pfefferminzfarbe"},
//{Colors.Honeydew, 0xF0FFF0, "Honeydew", "Honigmelone"},
//{Colors.Aquamarine, 0x7FFFD4, "Aquamarine", "Aquamarinblau"},
//{Colors.Turquoise, 0x40E0D0, "Turquoise", "Trkis"},
//{Colors.Mediumturqoise, 0x48D1CC, "Mediumturqoise", "Mittleres Trkis"},
//{Colors.Darkturquoise, 0x00CED1, "Darkturquoise", "Dunkles Trkis"},
//{Colors.Mediumaquamarine, 0x66CDAA, "Mediumaquamarine", "Mittleres Aquamarinblau"},
//{Colors.Lightseagreen, 0x20B2AA, "Lightseagreen", "Helles Seegrn"},
//{Colors.Darkcyan, 0x008B8B, "Darkcyan", "Dunkles Zyanblau"},
//{Colors.Teal, 0x008080, "Teal", "Entenbraun"},
//{Colors.Cadetblue, 0x5F9EA0, "Cadetblue", "Kadettblau"},
//{Colors.Mediumseagreen, 0x3CB371, "Mediumseagreen", "Mittleres Seegrn"},
//{Colors.Darkseagreen, 0x8FBC8F, "Darkseagreen", "Dunkles Seegrn"},
//{Colors.Lightgreen, 0x90EE90, "Lightgreen", "Hellgrn"},
//{Colors.Palegreen, 0x98FB98, "Palegreen", "Blassgrn"},
//{Colors.Mediumspringgreen, 0x00FA9A, "Mediumspringgreen", "Mittleres Frhlingsgrn"},
//{Colors.Springgreen, 0x00FF7F, "Springgreen", "Frhlingsgrn"},
//{Colors.Lime, 0x00FF00, "Lime", "Zitronengrn"},
//{Colors.Limegreen, 0x32CD32, "Limegreen", "Gelbgrn"},
//{Colors.Seagreen, 0x2E8B57, "Seagreen", "Seegrn"},
//{Colors.Forestgreen, 0x228B22, "Forestgreen", "Waldgrn"},
//{Colors.Green, 0x008000, "Green", "Grn"},
//{Colors.Darkgreen, 0x006400, "Darkgreen", "Dunkelgrn"},
//{Colors.Olivedrab, 0x6B8E23, "Olivedrab", "Olivfarbiges Graubraun"},
//{Colors.Darkolivegreen, 0x556B2F, "Darkolivegreen", "Dunkles Olivgrn"},
//{Colors.Olive, 0x808000, "Olive", "Olivgrn"},
//{Colors.Darkkhaki, 0xBDB76B, "Darkkhaki", "Dunkles Khaki"},
//{Colors.Yellowgreen, 0x9ACD32, "Yellowgreen", "Gelbgrn"},
//{Colors.Chartreuse, 0x7FFF00, "Chartreuse", "Hellgrn"},
//{Colors.Greenyellow, 0xADFF2F, "Greenyellow", "Grngelb"},
