#region PDFsharp - A .NET library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005-2007 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
// http://sourceforge.net/projects/pdfsharp
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.
#endregion

using System;
using System.Diagnostics;
using System.Collections;
using PdfSharp.Pdf.Annotations;
using PdfSharp.Pdf.Internal;

namespace PdfSharp.Pdf.AcroForms
{
  /// <summary>
  /// Represents the base class for all button fields.
  /// </summary>
  public abstract class PdfButtonField : PdfAcroField
  {
    /// <summary>
    /// Initializes a new instance of PdfButtonField.
    /// </summary>
    protected PdfButtonField(PdfDocument document) : base(document)
    {
    }

    protected PdfButtonField(PdfDictionary dict) : base(dict)
    {
    }

    /// <summary>
    /// Gets the name which represents the opposite of /Off.
    /// </summary>
    protected string GetNonOffValue()
    {
      // Try to get the information from the appearance dictionaray.
      // Just return the first key that is not /Off.
      // I'm not sure what is the right solution to get this value.
      PdfDictionary ap = Elements[PdfAnnotation.Keys.AP] as PdfDictionary;
      if (ap != null)
      {
        PdfDictionary n = ap.Elements["/N"] as PdfDictionary;
        if (n != null)
        {
          foreach (string name in n.Elements.Keys)
            if (name != "/Off")
              return name;
        }
      }
      return null;
    }

    internal override void GetDescendantNames(ref ArrayList names, string partialName)
    {
      string t = Elements.GetString(Keys.T);
      // HACK: ??? 
      if (t == "")
        t = "???";
      Debug.Assert(t != "");
      if (t.Length > 0)
      {
        if (partialName != null && partialName.Length > 0)
          names.Add(partialName + "." + t);
        else
          names.Add(t);
      }
    }

    /// <summary>
    /// Predefined keys of this dictionary. 
    /// The description comes from PDF 1.4 Reference.
    /// </summary>
    public new class Keys : PdfAcroField.Keys
    {
      // Pushbuttons have no additional entries.
    }
  }
}
