#region PDFsharp - A .NET library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005-2007 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
// http://sourceforge.net/projects/pdfsharp
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.
#endregion

namespace PdfSharp
{
  /// <summary>
  /// Version info base for all PDFsharp related assemblies.
  /// </summary>
  public sealed class ProductVersionInfo
  {
    ProductVersionInfo() { }

    public const string Title = "PDFsharp";
    public const string Description = "A .NET library for processing PDF.";
    public const string Producer = Title + " " + Version + " (" + Url + ")";
    public const string Version = "0.9.653";  // Build = days since 1.1.2005
    public const string Url = "www.pdfsharp.com";
    public const string Configuration = "";
    public const string Company = "empira Software GmbH, Cologne (Germany)";
    public const string Product = "PDFsharp";
    public const string Copyright = "Copyright  2005-2007 empira Software GmbH. All rights reserved.";
    public const string Trademark = "PDFsharp";
    public const string Culture = "";

    // Build = days since 1.1.2005
    public const int VersionMajor = 0;
    public const int VersionMinor = 9;
    public const int VersionBuild = 653;
    public const int VersionPatch = 0;

#if DEBUG
    public static int BuildDay = (System.DateTime.Now - new System.DateTime(2005, 1, 1)).Days;
#endif
  }

  /// <summary>
  /// Version info of this assembly.
  /// </summary>
  internal sealed class VersionInfo
  {
    VersionInfo() {}

    public const string Title         = ProductVersionInfo.Title;
    public const string Description   = ProductVersionInfo.Description;
    public const string Producer      = Title + " " + Version + " (" + Url +")";
    public const string Version       = ProductVersionInfo.Version;
    public const string Url           = ProductVersionInfo.Url;
    public const string Configuration = "";
    public const string Company       = ProductVersionInfo.Company;
    public const string Product       = ProductVersionInfo.Product;
    public const string Copyright     = ProductVersionInfo.Copyright;
    public const string Trademark     = ProductVersionInfo.Trademark;
    public const string Culture       = "";

    public const int VersionMajor = ProductVersionInfo.VersionMajor;
    public const int VersionMinor = ProductVersionInfo.VersionMinor;
    public const int VersionBuild = ProductVersionInfo.VersionBuild;
    public const int VersionPatch = ProductVersionInfo.VersionPatch;
  }
}
