/*
 * Decompiled with CFR 0.152.
 */
package xdman.mediaconversion;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import xdman.Config;
import xdman.mediaconversion.MediaConversionListener;
import xdman.mediaconversion.MediaFormat;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class FFmpeg {
    public static final int FF_NOT_FOUND = 10;
    public static final int FF_LAUNCH_ERROR = 20;
    public static final int FF_CONVERSION_FAILED = 30;
    public static final int FF_SUCCESS = 0;
    private MediaFormat outformat;
    private MediaConversionListener listener;
    private boolean copy;
    private List<String> inputFiles;
    private String outputFile;
    private boolean hls;
    private long totalDuration = 0L;
    private Process proc;
    private int ffExitCode;
    private String preset = "ultrafast";
    private String volume;
    private boolean useHwAccel;

    public FFmpeg(List<String> inputFiles, String outputFile, MediaConversionListener listener, MediaFormat outformat, boolean copy) {
        this.inputFiles = inputFiles;
        this.outputFile = outputFile;
        this.listener = listener;
        this.outformat = outformat;
        this.copy = copy;
    }

    public int convert() {
        File ffFile;
        block27: {
            Logger.log("Outformat: " + this.outformat);
            ffFile = new File(Config.getInstance().getDataFolder(), System.getProperty("os.name").toLowerCase().contains("windows") ? "ffmpeg.exe" : "ffmpeg");
            if (ffFile.exists() || (ffFile = new File(XDMUtils.getJarFile().getParentFile(), System.getProperty("os.name").toLowerCase().contains("windows") ? "ffmpeg.exe" : "ffmpeg")).exists()) break block27;
            return 10;
        }
        try {
            String ln;
            ArrayList<String> args = new ArrayList<String>();
            args.add(ffFile.getAbsolutePath());
            if (this.useHwAccel) {
                args.add("-hwaccel");
                args.add("auto");
            }
            if (this.hls) {
                args.add("-f");
                args.add("concat");
                args.add("-safe");
                args.add("0");
            }
            int i = 0;
            while (i < this.inputFiles.size()) {
                args.add("-i");
                args.add(this.inputFiles.get(i));
                ++i;
            }
            if (this.copy) {
                args.add("-acodec");
                args.add("copy");
                args.add("-vcodec");
                args.add("copy");
            } else {
                String[] arr;
                if (this.outformat.getResolution() != null) {
                    args.add("-s");
                    args.add(this.outformat.getResolution());
                }
                if (this.outformat.getVideo_codec() != null) {
                    args.add("-vcodec");
                    args.add(this.outformat.getVideo_codec());
                }
                if (this.outformat.getVideo_bitrate() != null) {
                    args.add("-b:v");
                    args.add(this.outformat.getVideo_bitrate());
                }
                if (this.outformat.getFramerate() != null) {
                    args.add("-r");
                    args.add(this.outformat.getFramerate());
                }
                if (this.outformat.getAspectRatio() != null) {
                    args.add("-aspect");
                    args.add(this.outformat.getAspectRatio());
                }
                if (this.outformat.getVideo_param_extra() != null) {
                    String[] arr2 = this.outformat.getVideo_param_extra().split(" ");
                    if (arr2.length > 0) {
                        args.addAll(Arrays.asList(arr2));
                    }
                } else if ("libx264".equals(this.outformat.getVideo_codec())) {
                    args.add("-profile:v");
                    args.add("baseline");
                }
                if (this.outformat.getAudio_codec() != null) {
                    args.add("-acodec");
                    args.add(this.outformat.getAudio_codec());
                }
                if (this.outformat.getAudio_bitrate() != null) {
                    args.add("-b:a");
                    args.add(this.outformat.getAudio_bitrate());
                }
                if (this.isNumeric(this.outformat.getSamplerate())) {
                    args.add("-ar");
                    args.add(this.outformat.getSamplerate());
                }
                if (this.isNumeric(this.outformat.getAudio_channel())) {
                    args.add("-ar");
                    args.add(this.outformat.getSamplerate());
                }
                if (this.outformat.getAudio_extra_param() != null && (arr = this.outformat.getAudio_extra_param().split(" ")).length > 0) {
                    args.addAll(Arrays.asList(arr));
                }
                if (this.volume != null) {
                    args.add("-filter:a");
                    args.add("volume=" + this.volume);
                }
            }
            args.add(this.outputFile);
            args.add("-y");
            for (String s : args) {
                Logger.log("@ffmpeg_args: " + s);
            }
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.redirectErrorStream(true);
            this.proc = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(this.proc.getInputStream()), 1024);
            while ((ln = br.readLine()) != null) {
                try {
                    String text = ln.trim();
                    this.processOutput(text);
                }
                catch (Exception e) {
                    Logger.log(e);
                }
            }
            this.ffExitCode = this.proc.waitFor();
            return this.ffExitCode == 0 ? 0 : 30;
        }
        catch (Exception e) {
            return 20;
        }
    }

    public void setHls(boolean hls) {
        this.hls = hls;
    }

    public void setHLSDuration(float totalDuration) {
        this.totalDuration = (long)totalDuration;
    }

    private long parseDuration(String dur) {
        long duration = 0L;
        String[] arr = dur.split(":");
        String s = arr[0].trim();
        if (!StringUtils.isNullOrEmpty(s)) {
            duration = Integer.parseInt(s, 10) * 3600;
        }
        if (!StringUtils.isNullOrEmpty(s = arr[1].trim())) {
            duration += (long)(Integer.parseInt(arr[1].trim(), 10) * 60);
        }
        if (!StringUtils.isNullOrEmpty(s = arr[2].split("\\.")[0].trim())) {
            duration += (long)Integer.parseInt(s, 10);
        }
        return duration;
    }

    private void processOutput(String text) {
        String dur;
        int index2;
        int index1;
        if (StringUtils.isNullOrEmpty(text)) {
            return;
        }
        if (this.totalDuration > 0L && text.startsWith("frame=") && text.contains("time=")) {
            index1 = text.indexOf("time");
            index1 = text.indexOf(61, index1);
            index2 = text.indexOf("bitrate=");
            dur = text.substring(index1 + 1, index2).trim();
            Logger.log("Parsing duration: " + dur);
            long t = this.parseDuration(dur);
            Logger.log("Duration: " + t + " Total duration: " + this.totalDuration);
            int prg = (int)(t * 100L / this.totalDuration);
            Logger.log("ffmpeg prg: " + prg);
            this.listener.progress(prg);
        }
        if (this.totalDuration == 0L && text.startsWith("Duration:")) {
            try {
                index1 = text.indexOf("Duration");
                index1 = text.indexOf(58, index1);
                index2 = text.indexOf(",", index1);
                dur = text.substring(index1 + 1, index2).trim();
                Logger.log("Parsing duration: " + dur);
                this.totalDuration = this.parseDuration(dur);
                Logger.log("Total duration: " + this.totalDuration);
            }
            catch (Exception e) {
                Logger.log(e);
                this.totalDuration = -1L;
            }
        }
    }

    public void stop() {
        try {
            if (this.proc.isAlive()) {
                this.proc.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getFfExitCode() {
        return this.ffExitCode;
    }

    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    private boolean isNumeric(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isUseHwAccel() {
        return this.useHwAccel;
    }

    public void setUseHwAccel(boolean useHwAccel) {
        this.useHwAccel = useHwAccel;
    }
}

