/*
 * Decompiled with CFR 0.152.
 */
package xdman.mediaconversion;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import xdman.Config;
import xdman.mediaconversion.MediaFormatInfo;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class MediaInfoExtractor {
    Pattern pattern1;
    Pattern pattern2;
    boolean stop;
    Process proc;

    public void stop() {
        this.stop = true;
        if (this.proc != null) {
            try {
                this.proc.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public MediaInfoExtractor() {
        String str1 = "Duration:\\s+(\\d+:\\d+:\\d+)    Stream .*, ([0-9]+x[0-9]+)";
        System.out.println(str1);
        this.pattern1 = Pattern.compile("Duration:\\s+([0-9]+:[0-9]+:[0-9]+)");
        this.pattern2 = Pattern.compile("Stream .*, ([0-9]+x[0-9]+)");
    }

    public MediaFormatInfo getInfo(String file) {
        File f = new File(file);
        File tmpOutput = new File(Config.getInstance().getTemporaryFolder(), UUID.randomUUID().toString());
        File tmpImgFile = new File(Config.getInstance().getTemporaryFolder(), String.valueOf(UUID.randomUUID().toString()) + ".jpg");
        if (!f.exists()) {
            return null;
        }
        File ffFile = new File(Config.getInstance().getDataFolder(), System.getProperty("os.name").toLowerCase().contains("windows") ? "ffmpeg.exe" : "ffmpeg");
        if (!ffFile.exists() && !(ffFile = new File(XDMUtils.getJarFile().getParentFile(), System.getProperty("os.name").toLowerCase().contains("windows") ? "ffmpeg.exe" : "ffmpeg")).exists()) {
            return null;
        }
        if (this.stop) {
            return null;
        }
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(ffFile.getAbsolutePath());
            args.add("-i");
            args.add(f.getAbsolutePath());
            args.add("-vf");
            args.add("scale=64:-1");
            args.add("-vframes");
            args.add("1");
            args.add("-f");
            args.add("image2");
            args.add(tmpImgFile.getAbsolutePath());
            args.add("-y");
            String str2 = "";
            for (String s : args) {
                str2 = String.valueOf(str2) + " " + s;
            }
            System.out.println(str2);
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.redirectError(tmpOutput);
            this.proc = pb.start();
            int ret = this.proc.waitFor();
            System.out.println("ret: " + ret);
            if (this.stop) {
                return null;
            }
            MediaFormatInfo info = new MediaFormatInfo();
            info.thumbnail = new ImageIcon(tmpImgFile.getAbsolutePath());
            byte[] array = Files.readAllBytes(tmpOutput.toPath());
            String str = new String(array, "utf-8");
            System.out.println(str);
            Matcher matcher1 = this.pattern1.matcher(str);
            Matcher matcher2 = this.pattern2.matcher(str);
            if (matcher1.find()) {
                info.duration = matcher1.group(1);
                System.out.println("Match: " + info.duration);
            } else {
                System.out.println("no match");
            }
            if (matcher2.find()) {
                info.resolution = matcher2.group(1);
                System.out.println("Match: " + info.resolution);
            }
            if (this.stop) {
                return null;
            }
            MediaFormatInfo mediaFormatInfo = info;
            return mediaFormatInfo;
        }
        catch (Exception e) {
            Logger.log(e);
        }
        finally {
            tmpOutput.delete();
            tmpImgFile.delete();
        }
        return null;
    }
}

