/*
 * Decompiled with CFR 0.152.
 */
package xdman.monitoring;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.UUID;
import xdman.Config;
import xdman.XDMApp;
import xdman.downloaders.metadata.DashMetadata;
import xdman.downloaders.metadata.HlsMetadata;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.monitoring.DASH_INFO;
import xdman.monitoring.F4mHandler;
import xdman.monitoring.FBHandler;
import xdman.monitoring.InstagramHandler;
import xdman.monitoring.M3U8Handler;
import xdman.monitoring.ParsedHookData;
import xdman.monitoring.Request;
import xdman.monitoring.Response;
import xdman.monitoring.VimeoHandler;
import xdman.monitoring.YtUtil;
import xdman.network.http.HeaderCollection;
import xdman.network.http.HttpHeader;
import xdman.network.http.JavaHttpClient;
import xdman.preview.FFmpegStream;
import xdman.preview.PreviewStream;
import xdman.util.FormatUtilities;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class MonitoringSession
implements Runnable {
    private String msg204 = "HTTP/1.1 204 No Content\r\nContent-length: 0\r\n\r\n";
    private Socket sock;
    private InputStream inStream;
    private OutputStream outStream;
    private Request request;
    private Response response;

    public MonitoringSession(Socket socket) {
        this.sock = socket;
        this.request = new Request();
        this.response = new Response();
        System.out.println("New session");
    }

    public void start() {
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    private void setResponseOk(Response res) {
        res.setCode(200);
        res.setMessage("OK");
        HeaderCollection headers = new HeaderCollection();
        headers.setValue("content-type", "application/json");
        headers.setValue("Cache-Control", "max-age=0, no-cache, must-revalidate");
        res.setHeaders(headers);
    }

    private void onDownload(Request request, Response res) throws UnsupportedEncodingException {
        try {
            Logger.log(new String(request.getBody()));
            byte[] b = request.getBody();
            ParsedHookData data = ParsedHookData.parse(b);
            if (data.getUrl() != null && data.getUrl().length() > 0) {
                HttpMetadata metadata = new HttpMetadata();
                metadata.setUrl(data.getUrl());
                metadata.setHeaders(data.getRequestHeaders());
                metadata.setSize(data.getContentLength());
                String file = data.getFile();
                XDMApp.getInstance().addDownload(metadata, file);
            }
        }
        finally {
            this.setResponseOk(res);
        }
    }

    private void onVideo(Request request, Response res) throws UnsupportedEncodingException {
        try {
            Logger.log(new String(request.getBody()));
            if (!Config.getInstance().isShowVideoNotification()) {
                return;
            }
            byte[] b = request.getBody();
            ParsedHookData data = ParsedHookData.parse(b);
            String type = data.getContentType();
            if (type == null) {
                type = "";
            }
            if (type.contains("f4f") || type.contains("m4s") || type.contains("mp2t") || data.getUrl().contains("fcs") || data.getUrl().contains("abst") || data.getUrl().contains("f4x") || data.getUrl().contains(".fbcdn") || data.getUrl().contains("http://127.0.0.1:9614")) {
                return;
            }
            if (!this.processDashSegment(data) && !this.processVideoManifest(data)) {
                this.processNormalVideo(data);
            }
        }
        finally {
            this.setResponseOk(res);
        }
    }

    private void onQuit(Request request, Response res) {
        XDMApp.getInstance().exit();
    }

    private void onCmd(Request request, Response res) {
        byte[] data = request.getBody();
        if (data == null || data.length < 1) {
            XDMApp.getInstance().showMainWindow();
        } else {
            String[] arr = new String(data).split("\n");
            int i = 0;
            while (i < arr.length) {
                String str = arr[i];
                int index = str.indexOf(":");
                if (index >= 1) {
                    String key = str.substring(0, index).trim();
                    String val = str.substring(index + 1).trim();
                    if (key.equals("url")) {
                        String url = val;
                        HttpMetadata metadata = new HttpMetadata();
                        metadata.setUrl(url);
                        String file = XDMUtils.getFileName(url);
                        XDMApp.getInstance().addDownload(metadata, file);
                    }
                }
                ++i;
            }
        }
        this.setResponseOk(res);
    }

    private void onSync(Request request, Response res) {
        StringBuffer json = new StringBuffer();
        json.append("{\n\"enabled\": ");
        json.append(Config.getInstance().isBrowserMonitoringEnabled());
        json.append(",\n\"blockedHosts\": [");
        this.appendArray(Config.getInstance().getBlockedHosts(), json);
        json.append("],");
        json.append("\n\"videoUrls\": [");
        this.appendArray(Config.getInstance().getVidUrls(), json);
        json.append("],");
        json.append("\n\"fileExts\": [");
        this.appendArray(Config.getInstance().getFileExts(), json);
        json.append("],");
        json.append("\n\"vidExts\": [");
        this.appendArray(Config.getInstance().getVidExts(), json);
        json.append("]");
        json.append("\n}");
        byte[] b = json.toString().getBytes();
        res.setCode(200);
        res.setMessage("OK");
        HeaderCollection headers = new HeaderCollection();
        headers.addHeader("Content-Length", String.valueOf(b.length));
        headers.addHeader("Content-Type", "application/json");
        headers.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.addHeader("Pragma", "no-cache");
        headers.addHeader("Expires", "0");
        res.setHeaders(headers);
        res.setBody(b);
    }

    private void appendArray(String[] arr, StringBuffer buf) {
        boolean insertComma = false;
        if (arr != null && arr.length > 0) {
            int i = 0;
            while (i < arr.length) {
                if (insertComma) {
                    buf.append(",");
                } else {
                    insertComma = true;
                }
                buf.append("\"" + arr[i] + "\"");
                ++i;
            }
        }
    }

    private void processRequest(Request request, Response res) throws IOException {
        String verb = request.getUrl();
        if (verb.equals("/sync")) {
            this.onSync(request, this.response);
        } else if (verb.equals("/download")) {
            this.onDownload(request, this.response);
        } else if (verb.equals("/video")) {
            this.onVideo(request, this.response);
        } else if (verb.equals("/cmd")) {
            this.onCmd(request, this.response);
        } else if (verb.equals("/quit")) {
            this.onQuit(request, this.response);
        } else if (verb.startsWith("/preview")) {
            this.onPreview(request, this.response);
        } else {
            throw new IOException("invalid verb " + verb);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onPreview(Request request, Response response) throws IOException {
        PreviewStream ps = null;
        FFmpegStream ff = null;
        try {
            int n;
            StringBuilder stringBuilder;
            String html;
            HttpMetadata metadata;
            boolean hls;
            block39: {
                block38: {
                    String input2;
                    String input1;
                    String url = request.getUrl();
                    if (!url.startsWith("/preview/video")) {
                        if (url.startsWith("/preview/player")) {
                            int index = url.lastIndexOf("/");
                            String id = url.substring(index + 1);
                            String link = "http://127.0.0.1:9614/preview/media/" + id;
                            String html2 = "<html><body><video id=\"myvideo\" width=\"640\" height=\"480\" controls>\r\n    <source src=\"" + link + "\"" + " type=\"video/webm\"  />\r\n" + "</video><br/><h3>If the video does not play in you browser,<br/>please copy <a href=\"" + link + "\">this link</a> and play this in VLC media player</body></html>";
                            byte[] b = html2.getBytes();
                            response.setCode(200);
                            response.setMessage("OK");
                            HeaderCollection headers = new HeaderCollection();
                            headers.addHeader("Content-Length", String.valueOf(b.length));
                            headers.addHeader("Content-Type", "text/html");
                            headers.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                            headers.addHeader("Pragma", "no-cache");
                            headers.addHeader("Expires", "0");
                            response.setHeaders(headers);
                            response.setBody(b);
                            return;
                        }
                        if (!url.startsWith("/preview/media")) return;
                        boolean dash = false;
                        hls = false;
                        int index = url.lastIndexOf("/");
                        String id = url.substring(index + 1);
                        metadata = HttpMetadata.load(id);
                        if (metadata instanceof DashMetadata) {
                            dash = true;
                        }
                        if (metadata instanceof HlsMetadata) {
                            hls = true;
                        }
                        html = "";
                        input1 = null;
                        input2 = null;
                        if (dash) {
                            input1 = "http://127.0.0.1:9614/preview/video/1003/" + metadata.getId() + "/T1";
                            input2 = "http://127.0.0.1:9614/preview/video/1003/" + metadata.getId() + "/T2";
                        } else {
                            input1 = hls ? "http://127.0.0.1:9614/preview/video/1001/" + metadata.getId() : "http://127.0.0.1:9614/preview/video/1000/" + metadata.getId();
                        }
                    } else {
                        String[] arr = url.split("/");
                        System.out.println(arr.length);
                        if (arr.length < 4) {
                            return;
                        }
                        String id = arr[4];
                        String tag = null;
                        if (arr.length == 6) {
                            tag = arr[5];
                        }
                        int type = Integer.parseInt(arr[3]);
                        String resp = "HTTP/1.1 200 OK\r\nTransfer-Encoding: Chunked\r\nCache-Control: no-cache, no-store, must-revalidate\r\nPragma: no-cache\r\nExpires: 0\r\nConnection: close\r\n\r\n";
                        this.outStream.write(resp.getBytes());
                        this.outStream.flush();
                        ps = new PreviewStream(id, type, tag);
                        byte[] buf = new byte[8192];
                        while (true) {
                            int x;
                            if ((x = ps.read(buf)) == -1) {
                                this.outStream.write("0\r\n\r\n".getBytes());
                                System.out.println("Done writing file");
                                ps.close();
                                this.outStream.flush();
                                this.outStream.close();
                                return;
                            }
                            String slen = String.valueOf(Integer.toHexString(x)) + "\r\n";
                            this.outStream.write(slen.getBytes());
                            this.outStream.write(buf, 0, x);
                            this.outStream.write("\r\n".getBytes());
                            this.outStream.flush();
                        }
                    }
                    System.out.println("input: " + input1 + " - " + input2);
                    String resp = "HTTP/1.1 200 OK\r\nContent-Type: video/webm\r\nTransfer-Encoding: Chunked\r\nCache-Control: no-cache, no-store, must-revalidate\r\nPragma: no-cache\r\nExpires: 0\r\nConnection: close\r\n\r\n";
                    this.outStream.write(resp.getBytes());
                    this.outStream.flush();
                    ff = new FFmpegStream(input1, input2);
                    byte[] buf = new byte[8192];
                    while (true) {
                        int x;
                        if ((x = ff.read(buf)) == -1) {
                            this.outStream.write("0\r\n\r\n".getBytes());
                            System.out.println("Done writing file");
                            ff.close();
                            this.outStream.flush();
                            this.outStream.close();
                            System.out.println("Finished writing");
                            stringBuilder = new StringBuilder("<html><body><video id=\"myvideo\" width=\"640\" height=\"480\" controls>\r\n    <source src=\"http://127.0.0.1:9614/preview/video/");
                            if (hls) {
                                break;
                            }
                            break block38;
                        }
                        String slen = String.valueOf(Integer.toHexString(x)) + "\r\n";
                        this.outStream.write(slen.getBytes());
                        this.outStream.write(buf, 0, x);
                        this.outStream.write("\r\n".getBytes());
                        this.outStream.flush();
                    }
                    n = 1001;
                    break block39;
                }
                n = 1000;
            }
            html = stringBuilder.append(n).append("/").append(metadata.getId()).append("\"").append(hls ? "type=\"video/mp2t\"" : "").append("  />\r\n").append("</video></body></html>").toString();
            return;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
            if (ff != null) {
                try {
                    System.out.println("Closing FFStream");
                    ff.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void serviceRequest() {
        try {
            this.inStream = this.sock.getInputStream();
            this.outStream = this.sock.getOutputStream();
            while (true) {
                this.request.read(this.inStream);
                this.processRequest(this.request, this.response);
                this.response.write(this.outStream);
            }
        }
        catch (Exception e) {
            Logger.log(e);
            this.cleanup();
            return;
        }
    }

    private void cleanup() {
        try {
            this.inStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.outStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.serviceRequest();
    }

    private boolean processDashSegment(ParsedHookData data) {
        block22: {
            block26: {
                DASH_INFO info;
                block25: {
                    String mime;
                    String id;
                    long clen;
                    int itag;
                    StringBuilder yt_url;
                    block24: {
                        block23: {
                            URL url;
                            block21: {
                                block20: {
                                    url = new URL(data.getUrl());
                                    String host = url.getHost();
                                    if (host.contains("youtube.com") || host.contains("googlevideo.com")) break block20;
                                    Logger.log("non yt host");
                                    return false;
                                }
                                String type = data.getContentType();
                                if (type == null) {
                                    type = "";
                                }
                                if (type.contains("audio/") || type.contains("video/") || type.contains("application/octet")) break block21;
                                Logger.log("non yt type");
                                return false;
                            }
                            String low_path = data.getUrl().toLowerCase();
                            if (low_path.indexOf("videoplayback") < 0 || low_path.indexOf("itag") < 0) break block22;
                            if (!StringUtils.isNullOrEmptyOrBlank(url.getQuery())) break block23;
                            return false;
                        }
                        int index = data.getUrl().indexOf("?");
                        String path = data.getUrl().substring(0, index);
                        String query = data.getUrl().substring(index + 1);
                        String[] arr = query.split("&");
                        yt_url = new StringBuilder();
                        yt_url.append(String.valueOf(path) + "?");
                        itag = 0;
                        clen = 0L;
                        id = "";
                        mime = "";
                        int i = 0;
                        while (i < arr.length) {
                            block28: {
                                String str;
                                block27: {
                                    str = arr[i];
                                    index = str.indexOf("=");
                                    if (index <= 0) break block27;
                                    String key = str.substring(0, index).trim();
                                    String val = str.substring(index + 1).trim();
                                    if (key.startsWith("range")) break block28;
                                    if (key.equals("itag")) {
                                        itag = Integer.parseInt(val);
                                    }
                                    if (key.equals("clen")) {
                                        clen = Integer.parseInt(val);
                                    }
                                    if (key.startsWith("mime")) {
                                        mime = URLDecoder.decode(val, "UTF-8");
                                    }
                                    if (str.startsWith("id")) {
                                        id = val;
                                    }
                                }
                                yt_url.append(str);
                                if (i < arr.length - 1) {
                                    yt_url.append("&");
                                }
                            }
                            ++i;
                        }
                        if (itag == 0 || !YtUtil.isNormalVideo(itag)) break block24;
                        Logger.log("Normal vid");
                        return false;
                    }
                    info = new DASH_INFO();
                    info.url = yt_url.toString();
                    info.clen = clen;
                    info.video = mime.startsWith("video");
                    info.itag = itag;
                    info.id = id;
                    info.mime = mime;
                    info.headers = data.getRequestHeaders();
                    Logger.log("processing yt mime: " + mime + " id: " + id + " clen: " + clen + " itag: " + itag);
                    if (!YtUtil.addToQueue(info)) break block25;
                    DASH_INFO di = YtUtil.getDASHPair(info);
                    if (di != null) {
                        DashMetadata dm = new DashMetadata();
                        dm.setUrl(info.video ? info.url : di.url);
                        dm.setUrl2(info.video ? di.url : info.url);
                        dm.setLen1(info.video ? info.clen : di.clen);
                        dm.setLen2(info.video ? di.clen : info.clen);
                        dm.setHeaders(info.video ? info.headers : di.headers);
                        dm.setHeaders2(info.video ? di.headers : info.headers);
                        String file = data.getFile();
                        file = StringUtils.isNullOrEmptyOrBlank(file) ? XDMUtils.getFileName(data.getUrl()) : XDMUtils.createSafeFileName(file);
                        Logger.log("file: " + file + " url1: " + dm.getUrl() + " url2: " + dm.getUrl2() + " len1: " + dm.getLen1() + " len2: " + dm.getLen2());
                        String szStr = null;
                        if (info.clen > 0L && di.clen > 0L) {
                            szStr = FormatUtilities.formatSize(info.clen + di.clen);
                        }
                        String videoContentType = info.video ? info.mime : di.mime;
                        String audioContentType = di.video ? info.mime : di.mime;
                        String ext = this.getYtDashFormat(videoContentType, audioContentType);
                        file = String.valueOf(file) + "." + ext;
                        XDMApp.getInstance().addMedia(dm, file, String.valueOf(YtUtil.getInfoFromITAG(info.video ? info.itag : di.itag)) + (szStr == null ? "" : " " + szStr));
                        return true;
                    }
                    break block26;
                }
                try {
                    System.out.println("+++updating");
                    XDMApp.getInstance().youtubeVideoTitleUpdated(info.url, data.getFile());
                }
                catch (Exception e) {
                    Logger.log(e);
                }
            }
            return true;
        }
        return false;
    }

    private boolean processVideoManifest(ParsedHookData data) {
        String url = data.getUrl();
        String file = data.getFile();
        String contentType = data.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        String ext = XDMUtils.getExtension(XDMUtils.getFileName(data.getUrl()));
        File manifestfile = null;
        try {
            if (contentType.contains("mpegurl") || ".m3u8".equalsIgnoreCase(ext)) {
                Logger.log("Downloading m3u8 manifest");
                manifestfile = this.downloadMenifest(data);
                boolean bl = M3U8Handler.handle(manifestfile, data);
                return bl;
            }
            if (contentType.contains("f4m") || ".f4m".equalsIgnoreCase(ext)) {
                Logger.log("Downloading f4m manifest");
                manifestfile = this.downloadMenifest(data);
                boolean bl = F4mHandler.handle(manifestfile, data);
                return bl;
            }
            if (url.contains(".facebook.com") && url.toLowerCase().contains("pagelet")) {
                Logger.log("Downloading fb manifest");
                manifestfile = this.downloadMenifest(data);
                boolean bl = FBHandler.handle(manifestfile, data);
                return bl;
            }
            if (url.contains("player.vimeo.com") && contentType.toLowerCase().contains("json")) {
                Logger.log("Downloading video manifest");
                manifestfile = this.downloadMenifest(data);
                boolean bl = VimeoHandler.handle(manifestfile, data);
                return bl;
            }
            if (url.contains("instagram.com/p/")) {
                Logger.log("Downloading video manifest");
                manifestfile = this.downloadMenifest(data);
                boolean bl = InstagramHandler.handle(manifestfile, data);
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (manifestfile != null) {
                manifestfile.delete();
            }
        }
        return false;
    }

    private void processNormalVideo(ParsedHookData data) {
        String sz;
        String file = data.getFile();
        String type = data.getContentType();
        if (type == null) {
            type = "";
        }
        if (StringUtils.isNullOrEmptyOrBlank(file)) {
            file = XDMUtils.getFileName(data.getUrl());
        }
        String ext = "";
        if (type.contains("video/mp4")) {
            ext = "mp4";
        } else if (type.contains("video/x-flv")) {
            ext = "flv";
        } else if (type.contains("video/webm")) {
            ext = "mkv";
        } else if (type.contains("matroska") || type.contains("mkv")) {
            ext = "mkv";
        } else if (type.equals("audio/mpeg") || type.contains("audio/mp3")) {
            ext = "mp3";
        } else if (type.contains("audio/aac")) {
            ext = "aac";
        } else if (type.contains("audio/mp4")) {
            ext = "m4a";
        } else {
            return;
        }
        file = String.valueOf(file) + "." + ext;
        if (data.getContentLength() < (long)Config.getInstance().getMinVidSize()) {
            Logger.log("video less than min size");
            return;
        }
        HttpMetadata metadata = new HttpMetadata();
        metadata.setUrl(data.getUrl());
        metadata.setHeaders(data.getRequestHeaders());
        metadata.setSize(data.getContentLength());
        long size = data.getContentLength();
        if (size > 0L && data.isPartialResponse()) {
            size = -1L;
        }
        String string = sz = size > 0L ? FormatUtilities.formatSize(size) : "";
        if (ext.length() > 0) {
            sz = String.valueOf(sz) + " " + ext.toUpperCase();
        }
        XDMApp.getInstance().addMedia(metadata, file, sz);
    }

    private File downloadMenifest(ParsedHookData data) {
        JavaHttpClient client = null;
        OutputStream out = null;
        try {
            client = new JavaHttpClient(data.getUrl());
            Iterator<HttpHeader> headers = data.getRequestHeaders().getAll();
            while (headers.hasNext()) {
                HttpHeader header = headers.next();
                client.addHeader(header.getName(), header.getValue());
            }
            client.setFollowRedirect(true);
            client.connect();
            int resp = client.getStatusCode();
            Logger.log("manifest download response: " + resp);
            if (resp == 206 || resp == 200) {
                InputStream in = client.getInputStream();
                File tmpFile = new File(Config.getInstance().getTemporaryFolder(), UUID.randomUUID().toString());
                long len = client.getContentLength();
                out = new FileOutputStream(tmpFile);
                XDMUtils.copyStream(in, out, len);
                Logger.log("manifest download successfull");
                File file = tmpFile;
                return file;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                client.dispose();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private String getYtDashFormat(String videoContentType, String audioContentType) {
        if (videoContentType == null) {
            videoContentType = "";
        }
        if (audioContentType == null) {
            audioContentType = "";
        }
        if (videoContentType.contains("mp4") && audioContentType.contains("mp4")) {
            return "mp4";
        }
        return "mkv";
    }
}

