/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import xdman.Config;
import xdman.DownloadQueue;
import xdman.QueueManager;
import xdman.XDMApp;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.mediaconversion.MediaFormat;
import xdman.mediaconversion.MediaFormats;
import xdman.ui.components.CustomButton;
import xdman.ui.components.MediaDownloaderWnd;
import xdman.ui.components.QueueListRenderer;
import xdman.ui.components.TitlePanel;
import xdman.ui.components.XDMFileChooser;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class BatchVideoWnd
extends JDialog
implements ActionListener {
    private JTextField txtFile;
    private JTextField txtQName;
    private JLabel lblName;
    private JComboBox<String> cmbQueOpts;
    private JComboBox<DownloadQueue> cmbQueues;
    private DefaultComboBoxModel<DownloadQueue> queueModel;
    private SimpleDateFormat dateFormat;
    private JComboBox<MediaFormat> cmbOutFormat;
    private ArrayList<MediaDownloaderWnd.VideoWrapper> items;

    public BatchVideoWnd(ArrayList<MediaDownloaderWnd.VideoWrapper> items) {
        this.items = items;
        this.initUI();
    }

    private void initUI() {
        this.setUndecorated(true);
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT) && !Config.getInstance().isNoTransparency()) {
                this.setOpacity(0.85f);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.setIconImage(ImageResource.get("icon.png").getImage());
        this.setSize(400, 310);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(ColorResource.getDarkestBgColor());
        TitlePanel titlePanel = new TitlePanel(null, this);
        titlePanel.setOpaque(false);
        titlePanel.setBounds(0, 0, 400, 50);
        CustomButton closeBtn = new CustomButton();
        closeBtn.setBounds(365, 5, 30, 30);
        closeBtn.setBackground(ColorResource.getDarkestBgColor());
        closeBtn.setBorderPainted(false);
        closeBtn.setFocusPainted(false);
        closeBtn.setName("CLOSE");
        closeBtn.setIcon(ImageResource.get("close_btn.png"));
        closeBtn.addActionListener(this);
        titlePanel.add(closeBtn);
        JLabel titleLbl = new JLabel(StringResource.get("VID_TITLE"));
        titleLbl.setFont(FontResource.getBiggerFont());
        titleLbl.setForeground(ColorResource.getSelectionColor());
        titleLbl.setBounds(25, 15, 200, 30);
        titlePanel.add(titleLbl);
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, 55, 400, 1);
        lineLbl.setOpaque(true);
        this.add(lineLbl);
        this.txtFile = new JTextField();
        this.txtFile.setBorder(new LineBorder(ColorResource.getSelectionColor(), 1));
        this.txtFile.setBackground(ColorResource.getDarkestBgColor());
        this.txtFile.setForeground(Color.WHITE);
        this.txtFile.setBounds(97, 80, 221, 20);
        this.txtFile.setCaretColor(ColorResource.getSelectionColor());
        this.add(this.txtFile);
        this.txtFile.setText(Config.getInstance().getDownloadFolder());
        CustomButton browse = new CustomButton("...");
        browse.setName("BROWSE_FOLDER");
        browse.setMargin(new Insets(0, 0, 0, 0));
        browse.setBounds(325, 80, 40, 20);
        browse.setFocusPainted(false);
        browse.setBackground(ColorResource.getDarkestBgColor());
        browse.setBorder(new LineBorder(ColorResource.getSelectionColor(), 1));
        browse.setForeground(Color.WHITE);
        browse.addActionListener(this);
        browse.setFont(FontResource.getItemFont());
        this.add(browse);
        this.add(titlePanel);
        JLabel lblFile = new JLabel(StringResource.get("LBL_SAVE_IN"), 4);
        lblFile.setFont(FontResource.getNormalFont());
        lblFile.setForeground(Color.WHITE);
        lblFile.setBounds(10, 80, 81, 23);
        this.add(lblFile);
        JLabel lblFmt = new JLabel(StringResource.get("LBL_CONVERT_TO"), 4);
        lblFmt.setFont(FontResource.getNormalFont());
        lblFmt.setForeground(Color.WHITE);
        lblFmt.setBounds(10, 120, 81, 23);
        this.add(lblFmt);
        this.cmbOutFormat = new JComboBox<MediaFormat>(MediaFormats.getSupportedFormats());
        this.cmbOutFormat.setFont(FontResource.getNormalFont());
        this.cmbOutFormat.setName("FORMAT_SELECT");
        this.cmbOutFormat.setBounds(97, 120, 180, 23);
        this.cmbOutFormat.addActionListener(this);
        this.add(this.cmbOutFormat);
        JLabel lblQueue = new JLabel(StringResource.get("LBL_QUEUE_USE"), 4);
        lblQueue.setFont(FontResource.getNormalFont());
        lblQueue.setForeground(Color.WHITE);
        lblQueue.setBounds(10, 160, 81, 23);
        this.add(lblQueue);
        this.cmbQueOpts = new JComboBox<String>(new String[]{StringResource.get("LBL_QUEUE_OPT1"), StringResource.get("LBL_QUEUE_OPT2"), StringResource.get("LBL_QUEUE_OPT3")});
        this.cmbQueOpts.setFont(FontResource.getNormalFont());
        this.cmbQueOpts.setForeground(Color.WHITE);
        this.cmbQueOpts.setName("QUEUE_OPTS");
        this.cmbQueOpts.setBounds(97, 160, 180, 23);
        this.cmbQueOpts.addActionListener(this);
        this.add(this.cmbQueOpts);
        this.lblName = new JLabel(StringResource.get("LBL_NEW_QUEUE"), 4);
        this.lblName.setFont(FontResource.getNormalFont());
        this.lblName.setForeground(Color.WHITE);
        this.lblName.setBounds(10, 200, 81, 23);
        this.add(this.lblName);
        this.txtQName = new JTextField();
        this.txtQName.setBorder(new LineBorder(ColorResource.getSelectionColor(), 1));
        this.txtQName.setBackground(ColorResource.getDarkestBgColor());
        this.txtQName.setForeground(Color.WHITE);
        this.txtQName.setBounds(97, 200, 221, 20);
        this.txtQName.setCaretColor(ColorResource.getSelectionColor());
        this.txtQName.setText(this.getNewQueName());
        this.add(this.txtQName);
        this.queueModel = new DefaultComboBoxModel();
        ArrayList<DownloadQueue> qlist = QueueManager.getInstance().getQueueList();
        int i = 0;
        while (i < qlist.size()) {
            this.queueModel.addElement(qlist.get(i));
            ++i;
        }
        this.cmbQueues = new JComboBox<DownloadQueue>(this.queueModel);
        this.cmbQueues.setRenderer(new QueueListRenderer());
        this.cmbQueues.setBounds(97, 200, 221, 20);
        this.cmbQueues.setVisible(false);
        this.add(this.cmbQueues);
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 260, 400, 50);
        panel.setBackground(Color.DARK_GRAY);
        this.add(panel);
        CustomButton downloadBtn = new CustomButton(StringResource.get("ND_DOWNLOAD_NOW"));
        this.styleButton(downloadBtn);
        downloadBtn.setName("DOWNLOAD");
        downloadBtn.setBounds(201, 1, 200, 50);
        panel.add(downloadBtn);
        CustomButton cancelBtn = new CustomButton(StringResource.get("ND_CANCEL"));
        this.styleButton(cancelBtn);
        cancelBtn.setName("CANCEL");
        cancelBtn.setBounds(0, 1, 200, 50);
        panel.add(cancelBtn);
    }

    private void styleButton(CustomButton btn) {
        btn.setBackground(ColorResource.getDarkestBgColor());
        btn.setPressedBackground(ColorResource.getDarkerBgColor());
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getBigFont());
        btn.setBorderPainted(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.setFocusPainted(false);
        btn.addActionListener(this);
    }

    private JButton createButton(String name) {
        CustomButton btn = new CustomButton(StringResource.get(name));
        btn.setBackground(ColorResource.getDarkBtnColor());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getNormalFont());
        btn.addActionListener(this);
        return btn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = ((JComponent)e.getSource()).getName();
        if ("BROWSE_FOLDER".equals(name)) {
            JFileChooser jfc = XDMFileChooser.getFileChooser(1, new File(this.txtFile.getText()));
            if (jfc.showOpenDialog(this) == 0) {
                this.txtFile.setText(jfc.getSelectedFile().getAbsolutePath());
            }
        } else if ("DOWNLOAD".equals(name)) {
            this.download();
            this.dispose();
        } else if ("CLOSE".equals(name)) {
            this.dispose();
        } else if ("QUEUE_OPTS".equals(name)) {
            this.queueOptionUpdated();
        }
    }

    private void queueOptionUpdated() {
        System.out.println("called");
        if (this.cmbQueOpts.getSelectedIndex() == 0) {
            this.lblName.setVisible(true);
            this.txtQName.setVisible(true);
            this.cmbQueues.setVisible(false);
            this.txtQName.setText(this.getNewQueName());
        } else {
            this.lblName.setVisible(false);
            this.txtQName.setVisible(false);
            this.cmbQueues.setVisible(this.cmbQueOpts.getSelectedIndex() == 1);
        }
    }

    private String getNewQueName() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("d MMM HH:mm");
        }
        return String.valueOf(StringResource.get("Q_WORD")) + " " + this.dateFormat.format(new Date());
    }

    private void createDownload(DownloadQueue q) {
        String folder = this.txtFile.getText();
        for (MediaDownloaderWnd.VideoWrapper vw : this.items) {
            String file = XDMUtils.createSafeFileName(vw.file);
            HttpMetadata metadata = vw.md;
            XDMApp.getInstance().createDownload(file, folder, metadata, q == null, q == null ? "" : q.getQueueId(), 0, 0);
        }
    }

    private void download() {
        int opt = this.cmbQueOpts.getSelectedIndex();
        switch (opt) {
            case 0: {
                DownloadQueue q = QueueManager.getInstance().createNewQueue();
                q.setName(this.txtQName.getText());
                QueueManager.getInstance().saveQueues();
                this.createDownload(q);
                q.start();
                break;
            }
            case 1: {
                DownloadQueue queue = (DownloadQueue)this.cmbQueues.getSelectedItem();
                if (queue == null) break;
                this.createDownload(queue);
                queue.start();
                break;
            }
            case 2: {
                this.createDownload(null);
            }
        }
    }
}

