/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import xdman.Config;
import xdman.ui.components.CustomButton;
import xdman.ui.components.TitlePanel;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class DownloadCompleteWnd
extends JDialog
implements ActionListener {
    JTextField txtFile;
    JTextField txtFolder;
    JCheckBox chkDontShow;

    public DownloadCompleteWnd(String file, String folder) {
        this.initUI(file, folder);
    }

    private void initUI(String file, String folder) {
        this.setUndecorated(true);
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT) && !Config.getInstance().isNoTransparency()) {
                this.setOpacity(0.85f);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.setIconImage(ImageResource.get("icon.png").getImage());
        this.setSize(350, 210);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(ColorResource.getDarkestBgColor());
        TitlePanel titlePanel = new TitlePanel(null, this);
        titlePanel.setOpaque(false);
        titlePanel.setBounds(0, 0, 350, 50);
        this.add(titlePanel);
        CustomButton closeBtn = new CustomButton();
        closeBtn.setBounds(310, 5, 30, 30);
        closeBtn.setBackground(ColorResource.getDarkestBgColor());
        closeBtn.setBorderPainted(false);
        closeBtn.setFocusPainted(false);
        closeBtn.setName("CLOSE");
        closeBtn.setIcon(ImageResource.get("close_btn.png"));
        closeBtn.addActionListener(this);
        titlePanel.add(closeBtn);
        JLabel titleLbl = new JLabel(StringResource.get("CD_TITLE"));
        titleLbl.setFont(FontResource.getBiggerFont());
        titleLbl.setForeground(ColorResource.getSelectionColor());
        titleLbl.setBounds(25, 15, 200, 30);
        titlePanel.add(titleLbl);
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, 55, 350, 1);
        lineLbl.setOpaque(true);
        this.add(lineLbl);
        JLabel lblFile = new JLabel(StringResource.get("ND_FILE"), 4);
        lblFile.setBounds(0, 75, 70, 20);
        lblFile.setForeground(Color.WHITE);
        this.add(lblFile);
        JLabel lblSave = new JLabel(StringResource.get("CD_LOC"), 4);
        lblSave.setBounds(0, 100, 70, 20);
        lblSave.setForeground(Color.WHITE);
        this.add(lblSave);
        this.txtFile = new JTextField();
        this.txtFile.setText(file);
        this.txtFile.setEditable(false);
        this.txtFile.setBorder(new LineBorder(ColorResource.getSelectionColor(), 1));
        this.txtFile.setBackground(ColorResource.getDarkestBgColor());
        this.txtFile.setForeground(Color.WHITE);
        this.txtFile.setBounds(80, 75, 220, 20);
        this.txtFile.setCaretColor(ColorResource.getSelectionColor());
        this.add(this.txtFile);
        this.txtFolder = new JTextField();
        this.txtFolder.setText(folder);
        this.txtFolder.setEditable(false);
        this.txtFolder.setBorder(new LineBorder(ColorResource.getSelectionColor(), 1));
        this.txtFolder.setBackground(ColorResource.getDarkestBgColor());
        this.txtFolder.setForeground(Color.WHITE);
        this.txtFolder.setBounds(80, 100, 220, 20);
        this.txtFolder.setCaretColor(ColorResource.getSelectionColor());
        this.add(this.txtFolder);
        this.chkDontShow = new JCheckBox(StringResource.get("MSG_DONT_SHOW_AGAIN"));
        this.chkDontShow.setBackground(ColorResource.getDarkestBgColor());
        this.chkDontShow.setName("MSG_DONT_SHOW_AGAIN");
        this.chkDontShow.setForeground(Color.WHITE);
        this.chkDontShow.setFocusPainted(false);
        this.chkDontShow.setBounds(75, 125, 200, 20);
        this.chkDontShow.setIcon(ImageResource.get("unchecked.png"));
        this.chkDontShow.setSelectedIcon(ImageResource.get("checked.png"));
        this.chkDontShow.addActionListener(this);
        this.add(this.chkDontShow);
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 155, 400, 55);
        panel.setBackground(Color.DARK_GRAY);
        this.add(panel);
        CustomButton btnMore = new CustomButton(StringResource.get("CD_OPEN_FILE"));
        CustomButton btnDN = new CustomButton(StringResource.get("CD_OPEN_FOLDER"));
        CustomButton btnCN = new CustomButton(StringResource.get("ND_CANCEL"));
        btnMore.setBounds(0, 1, 100, 55);
        btnMore.setName("CTX_OPEN_FILE");
        this.styleButton(btnMore);
        panel.add(btnMore);
        btnDN.setBounds(101, 1, 148, 55);
        btnDN.setName("CTX_OPEN_FOLDER");
        this.styleButton(btnDN);
        panel.add(btnDN);
        btnCN.setBounds(250, 1, 100, 55);
        btnCN.setName("CLOSE");
        this.styleButton(btnCN);
        panel.add(btnCN);
    }

    private void styleButton(CustomButton btn) {
        btn.setBackground(ColorResource.getDarkestBgColor());
        btn.setPressedBackground(ColorResource.getDarkerBgColor());
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getBigFont());
        btn.setBorderPainted(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.setFocusPainted(false);
        btn.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComponent) {
            String name = ((JComponent)e.getSource()).getName();
            if (name.startsWith("MSG_DONT_SHOW_AGAIN")) {
                Config.getInstance().setShowDownloadCompleteWindow(!this.chkDontShow.isSelected());
            } else if (name.equals("CLOSE")) {
                this.dispose();
            } else if (name.equals("CTX_OPEN_FILE")) {
                try {
                    XDMUtils.openFile(this.txtFile.getText(), this.txtFolder.getText());
                    this.dispose();
                }
                catch (Exception e1) {
                    Logger.log(e1);
                }
            } else if (name.equals("CTX_OPEN_FOLDER")) {
                try {
                    XDMUtils.openFolder(this.txtFile.getText(), this.txtFolder.getText());
                    this.dispose();
                }
                catch (Exception e1) {
                    Logger.log(e1);
                }
            }
        }
    }
}

