/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import xdman.ui.components.CustomButton;
import xdman.ui.components.DarkScrollBar;
import xdman.ui.components.XDMFrame;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;

public class MessageBox
extends JPanel
implements ActionListener {
    private static MessageBox msgBox;
    public static final int OK = 10;
    public static final int YES = 20;
    public static final int NO = 30;
    public static final int OK_OPTION = 10;
    public static final int YES_NO_OPTION = 20;
    private JTextArea txtMessage;
    private JLabel lblTitle;
    private JCheckBox chkOption;
    private int diffx;
    private int diffy;
    private XDMFrame parent;
    private CustomButton cbBtnOk;
    private CustomButton cbBtnYes;
    private CustomButton cbBtnNo;
    private JPanel panel2;
    private JPanel panel3;
    private int res;
    private static MsgBoxFocusTraversalPolicy focusPolicy;
    private int defaultButton;
    private JScrollPane jsp;

    private MessageBox() {
        this.setLayout(null);
        MouseInputAdapter ma = new MouseInputAdapter(){};
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        this.init();
    }

    public static int show(XDMFrame parent, String title, String msg, int buttons, int defaultButton) {
        return MessageBox.show(parent, title, msg, buttons, defaultButton, null);
    }

    public static int show(XDMFrame parent, String title, String msg, int buttons, int defaultButton, String checkText) {
        if (msgBox == null) {
            msgBox = new MessageBox();
        }
        MessageBox.msgBox.parent = parent;
        MessageBox.msgBox.lblTitle.setText(title);
        MessageBox.msgBox.txtMessage.setText(msg);
        msgBox.setLocation((parent.getWidth() - 350) / 2, (parent.getHeight() - 210) / 2);
        if (buttons == 10) {
            MessageBox.msgBox.panel2.setVisible(false);
            MessageBox.msgBox.panel3.setVisible(true);
        } else {
            MessageBox.msgBox.panel2.setVisible(true);
            MessageBox.msgBox.panel3.setVisible(false);
        }
        MessageBox.msgBox.defaultButton = defaultButton;
        if (checkText != null) {
            MessageBox.msgBox.chkOption.setSelected(false);
            MessageBox.msgBox.chkOption.setVisible(true);
            MessageBox.msgBox.jsp.setBounds(0, 54, 350, 76);
        } else {
            MessageBox.msgBox.chkOption.setSelected(false);
            MessageBox.msgBox.chkOption.setVisible(false);
            MessageBox.msgBox.jsp.setBounds(0, 54, 350, 106);
        }
        parent.showModal(msgBox);
        return MessageBox.msgBox.res;
    }

    public void selectDefaultButton() {
        if (this.defaultButton == 20) {
            MessageBox.msgBox.cbBtnYes.requestFocusInWindow();
        } else if (this.defaultButton == 30) {
            MessageBox.msgBox.cbBtnNo.requestFocusInWindow();
        } else if (this.defaultButton == 10) {
            MessageBox.msgBox.cbBtnOk.requestFocusInWindow();
        }
    }

    private void init() {
        this.lblTitle = new JLabel();
        this.txtMessage = new JTextArea();
        this.txtMessage.setWrapStyleWord(true);
        this.txtMessage.setLineWrap(true);
        this.txtMessage.setBackground(ColorResource.getDarkerBgColor());
        this.txtMessage.setForeground(Color.WHITE);
        this.txtMessage.setBorder(new EmptyBorder(new Insets(10, 10, 10, 30)));
        this.txtMessage.setEditable(false);
        this.setBackground(ColorResource.getDarkerBgColor());
        this.setBounds(0, 0, 350, 210);
        this.lblTitle.setBounds(25, 15, 300, 30);
        this.lblTitle.setFont(FontResource.getItemFont());
        this.lblTitle.setForeground(ColorResource.getSelectionColor());
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, 52, 350, 2);
        lineLbl.setOpaque(true);
        this.jsp = new JScrollPane(this.txtMessage);
        DarkScrollBar sc1 = new DarkScrollBar(1);
        this.jsp.setVerticalScrollBar(sc1);
        this.jsp.setBounds(0, 54, 350, 106);
        this.jsp.setBorder(null);
        this.chkOption = new JCheckBox(StringResource.get("LBL_DELETE_FILE"));
        this.chkOption.setIcon(ImageResource.get("unchecked.png"));
        this.chkOption.setSelectedIcon(ImageResource.get("checked.png"));
        this.chkOption.setBounds(15, 130, 320, 30);
        this.chkOption.setOpaque(false);
        this.chkOption.setFocusPainted(false);
        this.chkOption.setForeground(Color.WHITE);
        this.panel2 = new JPanel(null);
        this.panel2.setBounds(0, 160, 350, 50);
        this.panel2.setBackground(ColorResource.getDarkBgColor());
        this.panel3 = new JPanel(null);
        this.panel3.setBounds(0, 160, 350, 50);
        this.panel3.setBackground(ColorResource.getDarkBgColor());
        this.cbBtnOk = new CustomButton(StringResource.get("MB_OK"));
        this.cbBtnYes = new CustomButton(StringResource.get("MB_YES"));
        this.cbBtnNo = new CustomButton(StringResource.get("MB_NO"));
        this.cbBtnOk.setBounds(0, 1, 350, 50);
        this.cbBtnOk.setName("MB_OK");
        this.applyStyle(this.cbBtnOk);
        this.cbBtnYes.setBounds(0, 1, 174, 50);
        this.cbBtnYes.setName("MB_YES");
        this.cbBtnYes.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                MessageBox.this.cbBtnYes.setMnemonic(-1);
            }

            @Override
            public void focusGained(FocusEvent e) {
                MessageBox.this.cbBtnYes.setMnemonic(89);
            }
        });
        this.applyStyle(this.cbBtnYes);
        this.cbBtnNo.setBounds(175, 1, 175, 50);
        this.cbBtnNo.setName("MB_NO");
        this.cbBtnNo.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                MessageBox.this.cbBtnNo.setMnemonic(-1);
            }

            @Override
            public void focusGained(FocusEvent e) {
                MessageBox.this.cbBtnNo.setMnemonic(78);
            }
        });
        this.applyStyle(this.cbBtnNo);
        this.panel3.add(this.cbBtnOk);
        this.panel2.add(this.cbBtnYes);
        this.panel2.add(this.cbBtnNo);
        this.add(this.lblTitle);
        this.add(lineLbl);
        this.add(this.jsp);
        this.add(this.panel2);
        this.add(this.panel3);
        this.add(this.chkOption);
        this.registerMouseListener();
        Vector<Component> order = new Vector<Component>();
        order.add(this.cbBtnYes);
        order.add(this.cbBtnNo);
        focusPolicy = new MsgBoxFocusTraversalPolicy(order);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(focusPolicy);
    }

    public static MsgBoxFocusTraversalPolicy getFocusPolicy() {
        return focusPolicy;
    }

    public static void setFocusPolicy(MsgBoxFocusTraversalPolicy fp) {
        focusPolicy = fp;
    }

    void applyStyle(JButton btn) {
        btn.addActionListener(this);
        btn.setBackground(ColorResource.getDarkerBgColor());
        btn.setForeground(Color.WHITE);
        btn.setFocusable(true);
        btn.setFont(FontResource.getBigFont());
        btn.setBorderPainted(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "pressed");
        btn.getInputMap(0).put(KeyStroke.getKeyStroke("released ENTER"), "released");
    }

    private void updatePositions() {
    }

    public void registerMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                MessageBox.this.diffx = me.getXOnScreen() - MessageBox.this.getLocationOnScreen().x + ((MessageBox)MessageBox.this).parent.getLocationOnScreen().x;
                MessageBox.this.diffy = me.getYOnScreen() - MessageBox.this.getLocationOnScreen().y + ((MessageBox)MessageBox.this).parent.getLocationOnScreen().y;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                int left = me.getXOnScreen() - MessageBox.this.diffx;
                int top = me.getYOnScreen() - MessageBox.this.diffy;
                int right = left + MessageBox.this.getWidth();
                int bottom = top + MessageBox.this.getHeight();
                if (MessageBox.this.parent.contains(left, top) && MessageBox.this.parent.contains(right, bottom)) {
                    MessageBox.this.setLocation(left, top);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.res = e.getSource() == this.cbBtnOk ? 10 : (e.getSource() == this.cbBtnYes ? 20 : 30);
        this.parent.hideModal(msgBox);
    }

    public static boolean isChecked() {
        return msgBox != null ? MessageBox.msgBox.chkOption.isSelected() : false;
    }

    public static class MsgBoxFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order;

        public MsgBoxFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

