/*
 * Decompiled with CFR 0.152.
 */
package xdman.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class LinuxUtils {
    static String[] shutdownCmds = new String[]{"dbus-send --system --print-reply --dest=org.freedesktop.login1 /org/freedesktop/login1 \"org.freedesktop.login1.Manager.PowerOff\" boolean:true", "dbus-send --system --print-reply --dest=\"org.freedesktop.ConsoleKit\" /org/freedesktop/ConsoleKit/Manager org.freedesktop.ConsoleKit.Manager.Stop", "systemctl poweroff"};

    public static void initShutdown() {
        int i = 0;
        while (i < shutdownCmds.length) {
            String cmd = shutdownCmds[0];
            try {
                Process proc = Runtime.getRuntime().exec(cmd);
                int ret = proc.waitFor();
                if (ret == 0) {
                    break;
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
            ++i;
        }
    }

    public static void open(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException();
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("xdg-open", f.getAbsolutePath());
            pb.start();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void keepAwakePing() {
        try {
            Runtime.getRuntime().exec("dbus-send --print-reply --type=method_call --dest=org.freedesktop.ScreenSaver /ScreenSaver org.freedesktop.ScreenSaver.SimulateUserActivity");
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void addToStartup() {
        File f;
        block14: {
            File dir = new File(System.getProperty("user.home"), ".config/autostart");
            dir.mkdirs();
            f = new File(dir, "xdman.desktop");
            FileOutputStream fs = null;
            try {
                try {
                    fs = new FileOutputStream(f);
                    fs.write(LinuxUtils.getDesktopFileString().getBytes());
                }
                catch (Exception e) {
                    Logger.log(e);
                    try {
                        if (fs != null) {
                            fs.close();
                        }
                        break block14;
                    }
                    catch (Exception exception) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        fs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        f.setExecutable(true);
    }

    public static boolean isAlreadyAutoStart() {
        File f = new File(System.getProperty("user.home"), ".config/autostart/xdman.desktop");
        if (!f.exists()) {
            return false;
        }
        FileInputStream in = null;
        byte[] buf = new byte[(int)f.length()];
        try {
            in = new FileInputStream(f);
            if ((long)in.read(buf) != f.length()) {
                return false;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        String str = new String(buf);
        String s1 = LinuxUtils.getProperPath(System.getProperty("java.home"));
        String s2 = XDMUtils.getJarFile().getAbsolutePath();
        return str.contains(s1) && str.contains(s2);
    }

    public static void removeFromStartup() {
        File f = new File(System.getProperty("user.home"), ".config/autostart/xdman.desktop");
        f.delete();
    }

    private static String getDesktopFileString() {
        String str = "[Desktop Entry]\r\nEncoding=UTF-8\r\nVersion=1.0\r\nType=Application\r\nTerminal=false\r\nExec=\"%sbin/java\" -Xmx1024m -jar \"%s\" -m\r\nName=Xtreme Download Manager\r\nComment=Xtreme Download Manager\r\nCategories=Network;\r\nIcon=/opt/xdman/icon.png";
        String s1 = LinuxUtils.getProperPath(System.getProperty("java.home"));
        String s2 = XDMUtils.getJarFile().getAbsolutePath();
        return String.format(str, s1, s2);
    }

    private static String getProperPath(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return String.valueOf(path) + "/";
    }

    public static void browseURL(String url) {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("xdg-open", url);
            pb.start();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static String getXDGDownloaDir() {
        block16: {
            BufferedReader br = null;
            try {
                File f;
                br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(System.getProperty("user.home"), ".config/user-dirs.dirs"))));
                while (true) {
                    int index;
                    String line;
                    if ((line = br.readLine()) == null) {
                        break block16;
                    }
                    if (!line.startsWith("XDG_DOWNLOAD_DIR") || (index = line.indexOf("=")) == -1) continue;
                    String path = line.substring(index + 1).trim();
                    f = new File(path = path.replace("$HOME", System.getProperty("user.home")));
                    if (f.exists()) break;
                }
                String string = f.getAbsolutePath();
                return string;
            }
            catch (Exception e) {
                Logger.log(e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return null;
    }
}

