/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.cert.CRLReason;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.InvalidityDateExtension;

public class CertificateRevokedException
extends CertificateException {
    private static final long serialVersionUID = 7839996631571608627L;
    private Date revocationDate;
    private final CRLReason reason;
    private final X500Principal authority;
    private transient Map<String, Extension> extensions;

    public CertificateRevokedException(Date date, CRLReason cRLReason, X500Principal x500Principal, Map<String, Extension> map) {
        if (date == null || cRLReason == null || x500Principal == null || map == null) {
            throw new NullPointerException();
        }
        this.revocationDate = new Date(date.getTime());
        this.reason = cRLReason;
        this.authority = x500Principal;
        this.extensions = Collections.checkedMap(new HashMap(), String.class, Extension.class);
        this.extensions.putAll(map);
    }

    public Date getRevocationDate() {
        return (Date)this.revocationDate.clone();
    }

    public CRLReason getRevocationReason() {
        return this.reason;
    }

    public X500Principal getAuthorityName() {
        return this.authority;
    }

    public Date getInvalidityDate() {
        Extension extension = this.getExtensions().get("2.5.29.24");
        if (extension == null) {
            return null;
        }
        try {
            Date date = InvalidityDateExtension.toImpl(extension).get("DATE");
            return new Date(date.getTime());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Map<String, Extension> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    @Override
    public String getMessage() {
        return "Certificate has been revoked, reason: " + (Object)((Object)this.reason) + ", revocation date: " + this.revocationDate + ", authority: " + this.authority + ", extension OIDs: " + this.extensions.keySet();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.extensions.size());
        for (Map.Entry<String, Extension> entry : this.extensions.entrySet()) {
            Extension extension = entry.getValue();
            objectOutputStream.writeObject(extension.getId());
            objectOutputStream.writeBoolean(extension.isCritical());
            byte[] byArray = extension.getValue();
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.revocationDate = new Date(this.revocationDate.getTime());
        int n = objectInputStream.readInt();
        this.extensions = n == 0 ? Collections.emptyMap() : new HashMap<String, Extension>(n);
        for (int i = 0; i < n; ++i) {
            String string = (String)objectInputStream.readObject();
            boolean bl = objectInputStream.readBoolean();
            int n2 = objectInputStream.readInt();
            byte[] byArray = new byte[n2];
            objectInputStream.readFully(byArray);
            sun.security.x509.Extension extension = sun.security.x509.Extension.newExtension(new ObjectIdentifier(string), bl, byArray);
            this.extensions.put(string, extension);
        }
    }
}

