/*
 * Decompiled with CFR 0.152.
 */
package xdman.network.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import xdman.util.Logger;

public class FtpClient {
    private String url;
    private int statusCode;
    private String statusMessage;
    private long offset;
    private FTPClient fc;
    private String dir;
    private String file;
    private int port;
    private String host;
    private String path;
    private String user;
    private String password;
    private long length;

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public FtpClient(String url) {
        this.url = url;
    }

    public void connect() throws IOException {
        URI ftpuri;
        Logger.log("Initiate ftp: " + this.url);
        try {
            ftpuri = new URI(this.url);
        }
        catch (URISyntaxException e) {
            Logger.log(e);
            throw new IOException(e);
        }
        this.host = ftpuri.getHost();
        this.port = ftpuri.getPort();
        this.path = ftpuri.getPath();
        Logger.log("Path: " + this.path);
        this.getPath();
        this.fc = new FTPClient();
        Logger.log("Connecting ftp: " + this.host + ":" + this.port);
        if (this.port > 0) {
            this.fc.connect(this.host, this.port);
        } else {
            this.fc.connect(this.host);
        }
        Logger.log("Loggin in");
        this.fc.login(this.user, this.password);
        int reply = this.fc.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.statusCode = 401;
            this.statusMessage = this.fc.getReplyString();
            this.fc.disconnect();
            return;
        }
        Logger.log("Going binary");
        this.fc.setFileType(2);
        reply = this.fc.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.statusCode = 403;
            this.statusMessage = this.fc.getReplyString();
            this.fc.disconnect();
            return;
        }
        Logger.log("Going passive");
        this.fc.enterLocalPassiveMode();
        Logger.log("cd " + this.dir);
        this.fc.changeWorkingDirectory(this.dir);
        reply = this.fc.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.statusCode = 403;
            this.statusMessage = this.fc.getReplyString();
            this.fc.disconnect();
            return;
        }
        Logger.log("Listing files");
        FTPFile[] files = this.fc.listFiles(this.dir);
        reply = this.fc.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.statusCode = 403;
            this.statusMessage = this.fc.getReplyString();
            this.fc.disconnect();
            return;
        }
        int i = 0;
        while (i < files.length) {
            FTPFile f = files[i];
            if (f.getName().equals(this.file)) {
                this.length = f.getSize();
                Logger.log("Length retrived: " + this.length);
                break;
            }
            ++i;
        }
        this.statusCode = 200;
        if (this.offset > 0L && this.length > 0L) {
            Logger.log("Setting offset");
            this.fc.setRestartOffset(this.offset);
            if (!FTPReply.isPositiveCompletion(reply)) {
                throw new IOException(this.fc.getReplyString());
            }
            this.length -= this.offset;
            Logger.log("Length after seek: " + this.length);
            this.statusCode = 206;
        }
    }

    public void close() throws IOException {
        this.fc.disconnect();
    }

    public InputStream getInputStream() throws IOException {
        return this.fc.retrieveFileStream(this.file);
    }

    private void getPath() {
        int pos = this.path.lastIndexOf("/");
        if (pos < 0) {
            return;
        }
        this.dir = this.path.substring(0, pos);
        if (this.dir.length() < 1) {
            this.dir = "/";
        }
        if (pos == this.path.length() - 1) {
            return;
        }
        if (pos < this.path.length() - 1) {
            this.file = this.path.substring(pos + 1);
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getContentLength() {
        return this.length;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.fc.getPassivePort();
    }

    public void dispose() {
        try {
            this.fc.disconnect();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }
}

