/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import xdman.Config;
import xdman.mediaconversion.Format;
import xdman.mediaconversion.FormatGroup;
import xdman.mediaconversion.FormatLoader;
import xdman.mediaconversion.MediaFormat;
import xdman.ui.components.CustomButton;
import xdman.ui.components.DarkScrollBar;
import xdman.ui.components.MediaFormatRender;
import xdman.ui.components.SimpleListRenderer;
import xdman.ui.components.TitlePanel;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.Logger;
import xdman.util.StringUtils;

public class MediaFormatWnd
extends JDialog
implements ActionListener {
    boolean selected;
    MediaFormat fmt;
    String text;
    JList<Format> listFormat;
    JComboBox<String> cmbSize;
    JComboBox<String> cmbAc;
    JComboBox<String> cmbAbr;
    JComboBox<String> cmbAsr;
    JComboBox<String> cmbVBR;
    JComboBox<String> cmbFrameRate;
    JComboBox<String> cmbResolution;
    JComboBox<String> cmbAudioCodec;
    JComboBox<String> cmbVideoCodec;

    public MediaFormatWnd() {
        this.initUI();
    }

    private void initUI() {
        this.setUndecorated(true);
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT) && !Config.getInstance().isNoTransparency()) {
                this.setOpacity(0.85f);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.setModal(true);
        this.setTitle(StringResource.get("LBL_CONVERT_TO"));
        this.setIconImage(ImageResource.get("icon.png").getImage());
        this.setSize(600, 450);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(ColorResource.getDarkestBgColor());
        TitlePanel titlePanel = new TitlePanel(null, this);
        titlePanel.setOpaque(false);
        titlePanel.setBounds(0, 0, this.getWidth(), 50);
        CustomButton closeBtn = new CustomButton();
        closeBtn.setBounds(this.getWidth() - 35, 5, 30, 30);
        closeBtn.setBackground(ColorResource.getDarkestBgColor());
        closeBtn.setBorderPainted(false);
        closeBtn.setFocusPainted(false);
        closeBtn.setName("CLOSE");
        closeBtn.setIcon(ImageResource.get("close_btn.png"));
        closeBtn.addActionListener(this);
        titlePanel.add(closeBtn);
        JLabel titleLbl = new JLabel(StringResource.get("LBL_CONVERT_TO"));
        titleLbl.setFont(FontResource.getBiggerFont());
        titleLbl.setForeground(ColorResource.getSelectionColor());
        titleLbl.setBounds(25, 15, 200, 30);
        titlePanel.add(titleLbl);
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, 55, this.getWidth(), 1);
        lineLbl.setOpaque(true);
        this.add(lineLbl);
        this.add(titlePanel);
        final List<FormatGroup> list = FormatLoader.load();
        FormatGroup[] fgArr = new FormatGroup[list.size()];
        fgArr = list.toArray(fgArr);
        int y = 56;
        y += 10;
        DefaultComboBoxModel<FormatGroup> model = new DefaultComboBoxModel<FormatGroup>();
        for (FormatGroup fg : list) {
            model.addElement(fg);
        }
        final JComboBox<Object> cmbFormatGroup = new JComboBox<Object>(model);
        cmbFormatGroup.setRenderer(new SimpleListRenderer());
        cmbFormatGroup.setBounds(15, y, this.getWidth() - 30, 30);
        this.add(cmbFormatGroup);
        y += 40;
        final DefaultListModel listModel = new DefaultListModel();
        this.listFormat = new JList(listModel);
        this.listFormat.setCellRenderer(new MediaFormatRender());
        this.listFormat.setFont(FontResource.getItemFont());
        this.listFormat.setBackground(ColorResource.getDarkerBgColor());
        this.listFormat.setBorder(null);
        JScrollPane jsp = new JScrollPane(this.listFormat);
        jsp.setBounds(15, y, this.getWidth() - 30, 150);
        jsp.setBorder(null);
        jsp.setBackground(ColorResource.getDarkerBgColor());
        this.add(jsp);
        y += 160;
        DarkScrollBar scrollBar = new DarkScrollBar(1);
        jsp.setVerticalScrollBar(scrollBar);
        jsp.setHorizontalScrollBarPolicy(31);
        jsp.getVerticalScrollBar().setUnitIncrement(10);
        jsp.getVerticalScrollBar().setBlockIncrement(25);
        cmbFormatGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = cmbFormatGroup.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                FormatGroup fg = (FormatGroup)list.get(index);
                List<Format> formats = fg.getFormats();
                System.out.println(formats.size());
                listModel.removeAllElements();
                for (Format format : formats) {
                    listModel.addElement(format);
                }
                if (listModel.getSize() > 0) {
                    MediaFormatWnd.this.listFormat.setSelectedIndex(0);
                }
            }
        });
        int x = 15;
        JLabel lblVideoCodec = new JLabel("Video codec");
        lblVideoCodec.setBounds(x, y += 10, 100, 25);
        this.add(lblVideoCodec);
        JLabel lblAudioCodec = new JLabel("Audio codec");
        lblAudioCodec.setBounds(x += 115, y, 100, 25);
        this.add(lblAudioCodec);
        JLabel lblResolution = new JLabel("Resolution");
        lblResolution.setBounds(x += 115, y, 100, 25);
        this.add(lblResolution);
        JLabel lblFramerate = new JLabel("Frame rate");
        lblFramerate.setBounds(x += 115, y, 100, 25);
        this.add(lblFramerate);
        JLabel lblVideoBitrate = new JLabel("VBR");
        lblVideoBitrate.setBounds(x += 115, y, 100, 25);
        this.add(lblVideoBitrate);
        x += 110;
        x = 15;
        final DefaultComboBoxModel modelVideoCodec = new DefaultComboBoxModel();
        this.cmbVideoCodec = new JComboBox(modelVideoCodec);
        this.cmbVideoCodec.setBounds(x, y += 25, 100, 25);
        this.add(this.cmbVideoCodec);
        final DefaultComboBoxModel modelAudioCodec = new DefaultComboBoxModel();
        this.cmbAudioCodec = new JComboBox(modelAudioCodec);
        this.cmbAudioCodec.setBounds(x += 115, y, 100, 25);
        this.add(this.cmbAudioCodec);
        final DefaultComboBoxModel modelResolution = new DefaultComboBoxModel();
        this.cmbResolution = new JComboBox(modelResolution);
        this.cmbResolution.setBounds(x += 115, y, 100, 25);
        this.add(this.cmbResolution);
        final DefaultComboBoxModel modelFrameRate = new DefaultComboBoxModel();
        this.cmbFrameRate = new JComboBox(modelFrameRate);
        this.cmbFrameRate.setBounds(x += 115, y, 100, 25);
        this.add(this.cmbFrameRate);
        final DefaultComboBoxModel modelVBR = new DefaultComboBoxModel();
        this.cmbVBR = new JComboBox(modelVBR);
        this.cmbVBR.setBounds(x += 115, y, 100, 25);
        this.add(this.cmbVBR);
        x += 115;
        x = 15;
        JLabel lblAsr = new JLabel("Sample rate");
        lblAsr.setBounds(x, y += 30, 100, 25);
        this.add(lblAsr);
        JLabel lblAbr = new JLabel("ABR");
        lblAbr.setBounds(x += 115, y, 100, 25);
        this.add(lblAbr);
        JLabel lblAC = new JLabel("Channel");
        lblAC.setBounds(x += 115, y, 100, 25);
        this.add(lblAC);
        JLabel lblSize = new JLabel("Aspect ratio");
        lblSize.setBounds(x += 115, y, 100, 25);
        this.add(lblSize);
        x += 115;
        x = 15;
        final DefaultComboBoxModel modelAsr = new DefaultComboBoxModel();
        this.cmbAsr = new JComboBox(modelAsr);
        this.cmbAsr.setBounds(x, y += 25, 100, 25);
        this.add(this.cmbAsr);
        final DefaultComboBoxModel modelAbr = new DefaultComboBoxModel();
        this.cmbAbr = new JComboBox(modelAbr);
        this.cmbAbr.setBounds(x += 115, y, 100, 25);
        this.add(this.cmbAbr);
        final DefaultComboBoxModel modelAc = new DefaultComboBoxModel();
        this.cmbAc = new JComboBox(modelAc);
        this.cmbAc.setBounds(x += 115, y, 100, 25);
        this.add(this.cmbAc);
        final DefaultComboBoxModel modelSize = new DefaultComboBoxModel();
        this.cmbSize = new JComboBox(modelSize);
        this.cmbSize.setBounds(x += 115, y, 100, 25);
        this.cmbSize.setOpaque(false);
        this.add(this.cmbSize);
        x += 115;
        y += 50;
        JButton btn = this.createButton2(StringResource.get("ND_CANCEL"));
        btn.setName("CLOSE");
        btn.addActionListener(this);
        btn.setBounds(this.getBounds().width - 100 - 20, this.getHeight() - 45, 100, 30);
        this.add(btn);
        JButton btn2 = this.createButton2(StringResource.get("MSG_OK"));
        btn2.setBounds(this.getBounds().width - 100 - 20 - 100 - 10, this.getHeight() - 45, 100, 30);
        btn2.setName("BTN_OK");
        btn2.addActionListener(this);
        this.add(btn2);
        this.listFormat.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = MediaFormatWnd.this.listFormat.getSelectedIndex();
                System.out.println("List selected " + index);
                if (index < 0) {
                    return;
                }
                Format fmt = (Format)listModel.get(index);
                MediaFormatWnd.this.addToModel(modelVideoCodec, fmt.getVideoCodecs(), fmt.getDefautValue(fmt.getVideoCodecs(), fmt.getDefautVideoCodec()), MediaFormatWnd.this.cmbVideoCodec);
                MediaFormatWnd.this.addToModel(modelAudioCodec, fmt.getAudioCodecs(), fmt.getDefautValue(fmt.getAudioCodecs(), fmt.getDefautAudioCodec()), MediaFormatWnd.this.cmbAudioCodec);
                MediaFormatWnd.this.addToModel(modelResolution, fmt.getResolutions(), fmt.getDefautValue(fmt.getResolutions(), fmt.getDefaultResolution()), MediaFormatWnd.this.cmbResolution);
                MediaFormatWnd.this.addToModel(modelFrameRate, fmt.getFrameRate(), fmt.getDefautValue(fmt.getFrameRate(), fmt.getDefaultFrameRate()), MediaFormatWnd.this.cmbFrameRate);
                MediaFormatWnd.this.addToModel(modelVBR, fmt.getVideoBitrate(), fmt.getDefautValue(fmt.getVideoBitrate(), fmt.getDefaultVideoBitrate()), MediaFormatWnd.this.cmbVBR);
                MediaFormatWnd.this.addToModel(modelAsr, fmt.getAudioSampleRate(), fmt.getDefautValue(fmt.getAudioSampleRate(), fmt.getDefaultAudioSampleRate()), MediaFormatWnd.this.cmbAsr);
                MediaFormatWnd.this.addToModel(modelAbr, fmt.getAudioBitrate(), fmt.getDefautValue(fmt.getAudioBitrate(), fmt.getDefaultAudioBitrate()), MediaFormatWnd.this.cmbAbr);
                MediaFormatWnd.this.addToModel(modelSize, fmt.getAspectRatio(), fmt.getDefautValue(fmt.getAspectRatio(), fmt.getDefaultAspectRatio()), MediaFormatWnd.this.cmbSize);
                MediaFormatWnd.this.addToModel(modelAc, fmt.getAudioChannel(), fmt.getDefautValue(fmt.getAudioChannel(), fmt.getDefaultAudioChannel()), MediaFormatWnd.this.cmbAc);
                MediaFormatWnd.this.updateFormat();
            }
        });
        if (model.getSize() > 0) {
            cmbFormatGroup.setSelectedIndex(0);
        }
    }

    private void addToModel(DefaultComboBoxModel<String> model, List<String> list, String defaultValue, JComboBox<String> cmb) {
        model.removeAllElements();
        if (list == null) {
            return;
        }
        for (String s : list) {
            model.addElement(s);
        }
        if (!StringUtils.isNullOrEmptyOrBlank(defaultValue)) {
            cmb.setSelectedItem(defaultValue);
        }
    }

    private JButton createButton2(String text) {
        CustomButton btn = new CustomButton(text);
        btn.setBackground(ColorResource.getDarkBtnColor());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getNormalFont());
        return btn;
    }

    public MediaFormat getFormat() {
        return this.fmt;
    }

    private String getCmbVal(JComboBox<String> cmb) {
        String val = (String)cmb.getSelectedItem();
        return StringUtils.isNullOrEmptyOrBlank(val) ? null : val;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComponent) {
            String name = ((JComponent)e.getSource()).getName();
            if ("BTN_OK".equals(name)) {
                this.updateFormat();
                this.selected = true;
                this.setVisible(false);
            }
            if ("CLOSE".equals(name)) {
                this.setVisible(false);
                this.selected = false;
            }
        }
    }

    public boolean isApproveOption() {
        return this.selected;
    }

    private void updateFormat() {
        this.fmt = new MediaFormat();
        Format format = this.listFormat.getSelectedValue();
        this.fmt.setFormat(format.getExt());
        this.fmt.setDescription(format.getDesc());
        this.fmt.setResolution(Format.getSize((String)this.cmbResolution.getSelectedItem()));
        this.fmt.setVideo_codec(Format.getCodecName((String)this.cmbVideoCodec.getSelectedItem()));
        this.fmt.setVideo_bitrate(Format.getBitRate(this.getCmbVal(this.cmbVBR)));
        String fr = this.getCmbVal(this.cmbFrameRate);
        this.fmt.setFramerate(fr);
        this.fmt.setAspectRatio(Format.getAspec(this.getCmbVal(this.cmbSize)));
        this.fmt.setAudio_codec(Format.getCodecName(this.getCmbVal(this.cmbAudioCodec)));
        this.fmt.setAudio_bitrate(Format.getBitRate(this.getCmbVal(this.cmbAbr)));
        this.fmt.setSamplerate(this.getCmbVal(this.cmbAsr));
        this.fmt.setAudio_channel(this.getCmbVal(this.cmbAc));
        this.fmt.setVideo_param_extra(format.getVidExtra());
    }
}

