/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import xdman.XDMApp;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class TrayHandler {
    static ActionListener act;

    public static void createTray() {
        if (!SystemTray.isSupported()) {
            Logger.log("SystemTray is not supported");
            return;
        }
        if (XDMUtils.detectOS() == 30) {
            return;
        }
        PopupMenu popup = new PopupMenu();
        TrayIcon trayIcon = new TrayIcon(ImageResource.get("icon.png").getImage());
        trayIcon.setImageAutoSize(true);
        SystemTray tray = SystemTray.getSystemTray();
        act = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItem c = (MenuItem)e.getSource();
                String name = c.getName();
                if ("ADD_URL".equals(name)) {
                    XDMApp.getInstance().addDownload(null, null);
                } else if ("RESTORE".equals(name)) {
                    XDMApp.getInstance().showMainWindow();
                } else if ("EXIT".equals(name)) {
                    XDMApp.getInstance().exit();
                }
            }
        };
        MenuItem addUrlItem = new MenuItem(StringResource.get("MENU_ADD_URL"));
        addUrlItem.setFont(FontResource.getBigFont());
        addUrlItem.addActionListener(act);
        addUrlItem.setName("ADD_URL");
        MenuItem restoreItem = new MenuItem(StringResource.get("MSG_RESTORE"));
        restoreItem.setFont(FontResource.getBigFont());
        restoreItem.addActionListener(act);
        restoreItem.setName("RESTORE");
        MenuItem exitItem = new MenuItem(StringResource.get("MENU_EXIT"));
        exitItem.setFont(FontResource.getBigFont());
        exitItem.addActionListener(act);
        exitItem.setName("EXIT");
        popup.add(addUrlItem);
        popup.add(restoreItem);
        popup.add(exitItem);
        trayIcon.setToolTip("XDM 2018");
        trayIcon.setPopupMenu(popup);
        trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 || e.getClickCount() == 2) {
                    XDMApp.getInstance().showMainWindow();
                }
            }
        });
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e) {
            Logger.log("TrayIcon could not be added.");
        }
    }
}

