﻿// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Matthew Ward" email="mrward@users.sourceforge.net"/>
//     <version>$Revision: 1764 $</version>
// </file>

using ICSharpCode.SharpDevelop.Project;
using ICSharpCode.WixBinding;
using NUnit.Framework;
using System;
using System.Collections;
using System.Collections.Specialized;
using System.IO;
using System.Xml;
using WixBinding.Tests.PackageFiles;
using WixBinding.Tests.Utils;

namespace WixBinding.Tests.DirectoryImport
{
	/// <summary>
	/// Adds a subdirectory to an existing directory in the package files editor.
	/// </summary>
	[TestFixture]
	public class AddSubDirectoryTestFixture : PackageFilesTestFixtureBase
	{			
		WixDirectoryElement appDirectoryElement;
		WixFileElement exeFileElement;
		WixFileElement readmeFileElement;
		string directory = @"C:\Projects\Setup\MyApplication";
		string[] files = new string[] {"MyApp.exe", "readme.txt"};
		
		[TestFixtureSetUp]
		public void SetUpFixture()
		{
			base.InitFixture();
			WixDirectoryElement programFilesFolderElement = (WixDirectoryElement)editor.Document.RootDirectory.FirstChild;
			view.SelectedElement = programFilesFolderElement;
			editor.AddDirectory(directory);
			
			appDirectoryElement = (WixDirectoryElement)programFilesFolderElement.FirstChild;
			exeFileElement = (WixFileElement)appDirectoryElement.SelectSingleNode("w:Component/w:File[@Name='MyApp.exe']", new WixNamespaceManager(editor.Document.NameTable));
			readmeFileElement = (WixFileElement)appDirectoryElement.SelectSingleNode("w:Component/w:File[@Name='readme.txt']", new WixNamespaceManager(editor.Document.NameTable));
		}
		
		[Test]
		public void IsDirty()
		{
			Assert.IsTrue(view.IsDirty);
		}
		
		[Test]
		public void DirectoryElementAddedToView()
		{
			Assert.IsInstanceOfType(typeof(WixDirectoryElement), view.ElementsAdded[0]);
		}
		
		[Test]
		public void AppDirectoryName()
		{
			Assert.AreEqual("MyApplic", appDirectoryElement.ShortName);
		}
		
		[Test]
		public void AppDirectoryLongName()
		{
			Assert.AreEqual("MyApplication", appDirectoryElement.LongName);
		}
		
		[Test]
		public void ExeFileElementAdded()
		{
			Assert.IsNotNull(exeFileElement);
		}
		
		[Test]
		public void ReadmeFileElementAdded()
		{
			Assert.IsNotNull(readmeFileElement);
		}
		
		/// <summary>
		/// Gets the MyApp directory files.
		/// </summary>
		/// <param name="path"></param>
		/// <returns></returns>
		public override string[] GetFiles(string path)
		{
			return files;
		}

		protected override string GetWixXml()
		{
			return "<Wix xmlns=\"http://schemas.microsoft.com/wix/2003/01/wi\">\r\n" +
				"\t<Product Name=\"MySetup\" \r\n" +
				"\t         Manufacturer=\"\" \r\n" +
				"\t         Id=\"F4A71A3A-C271-4BE8-B72C-F47CC956B3AA\" \r\n" +
				"\t         Language=\"1033\" \r\n" +
				"\t         Version=\"1.0.0.0\">\r\n" +
				"\t\t<Package Id=\"6B8BE64F-3768-49CA-8BC2-86A76424DFE9\"/>\r\n" +
				"\t\t<Directory Id=\"TARGETDIR\" SourceName=\"SourceDir\">\r\n" +
				"\t\t\t<Directory Id='ProgramFiles' SourceName='ProgramFiles'>\r\n" +
				"\t\t\t</Directory>\r\n" +
				"\t\t</Directory>\r\n" +
				"\t</Product>\r\n" +
				"</Wix>";
		}
	}
}
