﻿// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Matthew Ward" email="mrward@users.sourceforge.net"/>
//     <version>$Revision: 1929 $</version>
// </file>

using System;
using System.Xml;

namespace ICSharpCode.XmlEditor
{
	public interface IXmlTreeView
	{
		/// <summary>
		/// Displays an error message indicating that the xml tree view
		/// could not display the xml since the xml is not well formed.
		/// </summary>
		/// <param name="ex">The exception that occurred when the xml
		/// was loaded.</param>
		void ShowXmlIsNotWellFormedMessage(XmlException ex);
		
		/// <summary>
		/// Gets or sets whether this view needs saving.
		/// </summary>
		bool IsDirty {get; set;}
		
		/// <summary>
		/// Gets or sets the xml document element.
		/// </summary>
		XmlElement DocumentElement {get; set;}
		
		/// <summary>
		/// Gets the xml element selected.
		/// </summary>
		XmlElement SelectedElement {get;}
		
		/// <summary>
		/// Shows the attributes for the selected xml element in the view.
		/// </summary>
		void ShowAttributes(XmlAttributeCollection attributes);
		
		/// <summary>
		/// Removes the attributes from the view.
		/// </summary>
		void ClearAttributes();
		
		/// <summary>
		/// Shows the xml element text content.
		/// </summary>
		void ShowTextContent(string text);
		
		/// <summary>
		/// Gets the text content currently on display.
		/// </summary>
		string TextContent {get;}
		
		/// <summary>
		/// Gets the xml element text node.
		/// </summary>
		XmlText SelectedTextNode {get;}

		/// <summary>
		/// Shows the add attribute dialog and allows the user
		/// to select a new attribute to be added to the selected
		/// xml element.
		/// </summary>
		/// <param name="attributes">The list of attributes to
		/// be displayed to the user.</param>
		/// <returns>The attributes selected; otherwise an empty 
		/// collection.</returns>
		string[] SelectNewAttributes(string[] attributes);
		
		/// <summary>
		/// Gets the name of the selected attribute.
		/// </summary>
		string SelectedAttribute {get;}
		
		/// <summary>
		/// Shows the add element dialog and allows the user
		/// to select a new element to be added to the selected
		/// xml element, either added as a child, inserted before
		/// or after.
		/// </summary>
		/// <param name="attributes">The list of elements to
		/// be displayed to the user.</param>
		/// <returns>The attributes elements; otherwise an empty 
		/// collection.</returns>
		string[] SelectNewElements(string[] elements);
		
		/// <summary>
		/// Appends the child element to the currently selected element.
		/// </summary>
		void AppendChildElement(XmlElement element);
		
		/// <summary>
		/// Inserts the specified element before the currently selected
		/// element.
		/// </summary>
		void InsertElementBefore(XmlElement element);
		
		/// <summary>
		/// Inserts the specified element after the currently selected
		/// element.
		/// </summary>
		void InsertElementAfter(XmlElement element);
	}
}
