// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Matthew Ward" email="mrward@users.sourceforge.net"/>
//     <version>$Revision: 1171 $</version>
// </file>

using ICSharpCode.CodeCoverage;
using NUnit.Framework;
using System;

namespace ICSharpCode.CodeCoverage.Tests
{
	/// <summary>
	/// Ensures that a code coverage method that has no included sequence 
	/// points is flagged as excluded.
	/// </summary>
	[TestFixture]
	public class ExcludedMethodTestFixture
	{
		[Test]
		public void IsExcluded()
		{
			CodeCoverageMethod method = new CodeCoverageMethod("Test1", "MyTestFixture");
			CodeCoverageSequencePoint pt = new CodeCoverageSequencePoint(@"c:\test\MyTestFixture.cs", 0, 10, 0, 10, 20, true);
			method.SequencePoints.Add(pt);
			
			Assert.IsTrue(method.IsExcluded, "Method should be excluded.");
		}
	}
}
