<!DOCTYPE html>
<html lang="ja">
<head>
	<meta charset="utf-8">
	<title>{{$plan.name|escape}} | {{$config.title}}</title>
	<style>
	th {
		text-align:left;
	}
	label {
		font-weight:bold;
	}
	</style>
</head>
<body>

<div id="fb-root"></div>
<script>(function(d, s, id) {
	var js, fjs = d.getElementsByTagName(s)[0];
	if (d.getElementById(id)) return;
	js = d.createElement(s); js.id = id;
	js.src = "//connect.facebook.net/en_US/all.js#xfbml=1&appId=130671650402558";
	fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>

<div id="container">
	<h1><a href="{{"/"|ciurl}}">{{$config.title}}</a></h1>

	<header>
		<div class="breadcrumbs">
		</div>
	</header>

	<div id="body">
		<h2>{{$plan.name|escape}} - {{$plan.status|escape}}</h2>
		<div>
			<table><tbody>
				<tr>
					<th>ID:</th>
					<td>{{$plan.id}}</td>
					<th>起案者:</th>
					<td>{{$plan.owner_name|escape}}</td>
				</tr>
				<tr>
					<th>期間:</th>
					<td>{{$plan.term|escape}}</td>
					<th>予算 (獲得済み / 目標):</th>
					<td>{{if $plan.budget}}{{$plan.budget}}{{else}}-{{/if}} / {{if $plan.target_budget}}{{$plan.target_budget}}{{else}}-{{/if}}</td>
				</tr>
				<tr>
					<th>作成日:</th>
					<td>{{$plan.created}}</td>
					<th>更新日:</th>
					<td>{{$plan.modified}}</td>
				</tr>
			</tbody></table>

			<div>
				<label>活性度:</label>
				{{include file="parts/activity.tpl" activity=$plan.activity}}
			</div>
		</div>

		<div>
			{{$plan.summary|escape|nl2br}}
		</div>

{{if $plan.docs}}
		<div>
			<fieldset>
				<legend>関連文書</legend>
{{foreach from=$plan.docs item=doc}}
				<fieldset>
					<legend>{{$doc.name|escape}}</legend>
					<div>
						{{$doc.html}}
					</div>
				</fieldset>
{{/foreach}}
			</fieldset>
		</div>
{{/if}}

{{if $plan.sponsors}}
		<div>
			<fieldset id="sponsor">
				<legend>スポンサー情報</legend>
{{foreach from=$plan.sponsors item=sponsor key=k}}
				<fieldset>
					<legend>{{$sponsor.name}}</legend>
					<div>
						{{if $sponsor.url}}<a href="{{$sponsor.url|escape}}">{{/if}}
							{{if $sponsor.img_url}}
								<img src="{{$sponsor.img_url|escape}}" alt="{{$sponsor.name}}" />
							{{else}}
								{{if $sponsor.url}}{{$sponsor.url}}{{else}}バナー未登録{{/if}}
							{{/if}}
						{{if $sponsor.url}}</a>{{/if}}
					</div>
					<div>
						<label>支援金額:</label>{{$sponsor.amount}}
					</div>
					<div>
						{{$sponsor.explain|escape|nl2br}}
					</div>
				</fieldset>
{{/foreach}}
			</fieldset>
		</div>
	</div>
{{/if}}

	<div class="fb-like" data-href="{{"/plan/view/"|cat:$plan.id|ciurl}}" data-send="true" data-width="450" data-show-faces="true"></div>
	<div class="fb-comments" data-href="{{"/plan/view/"|cat:$plan.id|ciurl}}" data-num-posts="2" data-width="470"></div>
</div>
</body>
</html>