/*-----------------------------------------------------------------------------
[]	EmphasisItem.cpp
[Tv]	\vf`NX̎
[l]	Ȃ
[]	2003-02-26	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Shitarabian.h"
#include "EmphasisItem.h"
#include "Common.h"
#include "ExeCommon.h"
#include "GeneralSetting.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CEmphasisItem::CEmphasisItem()
:	m_strPattern()
,	m_colFore( RGB( 0,0,0 ) )
,	m_colBack( RGB( 255,255,255 ) )
,	m_bEnabled( TRUE )
,	m_bEnabledToggle( TRUE )
,	m_bUnderLine( FALSE )
{
	m_tFindCondition.bRegExp	= TRUE;		// K\
	m_tFindCondition.bCaseCare	= TRUE;		// 啶
	m_tFindCondition.bToken		= TRUE;		// PP
}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CEmphasisItem::~CEmphasisItem()
{

}


/*-----------------------------------------------------------------------------
[]	t@Co
[@\]	t@Cւ̏oB
[ߒl]	BOOL	 [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL	CEmphasisItem::Write(
	CStdioFile* pFile		// O  :o͐t@C [-] (-) :-
)
{
	try
	{
		// ̏o
		CString	strChar;
		strChar.Format(
			"%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n",
			QuoteString( m_strPattern ),
			QuoteString( m_strTerminator ),
			ColorrefToString( m_colFore ),
			ColorrefToString( m_colBack ),
			BoolToString( m_bEnabled ),
			BoolToString( m_bEnabledToggle ),
			BoolToString( m_bUnderLine ),
			BoolToString( m_tFindCondition.bRegExp ),
			BoolToString( m_tFindCondition.bCaseCare ),
			BoolToString( m_tFindCondition.bToken )
		);
		pFile->WriteString( strChar );

		return( TRUE );
	}
	catch( CFileException* e )
	{
		e->Delete();
		ErrorLog( "t@Co", "CEmphasisItem::Write()" );
		return( FALSE );
	}
}


/*-----------------------------------------------------------------------------
[]	t@C
[@\]	t@C̓ǂݍ݁B
[ߒl]	BOOL	 [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL	CEmphasisItem::Read(
	CStdioFile& File		// I  :͌t@C [-] (-)
)
{
	try
	{
		BOOL bSuccess =TRUE;
		CString		strLine;

		bSuccess &= File.ReadString( strLine );
		m_strPattern = DeQuoteString( strLine );

		bSuccess &= File.ReadString( strLine );
		m_strTerminator = DeQuoteString( strLine );

		bSuccess &= File.ReadString( strLine );
		m_colFore = StringToColorref( strLine );

		bSuccess &= File.ReadString( strLine );
		m_colBack = StringToColorref( strLine );

		bSuccess &= File.ReadString( strLine );
		m_bEnabled = StringToBool( strLine );

		bSuccess &= File.ReadString( strLine );
		m_bEnabledToggle = StringToBool( strLine );

		bSuccess &= File.ReadString( strLine );
		m_bUnderLine = StringToBool( strLine );

		bSuccess &= File.ReadString( strLine );
		m_tFindCondition.bRegExp = StringToBool( strLine );

		bSuccess &= File.ReadString( strLine );
		m_tFindCondition.bCaseCare = StringToBool( strLine );

		bSuccess &= File.ReadString( strLine );
		m_tFindCondition.bToken = StringToBool( strLine );

		return( bSuccess );
	}
	catch( CFileException* e )
	{
		e->Delete();
		ErrorLog( "t@C", "CEmphasisItem::Read()" );
		return( FALSE );
	}
}


/*-----------------------------------------------------------------------------
[]	LԎ擾
[@\]	Ŝ̐ݒ肩狭\̗LԂ擾B
[ߒl]	BOOL	L [-] (TRUE:LAFALSE:)
[l]	Lݒ肪uLvłĂ\ŜɂĂΖ߂B
-----------------------------------------------------------------------------*/
BOOL CEmphasisItem::GetEnable()
{
	return( m_bEnabled && CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetEnable() );
}


/*-----------------------------------------------------------------------------
[]	Lݒ擾
[@\]	\̗Lݒ擾B
[ߒl]	BOOL	Lݒ [-] (TRUE:LAFALSE:)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CEmphasisItem::GetCheck()
{
	return( m_bEnabled );
}
