// LaunchItemDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "shitarabian.h"
#include "LaunchItemDlg.h"
#include <stdlib.h>
#include "Launcher.h"
#include "Common.h"
#include "ExeCommon.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CLaunchItemDlg _CAO


CLaunchItemDlg::CLaunchItemDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLaunchItemDlg::IDD, pParent)
	, m_pLaunchItem( NULL )
	, m_idxIcon( 0 )
	, m_strIconPathName()
{
	//{{AFX_DATA_INIT(CLaunchItemDlg)
	m_strName = _T("");
	m_strCommand = _T("");
	m_bEnable = FALSE;
	m_bDefaultOpen = FALSE;
	//}}AFX_DATA_INIT
}


void CLaunchItemDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLaunchItemDlg)
	DDX_Control(pDX, IDC_LAUNCHITEM_COMMAND, m_editCommand);
	DDX_Control(pDX, IDC_LAUNCHITEM_ICON, m_IconCanvas);
	DDX_Text(pDX, IDC_LAUNCHITEM_NAME, m_strName);
	DDX_Text(pDX, IDC_LAUNCHITEM_COMMAND, m_strCommand);
	DDX_Check(pDX, IDC_LAUNCHITEM_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_LAUNCHITEM_DEFAULT_OPEN, m_bDefaultOpen);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLaunchItemDlg, CDialog)
	//{{AFX_MSG_MAP(CLaunchItemDlg)
	ON_BN_CLICKED(IDC_LAUNCHITEM_ICONREF, OnLaunchitemIconref)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_LAUNCHITEM_PATH, OnLaunchitemPath)
	ON_BN_CLICKED(IDC_LAUNCHITEM_SHITARABIANFOLDER, OnLaunchitemShitarabianfolder)
	ON_BN_CLICKED(IDC_LAUNCHITEM_SHITARABIANHANDLE, OnLaunchitemShitarabianhandle)
	ON_BN_CLICKED(IDC_LAUNCHITEM_SHITARABIANCOMMAND, OnLaunchitemShitarabiancommand)
	ON_BN_CLICKED(IDC_LAUNCHITEM_FILEREF, OnLaunchitemFileref)
	ON_BN_CLICKED(IDC_LAUNCHITEM_SHITARABIANCURENTDOC, OnLaunchitemShitarabiancurentdoc)
	ON_BN_CLICKED(IDC_LAUNCHITEM_SHITARABIANSELECTION, OnLaunchitemShitarabianselection)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// OSUnicodegpĂ邩𔻒肷
BOOL IsUnicodeSystem()
{
    // OS ̃o[W擾
    OSVERSIONINFO stOsVerInfo;
    stOsVerInfo.dwOSVersionInfoSize = sizeof(stOsVerInfo);
    if ( ::GetVersionEx( &stOsVerInfo ) )
	{
        if ( stOsVerInfo.dwPlatformId == VER_PLATFORM_WIN32_NT )
		{
            // NT n
            return( TRUE );
        }
		else
		{
		    // NT nł͂Ȃ
            return( FALSE );
        }
    }
	else
	{
		// s
		return( FALSE );
    }
}


/////////////////////////////////////////////////////////////////////////////
// CLaunchItemDlg bZ[W nh

void CLaunchItemDlg::OnLaunchitemIconref() 
{
	typedef BOOL (WINAPI *LPSHPICKICONDIALOG)(HWND, void*, DWORD, PDWORD);

	HINSTANCE hShell = ::LoadLibrary(_T("SHELL32.DLL"));
	if(hShell)
	{
		LPSHPICKICONDIALOG pfnSHPickIconDialog = (LPSHPICKICONDIALOG)::GetProcAddress(hShell, (LPCSTR)62);
		if( pfnSHPickIconDialog )
		{
			BOOL	bDeside;
			CString	strIconPathName;
			DWORD	dwIndex;
			if ( !IsUnicodeSystem() )
			{
				// NTnŃACRI_CAO\
				char szIconFile[MAX_PATH] = "";
				bDeside = pfnSHPickIconDialog(m_hWnd, szIconFile, MAX_PATH, &dwIndex);
				strIconPathName = szIconFile;
			}
			else
			{
				// NTnŃACRI_CAO\
				WCHAR szIconFile[MAX_PATH] = L"";
				bDeside = pfnSHPickIconDialog(m_hWnd, szIconFile, MAX_PATH, &dwIndex);
				if ( bDeside )
				{
					// UnicodeShift-Jisɕϊ
					long	nChar = ::wcstombs( NULL, szIconFile, MAX_PATH );
					char*	pmbs = new char[ nChar+1 ];
					::wcstombs( pmbs, szIconFile, nChar );
					pmbs[nChar] = 0x00;
					strIconPathName = pmbs;
					delete [] pmbs;
				}
			}

			// ACRIꂽ̂Ȃ甽f
			if ( bDeside )
			{
				m_idxIcon = dwIndex;
				m_strIconPathName = strIconPathName;
				RedrawWindow();
			}
		}
		::FreeLibrary(hShell);
	}
}

void CLaunchItemDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	CRect	rcIcon;
	m_IconCanvas.GetWindowRect( &rcIcon );
	ScreenToClient( &rcIcon );

	// ACR̕`
	::DrawIcon(
		&dc,
		rcIcon,
		m_strIconPathName,
		m_idxIcon
	);
}

void CLaunchItemDlg::OnOK() 
{
	UpdateData( TRUE );
	if ( m_pLaunchItem != NULL )
	{
		m_pLaunchItem->m_bEnable = m_bEnable;
		m_pLaunchItem->m_idxIcon = m_idxIcon;
		m_pLaunchItem->m_strButtonName = m_strName;
		m_pLaunchItem->m_strCommandLine = m_strCommand;
		m_pLaunchItem->m_strIconPathName = m_strIconPathName;
		m_pLaunchItem->m_bDefaultOpen = m_bDefaultOpen;
	}
	
	CDialog::OnOK();
}

BOOL CLaunchItemDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if ( m_pLaunchItem != NULL )
	{
		m_bEnable = m_pLaunchItem->m_bEnable;
		m_idxIcon = m_pLaunchItem->m_idxIcon;
		m_strName = m_pLaunchItem->m_strButtonName;
		m_strCommand = m_pLaunchItem->m_strCommandLine;
		m_strIconPathName = m_pLaunchItem->m_strIconPathName;
		m_bDefaultOpen = m_pLaunchItem->m_bDefaultOpen;
	}
	UpdateData( FALSE );

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CLaunchItemDlg::OnLaunchitemPath() 
{
	CString	strPath;
	strPath.Format(
		_T( "\"%s\\%s.%s\"" ),
		CLauncher::m_strKeywordDocPath,
		CLauncher::m_strKeywordDocName,
		CLauncher::m_strKeywordDocExt
	);
	m_editCommand.ReplaceSel(
		strPath
	);
	m_editCommand.SetFocus();
}

void CLaunchItemDlg::OnLaunchitemShitarabianfolder() 
{
	m_editCommand.ReplaceSel(
		CLauncher::m_strKeywordShitarabianFolder
	);
	m_editCommand.SetFocus();
}

void CLaunchItemDlg::OnLaunchitemShitarabianhandle() 
{
	m_editCommand.ReplaceSel(
		CLauncher::m_strKeywordWindowHandle
	);
	m_editCommand.SetFocus();
}

void CLaunchItemDlg::OnLaunchitemShitarabiancommand() 
{
	m_editCommand.ReplaceSel(
		CLauncher::m_strKeywordMessageID
	);
	m_editCommand.SetFocus();
}

void CLaunchItemDlg::OnLaunchitemFileref() 
{
	// t@CI_CAO\A_uNH[e[Vł
	CFileDialog	dlgFile(
		TRUE,			//  TRUEȂwJxAFALSEȂAwOtĕۑxƂȂ
		"*.*",			//  ftHg̃t@Cgq(NULLȂȂ)
		NULL,			//  \t@C(NULLȂȂ)
		OFN_HIDEREADONLY,
		"SẴt@C(*.*)|*.*|"	//  t@C̊gq̎
	);
	if ( dlgFile.DoModal() == IDOK )
	{
		CString		strFilePathName;
		strFilePathName = ::QuoteString( dlgFile.GetPathName() );
		m_editCommand.ReplaceSel(
			strFilePathName
		);
	}
	m_editCommand.SetFocus();
}

void CLaunchItemDlg::OnLaunchitemShitarabiancurentdoc() 
{
	m_editCommand.ReplaceSel(
		CLauncher::m_strKeywordShitarabianCurrentDoc
	);
	m_editCommand.SetFocus();
}

void CLaunchItemDlg::OnLaunchitemShitarabianselection() 
{
	m_editCommand.ReplaceSel(
		CLauncher::m_strKeywordShitarabianSelection
	);
	m_editCommand.SetFocus();
}
