// RgL
// LaunchListCtrl.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "shitarabian.h"
#include "LaunchListCtrl.h"
#include "LaunchDlg.h"
#include "ExeCommon.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLaunchListCtrl

CLaunchListCtrl::CLaunchListCtrl()
: m_pLaunchDefine( NULL )
{
}

CLaunchListCtrl::~CLaunchListCtrl()
{
}


BEGIN_MESSAGE_MAP(CLaunchListCtrl, CListCtrl)
	//{{AFX_MSG_MAP(CLaunchListCtrl)
	ON_NOTIFY_REFLECT(NM_CLICK, OnClick)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLaunchListCtrl bZ[W nh

void CLaunchListCtrl::DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct )
{
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);

	COLORREF	colBack = RGB(255,255,255);
	COLORREF	colFore = RGB(0,0,0);

	BOOL	bSelected = ( lpDrawItemStruct->itemState & ODS_SELECTED );
	if ( bSelected )
	{
		colBack = RGB(64,128,128);
		colFore = RGB(255,255,255);
	}

	pDC->FillSolidRect(
		&(lpDrawItemStruct->rcItem),
		colBack
	);

	int	iLeft = lpDrawItemStruct->rcItem.left;
	pDC->SetTextColor( colFore );

	CArray<CLaunchItem, CLaunchItem&>& Itemz = *(m_pLaunchDefine->GetLaunchDefine());
	CLaunchItem&	Launch = Itemz[lpDrawItemStruct->itemID];

	// L
	{
		CRect rcClient(
			iLeft+2,
			lpDrawItemStruct->rcItem.top,
			iLeft+GetColumnWidth(0),
			lpDrawItemStruct->rcItem.bottom
		);
		if( Launch.m_bEnable )
		{
			pDC->DrawText(
				"",
				&rcClient,
				DT_CENTER
			);
		}
		else
		{
			pDC->DrawText(
				"",
				&rcClient,
				DT_CENTER
			);
		}
	}
	iLeft += GetColumnWidth(0);

	// ACR
	{
		CRect rcClient(
			iLeft+2,
			lpDrawItemStruct->rcItem.top,
			iLeft+GetColumnWidth(1),
			lpDrawItemStruct->rcItem.bottom
		);

		CRgn	rgn;
		rgn.CreateRectRgn(
			rcClient.left,
			rcClient.top,
			rcClient.right,
			rcClient.bottom
		);
		pDC->SelectClipRgn( NULL );
		pDC->SelectClipRgn(
			&rgn,
			RGN_AND
		);

		// ACR̕`
		::DrawIcon(
			pDC,
			rcClient,
			Launch.m_strIconPathName,
			Launch.m_idxIcon
		);

		pDC->SelectClipRgn( NULL );
		rgn.DeleteObject();
	}
	iLeft += GetColumnWidth(1);

	// 
	{
		CRect rcClient(
			iLeft+2,
			lpDrawItemStruct->rcItem.top,
			iLeft+GetColumnWidth(2),
			lpDrawItemStruct->rcItem.bottom
		);

		CRgn	rgn;
		rgn.CreateRectRgn(
			rcClient.left,
			rcClient.top,
			rcClient.right,
			rcClient.bottom
		);
		pDC->SelectClipRgn( NULL );
		pDC->SelectClipRgn(
			&rgn,
			RGN_AND
		);

		{
			pDC->DrawText(
				Launch.m_strButtonName,
				rcClient,
				DT_LEFT
			);
		}
		pDC->SelectClipRgn( NULL );
		rgn.DeleteObject();
	}
	iLeft += GetColumnWidth(2);

	// R}h
	{
		CRect rcClient(
			iLeft+2,
			lpDrawItemStruct->rcItem.top,
			iLeft+GetColumnWidth(3),
			lpDrawItemStruct->rcItem.bottom
		);

		CRgn	rgn;
		rgn.CreateRectRgn(
			rcClient.left,
			rcClient.top,
			rcClient.right,
			rcClient.bottom
		);
		pDC->SelectClipRgn( NULL );
		pDC->SelectClipRgn(
			&rgn,
			RGN_AND
		);

		{
			pDC->DrawText(
				Launch.m_strCommandLine,
				rcClient,
				DT_LEFT|DT_NOPREFIX
			);
		}
		pDC->SelectClipRgn( NULL );
		rgn.DeleteObject();
	}
	iLeft += GetColumnWidth(3);

	// g
	CPen	pen;
	pen.CreatePen( PS_SOLID, 1, RGB(200,200,200 ) );
	CPen*	ppenOld = (CPen*)pDC->SelectObject( &pen );
	pDC->MoveTo( lpDrawItemStruct->rcItem.left, lpDrawItemStruct->rcItem.bottom-1 );
	pDC->LineTo( iLeft-1, lpDrawItemStruct->rcItem.bottom-1 );

	iLeft = 0;
	for( int idxColumn=0 ; idxColumn<4 ; idxColumn++ )
	{
		iLeft += GetColumnWidth( idxColumn );
		pDC->MoveTo( iLeft-1, lpDrawItemStruct->rcItem.top );
		pDC->LineTo( iLeft-1, lpDrawItemStruct->rcItem.bottom-1 );
	}

	pDC->SelectObject( ppenOld );
}

void CLaunchListCtrl::OnClick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// warning C4100:x̖
	pNMHDR;

	// `FbNNbNꍇAL؂ւ
	CPoint	ptCursor;
	::GetCursorPos( &ptCursor );
	ScreenToClient( &ptCursor );
	int	idxItem = HitTest( ptCursor );
	if ( idxItem != -1 )
	{
		// `FbÑNbN
		if ( ptCursor.x < GetColumnWidth(0) )
		{
			// LgO
			CArray<CLaunchItem, CLaunchItem&>& Itemz = *( m_pLaunchDefine->GetLaunchDefine() );
			Itemz[idxItem].m_bEnable = !Itemz[idxItem].m_bEnable;

			Update( idxItem );
		}
	}

	((CLaunchDlg*)GetParent())->VisibleControl();

	*pResult = 0;
}
