/*-----------------------------------------------------------------------------
[]	TokenReader.cpp
[Tv]	g[N[_NX̎
[l]	Ȃ
[]	2002-12-12	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "TokenReader.h"
#include <mbctype.h>
#include "GeneralSetting.h"
#include "WhitespaceDefine.h"
#include "Unicoder.h"
#include "ShitarabianDoc.h"
#include "ExeCommon.h"
#include "MainFrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//-----------------------------------------------------------------------------
// 
//-----------------------------------------------------------------------------
/*
}`oCgPA̕񑀍֐
	_mbsnbicmp		2̃}`oCg̍ŏ n oCgA啶ʂɁArB
	_mbsnbcmp		啶ʂo[W
	_tcsrev			̔]
	_tcstok			̎̃g[N܂B
	_mbslen			}`oCg񒆂̃}`oCg̐Ԃ܂
	_tcsstr			܂B
	_tcsupr			񒆂̕啶ɕϊ܂B
*/


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CTokenReader::CTokenReader()
{

}

/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CTokenReader::~CTokenReader()
{

}


/*-----------------------------------------------------------------------------
[]	g[N
[@\]	̃J𕶎ʂƂɕAACɊi[B
[ߒl]	Ȃ
[l]	󔒕ݒ𔽉fB
-----------------------------------------------------------------------------*/
int	CTokenReader::StringToCharTypez(
	CString&					strSrc,		// I:  [-] (-) :-
	CArray< TToken, TToken& >*	paTokenz	// O: 㕶z [-] (-) :-
)
{
// J̑gݗ
	paTokenz->RemoveAll();

	// 𑖍
	int		idxByte = 0;
	int		idxColumn = 0;
	int		idxTypeStartColumn = 0;
	ECharType	ePrevCharType = CharTypeFunction;
	while( idxByte < strSrc.GetLength() )
	{
		// J̕ʔ
		ECharType	eCharType = CharTypeWhitespace;
		long		nColumn = 0;
		while( TRUE )	// break̂switchɋLq
		{
			unsigned char	iChar = strSrc[ idxByte ];

			// WhiteSpaceDefineɍv΋󔒕
			{
				const char* pstrChar = ((LPCTSTR)strSrc) + idxByte;
				CWhitespaceDefine*	pWhiteSpace = CGeneralSetting::GetInstance()->GetWhitespace();
				int		nByte;
				BOOL	bWhiteSpace = pWhiteSpace->IsWhitespace(
					pstrChar,
					&nByte
				);
				if( bWhiteSpace )
				{
					eCharType = CharTypeWhitespace;
					idxByte += nByte;

					CShitarabianDoc*	pDoc;
					pDoc = ::GetDocument();
					nColumn = ::StringToColumn( CString( pstrChar, nByte ) );
					break;
				}
			}

			// jR[h
			{
				const char* pstrChar = ((LPCTSTR)strSrc) + idxByte;

				// Unicode
				wchar_t		wcharUnicode;
				CUnicoder*	pUnicoder = CUnicoder::GetInstance();
				long	nByte = pUnicoder->IsUnicode(
					pstrChar,
					&wcharUnicode
				);
				if ( nByte > 0 )
				{
					eCharType = CharTypeUnicode;
					idxByte += nByte;
					nColumn = nByte;
					break;
				}
			}
	
			// [hoCgłΑSp
			if ( _ismbblead( iChar ) )
			{
				eCharType = CharTypeDoubleByte;
				idxByte+=2;
				nColumn = 1;
				break;
			}

			// p
			{
				BOOL	bFound = FALSE;
				switch ( iChar )
				{
				case '_':
					eCharType = CharTypeAlphabet;
					bFound = TRUE;
					break;
				default:
					if( _istalnum( iChar ) )
					{
						eCharType = CharTypeAlphabet;
						bFound = TRUE;
					}
					break;
				}
				if ( bFound )
				{
					idxByte++;
					nColumn = 1;
					break;
				}
			}

			// L
			{
				eCharType = CharTypeFunction;
				idxByte++;
				nColumn = 1;
				break;
			}
		}

		// ʂÔ̂ƈقȂPrev񂩂TokenL^
		if ( eCharType != ePrevCharType )
		{
			if ( idxColumn-idxTypeStartColumn > 0 )
			{
				TToken	tToken;
				tToken.eCharType = ePrevCharType;
				tToken.idxStartColumn = idxTypeStartColumn;
				tToken.nColumn = idxColumn-idxTypeStartColumn;
				paTokenz->Add( tToken );
			}
			ePrevCharType = eCharType;
			idxTypeStartColumn = idxColumn;
		}

		idxColumn += nColumn;
	}
	// ŌTokenL^
	if ( idxColumn-idxTypeStartColumn > 0 )
	{
		TToken	tToken;
		tToken.eCharType = ePrevCharType;
		tToken.idxStartColumn = idxTypeStartColumn;
		tToken.nColumn = idxColumn-idxTypeStartColumn;
		paTokenz->Add( tToken );
	}

	return( paTokenz->GetSize() );
}


/*-----------------------------------------------------------------------------
[]	P
[@\]	̃J𕶎ʂƂɕAACɊi[B
[ߒl]	long ΏۃJ܂ރg[N [CfNX] (0`:FoundAInvalidTokenIndex:NotFound)
[l]	Ȃ
-----------------------------------------------------------------------------*/
int	CTokenReader::TokenIndex(
	CArray< TToken, TToken& >&	aTokenz,	// I: g[NAC [-] (-) :-
	int							idxColumn	// I: ΏۃJ [-] (-) :-
)
{
	// g[NACvf̃JAΏۃJɒB܂ŏɑ
	int		idxToken;
	for( idxToken=0 ; idxToken<aTokenz.GetSize() ; idxToken++ )
	{
		if ( idxColumn >= aTokenz[idxToken].idxStartColumn )
		if ( idxColumn < aTokenz[idxToken].idxStartColumn + aTokenz[idxToken].nColumn )
		{
			// ΏۃJɒB̂ŁAHITg[NƂ݂Ȃ
			return( idxToken );
		}
	}

	// HITg[Ns
	return( InvalidTokenIndex );
}

